/*
 * Copyright: (C) 2003 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  forsberg@tns.net
 *
 */

/*! \class aflibOggFile
    \brief Derived class to read and write to Ogg format.

*/

#ifndef _AFLIBOGGFILE_H
#define _AFLIBOGGFILE_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "aflibFile.h"

#define AFLIB_DEV_ITEM_BUFFER "aflib_dev_item_buffer"

class aflibOggFile : public aflibFile {

public:

   aflibOggFile();

   ~aflibOggFile();

   aflibStatus
   afopen(
      const char * file,
      aflibConfig* cfg);

   aflibStatus
   afcreate(
      const char * file,
      const aflibConfig& config);

   aflibStatus
   afread(
      aflibData& data,
      long long position = -1);

   aflibStatus
   afwrite(
      aflibData& data,
      long long position = -1);

   bool
   isDataSizeSupported(aflib_data_size size);

   bool
   isEndianSupported(aflib_data_endian end);

   bool
   isSampleRateSupported(int& rate);

   bool
   getItem(
      const char* item,
      void* value);

private:


OggVorbis_File  *_vf;
FILE            *_fd;
aflib_data_size  _size;
string           _file;
int              _kbps;
long long        _total_samples;
long long        _current_sample;
int              _bytes_per_sample;

};

#endif
