/*
 * Copyright: (C) 2003 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  forsberg@tns.net
 *
 */

/*! \class aflibMadFile
    \brief Derived class to read MP3 audio files using the mpg decoder.
 
  This class will read audio files of the MP3 (MPEG Audio Compression
  Format) format. This module uses the mad decoder to decode MP3 files. 
*/


#ifndef _AFLIBMADFILE_H
#define _AFLIBMADFILE_H


#include "aflibFile.h"
#include <string>


class aflibMadFile : public aflibFile {

public:

   aflibMadFile();

   ~aflibMadFile();

   aflibStatus
   afopen(
      const char * file,
      aflibConfig* cfg);

   aflibStatus
   afcreate(
      const char * file,
      const aflibConfig& cfg);

   aflibStatus
   afread(
      aflibData& data,
      long long position = -1);

   aflibStatus
   afwrite(
      aflibData& data,
      long long position = -1);

   bool
   isDataSizeSupported(aflib_data_size size);
 
   bool
   isEndianSupported(aflib_data_endian end);
 
   bool
   isSampleRateSupported(int& rate);

   bool
   getItem(
      const char* item,
      void* value);

private:


FILE*    _fd;
int     	_sample_rate;
int		_channels;
bool    _dual_channel;
long 		_current_sample;
string 	_mpeg_cmd;
string 	_filename;
int     _kbps;

};


#endif
