/*
 *    Copyright 2006 Intel Corporation
 * 
 *    Licensed under the Apache License, Version 2.0 (the "License");
 *    you may not use this file except in compliance with the License.
 *    You may obtain a copy of the License at
 * 
 *        http://www.apache.org/licenses/LICENSE-2.0
 * 
 *    Unless required by applicable law or agreed to in writing, software
 *    distributed under the License is distributed on an "AS IS" BASIS,
 *    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *    See the License for the specific language governing permissions and
 *    limitations under the License.
 */

#ifndef _OASYS_XML_PARSER_H_
#define _OASYS_XML_PARSER_H_

#include <string>

namespace oasys {

class XMLDocument;

/**
 * Abstract interface to an XML parser.
 */
class XMLParser {
public:
    /**
     * Default constructor.
     */
    XMLParser() {}

    /**
     * Parse the given data into an xml document object.
     */
    virtual bool parse(XMLDocument* doc, const std::string& data) = 0;

    virtual ~XMLParser() {}
};

} // namespace oasys

#endif /* _OASYS_XML_PARSER_H_ */
