// Copyright (C) 2005-2007 Code Synthesis Tools CC
//
// This program was generated by XML Schema Definition Compiler (XSD)
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License version 2 as
// published by the Free Software Foundation.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
//
// In addition, as a special exception, Code Synthesis Tools CC gives
// permission to link this program with the Xerces-C++ library (or with
// modified versions of Xerces-C++ that use the same license as Xerces-C++),
// and distribute linked combinations including the two. You must obey
// the GNU General Public License version 2 in all respects for all of
// the code used other than Xerces-C++. If you modify this copy of the
// program, you may extend this exception to your version of the program,
// but you are not obligated to do so. If you do not wish to do so, delete
// this exception statement from your version.
//
// Furthermore, Code Synthesis Tools CC makes a special exception for
// the Free/Libre and Open Source Software (FLOSS) which is described
// in the accompanying FLOSSE file.
//

#ifndef DS_H
#define DS_H

#include <xsd/cxx/version.hxx>

#if (XSD_INT_VERSION != 2030100L)
#error XSD runtime version mismatch
#endif

// Begin prologue.
//
//
// End prologue.

#include <xsd/cxx/pre.hxx>

#ifndef XSD_USE_CHAR
#define XSD_USE_CHAR
#endif

#ifndef XSD_CXX_TREE_USE_CHAR
#define XSD_CXX_TREE_USE_CHAR
#endif

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/types.hxx>
#include <xsd/cxx/xml/error-handler.hxx>

#include <xsd/cxx/tree/parsing.hxx>

#include <xsd/cxx/tree/serialization.hxx>
#include <xsd/cxx/xml/dom/namespace-infomap.hxx>

namespace xml_schema
{
  // anyType and anySimpleType.
  //
  typedef ::xsd::cxx::tree::type type;
  typedef ::xsd::cxx::tree::simple_type<type> simple_type;

  // 8-bit
  //
  typedef signed char byte;
  typedef unsigned char unsigned_byte;

  // 16-bit
  //
  typedef short short_;
  typedef unsigned short unsigned_short;

  // 32-bit
  //
  typedef int int_;
  typedef unsigned int unsigned_int;

  // 64-bit
  //
  typedef long long long_;
  typedef unsigned long long unsigned_long;

  // Supposed to be arbitrary-length integral types.
  //
  typedef long long integer;
  typedef integer non_positive_integer;
  typedef integer non_negative_integer;
  typedef integer positive_integer;
  typedef integer negative_integer;

  // Boolean.
  //
  typedef bool boolean;

  // Floating-point types.
  //
  typedef float float_;
  typedef double double_;
  typedef long double decimal;

  // String types.
  //
  typedef ::xsd::cxx::tree::string< char, simple_type > string;
  typedef ::xsd::cxx::tree::normalized_string< char, string > normalized_string;
  typedef ::xsd::cxx::tree::token< char, normalized_string > token;
  typedef ::xsd::cxx::tree::name< char, token > name;
  typedef ::xsd::cxx::tree::nmtoken< char, token > nmtoken;
  typedef ::xsd::cxx::tree::nmtokens< char, simple_type, nmtoken> nmtokens;
  typedef ::xsd::cxx::tree::ncname< char, name > ncname;
  typedef ::xsd::cxx::tree::language< char, token > language;

  // ID/IDREF.
  //
  typedef ::xsd::cxx::tree::id< char, ncname > id;
  typedef ::xsd::cxx::tree::idref< type, char, ncname > idref;
  typedef ::xsd::cxx::tree::idrefs< char, simple_type, idref > idrefs;

  // URI.
  //
  typedef ::xsd::cxx::tree::uri< char, simple_type > uri;

  // Qualified name.
  //
  typedef ::xsd::cxx::tree::qname< char, simple_type, uri, ncname > qname;

  // Binary.
  //
  typedef ::xsd::cxx::tree::buffer< char > buffer;
  typedef ::xsd::cxx::tree::base64_binary< char, simple_type > base64_binary;
  typedef ::xsd::cxx::tree::hex_binary< char, simple_type > hex_binary;

  // Date/time.
  //
  typedef ::xsd::cxx::tree::date< char, simple_type > date;
  typedef ::xsd::cxx::tree::date_time< char, simple_type > date_time;
  typedef ::xsd::cxx::tree::duration< char, simple_type > duration;
  typedef ::xsd::cxx::tree::day< char, simple_type > day;
  typedef ::xsd::cxx::tree::month< char, simple_type > month;
  typedef ::xsd::cxx::tree::month_day< char, simple_type > month_day;
  typedef ::xsd::cxx::tree::year< char, simple_type > year;
  typedef ::xsd::cxx::tree::year_month< char, simple_type > year_month;
  typedef ::xsd::cxx::tree::time< char, simple_type > time;

  // Entity.
  //
  typedef ::xsd::cxx::tree::entity< char, ncname > entity;
  typedef ::xsd::cxx::tree::entities< char, simple_type, entity > entities;

  // Exceptions.
  //
  typedef ::xsd::cxx::tree::exception< char > exception;
  typedef ::xsd::cxx::tree::parsing< char > parsing;
  typedef ::xsd::cxx::tree::expected_element< char > expected_element;
  typedef ::xsd::cxx::tree::unexpected_element< char > unexpected_element;
  typedef ::xsd::cxx::tree::expected_attribute< char > expected_attribute;
  typedef ::xsd::cxx::tree::unexpected_enumerator< char > unexpected_enumerator;
  typedef ::xsd::cxx::tree::expected_text_content< char > expected_text_content;
  typedef ::xsd::cxx::tree::no_type_info< char > no_type_info;
  typedef ::xsd::cxx::tree::not_derived< char > not_derived;
  typedef ::xsd::cxx::tree::duplicate_id< char > duplicate_id;
  typedef ::xsd::cxx::tree::serialization< char > serialization;
  typedef ::xsd::cxx::tree::no_namespace_mapping< char > no_namespace_mapping;
  typedef ::xsd::cxx::tree::no_prefix_mapping< char > no_prefix_mapping;
  typedef ::xsd::cxx::tree::xsi_already_in_use< char > xsi_already_in_use;
  typedef ::xsd::cxx::tree::bounds< char > bounds;

  // Parsing/serialization error.
  //
  typedef ::xsd::cxx::tree::error< char > error;
  typedef ::xsd::cxx::tree::errors< char > errors;

  // Error handler interface.
  //
  typedef ::xsd::cxx::xml::error_handler< char > error_handler;

  // Namespace information. Used in serialization functions.
  //
  typedef ::xsd::cxx::xml::dom::namespace_info < char > namespace_info;
  typedef ::xsd::cxx::xml::dom::namespace_infomap < char > namespace_infomap;

  // Flags and properties.
  //
  typedef ::xsd::cxx::tree::flags flags;
  typedef ::xsd::cxx::tree::properties< char > properties;

  // DOM user data key for back pointers to tree nodes.
  //
#ifndef XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA
#define XSD_CXX_TREE_TREE_NODE_KEY_IN___XML_SCHEMA

  const XMLCh* const tree_node_key = ::xsd::cxx::tree::user_data_keys::node;

#endif
}

// Forward declarations.
//
namespace dsmessage
{
  class storeType;
  class tableInfoType;
  class fieldType;
  class fieldInfoType;
  class fieldNameValue;
  class fieldName;
  class languageName;
  class ds_caps_request_type;
  class ds_caps_reply_type;
  class ds_create_request_type;
  class ds_create_reply_type;
  class ds_del_request_type;
  class ds_del_reply_type;
  class ds_open_request_type;
  class ds_open_reply_type;
  class ds_stat_request_type;
  class ds_stat_reply_type;
  class ds_close_request_type;
  class ds_close_reply_type;
  class table_create_request_type;
  class table_create_reply_type;
  class table_del_request_type;
  class table_del_reply_type;
  class table_stat_request_type;
  class table_stat_reply_type;
  class table_keys_request_type;
  class table_keys_reply_type;
  class put_request_type;
  class put_reply_type;
  class get_request_type;
  class get_reply_type;
  class del_request_type;
  class del_reply_type;
  class select_request_type;
  class rowType;
  class select_reply_type;
  class eval_request_type;
  class eval_reply_type;
  class trigger_request_type;
  class trigger_reply_type;
  class ds_request_type;
  class ds_reply_type;
}


#include <memory>    // std::auto_ptr
#include <algorithm> // std::binary_search

#include <xsd/cxx/tree/exceptions.hxx>
#include <xsd/cxx/tree/elements.hxx>
#include <xsd/cxx/tree/containers.hxx>
#include <xsd/cxx/tree/list.hxx>

namespace dsmessage
{
  class storeType: public ::xml_schema::string
  {
    public:
    enum _xsd_storeType
    {
      pair,
      field,
      advanced
    };

    storeType (_xsd_storeType);

    storeType (const ::xml_schema::string&);

    storeType (const ::xercesc::DOMElement&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    storeType (const ::xercesc::DOMAttr&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    storeType (const ::std::basic_string< char >&,
               const ::xercesc::DOMElement*,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    storeType (const storeType&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    virtual storeType*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    storeType&
    operator= (_xsd_storeType);

    virtual
    operator _xsd_storeType () const
    {
      return _xsd_storeType_convert ();
    }

    protected:
    _xsd_storeType
    _xsd_storeType_convert () const;

    public:
    static const char* const _xsd_storeType_literals_[3];
    static const _xsd_storeType _xsd_storeType_indexes_[3];
  };

  class tableInfoType: public ::xml_schema::type
  {
    public:

    struct _xsd_tableInfoType
    {
      typedef ::xml_schema::type base_;
    };

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // Constructors.
    //
    public:
    tableInfoType (const table::type&);

    tableInfoType (const ::xercesc::DOMElement&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

    tableInfoType (const tableInfoType&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

    virtual tableInfoType*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< table::type > _xsd_table_;
  };

  class fieldType: public ::xml_schema::string
  {
    public:
    enum _xsd_fieldType
    {
      integer,
      float_,
      string,
      boolean
    };

    fieldType (_xsd_fieldType);

    fieldType (const ::xml_schema::string&);

    fieldType (const ::xercesc::DOMElement&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    fieldType (const ::xercesc::DOMAttr&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    fieldType (const ::std::basic_string< char >&,
               const ::xercesc::DOMElement*,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    fieldType (const fieldType&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    virtual fieldType*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    fieldType&
    operator= (_xsd_fieldType);

    virtual
    operator _xsd_fieldType () const
    {
      return _xsd_fieldType_convert ();
    }

    protected:
    _xsd_fieldType
    _xsd_fieldType_convert () const;

    public:
    static const char* const _xsd_fieldType_literals_[4];
    static const _xsd_fieldType _xsd_fieldType_indexes_[4];
  };

  class fieldInfoType: public ::xml_schema::type
  {
    public:

    struct _xsd_fieldInfoType
    {
      typedef ::xml_schema::type base_;
    };

    // Workaround for g++ bug# 23206.
    //
    public:
    struct type;

    // field
    // 
    public:
    struct field
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const field::type&
    field () const;

    field::type&
    field ();

    void
    field (const field::type&);

    void
    field (::std::auto_ptr< field::type >);

    // type
    // 
    public:
    struct type
    {
      typedef ::dsmessage::fieldType type_;
      typedef ::xsd::cxx::tree::traits< type_, char > traits;
    };

    const type::type_&
    type () const;

    type::type_&
    type ();

    void
    type (const type::type_&);

    void
    type (::std::auto_ptr< type::type_ >);

    // Constructors.
    //
    public:
    fieldInfoType (const field::type&,
                   const type::type_&);

    fieldInfoType (const ::xercesc::DOMElement&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

    fieldInfoType (const fieldInfoType&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

    virtual fieldInfoType*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< field::type > _xsd_field_;
    ::xsd::cxx::tree::one< type::type_ > _xsd_type_;
  };

  class fieldNameValue: public ::xml_schema::type
  {
    public:

    struct _xsd_fieldNameValue
    {
      typedef ::xml_schema::type base_;
    };

    // value
    // 
    public:
    struct value
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const value::type&
    value () const;

    value::type&
    value ();

    void
    value (const value::type&);

    void
    value (::std::auto_ptr< value::type >);

    // field
    // 
    public:
    struct field
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const field::type&
    field () const;

    field::type&
    field ();

    void
    field (const field::type&);

    void
    field (::std::auto_ptr< field::type >);

    // Constructors.
    //
    public:
    fieldNameValue (const value::type&,
                    const field::type&);

    fieldNameValue (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    fieldNameValue (const fieldNameValue&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    virtual fieldNameValue*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< value::type > _xsd_value_;
    ::xsd::cxx::tree::one< field::type > _xsd_field_;
  };

  class fieldName: public ::xml_schema::type
  {
    public:

    struct _xsd_fieldName
    {
      typedef ::xml_schema::type base_;
    };

    // field
    // 
    public:
    struct field
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const field::type&
    field () const;

    field::type&
    field ();

    void
    field (const field::type&);

    void
    field (::std::auto_ptr< field::type >);

    // Constructors.
    //
    public:
    fieldName (const field::type&);

    fieldName (const ::xercesc::DOMElement&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    fieldName (const fieldName&,
               ::xml_schema::flags = 0,
               ::xml_schema::type* = 0);

    virtual fieldName*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< field::type > _xsd_field_;
  };

  class languageName: public ::xml_schema::type
  {
    public:

    struct _xsd_languageName
    {
      typedef ::xml_schema::type base_;
    };

    // language
    // 
    public:
    struct language
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const language::type&
    language () const;

    language::type&
    language ();

    void
    language (const language::type&);

    void
    language (::std::auto_ptr< language::type >);

    // Constructors.
    //
    public:
    languageName (const language::type&);

    languageName (const ::xercesc::DOMElement&,
                  ::xml_schema::flags = 0,
                  ::xml_schema::type* = 0);

    languageName (const languageName&,
                  ::xml_schema::flags = 0,
                  ::xml_schema::type* = 0);

    virtual languageName*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< language::type > _xsd_language_;
  };

  class ds_caps_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_caps_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    ds_caps_request_type ();

    ds_caps_request_type (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_caps_request_type (const ::xercesc::DOMAttr&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_caps_request_type (const ::std::basic_string< char >&,
                          const ::xercesc::DOMElement*,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_caps_request_type (const ds_caps_request_type&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    virtual ds_caps_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class ds_caps_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_caps_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // language
    // 
    public:
    struct language
    {
      typedef ::dsmessage::languageName type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const language::container&
    language () const;

    language::container&
    language ();

    void
    language (const language::container&);

    // storetype
    // 
    public:
    struct storetype
    {
      typedef ::dsmessage::storeType type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const storetype::type&
    storetype () const;

    storetype::type&
    storetype ();

    void
    storetype (const storetype::type&);

    void
    storetype (::std::auto_ptr< storetype::type >);

    // supports-trigger
    // 
    public:
    struct supports_trigger
    {
      typedef ::xml_schema::boolean type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const supports_trigger::type&
    supports_trigger () const;

    supports_trigger::type&
    supports_trigger ();

    void
    supports_trigger (const supports_trigger::type&);

    // Constructors.
    //
    public:
    ds_caps_reply_type (const storetype::type&,
                        const supports_trigger::type&);

    ds_caps_reply_type (const ::xercesc::DOMElement&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    ds_caps_reply_type (const ds_caps_reply_type&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    virtual ds_caps_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< language::type > _xsd_language_;
    ::xsd::cxx::tree::one< storetype::type > _xsd_storetype_;
    ::xsd::cxx::tree::one< supports_trigger::type > _xsd_supports_trigger_;
  };

  class ds_create_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_create_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // password
    // 
    public:
    struct password
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const password::container&
    password () const;

    password::container&
    password ();

    void
    password (const password::type&);

    void
    password (const password::container&);

    void
    password (::std::auto_ptr< password::type >);

    // ds
    // 
    public:
    struct ds
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const ds::type&
    ds () const;

    ds::type&
    ds ();

    void
    ds (const ds::type&);

    void
    ds (::std::auto_ptr< ds::type >);

    // clear
    // 
    public:
    struct clear
    {
      typedef ::xml_schema::boolean type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const clear::container&
    clear () const;

    clear::container&
    clear ();

    void
    clear (const clear::type&);

    void
    clear (const clear::container&);

    // quota
    // 
    public:
    struct quota
    {
      typedef ::xml_schema::unsigned_int type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const quota::container&
    quota () const;

    quota::container&
    quota ();

    void
    quota (const quota::type&);

    void
    quota (const quota::container&);

    // user
    // 
    public:
    struct user
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const user::container&
    user () const;

    user::container&
    user ();

    void
    user (const user::type&);

    void
    user (const user::container&);

    void
    user (::std::auto_ptr< user::type >);

    // Constructors.
    //
    public:
    ds_create_request_type (const ds::type&);

    ds_create_request_type (const ::xercesc::DOMElement&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

    ds_create_request_type (const ds_create_request_type&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

    virtual ds_create_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< password::type > _xsd_password_;
    ::xsd::cxx::tree::one< ds::type > _xsd_ds_;
    ::xsd::cxx::tree::optional< clear::type > _xsd_clear_;
    ::xsd::cxx::tree::optional< quota::type > _xsd_quota_;
    ::xsd::cxx::tree::optional< user::type > _xsd_user_;
  };

  class ds_create_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_create_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    ds_create_reply_type ();

    ds_create_reply_type (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_create_reply_type (const ::xercesc::DOMAttr&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_create_reply_type (const ::std::basic_string< char >&,
                          const ::xercesc::DOMElement*,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_create_reply_type (const ds_create_reply_type&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    virtual ds_create_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class ds_del_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_del_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // password
    // 
    public:
    struct password
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const password::container&
    password () const;

    password::container&
    password ();

    void
    password (const password::type&);

    void
    password (const password::container&);

    void
    password (::std::auto_ptr< password::type >);

    // ds
    // 
    public:
    struct ds
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const ds::type&
    ds () const;

    ds::type&
    ds ();

    void
    ds (const ds::type&);

    void
    ds (::std::auto_ptr< ds::type >);

    // user
    // 
    public:
    struct user
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const user::container&
    user () const;

    user::container&
    user ();

    void
    user (const user::type&);

    void
    user (const user::container&);

    void
    user (::std::auto_ptr< user::type >);

    // Constructors.
    //
    public:
    ds_del_request_type (const ds::type&);

    ds_del_request_type (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    ds_del_request_type (const ds_del_request_type&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    virtual ds_del_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< password::type > _xsd_password_;
    ::xsd::cxx::tree::one< ds::type > _xsd_ds_;
    ::xsd::cxx::tree::optional< user::type > _xsd_user_;
  };

  class ds_del_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_del_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    ds_del_reply_type ();

    ds_del_reply_type (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    ds_del_reply_type (const ::xercesc::DOMAttr&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    ds_del_reply_type (const ::std::basic_string< char >&,
                       const ::xercesc::DOMElement*,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    ds_del_reply_type (const ds_del_reply_type&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    virtual ds_del_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class ds_open_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_open_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // password
    // 
    public:
    struct password
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const password::container&
    password () const;

    password::container&
    password ();

    void
    password (const password::type&);

    void
    password (const password::container&);

    void
    password (::std::auto_ptr< password::type >);

    // ds
    // 
    public:
    struct ds
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const ds::type&
    ds () const;

    ds::type&
    ds ();

    void
    ds (const ds::type&);

    void
    ds (::std::auto_ptr< ds::type >);

    // lease
    // 
    public:
    struct lease
    {
      typedef ::xml_schema::unsigned_int type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const lease::container&
    lease () const;

    lease::container&
    lease ();

    void
    lease (const lease::type&);

    void
    lease (const lease::container&);

    // user
    // 
    public:
    struct user
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const user::container&
    user () const;

    user::container&
    user ();

    void
    user (const user::type&);

    void
    user (const user::container&);

    void
    user (::std::auto_ptr< user::type >);

    // Constructors.
    //
    public:
    ds_open_request_type (const ds::type&);

    ds_open_request_type (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_open_request_type (const ds_open_request_type&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    virtual ds_open_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< password::type > _xsd_password_;
    ::xsd::cxx::tree::one< ds::type > _xsd_ds_;
    ::xsd::cxx::tree::optional< lease::type > _xsd_lease_;
    ::xsd::cxx::tree::optional< user::type > _xsd_user_;
  };

  class ds_open_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_open_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const handle::container&
    handle () const;

    handle::container&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (const handle::container&);

    void
    handle (::std::auto_ptr< handle::type >);

    // Constructors.
    //
    public:
    ds_open_reply_type ();

    ds_open_reply_type (const ::xercesc::DOMElement&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    ds_open_reply_type (const ds_open_reply_type&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    virtual ds_open_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< handle::type > _xsd_handle_;
  };

  class ds_stat_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_stat_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // Constructors.
    //
    public:
    ds_stat_request_type (const handle::type&);

    ds_stat_request_type (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    ds_stat_request_type (const ds_stat_request_type&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    virtual ds_stat_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
  };

  class ds_stat_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_stat_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // table
    // 
    public:
    struct table
    {
      typedef ::dsmessage::tableInfoType type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const table::container&
    table () const;

    table::container&
    table ();

    void
    table (const table::container&);

    // Constructors.
    //
    public:
    ds_stat_reply_type ();

    ds_stat_reply_type (const ::xercesc::DOMElement&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    ds_stat_reply_type (const ds_stat_reply_type&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    virtual ds_stat_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< table::type > _xsd_table_;
  };

  class ds_close_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_close_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // Constructors.
    //
    public:
    ds_close_request_type (const handle::type&);

    ds_close_request_type (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

    ds_close_request_type (const ds_close_request_type&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

    virtual ds_close_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
  };

  class ds_close_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_close_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    ds_close_reply_type ();

    ds_close_reply_type (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    ds_close_reply_type (const ::xercesc::DOMAttr&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    ds_close_reply_type (const ::std::basic_string< char >&,
                         const ::xercesc::DOMElement*,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    ds_close_reply_type (const ds_close_reply_type&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    virtual ds_close_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class table_create_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_create_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // field
    // 
    public:
    struct field
    {
      typedef ::dsmessage::fieldInfoType type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const field::container&
    field () const;

    field::container&
    field ();

    void
    field (const field::container&);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // key
    // 
    public:
    struct key
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const key::type&
    key () const;

    key::type&
    key ();

    void
    key (const key::type&);

    void
    key (::std::auto_ptr< key::type >);

    // keytype
    // 
    public:
    struct keytype
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keytype::type&
    keytype () const;

    keytype::type&
    keytype ();

    void
    keytype (const keytype::type&);

    void
    keytype (::std::auto_ptr< keytype::type >);

    // Constructors.
    //
    public:
    table_create_request_type (const handle::type&,
                               const table::type&,
                               const key::type&,
                               const keytype::type&);

    table_create_request_type (const ::xercesc::DOMElement&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

    table_create_request_type (const table_create_request_type&,
                               ::xml_schema::flags = 0,
                               ::xml_schema::type* = 0);

    virtual table_create_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< field::type > _xsd_field_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
    ::xsd::cxx::tree::one< key::type > _xsd_key_;
    ::xsd::cxx::tree::one< keytype::type > _xsd_keytype_;
  };

  class table_create_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_create_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    table_create_reply_type ();

    table_create_reply_type (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    table_create_reply_type (const ::xercesc::DOMAttr&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    table_create_reply_type (const ::std::basic_string< char >&,
                             const ::xercesc::DOMElement*,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    table_create_reply_type (const table_create_reply_type&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    virtual table_create_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class table_del_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_del_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // Constructors.
    //
    public:
    table_del_request_type (const handle::type&,
                            const table::type&);

    table_del_request_type (const ::xercesc::DOMElement&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

    table_del_request_type (const table_del_request_type&,
                            ::xml_schema::flags = 0,
                            ::xml_schema::type* = 0);

    virtual table_del_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
  };

  class table_del_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_del_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    table_del_reply_type ();

    table_del_reply_type (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    table_del_reply_type (const ::xercesc::DOMAttr&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    table_del_reply_type (const ::std::basic_string< char >&,
                          const ::xercesc::DOMElement*,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    table_del_reply_type (const table_del_reply_type&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    virtual table_del_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class table_stat_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_stat_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // Constructors.
    //
    public:
    table_stat_request_type (const handle::type&,
                             const table::type&);

    table_stat_request_type (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    table_stat_request_type (const table_stat_request_type&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    virtual table_stat_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
  };

  class table_stat_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_stat_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // field
    // 
    public:
    struct field
    {
      typedef ::dsmessage::fieldInfoType type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const field::container&
    field () const;

    field::container&
    field ();

    void
    field (const field::container&);

    // keyname
    // 
    public:
    struct keyname
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keyname::type&
    keyname () const;

    keyname::type&
    keyname ();

    void
    keyname (const keyname::type&);

    void
    keyname (::std::auto_ptr< keyname::type >);

    // keytype
    // 
    public:
    struct keytype
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keytype::type&
    keytype () const;

    keytype::type&
    keytype ();

    void
    keytype (const keytype::type&);

    void
    keytype (::std::auto_ptr< keytype::type >);

    // count
    // 
    public:
    struct count
    {
      typedef ::xml_schema::unsigned_int type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const count::type&
    count () const;

    count::type&
    count ();

    void
    count (const count::type&);

    // Constructors.
    //
    public:
    table_stat_reply_type (const keyname::type&,
                           const keytype::type&,
                           const count::type&);

    table_stat_reply_type (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

    table_stat_reply_type (const table_stat_reply_type&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

    virtual table_stat_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< field::type > _xsd_field_;
    ::xsd::cxx::tree::one< keyname::type > _xsd_keyname_;
    ::xsd::cxx::tree::one< keytype::type > _xsd_keytype_;
    ::xsd::cxx::tree::one< count::type > _xsd_count_;
  };

  class table_keys_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_keys_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // keyname
    // 
    public:
    struct keyname
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keyname::type&
    keyname () const;

    keyname::type&
    keyname ();

    void
    keyname (const keyname::type&);

    void
    keyname (::std::auto_ptr< keyname::type >);

    // Constructors.
    //
    public:
    table_keys_request_type (const handle::type&,
                             const table::type&,
                             const keyname::type&);

    table_keys_request_type (const ::xercesc::DOMElement&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    table_keys_request_type (const table_keys_request_type&,
                             ::xml_schema::flags = 0,
                             ::xml_schema::type* = 0);

    virtual table_keys_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
    ::xsd::cxx::tree::one< keyname::type > _xsd_keyname_;
  };

  class table_keys_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_table_keys_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // key
    // 
    public:
    struct key
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const key::container&
    key () const;

    key::container&
    key ();

    void
    key (const key::container&);

    // Constructors.
    //
    public:
    table_keys_reply_type ();

    table_keys_reply_type (const ::xercesc::DOMElement&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

    table_keys_reply_type (const table_keys_reply_type&,
                           ::xml_schema::flags = 0,
                           ::xml_schema::type* = 0);

    virtual table_keys_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< key::type > _xsd_key_;
  };

  class put_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_put_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // key
    // 
    public:
    struct key
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const key::type&
    key () const;

    key::type&
    key ();

    void
    key (const key::type&);

    void
    key (::std::auto_ptr< key::type >);

    // set
    // 
    public:
    struct set
    {
      typedef ::dsmessage::fieldNameValue type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const set::container&
    set () const;

    set::container&
    set ();

    void
    set (const set::container&);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // keyname
    // 
    public:
    struct keyname
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keyname::type&
    keyname () const;

    keyname::type&
    keyname ();

    void
    keyname (const keyname::type&);

    void
    keyname (::std::auto_ptr< keyname::type >);

    // Constructors.
    //
    public:
    put_request_type (const key::type&,
                      const handle::type&,
                      const table::type&,
                      const keyname::type&);

    put_request_type (const ::xercesc::DOMElement&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

    put_request_type (const put_request_type&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

    virtual put_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< key::type > _xsd_key_;
    ::xsd::cxx::tree::sequence< set::type > _xsd_set_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
    ::xsd::cxx::tree::one< keyname::type > _xsd_keyname_;
  };

  class put_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_put_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    put_reply_type ();

    put_reply_type (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    put_reply_type (const ::xercesc::DOMAttr&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    put_reply_type (const ::std::basic_string< char >&,
                    const ::xercesc::DOMElement*,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    put_reply_type (const put_reply_type&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    virtual put_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class get_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_get_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // key
    // 
    public:
    struct key
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const key::type&
    key () const;

    key::type&
    key ();

    void
    key (const key::type&);

    void
    key (::std::auto_ptr< key::type >);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // keyname
    // 
    public:
    struct keyname
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keyname::type&
    keyname () const;

    keyname::type&
    keyname ();

    void
    keyname (const keyname::type&);

    void
    keyname (::std::auto_ptr< keyname::type >);

    // Constructors.
    //
    public:
    get_request_type (const key::type&,
                      const handle::type&,
                      const table::type&,
                      const keyname::type&);

    get_request_type (const ::xercesc::DOMElement&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

    get_request_type (const get_request_type&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

    virtual get_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< key::type > _xsd_key_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
    ::xsd::cxx::tree::one< keyname::type > _xsd_keyname_;
  };

  class get_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_get_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // field
    // 
    public:
    struct field
    {
      typedef ::dsmessage::fieldNameValue type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const field::container&
    field () const;

    field::container&
    field ();

    void
    field (const field::container&);

    // Constructors.
    //
    public:
    get_reply_type ();

    get_reply_type (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    get_reply_type (const get_reply_type&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    virtual get_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< field::type > _xsd_field_;
  };

  class del_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_del_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // key
    // 
    public:
    struct key
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const key::type&
    key () const;

    key::type&
    key ();

    void
    key (const key::type&);

    void
    key (::std::auto_ptr< key::type >);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // keyname
    // 
    public:
    struct keyname
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const keyname::type&
    keyname () const;

    keyname::type&
    keyname ();

    void
    keyname (const keyname::type&);

    void
    keyname (::std::auto_ptr< keyname::type >);

    // Constructors.
    //
    public:
    del_request_type (const key::type&,
                      const handle::type&,
                      const table::type&,
                      const keyname::type&);

    del_request_type (const ::xercesc::DOMElement&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

    del_request_type (const del_request_type&,
                      ::xml_schema::flags = 0,
                      ::xml_schema::type* = 0);

    virtual del_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< key::type > _xsd_key_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
    ::xsd::cxx::tree::one< keyname::type > _xsd_keyname_;
  };

  class del_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_del_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // Constructors.
    //
    public:
    del_reply_type ();

    del_reply_type (const ::xercesc::DOMElement&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    del_reply_type (const ::xercesc::DOMAttr&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    del_reply_type (const ::std::basic_string< char >&,
                    const ::xercesc::DOMElement*,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    del_reply_type (const del_reply_type&,
                    ::xml_schema::flags = 0,
                    ::xml_schema::type* = 0);

    virtual del_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;
  };

  class select_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_select_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // get
    // 
    public:
    struct get
    {
      typedef ::dsmessage::fieldName type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const get::container&
    get () const;

    get::container&
    get ();

    void
    get (const get::container&);

    // where
    // 
    public:
    struct where
    {
      typedef ::dsmessage::fieldNameValue type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const where::container&
    where () const;

    where::container&
    where ();

    void
    where (const where::container&);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // table
    // 
    public:
    struct table
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const table::type&
    table () const;

    table::type&
    table ();

    void
    table (const table::type&);

    void
    table (::std::auto_ptr< table::type >);

    // count
    // 
    public:
    struct count
    {
      typedef ::xml_schema::unsigned_int type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const count::container&
    count () const;

    count::container&
    count ();

    void
    count (const count::type&);

    void
    count (const count::container&);

    // Constructors.
    //
    public:
    select_request_type (const handle::type&,
                         const table::type&);

    select_request_type (const ::xercesc::DOMElement&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    select_request_type (const select_request_type&,
                         ::xml_schema::flags = 0,
                         ::xml_schema::type* = 0);

    virtual select_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< get::type > _xsd_get_;
    ::xsd::cxx::tree::sequence< where::type > _xsd_where_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< table::type > _xsd_table_;
    ::xsd::cxx::tree::optional< count::type > _xsd_count_;
  };

  class rowType: public ::xml_schema::type
  {
    public:

    struct _xsd_rowType
    {
      typedef ::xml_schema::type base_;
    };

    // field
    // 
    public:
    struct field
    {
      typedef ::dsmessage::fieldNameValue type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const field::container&
    field () const;

    field::container&
    field ();

    void
    field (const field::container&);

    // Constructors.
    //
    public:
    rowType ();

    rowType (const ::xercesc::DOMElement&,
             ::xml_schema::flags = 0,
             ::xml_schema::type* = 0);

    rowType (const rowType&,
             ::xml_schema::flags = 0,
             ::xml_schema::type* = 0);

    virtual rowType*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< field::type > _xsd_field_;
  };

  class select_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_select_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // row
    // 
    public:
    struct row
    {
      typedef ::dsmessage::rowType type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::sequence< type > container;
      typedef container::iterator iterator;
      typedef container::const_iterator const_iterator;
    };

    const row::container&
    row () const;

    row::container&
    row ();

    void
    row (const row::container&);

    // Constructors.
    //
    public:
    select_reply_type ();

    select_reply_type (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    select_reply_type (const select_reply_type&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    virtual select_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::sequence< row::type > _xsd_row_;
  };

  class eval_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_eval_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // expr
    // 
    public:
    struct expr
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const expr::type&
    expr () const;

    expr::type&
    expr ();

    void
    expr (const expr::type&);

    void
    expr (::std::auto_ptr< expr::type >);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // language
    // 
    public:
    struct language
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const language::type&
    language () const;

    language::type&
    language ();

    void
    language (const language::type&);

    void
    language (::std::auto_ptr< language::type >);

    // Constructors.
    //
    public:
    eval_request_type (const expr::type&,
                       const handle::type&,
                       const language::type&);

    eval_request_type (const ::xercesc::DOMElement&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    eval_request_type (const eval_request_type&,
                       ::xml_schema::flags = 0,
                       ::xml_schema::type* = 0);

    virtual eval_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< expr::type > _xsd_expr_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< language::type > _xsd_language_;
  };

  class eval_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_eval_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // value
    // 
    public:
    struct value
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const value::type&
    value () const;

    value::type&
    value ();

    void
    value (const value::type&);

    void
    value (::std::auto_ptr< value::type >);

    // language
    // 
    public:
    struct language
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const language::type&
    language () const;

    language::type&
    language ();

    void
    language (const language::type&);

    void
    language (::std::auto_ptr< language::type >);

    // Constructors.
    //
    public:
    eval_reply_type (const value::type&,
                     const language::type&);

    eval_reply_type (const ::xercesc::DOMElement&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

    eval_reply_type (const eval_reply_type&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

    virtual eval_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< value::type > _xsd_value_;
    ::xsd::cxx::tree::one< language::type > _xsd_language_;
  };

  class trigger_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_trigger_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // expr
    // 
    public:
    struct expr
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const expr::type&
    expr () const;

    expr::type&
    expr ();

    void
    expr (const expr::type&);

    void
    expr (::std::auto_ptr< expr::type >);

    // handle
    // 
    public:
    struct handle
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const handle::type&
    handle () const;

    handle::type&
    handle ();

    void
    handle (const handle::type&);

    void
    handle (::std::auto_ptr< handle::type >);

    // language
    // 
    public:
    struct language
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const language::type&
    language () const;

    language::type&
    language ();

    void
    language (const language::type&);

    void
    language (::std::auto_ptr< language::type >);

    // Constructors.
    //
    public:
    trigger_request_type (const expr::type&,
                          const handle::type&,
                          const language::type&);

    trigger_request_type (const ::xercesc::DOMElement&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    trigger_request_type (const trigger_request_type&,
                          ::xml_schema::flags = 0,
                          ::xml_schema::type* = 0);

    virtual trigger_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< expr::type > _xsd_expr_;
    ::xsd::cxx::tree::one< handle::type > _xsd_handle_;
    ::xsd::cxx::tree::one< language::type > _xsd_language_;
  };

  class trigger_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_trigger_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // value
    // 
    public:
    struct value
    {
      typedef ::xml_schema::base64_binary type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const value::type&
    value () const;

    value::type&
    value ();

    void
    value (const value::type&);

    void
    value (::std::auto_ptr< value::type >);

    // language
    // 
    public:
    struct language
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const language::type&
    language () const;

    language::type&
    language ();

    void
    language (const language::type&);

    void
    language (::std::auto_ptr< language::type >);

    // Constructors.
    //
    public:
    trigger_reply_type (const value::type&,
                        const language::type&);

    trigger_reply_type (const ::xercesc::DOMElement&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    trigger_reply_type (const trigger_reply_type&,
                        ::xml_schema::flags = 0,
                        ::xml_schema::type* = 0);

    virtual trigger_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::one< value::type > _xsd_value_;
    ::xsd::cxx::tree::one< language::type > _xsd_language_;
  };

  class ds_request_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_request_type
    {
      typedef ::xml_schema::type base_;
    };

    // ds-caps
    // 
    public:
    struct ds_caps
    {
      typedef ::dsmessage::ds_caps_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_caps::container&
    ds_caps () const;

    ds_caps::container&
    ds_caps ();

    void
    ds_caps (const ds_caps::type&);

    void
    ds_caps (const ds_caps::container&);

    void
    ds_caps (::std::auto_ptr< ds_caps::type >);

    // ds-create
    // 
    public:
    struct ds_create
    {
      typedef ::dsmessage::ds_create_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_create::container&
    ds_create () const;

    ds_create::container&
    ds_create ();

    void
    ds_create (const ds_create::type&);

    void
    ds_create (const ds_create::container&);

    void
    ds_create (::std::auto_ptr< ds_create::type >);

    // ds-del
    // 
    public:
    struct ds_del
    {
      typedef ::dsmessage::ds_del_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_del::container&
    ds_del () const;

    ds_del::container&
    ds_del ();

    void
    ds_del (const ds_del::type&);

    void
    ds_del (const ds_del::container&);

    void
    ds_del (::std::auto_ptr< ds_del::type >);

    // ds-open
    // 
    public:
    struct ds_open
    {
      typedef ::dsmessage::ds_open_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_open::container&
    ds_open () const;

    ds_open::container&
    ds_open ();

    void
    ds_open (const ds_open::type&);

    void
    ds_open (const ds_open::container&);

    void
    ds_open (::std::auto_ptr< ds_open::type >);

    // ds-stat
    // 
    public:
    struct ds_stat
    {
      typedef ::dsmessage::ds_stat_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_stat::container&
    ds_stat () const;

    ds_stat::container&
    ds_stat ();

    void
    ds_stat (const ds_stat::type&);

    void
    ds_stat (const ds_stat::container&);

    void
    ds_stat (::std::auto_ptr< ds_stat::type >);

    // ds-close
    // 
    public:
    struct ds_close
    {
      typedef ::dsmessage::ds_close_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_close::container&
    ds_close () const;

    ds_close::container&
    ds_close ();

    void
    ds_close (const ds_close::type&);

    void
    ds_close (const ds_close::container&);

    void
    ds_close (::std::auto_ptr< ds_close::type >);

    // table-create
    // 
    public:
    struct table_create
    {
      typedef ::dsmessage::table_create_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_create::container&
    table_create () const;

    table_create::container&
    table_create ();

    void
    table_create (const table_create::type&);

    void
    table_create (const table_create::container&);

    void
    table_create (::std::auto_ptr< table_create::type >);

    // table-del
    // 
    public:
    struct table_del
    {
      typedef ::dsmessage::table_del_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_del::container&
    table_del () const;

    table_del::container&
    table_del ();

    void
    table_del (const table_del::type&);

    void
    table_del (const table_del::container&);

    void
    table_del (::std::auto_ptr< table_del::type >);

    // table-stat
    // 
    public:
    struct table_stat
    {
      typedef ::dsmessage::table_stat_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_stat::container&
    table_stat () const;

    table_stat::container&
    table_stat ();

    void
    table_stat (const table_stat::type&);

    void
    table_stat (const table_stat::container&);

    void
    table_stat (::std::auto_ptr< table_stat::type >);

    // table-keys
    // 
    public:
    struct table_keys
    {
      typedef ::dsmessage::table_keys_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_keys::container&
    table_keys () const;

    table_keys::container&
    table_keys ();

    void
    table_keys (const table_keys::type&);

    void
    table_keys (const table_keys::container&);

    void
    table_keys (::std::auto_ptr< table_keys::type >);

    // put
    // 
    public:
    struct put
    {
      typedef ::dsmessage::put_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const put::container&
    put () const;

    put::container&
    put ();

    void
    put (const put::type&);

    void
    put (const put::container&);

    void
    put (::std::auto_ptr< put::type >);

    // get
    // 
    public:
    struct get
    {
      typedef ::dsmessage::get_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const get::container&
    get () const;

    get::container&
    get ();

    void
    get (const get::type&);

    void
    get (const get::container&);

    void
    get (::std::auto_ptr< get::type >);

    // del
    // 
    public:
    struct del
    {
      typedef ::dsmessage::del_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const del::container&
    del () const;

    del::container&
    del ();

    void
    del (const del::type&);

    void
    del (const del::container&);

    void
    del (::std::auto_ptr< del::type >);

    // select
    // 
    public:
    struct select
    {
      typedef ::dsmessage::select_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const select::container&
    select () const;

    select::container&
    select ();

    void
    select (const select::type&);

    void
    select (const select::container&);

    void
    select (::std::auto_ptr< select::type >);

    // eval
    // 
    public:
    struct eval
    {
      typedef ::dsmessage::eval_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const eval::container&
    eval () const;

    eval::container&
    eval ();

    void
    eval (const eval::type&);

    void
    eval (const eval::container&);

    void
    eval (::std::auto_ptr< eval::type >);

    // trigger
    // 
    public:
    struct trigger
    {
      typedef ::dsmessage::trigger_request_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const trigger::container&
    trigger () const;

    trigger::container&
    trigger ();

    void
    trigger (const trigger::type&);

    void
    trigger (const trigger::container&);

    void
    trigger (::std::auto_ptr< trigger::type >);

    // cookie
    // 
    public:
    struct cookie
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const cookie::type&
    cookie () const;

    cookie::type&
    cookie ();

    void
    cookie (const cookie::type&);

    void
    cookie (::std::auto_ptr< cookie::type >);

    // Constructors.
    //
    public:
    ds_request_type (const cookie::type&);

    ds_request_type (const ::xercesc::DOMElement&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

    ds_request_type (const ds_request_type&,
                     ::xml_schema::flags = 0,
                     ::xml_schema::type* = 0);

    virtual ds_request_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< ds_caps::type > _xsd_ds_caps_;
    ::xsd::cxx::tree::optional< ds_create::type > _xsd_ds_create_;
    ::xsd::cxx::tree::optional< ds_del::type > _xsd_ds_del_;
    ::xsd::cxx::tree::optional< ds_open::type > _xsd_ds_open_;
    ::xsd::cxx::tree::optional< ds_stat::type > _xsd_ds_stat_;
    ::xsd::cxx::tree::optional< ds_close::type > _xsd_ds_close_;
    ::xsd::cxx::tree::optional< table_create::type > _xsd_table_create_;
    ::xsd::cxx::tree::optional< table_del::type > _xsd_table_del_;
    ::xsd::cxx::tree::optional< table_stat::type > _xsd_table_stat_;
    ::xsd::cxx::tree::optional< table_keys::type > _xsd_table_keys_;
    ::xsd::cxx::tree::optional< put::type > _xsd_put_;
    ::xsd::cxx::tree::optional< get::type > _xsd_get_;
    ::xsd::cxx::tree::optional< del::type > _xsd_del_;
    ::xsd::cxx::tree::optional< select::type > _xsd_select_;
    ::xsd::cxx::tree::optional< eval::type > _xsd_eval_;
    ::xsd::cxx::tree::optional< trigger::type > _xsd_trigger_;
    ::xsd::cxx::tree::one< cookie::type > _xsd_cookie_;
  };

  class ds_reply_type: public ::xml_schema::type
  {
    public:

    struct _xsd_ds_reply_type
    {
      typedef ::xml_schema::type base_;
    };

    // ds-caps-reply
    // 
    public:
    struct ds_caps_reply
    {
      typedef ::dsmessage::ds_caps_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_caps_reply::container&
    ds_caps_reply () const;

    ds_caps_reply::container&
    ds_caps_reply ();

    void
    ds_caps_reply (const ds_caps_reply::type&);

    void
    ds_caps_reply (const ds_caps_reply::container&);

    void
    ds_caps_reply (::std::auto_ptr< ds_caps_reply::type >);

    // ds-create-reply
    // 
    public:
    struct ds_create_reply
    {
      typedef ::dsmessage::ds_create_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_create_reply::container&
    ds_create_reply () const;

    ds_create_reply::container&
    ds_create_reply ();

    void
    ds_create_reply (const ds_create_reply::type&);

    void
    ds_create_reply (const ds_create_reply::container&);

    void
    ds_create_reply (::std::auto_ptr< ds_create_reply::type >);

    // ds-del-reply
    // 
    public:
    struct ds_del_reply
    {
      typedef ::dsmessage::ds_del_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_del_reply::container&
    ds_del_reply () const;

    ds_del_reply::container&
    ds_del_reply ();

    void
    ds_del_reply (const ds_del_reply::type&);

    void
    ds_del_reply (const ds_del_reply::container&);

    void
    ds_del_reply (::std::auto_ptr< ds_del_reply::type >);

    // ds-open-reply
    // 
    public:
    struct ds_open_reply
    {
      typedef ::dsmessage::ds_open_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_open_reply::container&
    ds_open_reply () const;

    ds_open_reply::container&
    ds_open_reply ();

    void
    ds_open_reply (const ds_open_reply::type&);

    void
    ds_open_reply (const ds_open_reply::container&);

    void
    ds_open_reply (::std::auto_ptr< ds_open_reply::type >);

    // ds-stat-reply
    // 
    public:
    struct ds_stat_reply
    {
      typedef ::dsmessage::ds_stat_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_stat_reply::container&
    ds_stat_reply () const;

    ds_stat_reply::container&
    ds_stat_reply ();

    void
    ds_stat_reply (const ds_stat_reply::type&);

    void
    ds_stat_reply (const ds_stat_reply::container&);

    void
    ds_stat_reply (::std::auto_ptr< ds_stat_reply::type >);

    // ds-close-reply
    // 
    public:
    struct ds_close_reply
    {
      typedef ::dsmessage::ds_close_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const ds_close_reply::container&
    ds_close_reply () const;

    ds_close_reply::container&
    ds_close_reply ();

    void
    ds_close_reply (const ds_close_reply::type&);

    void
    ds_close_reply (const ds_close_reply::container&);

    void
    ds_close_reply (::std::auto_ptr< ds_close_reply::type >);

    // table-create-reply
    // 
    public:
    struct table_create_reply
    {
      typedef ::dsmessage::table_create_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_create_reply::container&
    table_create_reply () const;

    table_create_reply::container&
    table_create_reply ();

    void
    table_create_reply (const table_create_reply::type&);

    void
    table_create_reply (const table_create_reply::container&);

    void
    table_create_reply (::std::auto_ptr< table_create_reply::type >);

    // table-del-reply
    // 
    public:
    struct table_del_reply
    {
      typedef ::dsmessage::table_del_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_del_reply::container&
    table_del_reply () const;

    table_del_reply::container&
    table_del_reply ();

    void
    table_del_reply (const table_del_reply::type&);

    void
    table_del_reply (const table_del_reply::container&);

    void
    table_del_reply (::std::auto_ptr< table_del_reply::type >);

    // table-stat-reply
    // 
    public:
    struct table_stat_reply
    {
      typedef ::dsmessage::table_stat_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_stat_reply::container&
    table_stat_reply () const;

    table_stat_reply::container&
    table_stat_reply ();

    void
    table_stat_reply (const table_stat_reply::type&);

    void
    table_stat_reply (const table_stat_reply::container&);

    void
    table_stat_reply (::std::auto_ptr< table_stat_reply::type >);

    // table-keys-reply
    // 
    public:
    struct table_keys_reply
    {
      typedef ::dsmessage::table_keys_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const table_keys_reply::container&
    table_keys_reply () const;

    table_keys_reply::container&
    table_keys_reply ();

    void
    table_keys_reply (const table_keys_reply::type&);

    void
    table_keys_reply (const table_keys_reply::container&);

    void
    table_keys_reply (::std::auto_ptr< table_keys_reply::type >);

    // put-reply
    // 
    public:
    struct put_reply
    {
      typedef ::dsmessage::put_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const put_reply::container&
    put_reply () const;

    put_reply::container&
    put_reply ();

    void
    put_reply (const put_reply::type&);

    void
    put_reply (const put_reply::container&);

    void
    put_reply (::std::auto_ptr< put_reply::type >);

    // get-reply
    // 
    public:
    struct get_reply
    {
      typedef ::dsmessage::get_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const get_reply::container&
    get_reply () const;

    get_reply::container&
    get_reply ();

    void
    get_reply (const get_reply::type&);

    void
    get_reply (const get_reply::container&);

    void
    get_reply (::std::auto_ptr< get_reply::type >);

    // del-reply
    // 
    public:
    struct del_reply
    {
      typedef ::dsmessage::del_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const del_reply::container&
    del_reply () const;

    del_reply::container&
    del_reply ();

    void
    del_reply (const del_reply::type&);

    void
    del_reply (const del_reply::container&);

    void
    del_reply (::std::auto_ptr< del_reply::type >);

    // select-reply
    // 
    public:
    struct select_reply
    {
      typedef ::dsmessage::select_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const select_reply::container&
    select_reply () const;

    select_reply::container&
    select_reply ();

    void
    select_reply (const select_reply::type&);

    void
    select_reply (const select_reply::container&);

    void
    select_reply (::std::auto_ptr< select_reply::type >);

    // eval-reply
    // 
    public:
    struct eval_reply
    {
      typedef ::dsmessage::eval_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const eval_reply::container&
    eval_reply () const;

    eval_reply::container&
    eval_reply ();

    void
    eval_reply (const eval_reply::type&);

    void
    eval_reply (const eval_reply::container&);

    void
    eval_reply (::std::auto_ptr< eval_reply::type >);

    // trigger-reply
    // 
    public:
    struct trigger_reply
    {
      typedef ::dsmessage::trigger_reply_type type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
      typedef ::xsd::cxx::tree::optional< type > container;
    };

    const trigger_reply::container&
    trigger_reply () const;

    trigger_reply::container&
    trigger_reply ();

    void
    trigger_reply (const trigger_reply::type&);

    void
    trigger_reply (const trigger_reply::container&);

    void
    trigger_reply (::std::auto_ptr< trigger_reply::type >);

    // cookie
    // 
    public:
    struct cookie
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const cookie::type&
    cookie () const;

    cookie::type&
    cookie ();

    void
    cookie (const cookie::type&);

    void
    cookie (::std::auto_ptr< cookie::type >);

    // error
    // 
    public:
    struct error
    {
      typedef ::xml_schema::string type;
      typedef ::xsd::cxx::tree::traits< type, char > traits;
    };

    const error::type&
    error () const;

    error::type&
    error ();

    void
    error (const error::type&);

    void
    error (::std::auto_ptr< error::type >);

    // Constructors.
    //
    public:
    ds_reply_type (const cookie::type&,
                   const error::type&);

    ds_reply_type (const ::xercesc::DOMElement&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

    ds_reply_type (const ds_reply_type&,
                   ::xml_schema::flags = 0,
                   ::xml_schema::type* = 0);

    virtual ds_reply_type*
    _clone (::xml_schema::flags = 0,
            ::xml_schema::type* = 0) const;

    // Implementation.
    //
    private:
    void
    parse (const ::xercesc::DOMElement&, ::xml_schema::flags);

    ::xsd::cxx::tree::optional< ds_caps_reply::type > _xsd_ds_caps_reply_;
    ::xsd::cxx::tree::optional< ds_create_reply::type > _xsd_ds_create_reply_;
    ::xsd::cxx::tree::optional< ds_del_reply::type > _xsd_ds_del_reply_;
    ::xsd::cxx::tree::optional< ds_open_reply::type > _xsd_ds_open_reply_;
    ::xsd::cxx::tree::optional< ds_stat_reply::type > _xsd_ds_stat_reply_;
    ::xsd::cxx::tree::optional< ds_close_reply::type > _xsd_ds_close_reply_;
    ::xsd::cxx::tree::optional< table_create_reply::type > _xsd_table_create_reply_;
    ::xsd::cxx::tree::optional< table_del_reply::type > _xsd_table_del_reply_;
    ::xsd::cxx::tree::optional< table_stat_reply::type > _xsd_table_stat_reply_;
    ::xsd::cxx::tree::optional< table_keys_reply::type > _xsd_table_keys_reply_;
    ::xsd::cxx::tree::optional< put_reply::type > _xsd_put_reply_;
    ::xsd::cxx::tree::optional< get_reply::type > _xsd_get_reply_;
    ::xsd::cxx::tree::optional< del_reply::type > _xsd_del_reply_;
    ::xsd::cxx::tree::optional< select_reply::type > _xsd_select_reply_;
    ::xsd::cxx::tree::optional< eval_reply::type > _xsd_eval_reply_;
    ::xsd::cxx::tree::optional< trigger_reply::type > _xsd_trigger_reply_;
    ::xsd::cxx::tree::one< cookie::type > _xsd_cookie_;
    ::xsd::cxx::tree::one< error::type > _xsd_error_;
  };
}

#include <iosfwd>

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMInputSource.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>

namespace dsmessage
{
  // Read from a URI or a local file.
  //

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::std::basic_string< char >&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::std::basic_string< char >&,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::std::basic_string< char >&,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from std::istream.
  //

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (::std::istream&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (::std::istream&,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (::std::istream&,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (::std::istream&,
              const ::std::basic_string< char >& id,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (::std::istream&,
              const ::std::basic_string< char >& id,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (::std::istream&,
              const ::std::basic_string< char >& id,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from InputSource.
  //

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::xercesc::DOMInputSource&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::xercesc::DOMInputSource&,
              ::xsd::cxx::xml::error_handler< char >&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::xercesc::DOMInputSource&,
              ::xercesc::DOMErrorHandler&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from DOM.
  //

  ::std::auto_ptr< ::dsmessage::ds_request_type >
  ds_request (const ::xercesc::DOMDocument&,
              ::xml_schema::flags = 0,
              const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from a URI or a local file.
  //

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::std::basic_string< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::std::basic_string< char >&,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::std::basic_string< char >&,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from std::istream.
  //

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (::std::istream&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (::std::istream&,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (::std::istream&,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (::std::istream&,
            const ::std::basic_string< char >& id,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (::std::istream&,
            const ::std::basic_string< char >& id,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (::std::istream&,
            const ::std::basic_string< char >& id,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from InputSource.
  //

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::xercesc::DOMInputSource&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::xercesc::DOMInputSource&,
            ::xsd::cxx::xml::error_handler< char >&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::xercesc::DOMInputSource&,
            ::xercesc::DOMErrorHandler&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());


  // Read from DOM.
  //

  ::std::auto_ptr< ::dsmessage::ds_reply_type >
  ds_reply (const ::xercesc::DOMDocument&,
            ::xml_schema::flags = 0,
            const ::xsd::cxx::tree::properties< char >& = ::xsd::cxx::tree::properties< char > ());
}

#include <iosfwd> // std::ostream&

#include <xercesc/dom/DOMDocument.hpp>
#include <xercesc/dom/DOMErrorHandler.hpp>
#include <xercesc/framework/XMLFormatter.hpp>

#include <xsd/cxx/xml/dom/auto-ptr.hxx>

namespace dsmessage
{
  void
  operator<< (::xercesc::DOMElement&,
              storeType);

  void
  operator<< (::xercesc::DOMAttr&,
              storeType);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              storeType);

  void
  operator<< (::xercesc::DOMElement&,
              const tableInfoType&);

  void
  operator<< (::xercesc::DOMElement&,
              fieldType);

  void
  operator<< (::xercesc::DOMAttr&,
              fieldType);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              fieldType);

  void
  operator<< (::xercesc::DOMElement&,
              const fieldInfoType&);

  void
  operator<< (::xercesc::DOMElement&,
              const fieldNameValue&);

  void
  operator<< (::xercesc::DOMElement&,
              const fieldName&);

  void
  operator<< (::xercesc::DOMElement&,
              const languageName&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_caps_request_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const ds_caps_request_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const ds_caps_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_caps_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_create_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_create_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const ds_create_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const ds_create_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_del_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_del_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const ds_del_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const ds_del_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_open_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_open_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_stat_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_stat_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_close_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_close_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const ds_close_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const ds_close_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_create_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_create_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const table_create_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const table_create_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_del_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_del_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const table_del_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const table_del_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_stat_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_stat_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_keys_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const table_keys_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const put_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const put_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const put_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const put_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const get_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const get_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const del_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const del_reply_type&);

  void
  operator<< (::xercesc::DOMAttr&,
              const del_reply_type&);

  void
  operator<< (::xsd::cxx::tree::list_stream< char >&,
              const del_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const select_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const rowType&);

  void
  operator<< (::xercesc::DOMElement&,
              const select_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const eval_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const eval_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const trigger_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const trigger_reply_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_request_type&);

  void
  operator<< (::xercesc::DOMElement&,
              const ds_reply_type&);

  // Serialize to an existing DOM instance.
  //
  void
  ds_request (::xercesc::DOMDocument&,
              const ::dsmessage::ds_request_type&,
              ::xml_schema::flags = 0);


  // Serialize to a new DOM instance.
  //
  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  ds_request (const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              ::xml_schema::flags = 0);


  // Serialize to XMLFormatTarget.
  //
  void
  ds_request (::xercesc::XMLFormatTarget&,
              const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              const ::std::basic_string< char >& = "UTF-8",
              ::xml_schema::flags = 0);


  void
  ds_request (::xercesc::XMLFormatTarget&,
              const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              ::xsd::cxx::xml::error_handler< char >&,
              const ::std::basic_string< char >& = "UTF-8",
              ::xml_schema::flags = 0);

  void
  ds_request (::xercesc::XMLFormatTarget&,
              const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              ::xercesc::DOMErrorHandler&,
              const ::std::basic_string< char >& = "UTF-8",
              ::xml_schema::flags = 0);


  // Serialize to std::ostream.
  //
  void
  ds_request (::std::ostream&,
              const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              const ::std::basic_string< char >& = "UTF-8",
              ::xml_schema::flags = 0);


  void
  ds_request (::std::ostream&,
              const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              ::xsd::cxx::xml::error_handler< char >&,
              const ::std::basic_string< char >& = "UTF-8",
              ::xml_schema::flags = 0);

  void
  ds_request (::std::ostream&,
              const ::dsmessage::ds_request_type&, 
              const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
              ::xercesc::DOMErrorHandler&,
              const ::std::basic_string< char >& = "UTF-8",
              ::xml_schema::flags = 0);


  // Serialize to an existing DOM instance.
  //
  void
  ds_reply (::xercesc::DOMDocument&,
            const ::dsmessage::ds_reply_type&,
            ::xml_schema::flags = 0);


  // Serialize to a new DOM instance.
  //
  ::xsd::cxx::xml::dom::auto_ptr< ::xercesc::DOMDocument >
  ds_reply (const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xml_schema::flags = 0);


  // Serialize to XMLFormatTarget.
  //
  void
  ds_reply (::xercesc::XMLFormatTarget&,
            const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);


  void
  ds_reply (::xercesc::XMLFormatTarget&,
            const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xsd::cxx::xml::error_handler< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);

  void
  ds_reply (::xercesc::XMLFormatTarget&,
            const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xercesc::DOMErrorHandler&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);


  // Serialize to std::ostream.
  //
  void
  ds_reply (::std::ostream&,
            const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);


  void
  ds_reply (::std::ostream&,
            const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xsd::cxx::xml::error_handler< char >&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);

  void
  ds_reply (::std::ostream&,
            const ::dsmessage::ds_reply_type&, 
            const ::xsd::cxx::xml::dom::namespace_infomap< char >&,
            ::xercesc::DOMErrorHandler&,
            const ::std::basic_string< char >& = "UTF-8",
            ::xml_schema::flags = 0);
}

#include <xsd/cxx/post.hxx>

// Begin epilogue.
//
//
// End epilogue.

#endif // DS_H
