/*
 * Copyright: (C) 2009 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */


#include "nitconverter.h"

#include <QtGui>

#include <cstdio>
#include <cstdlib>
#include <iostream>

using std::list;


#ifdef MAEMO
#include <libosso.h>
extern osso_context_t *osso_context; 
#endif


// Constructor
nitconverter::nitconverter(QApplication *app, bool debug)
    : mainForm()
{
   bool result;

   _debug = debug;
   _app = app;

   if (_debug)
      std::cout << "nitconverter: Entering constructor" << std::endl;


#ifdef MAEMO
   aboutAct = new QAction(tr("&About"), this);
   aboutAct->setStatusTip(tr("Show the application's About box"));
   result = connect(aboutAct, SIGNAL(triggered()), this, SLOT(about()));
   if (result == false)
   {
      if (_debug)
         std::cout << "Could not connect About menu" << std::endl;
   }

   helpMenu = menuBar()->addMenu(tr("&Help"));
   helpMenu->addAction(aboutAct);
#endif
}

// Destructor
nitconverter::~nitconverter()
{
   if (_debug)
      std::cout << "nitconverter: calling destructor" << std::endl;
}


void
nitconverter::about()
{
   if (_debug)
      std::cout << "nitconverter: about called" << std::endl;
   QMessageBox::about(this, tr("About NIT Converter"),
      tr("<img src=\"/usr/share/icons/hicolor/scalable/hildon/nitconverter.png\" align=\"middle\" />"
      "<h1 align=\"center\"><b>NIT Converter 0.60</b></h1>"
      "<h5 align=\"center\">Nokia Internet Tablet Units Converter</h5>"
      "<h5 align=\"center\">(C) 2010 Bruce Forsberg</h5>"
      "<h5 align=\"center\">http://converter.garage.maemo.org</h5>"));
}


