/*
 * Copyright: (C) 2009 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */


#include "nitconverter.h"
#include <qapplication.h>
#ifdef MAEMO
#include <libosso.h>
#endif

#include <cstdio>
#include <cstdlib>
#include <iostream>

#ifdef MAEMO
osso_context_t *osso_context = NULL;
#endif


int main( int argc, char ** argv )
{
    bool debug = FALSE;
    int  ret;


    QApplication a( argc, argv, true );

    if (argc > 1)
       if (strcmp(argv[1], "-v") == 0)
          debug = TRUE;

    if (debug)
       std::cout << "main: Entered main in debug mode" << std::endl;

#ifdef MAEMO
    osso_context = osso_initialize("nitconverter", "0.6", FALSE, NULL);
    if (osso_context == NULL)
       std::cerr << "Can't initialize osso context." << std::endl;
#endif

    nitconverter mw(&a, debug);

    if (debug)
       std::cout << "main: calling showMainWidget" << std::endl;

    mw.show();

    ret = a.exec();

#ifdef MAEMO
    if (osso_context != NULL)
       osso_deinitialize(osso_context);
#endif

    return ret;
}
