#include "nitconverterbase.h"

#include <qlabel.h>
#include <qlistwidget.h>
#include <qtabwidget.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qimage.h>
#include <qpixmap.h>
#include <QKeyEvent>
#include <QHBoxLayout>
#include <QLineEdit>
#include <QPushButton>

#include <cstdio>
#include <cstdlib>
#include <iostream>


// These conversions are more complicated
// nit_list_items  temp_list[] =
// {
//    {"Fahrenheit", 1.0},
//    {"Celsius",  3.93700787},
//    {"Kelvin", 39.3700787}
// };


/* 
 *  Constructs a mainForm which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 */
mainForm::mainForm( QWidget* parent, Qt::WindowFlags fl )
    : QMainWindow( parent, fl )
{
    QWidget  *tab;
    QLabel *in_label;
    QLabel *out_label;
    QLabel *in_list_title;
    QLabel *out_list_title;
    QGridLayout  *layout;
    QPushButton  *one_b;
    QPushButton  *two_b;
    QPushButton  *three_b;
    QPushButton  *four_b;
    QPushButton  *five_b;
    QPushButton  *six_b;
    QPushButton  *seven_b;
    QPushButton  *eight_b;
    QPushButton  *nine_b;
    QPushButton  *zero_b;
    QPushButton  *dot_b;
    QPushButton  *bs_b;
    int size_of_tabs;
    int size_of_list;

    resize( 720, 420 ); 
    //setSizePolicy( QSizePolicy( (QSizePolicy::SizeType)0, (QSizePolicy::SizeType)0, sizePolicy().hasHeightForWidth() ) );
    setMinimumSize( QSize( 720, 420 ) );
    setMaximumSize( QSize( 720, 420 ) );
    setWindowTitle( tr( "NIT Units Converter" ) );

    TabWidget2 = new QTabWidget( this );
    TabWidget2->setGeometry( QRect( 0, 0, 720, 420 ) ); 

    connect( TabWidget2, SIGNAL( currentChanged(int) ), this, SLOT( tabChanged(int) ) );

    size_of_tabs = sizeof(entire_list) / sizeof (nit_list_struct);
    for (int i = 0; i < size_of_tabs; i++)
    {
       tab = new QWidget( TabWidget2 );
       TabWidget2->insertTab( i, tab, tr( entire_list[i].tab_name ) );

       in_list[i] = new QListWidget( tab );
       out_list[i]= new QListWidget( tab );

       connect( in_list[i], SIGNAL( itemSelectionChanged() ), this, SLOT( listChanged() ) );
       connect( out_list[i], SIGNAL( itemSelectionChanged() ), this, SLOT( listChanged() ) );

       in_list_title = new QLabel("Input Units");
       out_list_title = new QLabel("Output Units");

       in_label = new QLabel("Input Value");
       out_label = new QLabel("Output Value");

       in_text[i] = new QLineEdit();
       out_text[i] = new QLineEdit();
       out_text[i]->setReadOnly(true);

       connect( in_text[i], SIGNAL( textChanged(const QString&) ), this, SLOT( inTextChanged(const QString&) ) );

       one_b = new QPushButton("1");
       two_b = new QPushButton("2");
       three_b = new QPushButton("3");
       four_b = new QPushButton("4");
       five_b = new QPushButton("5");
       six_b = new QPushButton("6");
       seven_b = new QPushButton("7");
       eight_b = new QPushButton("8");
       nine_b = new QPushButton("9");
       zero_b = new QPushButton("0");
       dot_b = new QPushButton(".");
       bs_b = new QPushButton("<-");

       connect( one_b, SIGNAL( pressed() ), this, SLOT( onePressed() ) );
       connect( two_b, SIGNAL( pressed() ), this, SLOT( twoPressed() ) );
       connect( three_b, SIGNAL( pressed() ), this, SLOT( threePressed() ) );
       connect( four_b, SIGNAL( pressed() ), this, SLOT( fourPressed() ) );
       connect( five_b, SIGNAL( pressed() ), this, SLOT( fivePressed() ) );
       connect( six_b, SIGNAL( pressed() ), this, SLOT( sixPressed() ) );
       connect( seven_b, SIGNAL( pressed() ), this, SLOT( sevenPressed() ) );
       connect( eight_b, SIGNAL( pressed() ), this, SLOT( eightPressed() ) );
       connect( nine_b, SIGNAL( pressed() ), this, SLOT( ninePressed() ) );
       connect( zero_b, SIGNAL( pressed() ), this, SLOT( zeroPressed() ) );
       connect( dot_b, SIGNAL( pressed() ), this, SLOT( dotPressed() ) );
       connect( bs_b, SIGNAL( pressed() ), this, SLOT( bsPressed() ) );

       one_b->setMaximumWidth(50);
       two_b->setMaximumWidth(50);
       three_b->setMaximumWidth(50);
       four_b->setMaximumWidth(50);
       five_b->setMaximumWidth(50);
       six_b->setMaximumWidth(50);
       seven_b->setMaximumWidth(50);
       eight_b->setMaximumWidth(50);
       nine_b->setMaximumWidth(50);
       zero_b->setMaximumWidth(50);
       dot_b->setMaximumWidth(50);
       bs_b->setMaximumWidth(50);

       layout = new QGridLayout();
       layout->addWidget(in_list_title, 0, 0, 1, 6);
       layout->addWidget(out_list_title, 0, 6, 1, 6);
       layout->addWidget(in_list[i], 1, 0, 8, 6);
       layout->addWidget(out_list[i], 1, 6, 8, 6);
       layout->addWidget(in_label, 0, 12, 1, 6);
       layout->addWidget(out_label, 2, 12, 1, 6);
       layout->addWidget(in_text[i], 1, 12, 1, 6);
       layout->addWidget(out_text[i], 3, 12, 1, 6);
       layout->addWidget(one_b, 4, 12, 1, 1);
       layout->addWidget(two_b, 4, 13, 1, 1);
       layout->addWidget(three_b, 4, 14, 1, 1);
       layout->addWidget(four_b, 5, 12, 1, 1);
       layout->addWidget(five_b, 5, 13, 1, 1);
       layout->addWidget(six_b, 5, 14, 1, 1);
       layout->addWidget(seven_b, 6, 12, 1, 1);
       layout->addWidget(eight_b, 6, 13, 1, 1);
       layout->addWidget(nine_b, 6, 14, 1, 1);
       layout->addWidget(zero_b, 7, 12, 1, 1);
       layout->addWidget(dot_b, 7, 13, 1, 1);
       layout->addWidget(bs_b, 7, 14, 1, 1);
       tab->setLayout(layout);
    }

    for (int j = 0; j < size_of_tabs; j++)
    {
       // Fill list
       size_of_list = sizeof(*((nit_list_items *)(entire_list[j].ptr_list))) / sizeof(nit_list_items);
       int counter = 0;
       while ( ((nit_list_items *)(entire_list[j].ptr_list))[counter].name != NULL )
       {
          in_list[j]->addItem(QString(((nit_list_items *)(entire_list[j].ptr_list))[counter].name));
          out_list[j]->addItem(QString(((nit_list_items *)(entire_list[j].ptr_list))[counter].name));
          counter++;
       }
    }
}

/*  
 *  Destroys the object and frees any allocated resources
 */
mainForm::~mainForm()
{
    // no need to delete child widgets, Qt does it all for us
}

#if 0
/*  
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool mainForm::event( QEvent* ev )
{
    bool ret = QWidget::event( ev ); 
    if ( ev->type() == QEvent::ApplicationFontChange ) {
    }
    return ret;
}
#endif

void mainForm::about()
{
    qWarning( "mainForm::about(): Not implemented yet!" );
}

void mainForm::inTextChanged(const QString& text)
{
   int in_item = in_list[current_tab]->currentRow();
   int out_item = out_list[current_tab]->currentRow();

   // Clear output no matter whether valid values or not
   out_text[current_tab]->clear();

   // Make sure both in and out items are selected in list and entry in input text
   if (in_item >= 0 && out_item >= 0 && text.size() != 0)
   {
      double conv_in = ((nit_list_items *)(entire_list[current_tab].ptr_list))[in_item].conv;
      double conv_out = ((nit_list_items *)(entire_list[current_tab].ptr_list))[out_item].conv;
      double off_in = ((nit_list_items *)(entire_list[current_tab].ptr_list))[in_item].off;
      double off_out = ((nit_list_items *)(entire_list[current_tab].ptr_list))[out_item].off;
      double value = atof(text.toStdString().c_str());
      if (strncmp(entire_list[current_tab].tab_name, TEMPERATURE, strlen(TEMPERATURE)) == 0)
      {
         char * convert_name = ((nit_list_items *)(entire_list[current_tab].ptr_list))[in_item].name;
         double intermediate_value;

         // First convert in item to Celcius
         if (strncmp(convert_name, FAHRENHEIT, strlen(FAHRENHEIT)) == 0)
         {
            intermediate_value = (value + off_in) * conv_in;
         }
         else if (strncmp(convert_name, KELVIN, strlen(KELVIN)) == 0)
         {
            intermediate_value = (value + off_in) * conv_in;
         }
         else
         {
            intermediate_value = value;
         }

         // Now convert celsius to out value
         convert_name = ((nit_list_items *)(entire_list[current_tab].ptr_list))[out_item].name;
         if (strncmp(convert_name, FAHRENHEIT, strlen(FAHRENHEIT)) == 0)
         {
            value = intermediate_value * 1.0 / conv_out - off_out;
         }
         else if (strncmp(convert_name, KELVIN, strlen(KELVIN)) == 0)
         {
            value = intermediate_value * 1.0 / conv_out - off_out;
         }
         else
         {
            value = intermediate_value;
         }
      }
      else
      {
         value = value * conv_in / conv_out + off_in - off_out;
      }
      QString out_string;
      out_string.setNum(value);
      out_text[current_tab]->insert(out_string);
   }
}

void mainForm::tabChanged(int index)
{
   current_tab = index;
}

void mainForm::listChanged()
{
   QString txt = in_text[current_tab]->text();
   inTextChanged(txt);
}

void mainForm::onePressed()
{
   in_text[current_tab]->insert("1");
}

void mainForm::twoPressed()
{
   in_text[current_tab]->insert("2");
}

void mainForm::threePressed()
{
   in_text[current_tab]->insert("3");
}

void mainForm::fourPressed()
{
   in_text[current_tab]->insert("4");
}

void mainForm::fivePressed()
{
   in_text[current_tab]->insert("5");
}

void mainForm::sixPressed()
{
   in_text[current_tab]->insert("6");
}

void mainForm::sevenPressed()
{
   in_text[current_tab]->insert("7");
}

void mainForm::eightPressed()
{
   in_text[current_tab]->insert("8");
}

void mainForm::ninePressed()
{
   in_text[current_tab]->insert("9");
}

void mainForm::zeroPressed()
{
   in_text[current_tab]->insert("0");
}

void mainForm::dotPressed()
{
   in_text[current_tab]->insert(".");
}

void mainForm::bsPressed()
{
   in_text[current_tab]->backspace();
}

