#!/usr/bin/env python2.5
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
# MA  02110-1301, USA.
#

import glob
import os
from distutils.core import setup

version = '1.0.12'

# files to install
inst_desktop = ['nicotine.desktop']
nicotine_dir = ['nicotine.py']

gtkgui_dir = []
for i in os.listdir('pynicotine/gtkgui'):
    gtkgui_dir.append('pynicotine/gtkgui/'+i)

pynicotine_dir = []
for j in os.listdir('pynicotine'):
    if j.endswith(".py"):
        pynicotine_dir.append('pynicotine/'+j)

inst_dbus = ['nicotine.service']
inst_icon = ['nicotine.png' ]
inst_icon_sca = ['img/nicotine.png']
backup_conf  = ['nicotine-backup.conf']

data_files = [
  ('share/applications/hildon', inst_desktop),
  ('share/nicotine',   nicotine_dir),
  ('share/nicotine/pynicotine',   pynicotine_dir), 
  ('share/nicotine/pynicotine/gtkgui',   gtkgui_dir),
  ('share/dbus-1/services',   inst_dbus), 
  ('share/icons/hicolor/26x26/hildon/',   inst_icon),
  ('share/icons/hicolor/scalable/hildon/',   inst_icon_sca), 
  ('/etc/osso-backup/applications/',   backup_conf), 
]

setup(
  name         = 'nicotine',
  version      = version,
  description  = 'Client for SoulSeek filesharing system.',
  author       = 'Daniel Martin Yerga',
  author_email = 'dyerga@gmail.com',
  url          = 'http://garage.maemo.org/projects/nicotine',
  data_files   = data_files
)
