import gtk
import mytube.lgc.mutils as mutils
from widgets import *
from mytube.lgc.conf import Cfg

class Prefs:
    def __init__(self):
        pass;
    
    def setPref(self, var, val):
        if var == "mplayer":
            Cfg.CMD_MPLAYER = val.split(" ")
        elif var == "youtube-dl":
            Cfg.CMD_YTDL = val.split(" ")
        elif var == "gtk-theme":
            mutils.info("restart to load the theme")
        elif var == "per_page":
            Cfg.PER_PAGE = val
        elif var == "browser":
            Cfg.CMD_BROWSER = val
        elif var == "kin_fric":
            Cfg.KIN_FRIC = val
        elif var == "kin_max_speed":
            Cfg.KIN_MAX_SPEED = val
        Cfg.INSTANCE.setCfg(var, val, True)
        print "save "+var+"="+str(val)
    
    def createPrefPageMplayer(self):
        pg = gtk.Table(1,10, True)
        cmd = gtk.Entry()
        set = gtk.Button("apply")
        cmd.set_text(" ".join(Cfg.CMD_MPLAYER))
        pg.attach(cmd, 0, 9, 0, 1)
        pg.attach(set, 9, 10, 0, 1)
        set.connect("clicked", lambda w, p: self.setPref("mplayer", cmd.get_text()), None)
        return pg
    
    def createPrefPageYoutubeDl(self):
        pg = gtk.Table(1,10,False)
        cmd = gtk.Entry()
        set = gtk.Button("apply")
        cmd.set_text(" ".join(Cfg.CMD_YTDL))
        pg.attach(cmd, 0, 9, 0, 1)
        pg.attach(set, 9, 10, 0, 1)
        set.connect("clicked", lambda w, p: self.setPref("youtube-dl", cmd.get_text()), None)
        return pg
    
    
    def createPrefPageThemes(self):
        pg = gtk.Table(1,10,False)
        set = gtk.Button("apply")
        cbx = SimpleComboBox(False)
        idx = -1
        crt = Cfg.INSTANCE.getCfg("gtk-theme")
        for dir in Cfg.INSTANCE.getThemesList()[:]:
            idx = idx + 1
            cbx.append_item(dir, None, lambda w, p: w)
            if crt == dir:
                cbx.set_active(idx)
        pg.attach(cbx, 0, 9, 0, 1)
        pg.attach(set, 9, 10, 0, 1)
        set.connect("clicked", lambda w, p: self.setPref("gtk-theme", cbx.get_active_item()[0]), None)
        
        return pg
        
    def createPrefPageMisc(self):
        pg = gtk.Table(2,13,False)
        set = gtk.Button("apply")
        lbl = gtk.Label("entries per page")
        spin = gtk.SpinButton(adjustment=gtk.Adjustment(value=1, step_incr=5, page_incr=5, page_size=5), climb_rate=5, digits=0)
        spin.set_range(1, 100)
        spin.set_value(Cfg.PER_PAGE)
        pg.attach(lbl, 0, 1, 0, 1)
        pg.attach(spin, 1, 12, 0, 1)
        pg.attach(set, 12, 13, 0, 2)
        
        lbl = gtk.Label("default browser")
        txt = gtk.Entry()
        txt.set_text(Cfg.CMD_BROWSER)
        pg.attach(lbl, 0, 1, 1, 2)
        pg.attach(txt, 1, 12, 1, 2)
        set.connect("clicked", lambda w, p: self.setPref("per_page", spin.get_value_as_int()), None)
        set.connect("clicked", lambda w, p: self.setPref("browser", txt.get_text()), None)
        return pg
    
    def createPrefPageKin(self):
        pg = gtk.Table(2,13,False)
        set = gtk.Button("apply")
        lbl = gtk.Label("friction %")
        spin = gtk.SpinButton(adjustment=gtk.Adjustment(lower=1, upper=100, step_incr=2, page_incr=2, page_size=5), climb_rate=5, digits=0)
        #spin.set_range(1, 100)
        spin.set_value(Cfg.KIN_FRIC)
        pg.attach(lbl, 0, 1, 0, 1)
        pg.attach(spin, 1, 12, 0, 1)
        pg.attach(set, 12, 13, 0, 2)
        
        lbl = gtk.Label("max speed")
        spin1 = gtk.SpinButton(adjustment=gtk.Adjustment(lower=0, upper=100, step_incr=1, page_incr=1, page_size=5), climb_rate=5, digits=0)
        #spin1.set_range(0, 100)
        spin1.set_value(Cfg.KIN_MAX_SPEED)
        pg.attach(lbl, 0, 1, 1, 2)
        pg.attach(spin1, 1, 12, 1, 2)
        set.connect("clicked", lambda w, p: self.setPref("kin_fric", spin.get_value_as_int()), None)
        set.connect("clicked", lambda w, p: self.setPref("kin_max_speed", spin1.get_value_as_int()), None)
        return pg
    
    def show(self):
        print "guiPrefsShow"
        dia = gtk.Dialog('more settings',
                 None,#somewidget.get_toplevel(),  #the toplevel wgt of your app
                 gtk.DIALOG_DESTROY_WITH_PARENT,  #binary flags or'ed together gtk.MODAL_DIALOG
                 (
                  #"Play Now", 77, 
                  gtk.STOCK_CLOSE, gtk.RESPONSE_CLOSE))
        dia.set_default_size(600, -1)
        tabs = gtk.Notebook()
        tabs.set_tab_pos(gtk.POS_TOP)
        page = self.createPrefPageMisc()
        tabs.append_page(page, gtk.Label('misc'))
        page = self.createPrefPageMplayer()
        tabs.append_page(page, gtk.Label('mplayer'))
        page = self.createPrefPageYoutubeDl()
        tabs.append_page(page, gtk.Label('youtube-dl'))
        page = self.createPrefPageThemes()
        tabs.append_page(page, gtk.Label('themes'))
        page = self.createPrefPageKin()
        tabs.append_page(page, gtk.Label('kinetic'))
        dia.vbox.pack_start(tabs)
        dia.show_all()
        dia.show()
        result = dia.run()
        if result == 77:
           pass
        elif result == gtk.RESPONSE_CLOSE:
           pass
        dia.destroy()
        
