import gtk
from ..lgc import ystorage
from ..lgc import mutils

class TagToolbar(gtk.Toolbar):
    def __init__(self, btns, max_items, extra_toggle):
        gtk.Toolbar.__init__(self)
        self.set_style(gtk.TOOLBAR_BOTH_HORIZ)
        
        self.__extra_toggle = extra_toggle
        self.__sigs = []
        self.active = None#[]
        self.btns = None#btns
        self.max_items = max_items
        # <
        menu_button = gtk.ToolButton()
        menu_button.set_icon_widget(ystorage.loadImage("myt-left.png", -1, -1))
        menu_button.set_size_request(60, 60)
        self.insert(menu_button, 0)
        menu_button.connect("clicked", self.cb_clickPrev)
        #
        self.generateButtons(btns, None)
        
        # >
        menu_button = gtk.ToolButton()
        menu_button.set_icon_widget(ystorage.loadImage("myt-right.png", -1, -1))
        menu_button.set_size_request(60, 60)
        self.insert(menu_button, -1)
        menu_button.connect("clicked", self.cb_clickNext)
        #
        self.show_all()
    
    def cb_clickNext(self, widget, ignore=None):
        last = self.btns.pop(len(self.btns)-1)
        self.btns.insert(0, last)
        self.generateButtons(self.btns, self.active)
        
    def cb_clickPrev(self, widget, ignore=None):
        first = self.btns.pop(0)
        self.btns.append(first)
        self.generateButtons(self.btns, self.active)
    
    def generateButtons(self, btns=None, active=None):
        #remove old button
        lenOld = 0
        if self.btns != None: lenOld = len(self.btns)
        lenNew = 0
        if btns != None: lenNew = len(btns)
        
        rebuild = (lenNew != lenOld)
        
        if rebuild:
            for i in range(0, min(self.max_items, lenOld)):
                prev_item = self.get_nth_item(1)
                if (prev_item != None):
                    self.remove(prev_item)
                    self.__sigs.pop(0)
                
        
        #update new ones        
        if btns != None:
            self.btns = btns
        if active != None:
            self.active = active
        
        #update buttons
        for i in range(0, min(self.max_items, lenNew)):
            tagname = self.btns[i]
            menu_button = None
            if rebuild:
                menu_button = gtk.ToggleToolButton()
                menu_button.set_size_request(60, 60)
                menu_button.set_is_important(True)
                sig = menu_button.connect("toggled", self.cb_clicked)
                self.__sigs.append(sig)
                self.insert(menu_button, i+1)
                menu_button.show()
            else:
                menu_button = self.get_nth_item(i+1)
            
            #disable toggle event
            menu_button.disconnect(self.__sigs[i])
            #
            menu_button.set_label(tagname)
            if mutils.bsearch(self.active, tagname) >= 0:
                menu_button.set_active(True)
            else:
                menu_button.set_active(False)
            #enable back toggle event
            self.__sigs[i] = menu_button.connect("toggled", self.cb_clicked)
            
            
            
    def cb_clicked(self, widget, param1=None, event=None):
        print ">>>clicked ",event
        tagname = widget.get_label()
        state = widget.get_active()
        self.__extra_toggle(tagname, state)
        if state:
            self.active.append(tagname)
        else:
            self.active.remove(tagname)
        return True
        
   
            
            