"""
    tags for mytube
"""

from conf import Cfg
import os, mutils, stat
import session

PREFIX = "list."

__tags = {}

class MTag:
    def __init__(self, tagname):
        self.__tagname = tagname
        self.__list = []
        self.__sort = session.SORT_NONE
        if tagname == None:
            self.__loadAll()
        else:
            self.__loadByName(tagname)
        #create sorted list
        self.__listSorted = []
        self.__listSorted.extend(self.__list)
        self.__listSorted.sort()
    
    def __loadByName(self, tagname):
        """loads video entries matching a tag"""
        self.__list = []
        self.__listCtime = []
        flist = open(getTagFilename(tagname), "r")
        for line in flist.readlines():
            line = line.strip()
            if (len(line) > 1):
                dirname = getVideoDirPath(line)
                try:
                    ctime = os.stat(dirname)[stat.ST_CTIME]
                    self.__listCtime.append(ctime)
                    self.__list.append(line)
                except:
                    pass
                
        flist.close()
    
    def __loadAll(self):
        """loads all video entries"""
        self.__list = []
        self.__listCtime = []
        self.listname = "saved"
        for fentry in os.listdir(Cfg.VIDEO_DIR):
            #to be a valid record some files must be there
            dirname = getVideoDirPath(fentry)
            if not os.path.isfile(dirname+os.path.sep+"info"):
                continue
            try:
                ctime = os.stat(dirname)[stat.ST_CTIME]
                self.__listCtime.append(ctime)
                self.__list.append(fentry)
            except:
                import traceback,sys
                traceback.print_exc(file=sys.stdout)
                
            
    def getList(self, sort = session.SORT_NONE):
        self.__sort = sort        
        if (self.__sort == session.SORT_NONE):
            return self.__list
        tmpList = sorted(self.__list, self.__cmpTagUp, key=self.__cmpTagIdx)
        return tmpList
    
    def __cmpTagUp(self, i, j):
        if self.__sort == session.SORT_ASC:
            return cmp(self.__listCtime[i], self.__listCtime[j])
        else:
          return cmp(self.__listCtime[j], self.__listCtime[i])
        
    
    def __cmpTagIdx(self, val):
        for i in range(0, len(self.__list)):
            if self.__list[i] == val:
                return i;
        return -1
    
    def contains(self, id):
        return mutils.bsearch(self.__listSorted, id) != -1
    
    def addEntry(self, id):
        for entry in self.__list:
            if entry == id:
                return False
        self.__list.append(id)
        mutils.binsert(self.__listSorted, id)
        return True
    
    def delEntry(self, id):
        for entry in self.__list:
            if entry == id:
                self.__list.remove(id)
                self.__listSorted.remove(id)
                return True
        return False
    
    def save(self):
        """saves the tag list to a file"""
        tagfilename = getTagFilename(self.__tagname)
        print "saving tag file ",self.__tagname
        ftags = open(tagfilename, "w")
        for entry in self.__list:
            entry = entry.strip()
            if (len(entry) > 1):
                ftags.write(entry+"\n")
        ftags.close()

   
    
    
    
def getTagFilename(tagname):
    return Cfg.VIDEO_DIR+os.path.sep+PREFIX+tagname

def getVideoDirPath(id):
    return Cfg.VIDEO_DIR+os.path.sep+id
            
def getTagNames():
    """returns all the available tags"""
    prefixLen = len(PREFIX)
    all = []
    for fentry in os.listdir(Cfg.VIDEO_DIR):
        fentry = fentry.strip()
        #to be a valid record some files must be there
        if not fentry.startswith(PREFIX):
            continue
        all.append(fentry[prefixLen:])
    return all

#creats a new tag list
def createTag(tagname):
    print "add tag ", tagname
    filename = getTagFilename(tagname)
    try:
        f = open(filename, "w+")
        f.close()
    except:
        mutils.log(sys.exc_info()[1])
        
        
    return True

#destroys a tag list
def destroyTag(tagname):
    print "del tag ", tagname
    filename = getTagFilename(tagname)
    try:
        os.remove(filename)
    except:
        mutils.log(sys.exc_info()[1])
    return True

def getMTag(tagname):
    """
    @return the mtag object associated with this tagname
    """
    #TODO: check for thread safe
    if __tags.has_key(tagname):
        return __tags[tagname]
    
    try:
        tag = MTag(tagname)
        __tags[tagname] = tag
        return tag
    except:
        return None
    
def getEntryTags(id):
    tagged = []
    alltags = getTagNames()
    
    for tagname in alltags:
        mtag = getMTag(tagname)
        if mtag.contains(id):
            mutils.binsert(tagged, tagname)
    #print ">>>tags for ",id," = ",tagged
    return tagged    

def addTag(entry, tagname):
    """tags an entry"""
    print "adding tag ",tagname
    tag = getMTag(tagname)
    if tag == None:
        mutils.log("cannot tag it, there is no tag "+tagname)
        return
    tag.addEntry(entry.getVideoId())
    tag.save()
    

def delTag(entry, tagname):
    """removes a tags from an entry"""
    print "deleting tag ",tagname
    tag = getMTag(tagname)
    if tag == None:
        mutils.log("cannot tag it, there is no tag "+tagname)
        return
    tag.delEntry(entry.getVideoId())
    tag.save()

if __name__ == "__main__":
    import sys
    sys.path.append("..")
    import ui.mtags
    cfg = Cfg()
    tags = getTagNames()
    ui.mtags.showDialog(tags, createTag, destroyTag)