import gtk, gobject
import mutils

from conf import Cfg
from yentry import YEntry
import ystorage
from ystreamer import YStreamer
from mytube.ui.widgets import SimpleComboBox
import session
from mytube.lgc import mtags


class GuiMyTube:
    BTN_SIZE = 60
    BTN_HEIGHT_NAV = 40
    ANIM_W = 500
    ANIM_S = 90

    def cb_deleteEvent(self, widget, event, data=None):
        print "delete event occurred"
        return False

    def cb_destroy(self, widget, data=None):
        print "destroy signal occurred"
        for vid, vstreamer in self.ystreamers.iteritems():
            print "terminating ystream for %s" %vid
            vstreamer.terminate()
        self.worker.terminate()
        gtk.main_quit()

#    def cb_rowChanged(self, treeView, data=None):
#        yentry, idx = self.getSelectedVideo()
#        if yentry == None:
#            return
#        self.updateActions(yentry)
#        #XXX: restructure this
#        self.videoCrt = yentry
#        
#        #set the view only if the list is expanded
#        if self.animState == 2:
#            #smoother animation
#            gobject.idle_add(self.details.setVideo, yentry, 
#                                priority=gobject.PRIORITY_LOW)
#            #self.details.setVideo(self.videoCrt)
#        try:
#            #reset this selection
#            self.searchRels.set_active(0)
#        except:
#            pass

#    def cb_rowActivated(self, treeView, path, column):
#        print path
#        model = treeView.get_model()
#        iter = model.get_iter(path)
#        video = model.get_value(iter, 0)
#        href = video.url
#        print "clicked %s" %(href)
#        return #TODO: disactivated
#        
#    def cb_rowClicked(self, treeView, event):
#        x = event.x
#        w = treeView.allocation.width
#        
#        if treeView.get_path_at_pos(event.x, event.y) == None:
#            return
#        
#        path, column, cx, cy = treeView.get_path_at_pos(event.x, event.y)
#            
#
#        model = treeView.get_model()
#        iter = model.get_iter(path)
#        video = model.get_value(iter, 0)
#        
#        video1, idx = self.getSelectedVideo()
#        
#        if (video1 == None or video1.url != video.url):
#            #print "skipping this click, select row first"
#            return
#        
#        if x >= w - YCellRenderer.DETAILS_X:            
#            print "so you want to see details for %s" %video.url
#            self.setDetailsExtraButtons(True)
#            self.startDetailsAnim(True)
#    
    def cb_rowClickedKinetic(self, widget, event=None):
        yentry, idx = self.getAtYVideo(event.y)
        if yentry == None:
            print "clicked on NOTHING"
            return
        x = event.x
        w = self.searchScroll.allocation.width
        #print "cb_rowClickedKinetic ",yentry.title," at x=",x, " ",widget
        
        #dont expand not selected
        if (self.videoCrt == yentry):
            if x >= w - Cfg.DETAILS_X and w > 500:            
                print "so you want to see details for ", yentry.url
                self.setDetailsExtraButtons(True)
                self.startDetailsAnim(True)
        else:
            print "not selected, skipping"
        
    
    def cb_rowSelectedKinetic(self, widget, event=None):
        yentry, idx = self.getSelectedVideo()
        
        print "cb_rowSelectedKinetic ", yentry
        w = self.searchScroll.allocation.width
        
        self.updateActions(yentry)
        self.videoCrt = yentry
        
        #set the view only if the list is expanded
        if self.animState == 2:
            if self.searchScroll.is_almost_idle:
                self.details.setVideo(yentry)
        try:
            #reset this selection
            self.searchRels.set_active(0)
        except:
            pass
    
        
    def cb_cancelVideo(self, widget, data=None):
        print "cancelCurrentRequest"
        yentry, idx = self.getSelectedVideo()
        if yentry == None:
            print "no video selected"
            return
        #CHECK here GUI responsiveness problem
        self.getStreamer(yentry).terminate()#cancelCurrentRequest()
        self.updateActions(yentry)
        
    def cb_playVideo(self, widget, data=None):
        print "playVideo ",
        yentry, idx = self.getSelectedVideo()
        print "yentry %s" %(yentry.title)
        self.getStreamer(yentry).addRequest(False)
        self.updateActions(yentry)

    def cb_deleteStored(self, widget, data=None):
        print "deleting stored",
        import ui.confirm
        if not ui.confirm.showDialog("Delete"):
            print "you should be sure!"
            return
        yentry, idx = self.getSelectedVideo()
        print "yentry %s" %(yentry.title)
        yentry.percentDl = 0;
        yentry.downloadedKb = 0
        self.updateEntry(idx, yentry)
        ystorage.deleteStored(yentry)
        self.updateActions(yentry)
        
    def cb_downloadVideo(self, widget, data=None):
        print "downloadVideo ",
        yentry, idx = self.getSelectedVideo()
        print "yentry %s" %(yentry.title)
        self.getStreamer(yentry).addRequest(True)
        self.updateActions(yentry)
    
    def cb_saveCached(self, widget, data=None):
        print "saving cached",
        yentry, idx = self.getSelectedVideo()
        print "yentry %s" %(yentry.title)
        ystorage.storeCachedVideo(yentry)
        self.updateActions(yentry)
    
    def cb_null(self, widget, data=None, data1=None, data2=None):
        print "null callback"

    def cb_entryActivated(self, widget, data=None):
        self.cb_search(widget, data)
        
    def cb_nextResults(self, widget, data=None):
        self.doGenericSearch(self.sess.type, self.sess.string, 
                             self.sess.start+Cfg.PER_PAGE, Cfg.PER_PAGE, 
                             self.sess.date)

    def cb_prevResults(self, widget, data=None):
        start = self.sess.start-Cfg.PER_PAGE
        if start < 1:
            start = 1
        self.doGenericSearch(self.sess.type, self.sess.string, 
                             start, Cfg.PER_PAGE, 
                             self.sess.date)
        
    def cb_addEntry(self, videos):
        addEntry(videos)
        
    #TODO: make just a callback with a paramter
    def cb_changeDate(self, widget, data=None):
        if self.sess.date == data:
            print "nothing changed"
            return
        self.doGenericSearch(self.sess.type, self.sess.string, 
                             self.sess.start, Cfg.PER_PAGE, 
                             data)
    
    def cb_retractClicked(self, widget, event):
        print "retract"
        self.setDetailsExtraButtons(False)
        self.startDetailsAnim(False)
    
    def cb_related(self, widget, event):
        print "related"
        if self.videoCrt == None or self.videoCrt.related == None:
            print "no url to go to"
            return
        self.doGenericSearch(session.TYPE_DIRECT_FEED, self.videoCrt.related, 1, Cfg.PER_PAGE)
    
    def cb_author(self, widget, event):
        if self.videoCrt == None or self.videoCrt.author == None:
            print "no author to search by"
            return
        self.doGenericSearch(session.TYPE_BY_AUTHOR, self.videoCrt.author, 1, Cfg.PER_PAGE)
        
    def cb_category(self, widget, event):
        if self.videoCrt == None or self.videoCrt.cat == None:
            print "no cat to search by"
            return        
        self.doGenericSearch(session.TYPE_BY_CAT, self.videoCrt.cat, 1, Cfg.PER_PAGE)

    def cb_search(self, widget, data=None):
        searchString = self.searchTxt.get_text()
        self.doGenericSearch(session.TYPE_SEARCH, searchString, 1, Cfg.PER_PAGE)
        
    def cb_toprated(self, widget, data=None):
        self.window.set_title("top rated")
        self.doGenericSearch(session.TYPE_TOPRATED, "dummy", 1, Cfg.PER_PAGE, self.searchDateCrt)
        
    def cb_mostviewed(self, widget, data=None):
        self.window.set_title("most viewed")
        self.doGenericSearch(session.TYPE_MOSTVIEWED, "dummy", 1, Cfg.PER_PAGE, self.searchDateCrt)

    def cb_featured(self, widget, data=None):
        self.window.set_title("featured")
        self.doGenericSearch(session.TYPE_FEATURED, "dummy", 1, Cfg.PER_PAGE)
    
    def cb_local(self, widget, data=None):
        self.window.set_title("local")
        self.doGenericSearch(session.TYPE_LOCAL, data, 1, Cfg.PER_PAGE)
    
    def cb_cycleDate(self, widget, data=None):
        if self.sess.type != session.TYPE_LOCAL:
            mutils.info("only on local search")
            return
        sort = self.sess.sort+1
        if sort > 1:
            sort = session.SORT_NONE
        
        #display info
        if sort == session.SORT_NONE:
            mutils.info("no sorting")
        elif sort == session.SORT_DESC:
            mutils.info("sort by date desc")
        if sort == session.SORT_ASC:
            mutils.info("sort by date asc")
        self.doGenericSearch(self.sess.type, self.sess.string,
                             self.sess.start, Cfg.PER_PAGE, 
                             self.sess.date, sort)
    
    def doGenericSearch(self, type, searchString, start, count, date=None, sort=session.SORT_NONE):
        #store in session
        self.sess.type = type
        self.sess.string = searchString
        self.sess.start = start
        self.sess.count = count
        self.sess.date = date
        #this only works for LOCAL search
        if type == session.TYPE_LOCAL:
            self.sess.sort = sort
        
        self.switchPage("search")
        self.setDetailsExtraButtons(False)
        self.startDetailsAnim(False)
        self.clearEntries()
        self.worker.addRequest([type, searchString, start, count, date, sort])
      
    def cb_window_state_change(self, widget, event, *args):
        if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
            self.window_in_fullscreen = True
        else:
            self.window_in_fullscreen = False
    
    def cb_test(self, widget):
        print "changed"
            
    def cb_key_press(self, widget, event, *args):
        if event.keyval == gtk.keysyms.F6:
            # The "Full screen" hardware key has been pressed
            if self.window_in_fullscreen:
                self.window.unfullscreen ()
            else:
                self.window.fullscreen ()
                
    def cb_pageSearch(self, widget, data=None):
        self.switchPage("search")
        
    
    def cb_pageHome(self, widget, data=None):
        self.switchPage("home")
    
    def cb_about(self, widget, data=None):
        from mytube.ui import about
        dialog = about.Dialog()
        dialog.run()
        dialog.destroy()

    def cb_copyUrl(self, widget, data=None):
        video, idx = self.getSelectedVideo()
        if video == None:
            return
        clipboard = gtk.clipboard_get(gtk.gdk.SELECTION_CLIPBOARD)
        clipboard.set_text(video.url)
        mutils.info("url copied")
    
    def cb_openBrowser(self, widget, data=None):
        video, idx = self.getSelectedVideo()
        if video == None:
            return
        import os
        os.system(Cfg.CMD_BROWSER+" "+video.url)
    
    def cb_searchByUrl(self, widget, data=None):
        clipboard = gtk.clipboard_get(gtk.gdk.SELECTION_CLIPBOARD)
        clipboard.request_text(self.cb_null)
        clipped = clipboard.wait_for_text()
        self.switchPage("search")
        if (clipped == None or len(clipped) < 7):
            self.searchTxt.set_text("PASTE HERE AND CLICK THERE  ->  !")
        else:
            self.searchTxt.set_text(clipped)
        self.searchTxt.select_region(0, -1)            
        
    #downloading animation
    def cb_timeout(self, video, idx):
        if self.hasStreamAlive(video):# and video.percentDl <= 0:
            video.dispAnim = video.dispAnim+1
            video.dispAnim = video.dispAnim%8
            self.updateEntry(idx, video)
            return True
        else:
            video.dispAnim = -1
            self.updateEntry(idx, video)
            self.updateActions(video)
        return False
    
    #sliding animation
    def cb_timeoutDetails(self, expand):
        w = self.details.get_width()
        #print "animation %d" %w
        if expand:
            if w < self.ANIM_W:
                self.animState = 1
                w = w + self.ANIM_S
                w = min(self.ANIM_W, w)
                self.details.set_size_request(w, -1)
                return True
            self.animState = 2
            self.details.setVideo(self.videoCrt)
            
        else:
            if w > 1:
                self.animState = 1
                w = w - self.ANIM_S
                w = max(0, w)
                self.details.set_size_request(w, -1)
                return True
            self.animState = 0
            print "retract ended "
        self.details.showChildren(True)
        return False
        
    def getStreamer(self, video):
        vid = video.getVideoId();
        if (not self.ystreamers.has_key(vid)) or (not self.ystreamers[vid].isAlive()):
            print "CREATED a streamer for "+video.title
            self.ystreamers[vid] = YStreamer(self, video)
            self.ystreamers[vid].start()
        return self.ystreamers[vid]
        
    def hasStreamAlive(self, video):
        vid = video.getVideoId();
        if (not self.ystreamers.has_key(vid)) or (not self.ystreamers[vid].isAlive()):
            return False
        return True
        
    #returns a tuple (video, index) in the listing
    def getSelectedVideo(self):
        try:
            if (Cfg.USE_KINETIC):
                yentry = self.searchScroll.get_selected_sprite().obj
                idx = self.searchScroll.get_selected_sprite_index()
                return (yentry, idx)
#            else:
#                treeSelection = self.treeView.get_selection()
#                list,paths = treeSelection.get_selected_rows()
#                yentry = list[paths[0][0]][0]
#                idx = paths[0][0]
#                return (yentry, idx)
        except:
            return (None, -1)
    
    def getAtYVideo(self, y):
        if (Cfg.USE_KINETIC):
            sprite, idx = self.searchScroll.get_sprite_at_y(int(y))
            if sprite == None:
                return (None, -1)
            return (sprite.obj, idx)
        return (None, -1)
        
    def addEntry(self, values):
        if Cfg.USE_KINETIC:
            from ..ui import kinetic
            idx = self.searchScroll.get_sprites_count()
            for value in values:
                self.searchScroll.add(kinetic.ScrollYItem(value, idx))
#        else:
#            self.liststore.append(values);
        
    def clearEntries(self):
        if (Cfg.USE_KINETIC):
            self.searchScroll.clear()
            self.searchScroll.dirty = True
#        else:
#            self.liststore.clear()
            
    def updateEntry(self, idx, value):
        #mark that we should recompute the pixbuf cache
        value.dirty = True
        
        if Cfg.USE_KINETIC:
            sprite = self.searchScroll.get_sprite(idx)
            if sprite == None:
                return
            sprite.dirty = True
            self.searchScroll.dirtyChild = True
#        else:
#            iter = self.liststore.get_iter(idx)
#            self.liststore.set_value(iter, 0, value)
        
    def notifyProgress(self, video, percentage, kilo):
        if Cfg.USE_KINETIC:
            idx = self.searchScroll.get_sprite_idx(video)
            if percentage == None:
                gobject.timeout_add(100, self.cb_timeout, video, idx)
                return
            else:
                video.percentDl = percentage
                video.downloadedKb = kilo
            self.updateEntry(idx, video)
#        else:    
#            iter = self.liststore.get_iter_first()
#            idx = -1
#            while not iter == None:
#                idx = idx+1
#                if self.liststore.get_value(iter, 0).videoId == video.videoId:
#                    #create a spinner here
#                    if percentage == None:
#                        gobject.timeout_add(100, self.cb_timeout, video, idx)
#                        return
#                    #display
#                    else:
#                        video.percentDl = percentage
#                        video.downloadedKb = kilo
#                    self.updateEntry(idx, video)
#                    #self.liststore.set_value(iter, 0, video)
#                    return
#                iter = self.liststore.iter_next(iter)
#            print "nu am gasit video"    

    
    def createWorkers(self):
        mutils.dbgTime("workers: begin")
        from ybgworker import YBgWorker
        self.ystreamers = dict()
        self.worker = YBgWorker(self)
        self.worker.start()
        mutils.dbgTime("workers: started")
        #stop the timeout
        return False

    def updateActions(self, video):
        #restructure this
        if self.downloadActionId != None:
            self.searchBtnDownload.disconnect(self.downloadActionId)
            self.downloadActionId = None
        if self.cancelActionId != None:
            self.searchBtnCancel.disconnect(self.cancelActionId)
            self.cancelActionId = None
        if video == None:
            self.searchBtnDownload.set_sensitive(False)
            self.searchBtnCancel.set_sensitive(False)
            return
        
        self.searchBtnDownload.set_sensitive(True)
        
        if self.hasStreamAlive(video):
            print ">>>Alive = ",self.hasStreamAlive(video)
            self.searchBtnCancel.set_sensitive(True)
            self.searchBtnDownload.set_sensitive(False)
        else:
            self.searchBtnCancel.set_sensitive(False)

        if video.isStored():
            self.searchBtnDownload.set_label("del")
            #TODO: optimize image loading here
            self.searchBtnDownload.set_image(ystorage.loadImage("myt-del.png", -1, -1))
            self.downloadActionId = self.searchBtnDownload.connect("clicked", self.cb_deleteStored, None)
            return
        if video.isCached():
            self.searchBtnDownload.set_label("store")
            self.searchBtnDownload.set_image(ystorage.loadImage("myt-saved.png", -1, -1))
            self.downloadActionId = self.searchBtnDownload.connect("clicked", self.cb_saveCached, None)
            return
        #otherwise
        self.searchBtnDownload.set_label("down")
        self.searchBtnDownload.set_image(ystorage.loadImage("myt-down.png", -1, -1))
        self.downloadActionId = self.searchBtnDownload.connect("clicked", self.cb_downloadVideo, None)
        
    

    def createLeftControls(self):
        #create controls        
        self.searchBtnPlay = gtk.Button("play")
        self.searchBtnPlay.set_image(ystorage.loadImage("myt-play.png", -1, -1))
        self.searchBtnPlay.set_size_request(self.BTN_SIZE, self.BTN_SIZE)
        self.searchBtnPlay.connect("clicked", self.cb_playVideo, None)
        self.searchBtnPlay.show()

        self.cancelActionId = None
        self.searchBtnCancel = gtk.Button("cancel")
        self.searchBtnCancel.set_image(ystorage.loadImage("myt-cancel.png", -1, -1))
        self.searchBtnCancel.connect("clicked", self.cb_cancelVideo, None)
        self.searchBtnCancel.show();
        self.searchBtnCancel.set_size_request(-1, self.BTN_SIZE)

        self.downloadActionId = None
        self.searchBtnDownload = gtk.Button("down")
        self.searchBtnDownload.set_image(ystorage.loadImage("myt-down.png", -1, -1))
        self.searchBtnDownload.show();
        self.searchBtnDownload.set_size_request(-1, self.BTN_SIZE)
        
        self.searchControlsVBox1 = gtk.VBox(False, 0)
        self.searchControlsVBox1.show()
        
        self.searchControlsVBox1.pack_start(self.searchBtnPlay, False, False, 0)
        self.searchControlsVBox1.pack_start(self.searchBtnCancel, False, False, 0)
        self.searchControlsVBox1.pack_start(self.searchBtnDownload, False, False, 0)
        
        return self.searchControlsVBox1
    
    def createBottomButton(self, txt, imgName, signalName, callback):
        if not mutils.isMaemo():
            btn = gtk.Button(txt)
            btn.set_image(ystorage.loadImage(imgName, -1, -1))
            btn.set_size_request(-1, self.BTN_HEIGHT_NAV)
        else:
            btn = gtk.ToolButton(ystorage.loadImage(imgName, -1, -1), txt)
            btn.set_is_important(True) 
        
        btn.connect(signalName, callback, None)
        return btn
    
    def createBottomControls(self):
        
        if not mutils.isMaemo():
            self.bottomToolbar = gtk.HBox(False, 0)
            self.bottomToolbar.set_size_request(-1, self.BTN_HEIGHT_NAV)
            self.bottomToolbar.modify_bg(gtk.STATE_NORMAL, gtk.gdk.color_parse("green"))
        else:
            self.bottomToolbar = gtk.Toolbar()
            self.bottomToolbar.set_style(gtk.TOOLBAR_BOTH_HORIZ)
            
        self.searchHide = self.createBottomButton("hide", "myt-esc.png", "clicked", self.cb_retractClicked)
        self.searchRels = cb = SimpleComboBox(True)
        cb.append_item("more ...", ystorage.loadPixbuf("myt-connections.png", -1, -1), self.cb_null)
        cb.append_item("related", ystorage.loadPixbuf("myt-related.png", -1, -1), self.cb_related)
        cb.append_item("by author", ystorage.loadPixbuf("myt-author.png", -1, -1), self.cb_author)
        cb.append_item("by cat", ystorage.loadPixbuf("myt-cat.png", -1, -1), self.cb_category)
        
        self.searchTime = cb = SimpleComboBox(True)
        cb.append_item("...", ystorage.loadPixbuf("myt-time.png", -1, -1), self.cb_changeDate)
        cb.append_item("today", None, self.cb_changeDate, "today")
        cb.append_item("week", None, self.cb_changeDate, "this_week")
        cb.append_item("month", None, self.cb_changeDate, "this_month")
        cb.append_item("all", None, self.cb_changeDate, None)
                
        self.searchBtnLeft = self.createBottomButton("prev", "myt-left.png", "clicked", self.cb_prevResults)        
        self.searchBtnHome = self.createBottomButton("home", "myt-home.png", "clicked", self.cb_pageHome)
        #SimpleComboBox(True)
        
        
        self.searchTxt = gtk.Entry()
        self.searchTxt.connect("activate", self.cb_entryActivated, None)
        
        self.searchBtn = self.createBottomButton("find", "myt-search.png", "clicked", self.cb_search)        
        self.searchBtnRight = self.createBottomButton("next", "myt-right.png", "clicked", self.cb_nextResults)
        
        if not mutils.isMaemo():
            self.bottomToolbar.pack_start(self.searchHide, False, False, 0)
            #self.searchHide.
            self.bottomToolbar.pack_start(self.searchBtnLeft, False, False, 0)
            self.bottomToolbar.pack_start(self.searchBtnHome, False, False, 0)
            self.bottomToolbar.pack_start(self.searchTxt, True, True, 0)
            self.bottomToolbar.pack_start(self.searchBtn, False, False, 0)
            self.bottomToolbar.pack_start(self.searchTime, False, False, 0)
            self.bottomToolbar.pack_start(self.searchBtnRight, False, False, 0)            
            self.bottomToolbar.pack_start(self.searchRels, False, False, 0)
            self.bottomToolbar.show_all()
            self.searchHide.hide()
            self.searchRels.hide()
        else:
            self.bottomToolbar.insert(self.searchHide, -1)
            self.bottomToolbar.insert(self.searchBtnLeft, -1)
            self.bottomToolbar.insert(self.searchBtnHome, -1)
            
            ti1 = gtk.ToolItem()
            ti1.add(self.searchTxt)
            ti1.set_expand(True)
            self.bottomToolbar.insert(ti1, -1)
            self.bottomToolbar.insert(self.searchBtn, -1)
            
            ti2 = gtk.ToolItem()
            ti2.add(self.searchTime)
            ti2.set_is_important(True)
            self.bottomToolbar.insert(ti2, -1)
            
            self.bottomToolbar.insert(self.searchBtnRight, -1)
            
            ti2 = gtk.ToolItem()
            ti2.add(self.searchRels)
            ti2.set_is_important(True)
            self.bottomToolbar.insert(ti2, -1)
            
            self.bottomToolbar.show_all()
            self.searchHide.hide()
            self.searchRels.hide()
        
        return self.bottomToolbar
    
#    def createListSearch(self):
#        #create main list
#        self.liststore = gtk.ListStore(object)
#
#        self.treeView = gtk.TreeView(self.liststore)
#        self.treeView.set_headers_visible(False)
#        self.treeView.connect("button-press-event", self.cb_rowClicked)
#        self.treeView.connect("row-activated", self.cb_rowActivated)
#        self.treeView.connect("cursor-changed", self.cb_rowChanged)
#        self.treeView.show()
#        
#
#        cellRenderer = YCellRenderer()
#        self.treeColumn = gtk.TreeViewColumn("videos", cellRenderer, obj=0);
#        self.treeView.append_column(self.treeColumn);
#        
#        self.searchScroll = gtk.ScrolledWindow()
#        self.searchScroll.show()
#        self.searchScroll.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
#        try:
#            hildon.hildon_helper_set_thumb_scrollbar(self.searchScroll, True)
#        except:
#            print "finger friendly scrollbar not available"
#        self.searchScroll.add(self.treeView)
#        return self.searchScroll
    
    def createListSearchKinetic(self):
        #create main list
        self.liststore = gtk.ListStore(object)
        from ..ui import kinetic
        self.searchScroll = kinetic.ScrollWidget()
        
        self.searchScroll.connect("scrollitem_click_event", self.cb_rowSelectedKinetic)
        self.searchScroll.connect("button-press-event", self.cb_rowClickedKinetic)
        #self.searchScroll.connect("button-press-event", self.cb_rowChanged)
        self.searchScroll.set_size_request(50,410)
        return self.searchScroll
    
    #TODO: check caching
    def createDetails(self):
        from ..ui import details
        self.details = details.createDetails(self.window)
        self.details.setVideo(None)
        #reset this selection
        try:
            self.searchRels.set_active(0)
        except:
            pass
        #return mutils.addBg(self.details, None) 
        #self.treeView.get_style().bg[gtk.STATE_SELECTED])
        return self.details
    
    def setDetailsExtraButtons(self, state):
        #make some room
        if mutils.isMaemo():
            self.searchBtnLeft.set_is_important(not state)
            self.searchBtnRight.set_is_important(not state)
            self.searchBtn.set_is_important(not state)
        
        showDate = False
        if state == False: #not in details mode
            if self.sess.type in [session.TYPE_MOSTVIEWED, session.TYPE_MOSTDISCUSSED, 
                                      session.TYPE_MOSTACTIVE, session.TYPE_TOPRATED]:
                showDate = True       
        if state == True:
            self.searchHide.show()
            self.searchRels.show()
            self.searchRels.set_active(0)
        else:
            self.searchHide.hide()
            self.searchRels.hide()
        
        if showDate:
            self.searchTime.show()
        else:
            self.searchTime.hide()
            
    def startDetailsAnim(self, expand):
        self.stopDetailsAnim()
        self.searchScroll.stop_animation()
        self.details.showChildren(False)
        self.timeoutobj = gobject.timeout_add(10, self.cb_timeoutDetails, expand)
        
    def stopDetailsAnim(self):
        if self.timeoutobj != -1:
            gobject.source_remove(self.timeoutobj)
            self.timeoutobj = -1
            
    def createMenu(self):
         # Create an accelerator group
        accelgroup = gtk.AccelGroup()
        # Add the accelerator group to the toplevel window
        self.window.add_accel_group(accelgroup)
        actiongroup = gtk.ActionGroup('BasicAction')
        
        # Create an action for quitting the program using a stock item
        action0 = gtk.Action('Sort by date (cycle)', 'Sort by date (cycle)', 'ceva', gtk.STOCK_SORT_ASCENDING)
        action0.connect('activate', self.cb_cycleDate)
        actiongroup.add_action_with_accel(action0, "<Control>d")
        action0.set_accel_group(accelgroup)
        
        # Create an action for quitting the program using a stock item
        action = gtk.Action('Search', 'Search', 'Search a video', gtk.STOCK_FIND)
        #action.set_property('short-label', '_Search')
        action.connect('activate', self.cb_pageSearch)
        actiongroup.add_action_with_accel(action, None)
        action.set_accel_group(accelgroup)
        
        # 
        action11 = gtk.Action('Copy video url', '_Copy video url', 'Copy video url', gtk.STOCK_COPY)
        #action11.set_property('short-label', '_Copy')
        action11.connect('activate', self.cb_copyUrl)
        actiongroup.add_action_with_accel(action11, None)
        action11.set_accel_group(accelgroup)
        
        # 
        action115 = gtk.Action('Paste youtube url', '_Paste youtube url', 'Paste youtube url', gtk.STOCK_PASTE)
        #action115.set_property('short-label', '_Paste')
        action115.connect('activate', self.cb_searchByUrl)
        actiongroup.add_action_with_accel(action115, None)
        action115.set_accel_group(accelgroup)
        
        # 
        action12 = gtk.Action('Open in browser', '_Open in browser', 'Open in browser', gtk.STOCK_OPEN)
        #action12.set_property('short-label', '_Open')
        action12.connect('activate', self.cb_openBrowser)
        actiongroup.add_action_with_accel(action12, None)
        action12.set_accel_group(accelgroup)
        
        
        # Create an action for quitting the program using a stock item
        action2 = gtk.Action('Home', '_Home', 'Go home', gtk.STOCK_HOME)
        #action2.set_property('short-label', '_Home')
        action2.connect('activate', self.cb_pageHome)
        actiongroup.add_action_with_accel(action2, None)
        action2.set_accel_group(accelgroup)
        
         # Create an action for quitting the program using a stock item
        action3 = gtk.Action('Preferences', '_Preferences', 'Preferences', gtk.STOCK_PREFERENCES)
        action3.set_property('short-label', '_Preferences')
        
        # Create about dialog
        action4 = gtk.Action('About', '_About', 'About', gtk.STOCK_ABOUT)
        action4.set_property('short-label', '_About')
        action4.connect('activate', self.cb_about)

        # Create an action for quitting the program using a stock item
        action5 = gtk.Action('Quit', '_Quit', 'Quit the Program', gtk.STOCK_QUIT)
        action5.set_property('short-label', '_Quit')
        action5.connect('activate', self.cb_destroy)
        actiongroup.add_action_with_accel(action5, None)
        action5.set_accel_group(accelgroup)

        # Create a MenuBar
        if not mutils.isMaemo():
            menubar = gtk.MenuBar()
            menubar.show()
            self.boxV.pack_start(menubar, False)

        # Create the File Action and MenuItem
        file_action = gtk.Action('File', '_File', None, None)
        actiongroup.add_action(file_action)
        file_menuitem = file_action.create_menu_item()
        if not mutils.isMaemo():
            menubar.append(file_menuitem)

        # Create the File Menu
        file_menu = gtk.Menu()
        file_menuitem.set_submenu(file_menu)
        
        menuitem = action0.create_menu_item()
        file_menu.append(menuitem)

        menuitem = action.create_menu_item()
        file_menu.append(menuitem)
        
        menuitem = action11.create_menu_item()
        file_menu.append(menuitem)
        
        menuitem = action115.create_menu_item()
        file_menu.append(menuitem)
        
        menuitem = action12.create_menu_item()
        file_menu.append(menuitem)
        
        menuitem = action2.create_menu_item()
        file_menu.append(menuitem)
        
        menuitem = action3.create_menu_item()
        file_menu.append(menuitem)
        
        menu3 = gtk.Menu()
        menuitem.set_submenu(menu3)
        menuitem3 = gtk.MenuItem("storage")
        menuitem3.show()
        menu3.append(menuitem3)
        menuitem3.connect("activate", self.cfg.setStorePath)
        #
        menuitem3 = gtk.MenuItem("more...")
        menuitem3.show()
        menu3.append(menuitem3)
        menuitem3.connect("activate", self.showPrefs)
        
        #
        
        menuitem = action4.create_menu_item()
        file_menu.append(menuitem)
        
        menuitem = action5.create_menu_item()
        file_menu.append(menuitem)
        
        if mutils.isMaemo():
            self.window.set_menu(file_menu)
            
    def showPrefs(self, ignore=None):
        #try to load code when needed only to speed up things
        from ..ui import prefs
        prefs = prefs.Prefs()
        prefs.show()

    def createPageSearch(self):
        try: #if allready exists, return it
            return self.searchVBox
        except:
            pass
        
        
        self.searchVBox = gtk.VBox(False, 0)
        #TODO: this is reversed so some resources can load
        if (Cfg.USE_KINETIC == True):
            self.searchScroll = self.createListSearchKinetic()
        else:
            self.searchScroll = self.createListSearch()
        self.details = self.createDetails()
        self.searchControlsVBox1 = self.createLeftControls()
        #add the list and right controls together
        self.searchHBox1 = gtk.HBox(False, 2)
        
        brdClr = gtk.gdk.color_parse("#000000")
        self.searchHBox1.pack_start(mutils.addBg(self.details, None),
                                    False, True, 0)
        self.searchHBox1.pack_start(self.searchScroll, True, True, 0)
        self.searchHBox1.pack_start(self.searchControlsVBox1, False, False, 0);
        
        self.searchVBox.pack_start(self.searchHBox1, True, True, 0)
        #
        
        #create search/navigate controls
        self.bottomToolbar = self.createBottomControls()
        if not mutils.isMaemo():
            self.searchVBox.pack_start(self.bottomToolbar, False, False, 0)
        else:
            self.window.add_toolbar(self.bottomToolbar)
        
        
        self.bottomToolbar.show()
        self.searchHBox1.show()
        self.searchVBox.show()
        self.searchScroll.show()
        
        
        #XXX: 2007HE bug
        self.window.show_all() #show toolbar in 2007
        self.setDetailsExtraButtons(False) #hide some of buttons exposed above
        
        #allow the theme to draw the bg
        self.searchVBox = mutils.addBg(self.searchVBox, None)
        
        return self.searchVBox
    
    def createListChoser(self):
        """creates a "choose list" combo box"""
        try:
            #reset when displaying 
            self.btnChooseList.set_active(0)
            return self.btnChooseList
        except:#does not exist
            pass
        print "creating lists"
        #create it
        itemIcon = None #ystorage.loadPixbuf("myt-related.png", -1, -1)
        self.btnChooseList = cb = SimpleComboBox(True, height=40)
        cb.append_item("saved", None, self.cb_null)
        allLists = [None]
        allLists.extend(mtags.getTagNames())
        for listname in allLists:
            friendlyStr = "["+str(listname)+"]"
            if listname == None:
                friendlyStr = "[all]"
            cb.append_item(friendlyStr, itemIcon, 
                lambda w, p: self.cb_local(w, allLists[self.btnChooseList.get_active()-1]))
        return self.btnChooseList
    
    def createPageHome(self):
        try: #if allready exists, return it
            self.createListChoser() #for a reset for combobox
            return self.homeHBox
        except:
            pass
        
        homeMenuL = (["most viewed", self.cb_mostviewed], ["top rated", self.cb_toprated], ["featured", self.cb_featured],["search", self.cb_pageSearch])
        homeMenuR = (["favorites"], ["upload"], ["login"], ["saved", self.cb_local])
        self.homeHBox = gtk.HBox()
        self.homeHBox.show()
        homeTableL = gtk.Table(3, 1, True)
        for i in range(len(homeMenuL)):
            homeMenuEntry = homeMenuL[i]
            if (len(homeMenuEntry) > 1):
                homeBtn = gtk.Button(homeMenuEntry[0])
                homeBtn.connect("clicked", homeMenuEntry[1], None)
            else:
                homeBtn = gtk.Button(homeMenuEntry[0])
                homeBtn.set_sensitive(False)
            homeTableL.attach(homeBtn, 0, 1, i, i+1)
            homeBtn.show()
        homeTableL.show()
        self.homeHBox.pack_start(homeTableL, False, False, 0)
        
        logo = ystorage.loadImage("youtube-logo.gif", -1, -1)
        logo.show()
        self.homeHBox.pack_start(mutils.addBg(logo, None), True, True, 0)
        
        homeTableR = gtk.Table(3, 1)
        for i in range(len(homeMenuR)):
            homeMenuEntry = homeMenuR[i]
            if (len(homeMenuEntry) > 1):
                if (homeMenuEntry[1] == self.cb_local):
                    homeBtn = self.createListChoser()
                else:
                    homeBtn = gtk.Button(homeMenuEntry[0])
                    homeBtn.connect("clicked", homeMenuEntry[1], None)
            else:
                homeBtn = gtk.Button(homeMenuEntry[0])
                homeBtn.set_sensitive(False)
            homeTableR.attach(homeBtn, 0, 1, i, i+1)
            homeBtn.show()
        homeTableR.show()
        self.homeHBox.pack_start(homeTableR, False, False, 0)
        
        return self.homeHBox
    
    def switchPage(self, pageName):
        if self.pageCrt != None:
            self.boxV.remove(self.pageCrt)
        if pageName == "search":
            self.pageCrt = self.createPageSearch()
            self.updateActions(None)
            if self.bottomToolbar != None:
                self.bottomToolbar.show()
        elif pageName == "home":
            if self.bottomToolbar != None:
                self.bottomToolbar.hide()
            self.pageCrt = self.createPageHome();
        else:
            return
        self.boxV.pack_start(self.pageCrt, True, True, 0)
        
    
        
    def __init__(self):
        #slider animation state
        self.animState = 0
        self.window = None
        self.cfg = Cfg()
        self.sess = session.Session()
        
        Cfg.setGtkTheme(self.cfg.getCfg("gtk-theme", "default"))
        # create a new window
        if (mutils.isMaemo()):
            import hildon
            self.window = hildon.Window()
        else:
            self.window = gtk.Window(gtk.WINDOW_TOPLEVEL)
            self.window.set_position(gtk.WIN_POS_CENTER_ALWAYS)

        mutils.enableBtnImages(gtk.Button())
        
        self.window.set_title("mYTube")
        self.window_in_fullscreen = False
        self.window.connect("window-state-event", self.cb_window_state_change)
        self.window.connect("key-press-event", self.cb_key_press)

        self.window.set_default_size(800, 480)
    
        self.window.connect("delete_event", self.cb_deleteEvent)
        self.window.connect("destroy", self.cb_destroy)
        self.window.set_border_width(1)

        self.boxV = gtk.VBox(False, 0)
        self.window.add(self.boxV);
        #delay this
        #gobject.timeout_add(10, self.createMenu, priority=gobject.PRIORITY_LOW)
        self.createMenu()
        
        #TODO: these should not be members inside the GUI. don't be lazy
        self.pageCrt = None
        self.videoCrt = None
        self.searchTypeCrt = None
        self.searchDateCrt = None
        
        self.bottomToolbar = None
        self.switchPage("home")
        
        self.boxV.show()
        if not mutils.isMaemo():
            self.window.set_icon_from_file(ystorage.getImgPath("mytube.png"))
        self.window.show()
        #delay workers creation 
        gobject.timeout_add(200, self.createWorkers, priority=gobject.PRIORITY_LOW)
        self.timeoutobj = -1

    def main(self):
        # All PyGTK applications must have a gtk.main(). Control ends here
        # and waits for an event to occur (like a key press or mouse event).
        gtk.gdk.threads_init()
        gtk.gdk.threads_enter()
        gtk.main()
        gtk.gdk.threads_leave()


