#Class used for both Config and Environment functions
#TODO: restructure

from ConfigParser import ConfigParser
import os, sys, gtk, traceback, mutils

print ">>>init conf"

class Cfg:
    CFG_NAME = os.path.expanduser("~")+"/.mytuberc"
    STORE_PATH_DEFAULT  = "/media/mmc2"
    STORE_PATH          = STORE_PATH_DEFAULT
    VIDEO_DIR_DEFAULT   = "mtube"
    VIDEO_DIR           = ""
    CACHE_DIR_DEFAULT   = "mtube"+os.path.sep+".cache"
    CACHE_DIR           = ""
    VER                 = "0.1.4"
    CMD_MPLAYER_DEFAULT = "mplayer -osdlevel 3 -correct-pts -subfont-osd-scale 3 -- %s".split(" ")
    CMD_MPLAYER         = CMD_MPLAYER_DEFAULT
    CMD_YTDL_DEFAULT    = "youtube-dl-x -o %d -- %s".split(" ")
    CMD_YTDL            = CMD_YTDL_DEFAULT
    CMD_BROWSER_DEFAULT = "/usr/bin/browser --url"
    CMD_BROWSER         = CMD_BROWSER_DEFAULT
    GTK_THEMES_PATHS    = ["/usr/share/themes", "C:\\Program Files\\Common Files\\GTK\\2.0\\share\\themes"]
    PER_PAGE            = 10
    USE_KINETIC         = True
    KIN_FRIC            = 30
    KIN_MAX_SPEED       = 10
    INSTANCE            = None
    __hiddenWindow      = None
    
    
    #------------- defines start
    DETAILS_X           = 70
    #------------- defines end
    
    def __init__(self):
        Cfg.INSTANCE = self
        self.cfg = ConfigParser()
        self.cfg.read(self.CFG_NAME)
        
        #default ini file
        if not self.cfg.has_section("global"):
            self.cfg.add_section("global")
            #self.saveCfg()

        Cfg.STORE_PATH = self.getCfg("store", Cfg.STORE_PATH_DEFAULT) 
        Cfg.VIDEO_DIR = Cfg.STORE_PATH+os.path.sep+Cfg.VIDEO_DIR_DEFAULT
        Cfg.CACHE_DIR = Cfg.STORE_PATH+os.path.sep+Cfg.CACHE_DIR_DEFAULT
        Cfg.CMD_MPLAYER = self.getCfg("mplayer", " ".join(Cfg.CMD_MPLAYER_DEFAULT)).split(" ")
        Cfg.CMD_YTDL = self.getCfg("youtube-dl", " ".join(Cfg.CMD_YTDL_DEFAULT)).split(" ")
        Cfg.CMD_BROWSER = self.getCfg("browser", Cfg.CMD_BROWSER_DEFAULT)
        Cfg.PER_PAGE = int(self.getCfg("per_page", "10"))
        Cfg.KIN_FRIC = int(self.getCfg("kin_fric", Cfg.KIN_FRIC))
        Cfg.KIN_MAX_SPEED = int(self.getCfg("kin_max_speed", Cfg.KIN_MAX_SPEED))
        
        self.ensureStorage()

    def getCfg(self, varName, defaultVal = None):
        var = ""
        try:
            var = self.cfg.get("global", varName)
        except:
            if defaultVal != None:
                var = defaultVal
                #and save it in case it's not set
                self.cfg.set("global", varName, defaultVal)
            else:
                #worth of notifying the user?
                mutils.log(sys.exc_info()[1])
        return var
        
    def setCfg(self, var, val, save=True):
        self.cfg.set("global", var, val)
        if save:
            self.saveCfg()
            
    def saveCfg(self):
        f = open(self.CFG_NAME, "w")
        self.cfg.write(f)
        f.close()
        
    def ensureStorage(self):
        if not os.path.isdir(Cfg.STORE_PATH):
            mutils.log("storage dir does not exist "+Cfg.STORE_PATH)
            self.setStorePath()
            return
        if not os.path.isdir(Cfg.VIDEO_DIR):
            mutils.log("creating video dir")
            os.mkdir(Cfg.VIDEO_DIR)
        if not os.path.isdir(Cfg.CACHE_DIR):
            mutils.log("creating cache dir (first time?)")
            os.mkdir(Cfg.CACHE_DIR)
    
    def __chooseStoreFolder(self):
        if not mutils.isMaemo():
            fc = gtk.FileChooserDialog("Choose video storage path",
                    None, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER, 
                    (gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL, gtk.STOCK_OK, gtk.RESPONSE_ACCEPT))
        else:
            if Cfg.__hiddenWindow == None:
                Cfg.__hiddenWindow = hildon.Window()
            fc = hildon.FileChooserDialog(Cfg.__hiddenWindow, gtk.FILE_CHOOSER_ACTION_SELECT_FOLDER)
        
        fc.set_current_folder(Cfg.STORE_PATH)
        res = fc.run()
        fc.hide()

        if res != gtk.RESPONSE_ACCEPT and res != gtk.RESPONSE_OK:
            return
        self.setCfg("store", fc.get_filename(), True)
        
    def setStorePath(self, ignore1=None):
        self.__chooseStoreFolder()        
        Cfg.STORE_PATH = self.getCfg("store", Cfg.STORE_PATH_DEFAULT)
        Cfg.VIDEO_DIR = Cfg.STORE_PATH+os.path.sep+Cfg.VIDEO_DIR_DEFAULT
        Cfg.CACHE_DIR = Cfg.STORE_PATH+os.path.sep+Cfg.CACHE_DIR_DEFAULT
        self.ensureStorage()
        
    def getThemesList(self):
        paths = Cfg.GTK_THEMES_PATHS
        dirs = []
        for path in paths:
            try:
                dirs = sorted([d for d in os.listdir(path) if (os.path.isfile(path+os.path.sep+d+os.path.sep+"gtk-2.0"+os.path.sep+"gtkrc"))])
                return dirs
            except:
                pass
        return dirs
    
    def setGtkTheme(themeName):
        paths = Cfg.GTK_THEMES_PATHS
        for path in paths:
            rc = path+os.path.sep+themeName+os.path.sep+"gtk-2.0"+os.path.sep+"gtkrc"
            if os.path.isfile(rc):
                gtk.rc_set_default_files([rc])
                rcCrt = gtk.settings_get_default()
                gtk.rc_reparse_all_for_settings(rcCrt,True)
                return
    
    setGtkTheme = staticmethod(setGtkTheme)