#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import os
import threading

import gobject
import gtk
gtk.gdk.threads_init()
import gtk.glade
import datetime
import mtasks_framework
import pango

try:
	import hildon
except ImportError:
	hildon = None

class mTasks(object):

	__pretty_app_name__ = "mTasks"
	__app_name__ = "mtasks"
	__version__ = "0.2.0"

	_glade_files = [
		'ui/mtasks.glade',
	]

	def __init__(self):
		self._callbackList = None

		for path in mTasks._glade_files:
			if os.path.isfile(path):
				self._widgetTree = gtk.glade.XML(path)
				break
		else:
			#self.display_error_message("Cannot find mcalendar.glade")
#			gtk.main_quit()
			return

		#Get the buffer associated with the number display
		self._window = self._widgetTree.get_widget("MainView")

		print '1'

		global hildon
		self._app = None
		self._isFullScreen = False
		if hildon is not None and self._window is gtk.Window:
			warnings.warn("Hildon installed but glade file not updated to work with hildon", UserWarning, 2)
			hildon = None
		elif hildon is not None:
			self._app = hildon.Program()
			self._window = hildon.Window()
			self._window.set_border_width(0)
			self._widgetTree.get_widget("VirtualWindow").reparent(self._window)
			self._app.add_window(self._window)
			hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow2'),True)
			self._window.connect("key-press-event", self._on_key_press)
			self._window.connect("window-state-event", self._on_window_state_change)
		else:
			warnings.warn("No Hildon", UserWarning, 2)

		print '1.5'

		if hildon is not None:
			self._window.set_title("mTasks")
		else:
			self._window.set_title("%s" % self.__pretty_app_name__)

		callbackMapping = {
			# EventsList Signal
		  "on_bDelete_clicked": self._delete_task,
		  "on_bLow_clicked": self._set_low,
		  "on_bNormal_clicked": self._set_normal,
		  "on_bHigh_clicked": self._set_high,
		  "on_bNew_clicked": self._add_task,
		}
		self._widgetTree.signal_autoconnect(callbackMapping)

		print '1.75'

		if self._window:
			print '2'
			self._children_color_bg(self._window)
			print '3'
			self._window.connect("delete-event", self._win_closebox)
			self._window.show()
			print '4'
		print '2'

		threading.Thread(target=self._idle_setup).start()

	def _delete_task(self,widget):
		selection = self.tasksListTree.get_selection()
		model, selection_iter = selection.get_selected()
		if (selection_iter):
			uuid = self._tasksList.get_value(selection_iter, 0)
			task = mtasks_framework.Task(uuid)
			self._tasksList.remove(selection_iter)
			task.delete_from_db()
			self.refresh()	

	def refresh(self):
#		gtk.gdk.threads_enter()
		tasks_list =  mtasks_framework.TasksList().get_all_tasks()
		tasks_list.sort()
		new_order = range(len(tasks_list))
		uuid_list = []
		for task in tasks_list:
			uuid_list.append(task[3])

		iter = self._tasksList.get_iter_root()
		index = 0
		while(iter):
			new_order[uuid_list.index(self._tasksList.get_value(iter, 0))] = index
			index = index  + 1
			iter = self._tasksList.iter_next(iter)
		self._tasksList.reorder(new_order)
#		gtk.gdk.threads_leave()
		self._pijama_color()

	def _pijama_color(self):
		#pijama
#		gtk.gdk.threads_enter()
		iter = self._tasksList.get_iter_root()
		pij = True
		print 'pjama'
		while(iter):
			if pij == True:
				color = '#E5E5FF'
			else:
				color = '#FFFFFF'
			pij = not pij
			self._tasksList.set_value(iter, 6, color)
			iter = self._tasksList.iter_next(iter)
		self.tasksListTree.queue_draw()
#		gtk.gdk.threads_leave()
		print 'end pjama'

	def _set_low(self,widget):
		selection = self.tasksListTree.get_selection()
		model, selection_iter = selection.get_selected()
		if (selection_iter):
			uuid = self._tasksList.get_value(selection_iter, 0)
			task = mtasks_framework.Task(uuid)
			task.priority = 2
			self._tasksList.set_value(selection_iter, 3,task.priority)
			self._tasksList.set_value(selection_iter, 5,task.get_fg_color())
			task.save_to_db()
			self.refresh()

	def _set_normal(self,widget):
		selection = self.tasksListTree.get_selection()
		model, selection_iter = selection.get_selected()
		if (selection_iter):
			uuid = self._tasksList.get_value(selection_iter, 0)
			task = mtasks_framework.Task(uuid)
			task.priority = 1
			self._tasksList.set_value(selection_iter, 3,task.priority)
			self._tasksList.set_value(selection_iter, 5,task.get_fg_color())
			task.save_to_db()
			self.refresh()

	def _set_high(self,widget):
		selection = self.tasksListTree.get_selection()
		model, selection_iter = selection.get_selected()
		if (selection_iter):
			uuid = self._tasksList.get_value(selection_iter, 0)
			task = mtasks_framework.Task(uuid)
			task.priority = 0
			self._tasksList.set_value(selection_iter, 3,task.priority)
			self._tasksList.set_value(selection_iter, 5,task.get_fg_color())
			task.save_to_db()
			self.refresh()

	def _add_task(self,widget):
	  task = mtasks_framework.Task('')
	  task.description = 'Enter a description'
	  task.date = datetime.datetime.now()
	  due_datetime = datetime.datetime.strftime(task.date,'%x')
	  task.due_datetime = datetime.datetime.now()
	  self._tasksList_append(self._tasksList,task.uuid,task.status,due_datetime,task.priority,task.description,task.get_fg_color(),task.get_bg_color(),task.get_style())
	  task.save_to_db()
	  self.tasksListTree.queue_draw()

	def _win_closebox(self,widget,data):
		self._window.destroy()
		gtk.main_quit()
		return False

	def _children_color_bg(self,widget):
		if (type(widget)!=gtk.Image) and (type(widget)!=gtk.Label) and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView) and (type(widget)!=gtk.Calendar):
			widget.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
			widget.modify_bg(gtk.STATE_INSENSITIVE,gtk.gdk.Color(60000,60000,60000))
			for child in widget.get_children():
				self._children_color_bg(child)

	def _idle_setup(self):
		"""
		If something can be done after the UI loads, push it here so it's not blocking the UI
		"""

		try:
			import osso
		except ImportError:
			osso = None

		self._osso = None
		if osso is not None:
			self._osso = osso.Context(mTasks.__app_name__, mTasks.__version__, False)
		else:
			warnings.warn("No OSSO", UserWarning, 2)

		gtk.gdk.threads_enter()
		self._tasksList = self._tasksList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_INT,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
		self.tasksListTree = self._widgetTree.get_widget("tDisplay")
		self.tasksListTree.set_rubber_banding(True)
#		self.eventListTree.connect("row-activated", self._edit_event)
		self.tasksListTree.set_model(self._tasksList)

		checkboxrenderer = gtk.CellRendererToggle()
		checkboxrenderer.set_property('activatable' , True)
#		checkboxrenderer.set_property('background-set' , True)
#		checkboxrenderer.set_property('foreground-set' , True)
#		checkboxrenderer.connect('edited', self.edited_cell_cb, (self._tasksList, 1))

		checkboxrenderer.connect("toggled", self.edited_checkbox_cb, (self._tasksList, 1))		
		column_status = gtk.TreeViewColumn("Status", checkboxrenderer, active=1)

#		column_status.set_resizable(True)
#		column_status.set_clickable(True)

#		column_status.add_attribute(checkboxrenderer, 'background', 5)
#		column_status.add_attribute(textrenderer, 'foreground', 6)
		self.tasksListTree.append_column(column_status)

		descriptiontextrenderer = gtk.CellRendererText()
		descriptiontextrenderer.set_property('editable' , True)
		descriptiontextrenderer.set_property('background-set' , True)
		descriptiontextrenderer.set_property('foreground-set' , True)
		descriptiontextrenderer.set_property('wrap-mode' , pango.WRAP_CHAR)
		descriptiontextrenderer.set_property('style' , True)
		descriptiontextrenderer.set_property('width' , 460)
		descriptiontextrenderer.connect('edited', self.edited_cell_cb, (self._tasksList, 4))
		column_description = gtk.TreeViewColumn("Description", descriptiontextrenderer, text=4)
		column_description.add_attribute(descriptiontextrenderer, 'background', 6)
		column_description.add_attribute(descriptiontextrenderer, 'foreground', 5)
 		column_description.add_attribute(descriptiontextrenderer, 'style', 7)
 		self.tasksListTree.append_column(column_description)

		datetimetextrenderer = gtk.CellRendererText()
		datetimetextrenderer.set_property('editable' , True)
		datetimetextrenderer.set_property('background-set' , True)
		datetimetextrenderer.set_property('foreground-set' , True)
		datetimetextrenderer.set_property('wrap-mode' , pango.WRAP_CHAR)
		datetimetextrenderer.set_property('style' , True)
		datetimetextrenderer.set_property('width' , 80)
		datetimetextrenderer.connect('edited', self.edited_cell_cb, (self._tasksList, 2))
 		column_datetime = gtk.TreeViewColumn("Datetime", datetimetextrenderer, markup=2)
		column_datetime.add_attribute(datetimetextrenderer, 'background', 6)
		column_datetime.add_attribute(datetimetextrenderer, 'foreground', 5)
 		column_datetime.add_attribute(datetimetextrenderer, 'style', 7)
		self.tasksListTree.append_column(column_datetime)

		self._tasks_loader_process = threading.Thread(target=self._load_taskslist,args=[self._tasksList])
		self._tasks_loader_process.start()
		gtk.gdk.threads_leave()

		#Menu
		gtk.gdk.threads_enter()
		self.create_menu()
		gtk.gdk.threads_leave()

		return False

	def _on_window_state_change(self, widget, event, *args):
		"""
		@note Hildon specific
		"""
		if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
			self._isFullScreen = True
		else:
			self._isFullScreen = False

	def _tasksList_append(self,tasksList,uuid,status,datetime, priority,description, fg_color,bg_color,style):
		tasksList.append((uuid,status==1,datetime, priority,description, fg_color,bg_color,style))

	def _load_taskslist_bg(self):
		self._tasksList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_BOOLEAN, gobject.TYPE_STRING, gobject.TYPE_INT,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
		self.tasksListTree.set_model(self._tasksList)
		self._tasks_loader_process = threading.Thread(target=self._load_taskslist,args=[self._tasksList])
		self._tasks_loader_process.start()

	def _load_taskslist(self,tasksList):
		gtk.gdk.threads_enter()
		tasksList.clear()
		gtk.gdk.threads_leave()
		tasks_uuid_list =  mtasks_framework.TasksList().get_all_tasks()
		tasks_uuid_list.sort()
		task = None
		for (task_status,task_due_datetime,task_priority,task_uuid) in tasks_uuid_list:
			if self._tasksList != tasksList:
				return False
			task = mtasks_framework.Task(task_uuid)
			if task.due_datetime != None:
				due_datetime = datetime.datetime.strftime(task_due_datetime,'%x')
			else:
				due_datetime = None
			gtk.gdk.threads_enter()
			self._tasksList_append(tasksList,task.uuid,task.status,due_datetime,task.priority,task.description,task.get_fg_color(),task.get_bg_color(),task.get_style())
			gtk.gdk.threads_leave()

		gtk.gdk.threads_enter()
		self._pijama_color()
		gtk.gdk.threads_leave()
		return False

	def edited_checkbox_cb(self,cell, path, user_data):
		liststore, column = user_data
		liststore[path][column] = not liststore[path][column]

		task = mtasks_framework.Task(liststore[path][0])
		if column == 1:
			task.status = int(liststore[path][1])
		task.save_to_db()
		liststore[path][7] = task.get_style()
		self.refresh()

		return

	def edited_cell_cb(self,cell, path, new_text, user_data):
			liststore, column = user_data
			liststore[path][column] = new_text

			task = mtasks_framework.Task(liststore[path][0])
			if column == 4:
				task.description = liststore[path][4]
			elif column == 2:
				task.due_datetime = datetime.datetime.strptime(liststore[path][2],'%x')
			task.save_to_db()
			self.refresh()
			return
			
	def purge_done(self,widget,*data):
		mtasks_framework
		tasks_uuid_list =  mtasks_framework.TasksList().get_done_tasks()
		task = None
		for (task_status,task_due_datetime,task_priority,task_uuid) in tasks_uuid_list:
			task = mtasks_framework.Task(task_uuid)
			task.delete_from_db()
		self._load_taskslist_bg()

	def create_menu(self):
		self.menubar = gtk.Menu ()
		self._window.set_menu(self.menubar)
		accel_group = gtk.AccelGroup ()
		self._window.add_accel_group (accel_group)

		#Purge
		item = gtk.ImageMenuItem (gtk.STOCK_DELETE, accel_group)
		item.get_child().set_text('Purge Tasks done')
		item.connect ("activate", self.purge_done)
		item.show ()
		self.menubar.append (item)

		#Separator
		item = gtk.SeparatorMenuItem ()
		item.show ()
		self.menubar.append (item)

		#About
		item = gtk.ImageMenuItem (gtk.STOCK_ABOUT, accel_group)
		item.connect ("activate", self.onAbout)
		item.show ()
		self.menubar.append (item)

	def _on_key_press(self, widget, event, *args):
		"""
		@note Hildon specific
		"""
		if event.keyval == gtk.keysyms.F6:
			if self._isFullScreen:
				self._window.unfullscreen()
			else:
				self._window.fullscreen()

	def onAbout(self, widget):
		dialog = gtk.AboutDialog()
		dialog.set_name(self.__pretty_app_name__)
		dialog.set_logo_icon_name(self.__app_name__)
		dialog.set_authors(("Benoit HERVIER (Khertan)","","Thanks to :","",""))
		dialog.set_comments('a PIM Tasks for Maemo')
		dialog.set_version(self.__version__)
		dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
		dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
		dialog.set_website("http://khertan.net/")
		dialog.connect ("response", lambda d, r: d.destroy())
		dialog.show()

def run_mtasks():
	gtk.gdk.threads_init()
	if hildon is not None:
		gtk.set_application_name(mTasks.__pretty_app_name__)
	handle = mTasks()
	gtk.main()

if __name__ == "__main__":
	run_mtasks()