/**
 * @file	moncellsd.h
 * @author  Zach Habersang
 * @brief 	System Monitor Server Header
 *
 * Copyright (C) 2008 Zach Habersang
 *
 * @section LICENSE
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _MONCELLSD_H_
#define _MONCELLSD_H_ 1

// standard
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

// sockets
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// logging
#include <netdb.h>
#include <syslog.h>

// sysinfo
#include <sys/sysinfo.h>

// signals
#include <signal.h>

#define DEBUG 0

// monitor raw text protocol
// note: Windows uses '\r\n' :: UNIX and OSX uses '\n' ...for newlines 
#define MSG_DELIMIT '\n'
#define CMD_DELIMIT ':'
#define NUM_PROTOCOL_FIELDS 30 // e.g. "UPTIME:1482482\n"

#define SYS "SYSTEM"
#define PROCS "PROCS"
#define CPU "CPU"
#define MEM "MEMORY"


#define ERROR_DATA_RETURN "N/A" // display this to the user when a certain piece of data can't be gathered


//
// config
//

#define MAXPENDING 16
#define PORT 31427

#ifndef MAXSENDSIZE
#define MAXSENDSIZE 1024
#endif

#define INTERVAL_OF_DATA_UPDATES 5

#define RCVSIZE 512


// top length
#define TLEN 128


void ServDieWithError(char *errorMsg, int sock);
void handleClient(int clntsock, struct sockaddr_in clntAddr);
void *ServerThreadMain(void *threadArgs);
int sendclnt(int clntsock, char *str, ...);
void recvclnt(int clntsock, struct sockaddr_in clntAddr);
void serv_init(void);
int daemonize(void);
void printuse_exit(void);
void monitor_init(void);

int Build_Monitor_Data(int clntsock, struct sockaddr_in clntAddr);

// Structure of arguements to pass to thread
struct ThreadArgs
{
	int socket;
	struct sockaddr_in address;
};

void ServerSignalHandler(int signal);
void MS_signals_init(void (*func)(int signal));

int ServERR(char *errorMsg);




#endif
