/**
 * @file	moncells.h
 * @author  Zach Habersang
 * @brief 	Monitor Application Header
 *
 * Copyright (C) 2008 Zach Habersang
 *
 * @section LICENSE
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _MONCELLS_H_
#define _MONCELLS_ 1

// standard
#include <stdio.h>
#include <stdarg.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

// sockets
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>

// logging
#include <netdb.h>
#include <syslog.h>

// errno
#include <errno.h>

// for O_NONBLOCK and FASYNC
#include <sys/file.h>

// for struct timeval
#include <sys/time.h>

// threading
#include <pthread.h>


// liqbase
#include <liqbase/liqbase.h>
#include <liqbase/liqcell.h>
#include <liqbase/liqcell_prop.h>
#include <liqbase/liqcell_easyrun.h>
#include <liqbase/liqcell_easyhandler.h>
#include <liqbase/liqcell_mk_star.h>

// signals
#include <signal.h>

#define DEBUG 0

// monitor raw text protocol
#define MSG_DELIMIT '\n' // note: Windows uses '\r\n' :: UNIX and OSX uses '\n' ...for newlines 
#define CMD_DELIMIT ':'
#define NUM_PROTOCOL_FIELDS 30 // e.g. "UPTIME 1482482\n"

#define SYS "SYSTEM"
#define PROCS "PROCS"
#define CPU "CPU"
#define MEM "MEMORY"

#define ERROR_DATA_RETURN "N/A" // display this to the user when a certain piece of data can't be gathered

// app config
#define APP_NAME "Moncells"
#define APP_VERSION "0.1"
#define APP_DESCRIPT "Use Monitor Cells to connect to machines and monitor system information."
#define APP_AUTHOR "zachhabersang@gmail.com"

#define APP_DIR "/usr/share/liqbase/moncells/"

// titlebar
#define MONITOR_TITLEBAR_HEIGHT 100
#define MONITOR_TITLEBAR_CAPTION "Moncells :: System Monitoring Cells"



#define MON_UNIVERSE_BG APP_DIR "media/monitor_borg_bg.jpg"
#define MONCELL_BG APP_DIR "media/moncell-bg.jpg"

// hostnames
#define HOSTNAME_FILE "/usr/share/liqbase/moncells/hostnames.conf"

//
// config
//
#define MAXPENDING 16
#define PORT 31427

#define MAXSENDSIZE 1024

#define INTERVAL_OF_DATA_UPDATES 5

#define RCVSIZE 512

#define LOCALHOST "127.0.0.1"

#define CLIENT_CONNECT_TIMEOUT_SECONDS 5

// colors
#define  BLACK    "rgb(0,0,0)"
#define  WHITE    "rgb(255,255,255)"
#define  RED      "rgb(210,0,0)"
#define  GREEN    "rgb(0,173,0)"
#define  BLUE     "rgb(0,0,255)"
#define  YELLOW   "rgb(225,225,0)"
#define  CYAN     "rgb(0,175,175)"
#define  MAGENTA  "rgb(255,0,255)"
#define  DARK     "rgb(24,24,24)"

//
// protos
//

int ClntDieWithError(char *errorMsg);
char *NonFatalSysError();
int autoconnect_hostnames(liqcell *self);
void Monitor_Cell_Init(liqcell *self, char *hostname);  // needed by ipbar.c

#endif
