/**
 * @file	moncell.h
 * @author  Zach Habersang
 * @brief 	Network Monitor Client General Includes
 *
 * Copyright (C) 2008 Zach Habersang
 *
 * @section LICENSE
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#ifndef _MONCELL_H_
#define _MONCELL_ 1


typedef struct _Moncell_SYS Moncell_SYS;
struct _Moncell_SYS
{
	liqcell *body;

	liqcell *uptime;

	liqcell *sysname;  // Linux
	liqcell *nodename; // Nokia-N810-43-7
	liqcell *release;  // 2.6.21-omap1
	liqcell *version;  // #2 Tue Oct 14 11:25:25 EEST 2008
	liqcell *machine;  // armv6l
};

typedef struct _Moncell_CPU Moncell_CPU;
struct _Moncell_CPU
{
	liqcell *body;
	liqcell *usage_graph;

	liqcell *load;
	liqcell *freq;
	liqcell *cpu_usage; // put freq in this caption
	liqcell *cpu_count;
	
	/*
	float loadavg[3];
	float cpu_usage;
	unsigned int cpu_count;
	float freq;
	*/
	
	liqcell *name; // Intel Core 2 Duo P8700
};

typedef struct _Moncell_PROC Moncell_PROC;
struct _Moncell_PROC
{
	liqcell *body;
	
	liqcell *procs;
	liqcell *run_procs;

	/*
	unsigned short procs;
	unsigned short run_procs;
	*/
	
	// top
	liqcell *top1;
	liqcell *top2;
	liqcell *top3;
	liqcell *top4;
	liqcell *top5;
};

typedef struct _Moncell_MEM Moncell_MEM;
struct _Moncell_MEM
{
	liqcell *body;
	
	liqcell *ram_usage_graph;
	liqcell *ram_stat;
	liqcell *ram_usage;
	
	/*
	unsigned long long mem_used;
	unsigned long long mem_max;
	int mem_usage;
	*/

	liqcell *swap_usage_graph;
	liqcell *swap_stat;
	liqcell *swap_usage;
	
	/*
	unsigned long long swap_used;
	unsigned long long swap_max;
	int swap_usage;
	*/
};

// Structure of arguements to pass to thread
struct Mon_App_Args
{	
	// holds all the data below
	liqcell *body;

	// general sys data
	Moncell_SYS  sys;
	Moncell_CPU  cpu;
	Moncell_PROC proc;
	Moncell_MEM  mem;
	
	// hostname moncell is connected to
	char *hostname;
	
	// set this flag after init moncell
	int isInit;
};


// Structure of arguements to pass to thread
struct ThreadArgs
{
	int socket;
	liqcell *body;
	char *hostname;
};

liqcell* Monitor_App_Create();
void Monitor_Updata_Data(char MonArgs[NUM_PROTOCOL_FIELDS][MAXSENDSIZE], struct Mon_App_Args *Monitor_Data);
void Init_Monitor_Data(struct Mon_App_Args *Monitor_Data);
void moncell_update_sys(struct Mon_App_Args *mon, char MonArgs[NUM_PROTOCOL_FIELDS][MAXSENDSIZE]);
void moncell_sys_init(struct Mon_App_Args *mon);
void moncell_cpu_init(struct Mon_App_Args *mon);
void moncell_update_cpu(struct Mon_App_Args *mon, char MonArgs[NUM_PROTOCOL_FIELDS][MAXSENDSIZE]);
void moncell_update_mem(struct Mon_App_Args *mon, char MonArgs[NUM_PROTOCOL_FIELDS][MAXSENDSIZE]);
void moncell_mem_init(struct Mon_App_Args *mon);
void moncell_procs_init(struct Mon_App_Args *mon);
void moncell_update_procs(struct Mon_App_Args *mon, char MonArgs[NUM_PROTOCOL_FIELDS][MAXSENDSIZE]);
liqcell *moncell_create();
static moncell_shown(liqcell *self, liqcelleventargs *args, void *context);
int SocketShutdown(char *errorMsg, int socket);
int Moncell_Client_Thread(char *hostname, liqcell *body, int servsock);
void *ClientThreadMain(void *threadArgs);
void Recv_From_Server(int sock, liqcell *body, char *hostname);
void Parse_Monitor_Data(char recvBuf[], struct Mon_App_Args *Monitor_Data);

liqfont *font;
int font_h;

liqfont *lfont;
int lfont_h;

liqfont *xlfont;
int xlfont_h;

liqfont *xxlfont;
int xxlfont_h;



#endif
