/**
 * @file	ipbar.c
 * @author  Zach Habersang
 * @brief 	IP Address Input Bar
 *
 * Copyright (C) 2008 Zach Habersang
 *
 * @section LICENSE
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

#include "moncells.h"


liqcell *ipbar_create();

static int widget_click(liqcell *self, liqcellclickeventargs *args)
{
	liqcell *dialog=liqcell_getcontent(self);
	liqcell_easyrun(dialog);
	liqcell_setvisible(dialog,1);
	//args->newdialogtoopen = liqcell_getcontent(self);
	return 1;
}

/**	Ip Submit Button Action */	
static int ip_submit_click(liqcell *self, liqcelleventargs *args, liqcell *ipbar)
{
	// get ip
	liqcell *ip_textbox = liqcell_child_lookup(ipbar, "ip_textbox");
	char *ip_addr = liqcell_getcaption(ip_textbox);
	
	// create new monitor cell
	liqcell *zachmon = liqcell_getlinkparent(ipbar);
	Monitor_Cell_Init(zachmon, ip_addr);

	return 1;
}

/**	Creat an IP Address Input Bar */
liqcell *ipbar_create()
{
	liqcell *self = liqcell_quickcreatewidget("ipbar", "form", 600, 50);
	
	// exit if fail create
	if(!self)
	{
		liqapp_log("liqcell error not create 'ipbar'"); 
		return NULL;
	}
	
	
	// create label: Enter IP Address:
	liqcell *ip_label = liqcell_quickcreatevis("ip_label", "label", 20, 7, 200, 36);
	liqcell_setfont(ip_label, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (22), 0));
	liqcell_setcaption(ip_label, "Quick Connect:");
	liqcell_propsets(ip_label, "textcolor", CYAN); //liqcell_propsets(ip_label, "backcolor", "rgb(0,0,0)");
	liqcell_propseti(ip_label, "textalign", 1);
	liqcell_child_append(self, ip_label);
	
	
	// create textbox
	liqcell *ip_textbox = liqcell_quickcreatevis("ip_textbox", "textbox", 226, 7, 200, 36);
	liqcell_setfont(ip_textbox, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (22), 0) );
	liqcell_setcaption(ip_textbox, "");
	liqcell_propsets(ip_textbox, "textcolor", WHITE);
	liqcell_propsets(ip_textbox, "backcolor", BLACK);
	liqcell_propsets(ip_textbox, "bordercolor", CYAN);
	liqcell_propseti(ip_textbox, "textalign", 0);
	liqcell_propseti(ip_textbox, "textaligny", 2);
	liqcell_child_append(self, ip_textbox);
	
	/*
	
	// add vkbd
	liqcell *vkbd = liqcell_quickcreatevis("vkbd", "liqkeyboard", 0, 0, 0, 0);
	liqcell_setdata(vkbd, ip_textbox);
	
	
	liqcell *wrap = liqcell_quickcreatevis("vkbd_wrap" ,NULL, 425, 7, 32, 32);
	liqcell_handleradd(wrap, "click", widget_click);
	liqcell_setfont(wrap, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (24), 0));
	liqcell_setcaption(wrap, "");
	liqcell_propsets(wrap, "backcolor", CYAN);
	liqcell_propsets(wrap, "textcolor", BLACK);
	liqcell_propseti(wrap, "textalign", 2);
	liqcell_propseti(wrap, "textaligny", 2);
	liqcell_setcontent(wrap, vkbd);
	liqcell_propseti(wrap, "lockaspect", 1);
	liqcell_child_append(self, wrap);
	
	*/
	
	// create buttom: Submit
	liqcell *ip_submit = liqcell_quickcreatevis("ip_submit", "commandbutton", 460, 7, 76, 32);
	liqcell_setfont(ip_submit, liqfont_cache_getttf("/usr/share/fonts/nokia/nosnb.ttf", (22), 0) );
	liqcell_setcaption(ip_submit, "Submit");
	liqcell_propsets(ip_submit, "textcolor", CYAN);
	liqcell_propsets(ip_submit, "backcolor", BLACK);
	liqcell_handleradd_withcontext(ip_submit, "click", ip_submit_click, self);
	liqcell_propseti(ip_submit, "textalign", 1);
	liqcell_child_append(self, ip_submit);
	
	
	
	
	
	return self;
}
