#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import dateutil
import time
import uuid
import commands,os
import sqlite
import sqlite3
import pango
import hashlib          
import StringIO
import html2text
DB_FORMAT = '%Y-%m-%d'
FRAMEWORK_VERSION = '0.3.2' 
HOME_PATH = os.path.expanduser("~")
DB_PATH = HOME_PATH + '/.mPIM/mnotes.db'
DB_IMG_FOLDER = HOME_PATH + '/.mPIM/mnotes_img/'

class Database:
        def __init__(self,path=None):
          self.db = None
          self.cursor = None
          if path != None:
            self.path = path
          else:
            self.path = DB_PATH
          try:
            self.db = sqlite3.connect(self.path)
            self.db.text_factory = str
            self.cursor = self.db.cursor()
            try:
              self._update()
            except:
              pass
          except StandardError, e:
            print e
            print 'Database doesn t exist'
            self._create()

        def _create(self):
          #Try to create the folder in case of
          commands.getoutput("mkdir "+HOME_PATH +"/.mPIM/")
          self.db = sqlite3.connect(self.path)
          self.cursor = self.db.cursor()
          self.cursor.execute('CREATE TABLE notes (uuid TEXT PRIMARY KEY, title DATETIME, description TEXT,type INTEGER,google_id TEXT, google_last_update TEXT)')
          self.db.commit()
          self.cursor.execute('CREATE TABLE db_struct (version TEXT);')
          self.db.commit()
          self.cursor.execute('INSERT INTO db_struct (version) VALUES ("'+FRAMEWORK_VERSION+'");')
          self.db.commit()
          self.cursor.execute('CREATE TABLE prefs (uuid TEXT PRIMARY KEY, value TEXT)')
          self.db.commit()

        def _update(self):
          self.cursor.execute('SELECT version From db_struct;')
          for version in self.cursor.fetchall():
            v = version
          version = v[0]

          try:
            if version < '0.1.0':
              self._create()
            if version < '0.1.1':
              self.cursor.execute('CREATE TABLE prefs (uuid TEXT PRIMARY KEY, value TEXT)')
              self.db.commit()
            if version < '0.1.3':
#              self.cursor.execute('ALTER TABLE notes ADD COLUMN photo BINARY')
#              self.cursor.execute('ALTER TABLE notes ADD COLUMN draw BINARY')
              self.db.commit()
            if version < '0.2.7':
                self.cursor.execute('ALTER TABLE notes ADD COLUMN type INTEGER')
                self.db.commit()
            if version < '0.3.1':
                self.cursor.execute('ALTER TABLE notes ADD COLUMN google_id TEXT')
                self.db.commit()
                self.cursor.execute('ALTER TABLE notes ADD COLUMN google_last_update TEXT')
                self.db.commit()
            if version < '0.3.2':
                self.cursor.execute('ALTER TABLE notes ADD COLUMN google_last_update TEXT')
                self.db.commit()

          except:
            pass

          if version != FRAMEWORK_VERSION:
            self.cursor.execute('UPDATE db_struct set version=?',[FRAMEWORK_VERSION,])
            self.db.commit()

        def close(self):
          self.db.close()

class mPrefs:
       def __init__(self):
           self.hpane_position = None
           self.google_login = None
           self.google_password = None
           self.load_from_db()

       def load_from_db(self):
           db = Database(DB_PATH)
           db.cursor.execute('SELECT uuid, value FROM prefs')
           for prefs in db.cursor.fetchall():
             if (prefs[0]=='hpane_position'):
               self.hpane_position=int(prefs[1])
             if (prefs[0]=='google_login'):
               self.google_login=prefs[1]
             if (prefs[0]=='google_password'):
               self.google_password=prefs[1]
           db.close()

           if self.hpane_position==None:
             self.save_to_db()

       def save_to_db(self):
           db = Database(DB_PATH)           
           if self.hpane_position==None:
             self.hpane_position=150
             db.cursor.execute('INSERT INTO prefs (uuid , value) VALUES (?,?);',['hpane_position',150])
             db.db.commit()
           else:
             db.cursor.execute('UPDATE prefs SET value=? WHERE uuid=?;',[self.hpane_position,'hpane_position'])
             db.db.commit()

           if self.google_login == None:
             self.google_login = ''
             db.cursor.execute('INSERT INTO prefs (uuid , value) VALUES (?,?);',['google_login',''])
             db.db.commit()
           else:
             db.cursor.execute('UPDATE prefs SET value=? WHERE uuid=?;',[self.google_login,'google_login'])
             db.db.commit()

           if self.google_password==None:
             self.google_password = ''
             db.cursor.execute('INSERT INTO prefs (uuid , value) VALUES (?,?);',['google_password',''])
             db.db.commit()
           else:
             db.cursor.execute('UPDATE prefs SET value=? WHERE uuid=?;',[self.google_password,'google_password'])
             db.db.commit()

           db.close()

class Note:
        """This class represents one note"""

        def __init__(self,suuid='',default_title='Untitled'):

            self.title = default_title
            self.description = ''
            self.crypted = False
            self.have_photo = False
            self.have_draw = False
            self.google_id = ''
            self.google_last_update = '1974-01-01T01:01:01.000Z' #google date format

            #0 -> Text
            #1  -> Draw
            #2 ->  Image
            self.type = 0

            if suuid=='':
              self.uuid = uuid.uuid4().__str__()
              self.new = True
            else:
              self.uuid = suuid
              self.load_from_db(self.uuid)
              self.new = False

        def test_have_photo(self):
          if os.path.exists(self.get_photo_path())==False:
            self.have_photo = False
          else:
            self.have_photo=True

        def test_have_draw(self):
          if os.path.exists(self.get_draw_path())==False:
            self.have_draw = False
          else:
            self.have_draw =True

        def get_photo_path(self):
          if os.path.exists(DB_IMG_FOLDER)==False:
            commands.getoutput("mkdir " + DB_IMG_FOLDER)
          return DB_IMG_FOLDER+'photos_'+self.uuid+'.jpg'
        def get_draw_path(self):
          if os.path.exists(DB_IMG_FOLDER)==False:
            commands.getoutput("mkdir " + DB_IMG_FOLDER)
          return DB_IMG_FOLDER+'draw_'+self.uuid+'.jpg'

        def load_from_db(self,suuid):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT title, description,type,google_id,google_last_update FROM notes where uuid="'+suuid+'"')
            for note in db.cursor.fetchall():
              self.description = note[1]
              self.title = note[0]
              self.new = False
              if note[2] != None:
                self.type = int(note[2])
              else:
                self.type = 0
              if note[3] != None:
                self.google_id = note[3]
              if note[4] != None:
                self.google_last_update = note[4]
            self.test_have_draw()
            self.test_have_photo()
            db.close()

        def load_from_google_id(self,google_id):
            db = Database(DB_PATH)
            db.cursor.execute('SELECT uuid FROM notes where google_id="'+google_id+'"')
            uuid = ''
            for note in db.cursor.fetchall():
              uuid = note[0]
            db.close()
            if uuid != '':
              self.load_from_db(uuid)

        def save_to_db(self):
            #if self.crypted == False:
              #self.title = self.description.split('\n')[0]
            self.google_updated = ((datetime.datetime.now().replace(tzinfo=dateutil.tz.tzlocal())).astimezone(dateutil.tz.tzutc())).strftime('%Y-%m-%dT%H:%M:%S.000Z')
            print 'Saved date:'+self.google_updated

            db = Database(DB_PATH)
            if self.new==True:
              db.cursor.execute('INSERT INTO notes (uuid , title, description,type,google_id,google_last_update ) VALUES(?,?,?,?,?,?);',[self.uuid,self.title,self.description,self.type,self.google_id,self.google_last_update])
              db.db.commit()
            else:
              db.cursor.execute('UPDATE notes SET title=?, description=?, type=?,google_id=?,google_last_update=? WHERE uuid=?;',[self.title,self.description,self.type,self.google_id,self.google_last_update,self.uuid])
              db.db.commit()
            db.close()

        def encrypt(self,password):
          digest = hashlib.md5(password).digest()
          krypt = pyDes.triple_des( digest, pyDes.ECB )
          mod = len( self.description ) % 8
          if mod != 0 :
            self.description = self.description + ''.rjust( 8 - mod, '\0' )
          self.description = krypt.encrypt(self.description)
          self.crypted = True

        def get_uncrypted_text(self,password):
          if self.crypted == False:
            return self.description
          else:
            digest = hashlib.md5(password).digest()
            krypt = pyDes.triple_des( digest, pyDes.ECB )
            return str(krypt.decrypt(self.description))

        def decrypt(self,password):
          if self.crypted == True:
            digest = hashlib.md5(password).digest()
            krypt = pyDes.triple_des( digest, pyDes.ECB )
            self.description = krypt.decrypt(self.description)
            self.crypted = False

        def get_bg_color(self):
          return '#FFFFFF'

        def get_fg_color(self):
          return "#000000"

        def get_style(self):
          return pango.STYLE_NORMAL

        def delete_from_db(self):
            db = Database(DB_PATH)
            if self.google_id == '':
              db.cursor.execute('DELETE FROM notes WHERE uuid ="'+self.uuid + '";')
              db.db.commit()
            else:
              db.cursor.execute('UPDATE notes SET title="DELETED" WHERE uuid =?;',[self.uuid,])
              db.db.commit()
            db.close()

class NotesList:
        def __init__(self):
            self.notes_list = []

        def clear(self):
            self.notes_list = []

        def get_all_notes(self):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM notes  '
            where = ' WHERE title != "DELETED"'
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              note = Note(uuid[0])
              self.notes_list.append((note.title,note.uuid))
            db.close()

            return self.notes_list

        def get_notes_with_text(self,text):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM notes  '
            where = ' WHERE title != "DELETED" AND (description LIKE "%' +text+ '%" OR title LIKE "%' +text+ '%")'
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              note = Note(uuid[0])
              self.notes_list.append((note.title,note.uuid))
            db.close()

            return self.notes_list

        def get_text_only_notes_without_google_id(self):
            db = Database(DB_PATH)

            select = 'SELECT uuid FROM notes  '
            where = ' WHERE google_id = "" and type = 0'
            query = select + where

            db.cursor.execute(query)       
            for uuid in db.cursor.fetchall():
              note = Note(uuid[0])
              self.notes_list.append((note.title,note.uuid))
            db.close()

            return self.notes_list
