#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import datetime
import time
from mnotes_framework import *
import commands
import gdata
import gdata.docs
import gdata.docs.service
import gdata.service
import atom.service
import socket
import urllib
import string
import dateutil
import dateutil.tz
import dateutil.parser

class GSync:
  def __init__(self,login,password):
    self.login = login
    self.password = password
    self.gd_client = None
    self.errors = []

  def get_last_error(self):
    if len(self.errors)!=0:
      return self.errors[len(self.errors)-1]
    else:
      return None

  def convert_local_datetime(self,ldatetime,format=0):
    if format==0:
      return ldatetime.strftime("%Y-%m-%dT%H:%M:%S.000")
    elif format==1:
      return ldatetime.strftime("%Y%m%dT%H%M00")
    elif format==2:
      return ldatetime.strftime("%Y%m%d")

  def parse_google_datetime(self,gdatetime):
    ldatetime = dateutil.parser.parse(gdatetime)
    return ldatetime

  def connect(self):
    try:
      print 'Connecting (Erzatz)...'
      self.gd_client = gdata.docs.service.DocsService()
      self.gd_client.source = 'mNotes ' + FRAMEWORK_VERSION
      self.gd_client.additional_headers['User-Agent'] = 'Nokian95'
      self.gd_client.email = self.login
      self.gd_client.password = self.password
      self.gd_client.ProgrammaticLogin()  
      print 'Connected.'
      return True
    except (StandardError,gdata.service.Error,gdata.service.RequestError,socket.error) ,error:
      import traceback
      trace = str(traceback.print_exc())
      self.errors.append('While connecting to google docs:\n'+str(error) + "\n" + trace)
      return False

  def upload_file(self,file_path, content_type, title=None):
    import gdata
    ms = gdata.MediaSource(file_path = file_path, content_type = content_type)
    entry = self.gd_client.UploadDocument(ms,title)
    return entry

  def upload_note(self,note):
   print 'Try to upload a note ...'
   if (note.google_id == ''):
     note.title = note.title + ' [*]'
   if '[*]' in note.title:
     #Write note to text
     fileHandle = open(note.uuid+'.txt', 'w')
     fileHandle.write(note.description)
     fileHandle.close()
     print 'file:'+note.uuid+'.txt'
     print 'title:'+note.title 
     entry = self.upload_file(note.uuid+'.txt','text/plain',title=note.title)
     note.google_id = entry.id.text.encode('UTF-8')
     note.google_last_updated = entry.updated.text.encode('UTF-8')
     note.save_to_db()
     print '--'
     print 'Entry uploaded:'+entry.title.text.encode('UTF-8')
     print 'Entry id'+entry.id.text.encode('UTF-8')
     print '--'

  def sync_text_new_local(self):
    print 'Looking for never synced note ...'
    notes_uuid_list =  NotesList().get_text_only_notes_without_google_id()
    for (title,uuid) in notes_uuid_list:
      self.upload_note(Note(uuid))

  def sync_text_new_or_updated_on_google(self):
    query = gdata.docs.service.DocumentQuery(categories=['document'])
    feed = self.gd_client.Query(query.ToUri())
    if not feed.entry:
      self.errors.append('No documents found')
    for entry in feed.entry:
      note = Note()
      note.load_from_google_id(entry.id.text.encode('UTF-8'))
      if note.google_id == '':
        note.google_id = entry.id.text.encode('UTF-8')
      print '--'
      print 'title:'+note.title
      print self.parse_google_datetime(note.google_last_update)
      print self.parse_google_datetime(entry.updated.text.encode('UTF-8'))
      print '--'

      if note.title != 'DELETED':
        if self.parse_google_datetime(note.google_last_update)<self.parse_google_datetime(entry.updated.text.encode('UTF-8')):
          note.title = entry.title.text.encode('UTF-8')
          if '[*]' not in note.title:
            note.title = note.title + ' [*]'
          note.description = note.title + '\n'+html2text.html2text(self.gd_client.Get(entry.content.src, converter=str).decode('utf-8'))
          note.type = 0
          note.google_last_update = entry.updated.text.encode('UTF-8')
          note.save_to_db()
        elif self.parse_google_datetime(note.google_last_update)>self.parse_google_datetime(entry.updated.text.encode('UTF-8')):
          self.upload_note(note)
  
  def sync_docs(self):
    if (self.connect()==True):
      self.sync_text_new_or_updated_on_google()
      self.sync_text_new_local()
      if len(self.errors) > 0:
          gcal.last_update = datetime.datetime.now()
          gcal.save_to_db()