#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import sys
import os
import threading

import gobject
import gtk
gtk.gdk.threads_init()
import gtk.glade
import datetime
import mnotes_framework
import pango

try:
  import hildon
except ImportError:
  hildon = None

class mNotes(object):

  __pretty_app_name__ = "mNotes"
  __app_name__ = "mNotes"
  __version__ = "0.2.2"
  __context__ = "net.khertan.mnotes"

  _glade_files = [
    '/usr/lib/mnotes/ui/mnotes.glade',
    #'ui/mnotes.glade',
  ]

  def __init__(self,app,context):
    self._callbackList = None
    self._search_text = None

    for path in mNotes._glade_files:
      if os.path.isfile(path):
        self._widgetTree = gtk.glade.XML(path)
        break
    else:
      #self.display_error_message("Cannot find mcalendar.glade")
#     gtk.main_quit()
      return

    #Get the buffer associated with the number display
    self._window = self._widgetTree.get_widget("window1")

    global hildon
    self._app = None
    self._isFullScreen = False
    if hildon is not None and self._window is gtk.Window:
      warnings.warn("Hildon installed but glade file not updated to work with hildon", UserWarning, 2)
      hildon = None
    elif hildon is not None:
      self._app = app
      self._context = context
      self._window = hildon.Window()
      self._window.hide()
      self._window.set_border_width(0)
      self._widgetTree.get_widget("vbox1").reparent(self._window)
      self._app.add_window(self._window)
      hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow1'),True)
      hildon.hildon_helper_set_thumb_scrollbar(self._widgetTree.get_widget('scrolledwindow2'),True)
      self._window.connect("key-press-event", self._on_key_press)
      self._window.connect("window-state-event", self._on_window_state_change)
    else:
      warnings.warn("No Hildon", UserWarning, 2)

    if hildon is not None:
      self._window.set_title("mNotes")
    else:
      self._window.set_title("%s" % self.__pretty_app_name__)

    self._draw_pencil = self._widgetTree.get_widget("bPencil")
    self._draw_clear = self._widgetTree.get_widget("bClearDraw")
    
    callbackMapping = {
      # EventsList Signal
      "on_Del_clicked": self._delete_note,
      "on_Add_clicked": self._add_note,
      "on_Search_clicked": self._search_note,
      "on_bPick_clicked": self.button_cam,
      "on_bPencil_clicked": self.toggle_draw_button_pencil,
      "on_bClearDraw_clicked": self.toggle_draw_button_clear,
      "on_notebook_switch_page": self._page_changed,

#      "on_Liste_row_activated": self._row_selected,
    }
    self._widgetTree.signal_autoconnect(callbackMapping)

    self._load_hpane_position()

    if self._window:
      self._children_color_bg(self._window)
      self._window.connect("delete-event", self._win_closebox)
      self._window.show_all()      
    
    self._drawview = self._widgetTree.get_widget("DrawView")
    self._drawview.connect("configure_event", self.draw_configure_event)
    self._drawview.set_events(gtk.gdk.EXPOSURE_MASK |
        gtk.gdk.LEAVE_NOTIFY_MASK |
        gtk.gdk.BUTTON_PRESS_MASK |
        gtk.gdk.POINTER_MOTION_MASK |
        gtk.gdk.POINTER_MOTION_HINT_MASK)        
    self._drawview.set_size_request(-1,-1)
    self._drawview.queue_draw()

    self._draw_pencil.set_active(True)
    self._draw_clear.set_active(False)

    self.pixmap = None
#    self.pixmap = gtk.gdk.Pixmap(None, 800, 480)
#    width, height = 720,480
#   self.pixmap = gtk.gdk.Pixmap(self._drawview.window, width, height)

    self._notesList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self._current_note = None
    threading.Thread(target=self._idle_setup).start()

  def _page_changed(self,widget,page,page_num):
    print 'page changed :'+str(page_num)
#    if page_num == 1:
#      self._load_current_note_draw()

  def _load_current_note_draw(self):
    if self._current_note.draw == True:
#      self._drawview.show()
      pixbuf = gtk.gdk.pixbuf_new_from_file(self._current_note.get_draw_path())
      if pixbuf == None:
        pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, False, 8, 600, 400)
      try:
        self._drawview.window.draw_pixbuf(None,pixbuf,0,0,0,0)
        self.pixmap,_ = pixbuf.render_pixmap_and_mask()
        self.pixmap.draw_rectangle(self._drawview.get_style().white_gc, True,0, 0, 600, 400)
        del pixbuf
        self._current_note.draw_loaded = True
      except StandardError,e:
        print e
        self._current_note.draw_loaded = False
        pass
    else:
      self._current_note.draw_loaded = False
      pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, False, 8, 600, 400)
      try:
        self._drawview.window.draw_pixbuf(None,pixbuf,0,0,0,0)
        self.pixmap,_ = pixbuf.render_pixmap_and_mask()
        self.pixmap.draw_rectangle(self._drawview.get_style().white_gc, True,0, 0, 600, 400)
        del pixbuf
        self._current_note.draw_loaded = True
      except StandardError,e:
        print e
        self._current_note.draw_loaded = False
        pass
      
  def _save_current_note(self):
    if self._current_note != None:
      buffer = self._editor.get_buffer()
      start, end = buffer.get_bounds ()      
      self._current_note.description = buffer.get_text(start,end)
      self._current_note.save_to_db()

      if (self._drawview.window != None) and (self._current_note.draw_loaded == True):
        width, height =600,400 #self._drawview.window.get_size ()
        pixbuf = gtk.gdk.Pixbuf (gtk.gdk.COLORSPACE_RGB, 0, 8, width, height)
        pixbuf.get_from_drawable(self._drawview.window, self._drawview.window.get_colormap (),0, 0, 0, 0, width, height)
        pixbuf.save (self._current_note.get_draw_path(), "jpeg")
        del pixbuf 
        
      if (self._current_selection_iter):
        uuid = self._notesList.set_value(self._current_selection_iter, 1,self._current_note.title)

      self.refresh()
      #self._load_noteslist_bg()

  def _row_selected(self,widget,*args):
    selection = self.notesListTree.get_selection()
    model, selection_iter = selection.get_selected()

    if (selection_iter):
      uuid = self._notesList.get_value(selection_iter, 0)
      self._save_current_note()
      self._current_selection_iter = selection_iter
      self._current_note = mnotes_framework.Note(uuid)
      self._editor.get_buffer().set_text(self._current_note.description)
      #Load photo
      if (self._current_note.photo == True) :
        self._photoview.set_from_file(self._current_note.get_photo_path())
      else:
        self._photoview.set_from_stock(gtk.STOCK_MISSING_IMAGE,gtk.STATE_NORMAL)
      #load draw here only when the drawingarea have window so when selected page on the notebook
      if self._widgetTree.get_widget("notebook1").get_current_page()==1:
        self._load_current_note_draw()
      else:
        self._current_note.draw_loaded = False
    return

  def _search_note(self,widget):
    self._search_text = self._widgetTree.get_widget("SearchTexte").get_text()
    self._load_noteslist_bg()

  def _delete_note(self,widget):
    selection = self.notesListTree.get_selection()
    model, selection_iter = selection.get_selected()
    if (selection_iter):
      uuid = self._notesList.get_value(selection_iter, 0)
      note = mnotes_framework.Note(uuid)
      self._notesList.remove(selection_iter)
      note.delete_from_db()
      selection = self.notesListTree.get_selection()
      self.notesListTree.set_cursor(0)
      selection.select_path(0)
      self.refresh()  

  def refresh(self):
    self._pijama_color()

  def _pijama_color(self):
    iter = self._notesList.get_iter_root()
    pij = True
    while(iter):
      if pij == True:
        color = '#E5E5FF'
      else:
        color = '#FFFFFF'
      pij = not pij
      self._notesList.set_value(iter, 3, color)
      iter = self._notesList.iter_next(iter)
    self.notesListTree.queue_draw()

  def _add_note(self,widget):
    self._save_current_note()
    note = mnotes_framework.Note('')
    self._notesList_append(self._notesList,note.uuid,note.title,note.get_fg_color(),note.get_bg_color(),note.get_style())
    note.save_to_db()
    selection = self.notesListTree.get_selection()
    selection.unselect_all()
    selection.select_path(len(self._notesList)-1)
    self.notesListTree.set_cursor(len(self._notesList)-1)
    self.refresh()
    self.notesListTree.queue_draw()

  def _save_hpane_position(self):
    value = self._widgetTree.get_widget("hpaned1").get_position()
    prefs = mnotes_framework.mPrefs()
    prefs.hpane_position = value
    prefs.save_to_db()

  def _load_hpane_position(self):
    value = mnotes_framework.mPrefs().hpane_position
    self._widgetTree.get_widget("hpaned1").set_position(value)

  def _win_closebox(self,widget,data):
    self._save_current_note()
    self._save_hpane_position()
    self._window.destroy()
    gtk.main_quit()
    return False

  def _children_color_bg(self,widget):
    if (type(widget)!=gtk.DrawingArea) and (type(widget)!=gtk.Image) and (type(widget)!=gtk.Label) and (type(widget)!=gtk.TreeView) and (type(widget)!=gtk.VSeparator)  and (type(widget)!=gtk.Entry) and (type(widget)!=gtk.CellView) and (type(widget)!=gtk.Calendar):
      widget.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(60000,60000,60000))
      widget.modify_bg(gtk.STATE_INSENSITIVE,gtk.gdk.Color(60000,60000,60000))
      for child in widget.get_children():
        self._children_color_bg(child)

  def _idle_setup(self):
    """
    If something can be done after the UI loads, push it here so it's not blocking the UI
    """
    gtk.gdk.threads_enter()

    try:
      import osso
    except ImportError:
      osso = None

    self._osso = None
    if osso is not None:
      self._osso = osso.Context(mNotes.__app_name__, mNotes.__version__, False)
    else:
      warnings.warn("No OSSO", UserWarning, 2)

    self._editor = self._widgetTree.get_widget("Editor")
    self._editor.get_buffer().set_text('Welcome to mnotes !')
    self._photoview =self._widgetTree.get_widget("PhotoView")
    self._draw_x,self._draw_y,self._draw_old_x,self._draw_old_y = (0,0,0,0)
    self._draw_mode = 1
    self._draw_same = False
    self._drawview.connect("expose_event", self.draw_expose_event)
    self._drawview.connect("motion_notify_event", self.draw_motion_notify_event)
    self._drawview.connect("button_press_event", self.draw_button_press_event)
    self._draw_pencil.set_active(True)
    self._draw_clear.set_active(False)

    self.notesListTree = self._widgetTree.get_widget("Liste")
    self.notesListTree.set_grid_lines(False)
    self.notesListTree.set_hadjustment(gtk.Adjustment(value=0))
    self.notesListTree.connect("cursor-changed", self._row_selected)
    self.notesListTree.set_model(self._notesList)
#   self.tasksListTree.set_border_width(0)

    titletextrenderer = gtk.CellRendererText()
#    descriptiontextrenderer.set_property('editable' , True)
    titletextrenderer.set_property('background-set' , True)
    titletextrenderer.set_property('foreground-set' , True)
    titletextrenderer.set_property('wrap-mode' , pango.WRAP_CHAR)
    titletextrenderer.set_property('style' , True)
    titletextrenderer.set_property('height' , 50)
#    descriptiontextrenderer.connect('edited', self.edited_cell_cb, (self._tasksList, 4))
    column_title = gtk.TreeViewColumn("Title", titletextrenderer, text=1)
    column_title.set_spacing(0)
    column_title.add_attribute(titletextrenderer, 'background', 3)
    column_title.add_attribute(titletextrenderer, 'foreground', 2)
    column_title.add_attribute(titletextrenderer, 'style', 4)
    self.notesListTree.append_column(column_title)

    self._notes_loader_process = threading.Thread(target=self._load_noteslist,args=[self._notesList])
    self._notes_loader_process.start()
    gtk.gdk.threads_leave()

    #Menu
    gtk.gdk.threads_enter()
    self.create_menu()
    gtk.gdk.threads_leave()

    return False

  def _on_window_state_change(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.new_window_state & gtk.gdk.WINDOW_STATE_FULLSCREEN:
      self._isFullScreen = True
    else:
      self._isFullScreen = False

  def toggle_draw_button_pencil(self,widget):
    if self._draw_pencil.state==True:
      self._draw_clear.set_active(False)
      self._draw_mode=1
    else:
      self._draw_clear.set_active(True)
      self._draw_mode=0

  def toggle_draw_button_clear(self,widget):
    if self._draw_clear.state==True:
      self._draw_pencil.set_active(False)
      self._draw_mode=0
    else:
      self._draw_pencil.set_active(True)
      self._draw_mode=1

  def draw_expose_event(self,widget, event):
  
    if self._current_note.draw_loaded == False:
      self._load_current_note_draw()
    x, y, width, height = event.area
    gc = widget.get_style().fg_gc[gtk.STATE_NORMAL]
    widget.window.draw_drawable(gc, self.pixmap, x, y, x, y, width, height)
    return False

  def draw_clean(self,widget, x, y):
    x, y = int(x), int(y)
    self.pixmap.draw_rectangle(widget.get_style().white_gc, True,x-5, y-5, 50, 50)
    widget.queue_draw()

  def draw_line(self,widget, oldx,oldy,x, y):
    self.pixmap.draw_line(widget.get_style().black_gc,int(oldx), int(oldy), int(x), int(y))
    widget.queue_draw()

  def draw_button_press_event(self,widget, event):
    if event.button == 1 and self.pixmap != None:
      if self._draw_same == True:
        self._draw_old_x=self._draw_x
        self._draw_old_y=self._draw_y
      self._draw_x=event.x
      self._draw_y=event.y
      if self._draw_same == False:
        self._draw_old_x=self._draw_x
        self._draw_old_y=self._draw_y
      self._draw_same = True
#      if self._draw_same == False:
#        self._draw_old_x=self._draw_x
#       self._draw_old_y=self._draw_y

      if self._draw_mode == 1:
        self.draw_line(widget, self._draw_old_x,self._draw_old_y,self._draw_x,self._draw_y)
      else:
        self.draw_clean(widget,self._draw_x,self._draw_y)
    return True

  def draw_motion_notify_event(self,widget, event):
    if event.is_hint:
      if self._draw_same==True:
        self._draw_old_x= self._draw_x
        self._draw_old_y = self._draw_y
      self._draw_x, self._draw_y, state = event.window.get_pointer()
      if self._draw_same==False:
        self._draw_old_x=self._draw_x
        self._draw_old_y = self._draw_y
    else:
      if self._draw_same==True:
        self._draw_old_x=self._draw_x
        self._draw_old_y=self._draw_y
      self._draw_x = event.x; self._draw_y = event.y
      if self._draw_same==False:
        self._draw_old_x=self._draw_x
        self._draw_old_y=self._draw_y
      state = event.state
    if state & gtk.gdk.BUTTON1_MASK and self.pixmap != None:
      if self._draw_mode==1:
        self.draw_line(widget, self._draw_old_x,self._draw_old_y,self._draw_x, self._draw_y)
      else:
        self.draw_clean(widget, self._draw_x, self._draw_y)
    else:
      self._draw_same = False
    return True

  def draw_configure_event(self,widget, event):
    if self.pixmap == None:
      win = widget.window
#      width, height = win.get_size()  
      width, height = 600,400
      self.pixmap = gtk.gdk.Pixmap(win, width, height)
      self.pixmap.draw_rectangle(widget.get_style().white_gc, True,0, 0, width, height)
    return True

  def _notesList_append(self,notesList,uuid,title, fg_color,bg_color,style):
    notesList.append((uuid,title, fg_color,bg_color,style))

  def _load_noteslist_bg(self):
    self._notesList = gtk.ListStore(gobject.TYPE_STRING, gobject.TYPE_STRING, gobject.TYPE_STRING,gobject.TYPE_STRING,gobject.TYPE_INT)
    self.notesListTree.set_model(self._notesList)
    self._notes_loader_process = threading.Thread(target=self._load_noteslist,args=[self._notesList])
    self._notes_loader_process.start()

  def _load_noteslist(self,notesList):
    gtk.gdk.threads_enter()
    notesList.clear()
    if (self._search_text==None) or (self._search_text==''):
      notes_uuid_list =  mnotes_framework.NotesList().get_all_notes()
    else:
      notes_uuid_list =  mnotes_framework.NotesList().get_notes_with_text(self._search_text)

#    notes_uuid_list =  mnotes_framework.NotesList().get_all_notes()
    notes_uuid_list.sort()
    note = None
    #gtk.gdk.threads_enter()
    for (title,uuid) in notes_uuid_list:
      if self._notesList != notesList:
        return False
      note = mnotes_framework.Note(uuid)
      self._notesList_append(notesList,note.uuid,note.title,note.get_fg_color(),note.get_bg_color(),note.get_style())

    self._pijama_color()
    self.notesListTree.set_cursor(0)
    gtk.gdk.threads_leave()
    return False

  def click_cam(self):
    gtk.gdk.threads_enter()
    from easy import camera
    camera.click(self._current_note.get_photo_path())
    self._current_note.test_have_photo()
    self._photoview.set_from_file(self._current_note.get_photo_path())
    gtk.gdk.threads_leave()

  def button_cam(self,widget):
    threading.Thread(target=self.cam_switch).start()

  def cam_switch(self):
    from easy import camera
    if camera.is_displaying() == True:
      self.click_cam()
      self.stop_cam()
    else:
      self.start_cam()

  def stop_cam(self):
    gtk.gdk.threads_enter()
    from easy import camera
    camera.stop_display()
    self._widgetTree.get_widget("Photo").hide()
    self._photoview.show()
    gtk.gdk.threads_leave()

  def start_cam(self):
    gtk.gdk.threads_enter()
    from easy import camera
    self._widgetTree.get_widget("Photo").show()
    self._photoview.hide()
#    camera.display(resolution=camera.RESOLUTION_640x480)
#    print type(self._widgetTree.get_widget("drawingarea1").window.xid)
#    self._widgetTree.get_widget("drawingarea1").show()
#    self._widgetTree.get_widget("xwindow").set_size_request(64,48)
    camera.set_window_id(self._widgetTree.get_widget("Photo").window.xid)
#    camera.click("/tmp/mnotes.jpg")
#    camera.display()
    camera.display(resolution=camera.RESOLUTION_320x240)
    gtk.gdk.threads_leave()

  def create_menu(self):
    self.menubar = gtk.Menu ()
    self._window.set_menu(self.menubar)
    accel_group = gtk.AccelGroup ()
    self._window.add_accel_group (accel_group)

    #Separator
    item = gtk.SeparatorMenuItem ()
    item.show ()
    self.menubar.append (item)

    #About
    item = gtk.ImageMenuItem (gtk.STOCK_ABOUT, accel_group)
    item.connect ("activate", self.onAbout)
    item.show ()
    self.menubar.append (item)

  def _on_key_press(self, widget, event, *args):
    """
    @note Hildon specific
    """
    if event.keyval == gtk.keysyms.F6:
      if self._isFullScreen:
        self._window.unfullscreen()
      else:
        self._window.fullscreen()

  def onAbout(self, widget):
    dialog = gtk.AboutDialog()
    dialog.set_name(self.__pretty_app_name__)
    dialog.set_logo_icon_name('mnotes64')
    dialog.set_authors(("Benoit HERVIER (Khertan)","","Thanks to :","",""))
    dialog.set_comments('a PIM Notes for Maemo')
    dialog.set_version(self.__version__)
    dialog.set_license("This program is free software; you can redistribute it and/or\nmodify it under the terms of the GNU General Public License\nas published by the Free Software Foundation; either version 2\nof the License, or (at your option) any later version.")
    dialog.set_copyright("By Benoit HERVIER (aka Khertan)")
    dialog.set_website("http://khertan.net/")
    dialog.connect ("response", lambda d, r: d.destroy())
    dialog.show()

def run_mnotes(app,context):
  gtk.gdk.threads_init()
  if hildon is not None:
    gtk.set_application_name(mNotes.__pretty_app_name__)
  handle = mNotes(app,context)
  gtk.main()

if __name__ == "__main__":
  run_mnotes(hildon.Program(),None)