#!/usr/bin/python -tt
# vim: sw=4 ts=4 expandtab ai
#
# Mnemosyne. Learning tool based on spaced repetition technique
#
# Copyright (C) 2008 Pomni Development Team <pomni@googlegroups.com>
#
# This program is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License version 2 as published by the
# Free Software Foundation.
#
# This program is distributed in the hope that it will be useful, but WITHOUT
# ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
# FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
# details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
# 02110-1301 USA
#

"""
Hildon UI. Statistics widget.
"""

import gtk
import mnemosyne.maemo_ui.widgets.common as widgets

def create_statistics_ui(main_switcher):
    """Creates MaemoStatisticsWidget UI."""

    toplevel_table = gtk.Table(rows=1, columns=2)
    toolbar_container = widgets.create_toolbar_container('toolbar_container')
    toolbar_table = gtk.Table(rows=5, columns=1, homogeneous=True)
    # create toolbar buttons
    current_card_button = widgets.create_radio_button(None, \
        'stat_toolbar_current_card_button', None, width=80, height=80)
    common_button = widgets.create_radio_button(current_card_button, \
        'stat_toolbar_common_stat_button', None, width=80, height=80)
    tags_button = widgets.create_radio_button(common_button, \
        'stat_toolbar_tags_stat_button', None, width=80, height=80)
    menu_button = widgets.create_button('main_menu_button', None)
    # packing toolbar buttons
    toolbar_table.attach(current_card_button,  0, 1, 0, 1, \
        xoptions=gtk.SHRINK, yoptions=gtk.EXPAND)
    toolbar_table.attach(common_button, 0, 1, 1, 2, \
        xoptions=gtk.SHRINK, yoptions=gtk.EXPAND)
    toolbar_table.attach(tags_button, 0, 1, 2, 3, \
        xoptions=gtk.SHRINK, yoptions=gtk.EXPAND)
    toolbar_table.attach(menu_button, 0, 1, 4, 5, \
        xoptions=gtk.SHRINK, yoptions=gtk.EXPAND)
    toolbar_container.add(toolbar_table)
    toplevel_table.attach(toolbar_container, 0, 1, 0, 1, \
        xoptions=gtk.SHRINK, yoptions=gtk.SHRINK|gtk.EXPAND|gtk.FILL)
    # create stats widgets
    stats_table = gtk.Table(rows=1, columns=1, homogeneous=False)
    stats_frame = gtk.Frame()
    stats_frame.set_name('html_container')
    stats_eventbox = gtk.EventBox()
    stats_eventbox.set_visible_window(True)
    stats_eventbox.set_name('viewport_widget')
    stats_scrolledwindow = gtk.ScrolledWindow()
    stats_scrolledwindow.set_policy(gtk.POLICY_AUTOMATIC, \
        gtk.POLICY_AUTOMATIC)
    stats_scrolledwindow.set_name('scrolled_window')
    stats_html = widgets.create_gtkhtml()
    # packing widgets
    stats_table.attach(stats_frame, 0, 1, 0, 1, \
        xoptions=gtk.SHRINK|gtk.EXPAND|gtk.FILL, \
        yoptions=gtk.SHRINK|gtk.EXPAND|gtk.FILL, \
        xpadding=30, ypadding=30)
    stats_scrolledwindow.add(stats_html)
    stats_eventbox.add(stats_scrolledwindow)
    stats_frame.add(stats_eventbox)
    toplevel_table.attach(stats_table, 1, 2, 0, 1, \
        xoptions=gtk.SHRINK|gtk.EXPAND|gtk.FILL, \
        yoptions=gtk.SHRINK|gtk.EXPAND|gtk.FILL)
    toplevel_table.show_all()
    return main_switcher.append_page(toplevel_table), stats_html, \
        menu_button, current_card_button, common_button, tags_button
