/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */
#ifndef MILEAGEFILE_H
#define MILEAGEFILE_H


extern int
returnCars(char **car_array);
extern GSList *
returnCarFiles();
extern GSList *
returnMileEntries(char *car);
extern int
searchForCar(const char *carname);
extern int
createNewCar(const char *carname);
extern void
addMileEntry(char *car, char *str, int previous);
extern void
deleteCar(const char *carname);
extern void
deleteEntry(char *car, char *mileage);
extern void
deleteActivityAlertEntry(char *car, char *date, char *mileage, char *activity, int entry);
extern void
deleteTripEntry(char *car, char *start_odo);
extern FILE *
openCarFile(char *car);
extern void
openCarDir(GString *path);
extern void
createCarName(const char *car, GString *path_to_car);
extern void
addActivityEntry(char *car, char *date_str, char *odo_str, char *act_str, char *comment_str, char *cost_str);
extern void
addAlertEntry(char *car, char *odo_str, char *repeat, char *act_str, char *comment_str);
extern void
addTripEntry(char *car, char *start_date, char *start_odo, char *end_date, char *end_odo,
             char *person_str, char *dest_text, char *purpose_text);
extern GSList *
getNextAlert(char *car, int delta);
extern GSList *
returnActivityEntries(char *car);
extern GSList *
returnAlertEntries(char *car);
extern GSList *
returnTripEntries(char *car);
extern int
returnEntryUnits(char *car);
extern void
addEntryUnits(char *car, int units);


#define CAR_DATA_DIR  "MyDocs/mileage/"

#endif
