/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */

#include <stdlib.h>
#include <string.h>

#include <gtk/gtk.h>

#include "common_tab.h"
#include "care_tab.h"
#include "entry_tab.h"
#include "mileagefile.h"

#define NUM_BUTTON_SIZE 35
#define BIG_NUM_BUTTON_SIZE 45


static GtkWidget *car_selector = NULL;
static GtkWidget  *table1 = NULL;
static int        car_inserted = FALSE;
static GtkWidget  *date_label = NULL;
static GtkWidget  *date_text = NULL;
static GtkWidget  *repeat_label = NULL;
static GtkWidget  *repeat_text = NULL;
static GtkWidget  *alert_but = NULL;
static GtkWidget  *odo_text = NULL;
static GtkWidget  *activity_text = NULL;
static GtkWidget  *cost_label = NULL;
static GtkWidget  *cost_text = NULL;
static GtkWidget  *comment_text = NULL;
static GtkWidget *cur_selected_text = NULL;
static GtkWidget *button0, *button1, *button2, *button3, *button4, *button5, *button6, *button7, *button8, *button9, *buttondot, *buttonslash;

static void car_selector_clicked_cb(GtkWidget* w, gpointer data);
static void care_save_clicked_cb(GtkWidget* w, gpointer data);
static void care_button_clicked_cb(GtkWidget* w, gpointer data);
static void care_key_press_clicked_cb(GtkWidget* w, gpointer data);
static gboolean text_clicked_cb(GtkWidget* w, gpointer data);
static void care_backspace_clicked_cb(GtkWidget* w, gpointer data);

void care_tab_layout(GtkWidget *window)
{
   GtkWidget *vboxl;
   GtkWidget *vboxr;
   GtkWidget *vsep;
   GtkWidget  *activity_but;
   GtkWidget  *label2, *label4, *label5;
   GtkWidget  *button;
   GtkWidget *buttona, *buttonb;
   GtkTable  *table2;


   vboxl = gtk_vbox_new(FALSE, 10);
   gtk_container_add(GTK_CONTAINER(window), vboxl);

   vsep = gtk_vseparator_new();
   gtk_container_add(GTK_CONTAINER(window), vsep);

   vboxr = gtk_vbox_new(FALSE, 10);
   gtk_container_add(GTK_CONTAINER(window), vboxr);


   table1 = gtk_table_new(9,9,FALSE);
   gtk_container_add(GTK_CONTAINER(vboxl), (GtkWidget *)table1);

   car_selector = gtk_combo_box_new_text();
   gtk_table_attach(GTK_TABLE(table1), car_selector, 3, 7, 0, 1, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_signal_connect(GTK_OBJECT(car_selector),
                     "changed",
                     GTK_SIGNAL_FUNC(car_selector_clicked_cb),
                     car_selector);

   alert_but = gtk_radio_button_new_with_label(NULL, "Alerts");
   gtk_table_attach(GTK_TABLE(table1), alert_but, 0, 4, 1, 2, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_signal_connect(GTK_OBJECT(alert_but),
                     "toggled",
                     GTK_SIGNAL_FUNC(care_button_clicked_cb),
                     car_selector);

   activity_but = gtk_radio_button_new_with_label_from_widget(GTK_RADIO_BUTTON(alert_but), "Activity");
   gtk_table_attach(GTK_TABLE(table1), activity_but, 5, 9, 1, 2, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(activity_but), TRUE);

   date_label = gtk_label_new("Date YYYY/MM/DD");
   gtk_table_attach(GTK_TABLE(table1), date_label, 0, 4, 2, 3, GTK_FILL, GTK_SHRINK, 2, 2);

   date_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(date_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     date_text);
   gtk_table_attach(GTK_TABLE(table1), date_text, 5, 9, 2, 3, GTK_FILL, GTK_SHRINK, 2, 2);

   label2 = gtk_label_new("Odometer");
   gtk_table_attach(GTK_TABLE(table1), label2, 0, 4, 3, 4, GTK_FILL, GTK_SHRINK, 2, 2);

   odo_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(odo_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     odo_text);
   gtk_table_attach(GTK_TABLE(table1), odo_text, 5, 9, 3, 4, GTK_FILL, GTK_SHRINK, 2, 2);

   repeat_label = gtk_label_new("Repeat Every");
   gtk_table_attach(GTK_TABLE(table1), repeat_label, 0, 4, 4, 5, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_widget_set_sensitive(GTK_WIDGET(repeat_label), FALSE);

   repeat_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(repeat_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     repeat_text);
   gtk_table_attach(GTK_TABLE(table1), repeat_text, 5, 9, 4, 5, GTK_FILL, GTK_SHRINK, 2, 2);
   gtk_widget_set_sensitive(GTK_WIDGET(repeat_text), FALSE);

   label4 = gtk_label_new("Activity");
   gtk_table_attach(GTK_TABLE(table1), label4, 0, 4, 5, 6, GTK_FILL, GTK_SHRINK, 2, 2);

   activity_text = gtk_entry_new_with_max_length(25);
   gtk_signal_connect(GTK_OBJECT(activity_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     activity_text);
   gtk_table_attach(GTK_TABLE(table1), activity_text, 5, 9, 5, 6, GTK_FILL, GTK_SHRINK, 2, 2);

   cost_label = gtk_label_new("Cost");
   gtk_table_attach(GTK_TABLE(table1), cost_label, 0, 4, 6, 7, GTK_FILL, GTK_SHRINK, 2, 2);

   cost_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(cost_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     cost_text);
   gtk_table_attach(GTK_TABLE(table1), cost_text, 5, 9, 6, 7, GTK_FILL, GTK_SHRINK, 2, 2);

   label5 = gtk_label_new("Comment");
   gtk_table_attach(GTK_TABLE(table1), label5, 0, 3, 7, 8, GTK_FILL, GTK_SHRINK, 2, 2);

   comment_text = gtk_entry_new_with_max_length(60);
   gtk_signal_connect(GTK_OBJECT(comment_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     comment_text);
   gtk_table_attach(GTK_TABLE(table1), comment_text, 3, 9, 7, 8, GTK_FILL, GTK_SHRINK, 2, 2);

   button = gtk_button_new_with_label("Save");
   gtk_signal_connect(GTK_OBJECT(button),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_save_clicked_cb),
                     NULL);
   gtk_table_attach(GTK_TABLE(table1), button, 3, 6, 8, 9, GTK_FILL, GTK_SHRINK, 2, 2);


   table2 = (GtkTable *)gtk_table_new(5,6,FALSE);
   gtk_container_add(GTK_CONTAINER(vboxr), (GtkWidget *)table2);

   button1 = gtk_button_new_with_label("1");
   gtk_widget_set_size_request(button1, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button1),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "1");
   gtk_table_attach(table2, button1, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button2 = gtk_button_new_with_label("2");
   gtk_widget_set_size_request(button2, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button2),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "2");
   gtk_table_attach(table2, button2, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button3 = gtk_button_new_with_label("3");
   gtk_widget_set_size_request(button3, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button3),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "3");
   gtk_table_attach(table2, button3, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button0 = gtk_button_new_with_label("0");
   gtk_widget_set_size_request(button0, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button0),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "0");
   gtk_table_attach(table2, button0, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button4 = gtk_button_new_with_label("4");
   gtk_widget_set_size_request(button4, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button4),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "4");
   gtk_table_attach(table2, button4, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   button5 = gtk_button_new_with_label("5");
   gtk_widget_set_size_request(button5, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button5),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "5");
   gtk_table_attach(table2, button5, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   button6 = gtk_button_new_with_label("6");
   gtk_widget_set_size_request(button6, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button6),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "6");
   gtk_table_attach(table2, button6, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   buttondot = gtk_button_new_with_label(".");
   gtk_widget_set_size_request(buttondot, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(buttondot),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     ".");
   gtk_table_attach(table2, buttondot, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   button7 = gtk_button_new_with_label("7");
   gtk_widget_set_size_request(button7, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button7),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "7");
   gtk_table_attach(table2, button7, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   button8 = gtk_button_new_with_label("8");
   gtk_widget_set_size_request(button8, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button8),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "8");
   gtk_table_attach(table2, button8, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   button9 = gtk_button_new_with_label("9");
   gtk_widget_set_size_request(button9, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button9),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "9");
   gtk_table_attach(table2, button9, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   buttonslash = gtk_button_new_with_label("/");
   gtk_widget_set_size_request(buttonslash, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(buttonslash),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_key_press_clicked_cb),
                     "/");
   gtk_table_attach(table2, buttonslash, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   buttona = gtk_button_new_with_label("Today's Date");
   gtk_widget_set_size_request(buttona, -1, 30);
   gtk_signal_connect(GTK_OBJECT(buttona),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_today_date_clicked_cb),
                     date_text);
   gtk_table_attach(table2, buttona, 0, 5, 3, 4, GTK_FILL, GTK_FILL, 2, 2);

   buttonb = gtk_button_new_with_label("<-Backspace");
   gtk_widget_set_size_request(buttonb, -1, 30);
   gtk_signal_connect(GTK_OBJECT(buttonb),
                     "clicked",
                     GTK_SIGNAL_FUNC(care_backspace_clicked_cb),
                     "B");
   gtk_table_attach(table2, buttonb, 0, 5, 4, 5, GTK_FILL, GTK_FILL, 2, 2);
}

void
care_tab_load_car(char * car)
{  
   if (car == NULL) 
   {
      gtk_widget_destroy(car_selector);
      car_selector = gtk_combo_box_new_text();
      gtk_table_attach(GTK_TABLE(table1), car_selector, 3, 7, 0, 1, GTK_FILL, GTK_SHRINK, 2, 2);
      gtk_signal_connect(GTK_OBJECT(car_selector),
                     "changed",
                     GTK_SIGNAL_FUNC(car_selector_clicked_cb),
                     car_selector);
      gtk_widget_show_all(car_selector);
      car_inserted = FALSE;
   }
   else
   {
      gtk_combo_box_append_text(GTK_COMBO_BOX(car_selector), car);
      car_inserted = TRUE;
   }
}

GtkWidget *
care_tab_get_car_selector()
{
   return car_selector;
}

int
care_tab_get_car_inserted()
{
   return car_inserted;
}

void
care_tab_update_car_combo_box(int value)
{
   gtk_combo_box_set_active(GTK_COMBO_BOX(car_selector), value);
}

void
car_selector_clicked_cb(GtkWidget* w, gpointer data)
{
   char *car;

   /* Update all combo boxes to the same value */
   common_tab_update_car_combo_box(gtk_combo_box_get_active((GtkComboBox *)car_selector));

   if (data)
   {
      car = gtk_combo_box_get_active_text(data);
      if (car[strlen(car) - 1] == '\n')
      {
         car[strlen(car) - 1] = '\0';
      }

#ifdef DEBUG
      fprintf(stdout, "Car Selector choosen %s.\n", car);
#endif
#if 0
      /* Only called from car_tab */
      common_tab_load_data(car);
#endif

      if (car)
         free(car);
   }
}

void
care_save_clicked_cb(GtkWidget* w, gpointer data)
{
   char *date_str;
   char *odo_str;
   char *repeat_str;
   char *activity_str;
   char *comment_str;
   char *cost_str;
   char *car;
   GtkWidget  *dialog = NULL;

#ifdef DEBUG
      fprintf(stdout, "Save selected\n");
#endif
   date_str = (char *)gtk_entry_get_text(GTK_ENTRY(date_text));
   odo_str = (char *)gtk_entry_get_text(GTK_ENTRY(odo_text));
   repeat_str = (char *)gtk_entry_get_text(GTK_ENTRY(repeat_text));
   activity_str = (char *)gtk_entry_get_text(GTK_ENTRY(activity_text));
   comment_str = (char *)gtk_entry_get_text(GTK_ENTRY(comment_text));
   cost_str = (char *)gtk_entry_get_text(GTK_ENTRY(cost_text));

   /* ALERT saved */
   if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(alert_but)) == TRUE)
   {
      if ((odo_str == NULL) || (atof(odo_str) <= 0.0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Alert not Stored! Invalid odometer.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }
      if ((activity_str == NULL) || (strlen(activity_str) == 0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Alert not Stored! Invalid Activity.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }

      car = gtk_combo_box_get_active_text(GTK_COMBO_BOX(car_selector));
      if (car != NULL)
      {
         if (car[strlen(car) - 1] == '\n')
         {
            car[strlen(car) - 1] = '\0';
         }

         /* IF Repeat String is empty then put in 0 */
         if (strlen(repeat_str) == 0)
            addAlertEntry(car, odo_str, "0", activity_str, comment_str);
         else
            addAlertEntry(car, odo_str, repeat_str, activity_str, comment_str);
         common_tab_updateDisplayTab(car);
         g_free(car);

         /* Clear all entries */
         gtk_entry_set_text(GTK_ENTRY(date_text), "");
         gtk_entry_set_text(GTK_ENTRY(odo_text), "");
         gtk_entry_set_text(GTK_ENTRY(repeat_text), "");
         gtk_entry_set_text(GTK_ENTRY(activity_text), "");
         gtk_entry_set_text(GTK_ENTRY(comment_text), "");
         gtk_entry_set_text(GTK_ENTRY(cost_text), "");
      }
      else
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Alert not Stored! Please create car first.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
      }
   }
   /* ACTIVITY saved */
   else
   {
       if (common_valid_date(date_str) == FALSE)
       {
          dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Invalid date.");
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
          return;
       }
      if ((odo_str == NULL) || (atof(odo_str) <= 0.0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Invalid odometer.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }
      if ((activity_str == NULL) || (strlen(activity_str) == 0))
      {
         dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Invalid Activity.");
         gtk_dialog_run (GTK_DIALOG (dialog));
         gtk_widget_destroy (dialog);
         return;
      }

      car = gtk_combo_box_get_active_text(GTK_COMBO_BOX(car_selector));
      if (car != NULL)
      {
         if (car[strlen(car) - 1] == '\n')
         {
            car[strlen(car) - 1] = '\0';
         }
         addActivityEntry(car, date_str, odo_str, activity_str, comment_str, cost_str);
         common_tab_updateDisplayTab(car);
         g_free(car);

         /* Clear all entries */
         gtk_entry_set_text(GTK_ENTRY(date_text), "");
         gtk_entry_set_text(GTK_ENTRY(odo_text), "");
         gtk_entry_set_text(GTK_ENTRY(repeat_text), "");
         gtk_entry_set_text(GTK_ENTRY(activity_text), "");
         gtk_entry_set_text(GTK_ENTRY(comment_text), "");
         gtk_entry_set_text(GTK_ENTRY(cost_text), "");
      }
      else
      {
          dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Activity not Stored! Please create car first.");
          gtk_dialog_run (GTK_DIALOG (dialog));
          gtk_widget_destroy (dialog);
      }
   }
}

void
care_button_clicked_cb(GtkWidget* w, gpointer data)
{
   /* IF alert button is TRUE */
   if (gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)) == TRUE)
   {
      if (date_label)
         gtk_widget_set_sensitive(GTK_WIDGET(date_label), FALSE);
      if (date_text)
         gtk_widget_set_sensitive(GTK_WIDGET(date_text), FALSE);
      if (repeat_label)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_label), TRUE);
      if (repeat_text)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_text), TRUE);
      if (cost_label)
         gtk_widget_set_sensitive(GTK_WIDGET(cost_label), FALSE);
      if (cost_text)
         gtk_widget_set_sensitive(GTK_WIDGET(cost_text), FALSE);
   }
   else
   {
      if (date_label)
         gtk_widget_set_sensitive(GTK_WIDGET(date_label), TRUE);
      if (date_text)
         gtk_widget_set_sensitive(GTK_WIDGET(date_text), TRUE);
      if (repeat_label)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_label), FALSE);
      if (repeat_text)
         gtk_widget_set_sensitive(GTK_WIDGET(repeat_text), FALSE);
      if (cost_label)
         gtk_widget_set_sensitive(GTK_WIDGET(cost_label), TRUE);
      if (cost_text)
         gtk_widget_set_sensitive(GTK_WIDGET(cost_text), TRUE);
   }
}

void
care_key_press_clicked_cb(GtkWidget* w, gpointer data)
{
   GtkWidget  *dialog;

   if (cur_selected_text != NULL)
      gtk_entry_append_text(GTK_ENTRY(cur_selected_text), data);
   else
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Please select a text field.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
   }
}

gboolean
text_clicked_cb(GtkWidget* w, gpointer data)
{
   /* Save the last selected field so we know what field to edit */
   if (w == date_text)
      cur_selected_text = date_text;
   else if (w == odo_text)
      cur_selected_text = odo_text;
   else if (w == repeat_text)
      cur_selected_text = repeat_text;
   else if (w == activity_text)
      cur_selected_text = activity_text;
   else if (w == comment_text)
      cur_selected_text = comment_text;
   else if (w == cost_text)
      cur_selected_text = cost_text;

   return FALSE;
}

void
care_backspace_clicked_cb(GtkWidget* w, gpointer data)
{
   GtkWidget  *dialog;
   char       *cur_text;
   char        buf[1024];
   int         position;

   /* See if there is a currently selected text item */
   if (cur_selected_text == NULL)
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Please select a text field.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
   }
   else
   {
      /* delete a character from the current position of the currect text item */
      g_object_get(cur_selected_text, "cursor-position", &position, NULL);
      cur_text = (char *)gtk_entry_get_text(GTK_ENTRY(cur_selected_text));
      memset(buf, 0, 1024);
      if (position != 0)
         strncpy(buf, cur_text, position - 1);
      strncat(buf, cur_text + position, strlen(cur_text) - position);
      gtk_entry_set_text(GTK_ENTRY(cur_selected_text), buf);
      /* Set edit position again on this entry so we can backspace again */
      gtk_editable_set_position(GTK_EDITABLE(cur_selected_text), -1);
   }
}
void
care_tab_fullscreen(int fullscreen)
{
   if (fullscreen == 1)
   {
      gtk_widget_set_size_request(button1, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button2, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button3, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button4, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button5, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button6, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button7, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button8, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button9, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button0, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(buttondot, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(buttonslash, BIG_NUM_BUTTON_SIZE, BIG_NUM_BUTTON_SIZE);
   }
   else
   {
      gtk_widget_set_size_request(button1, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button2, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button3, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button4, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button5, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button6, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button7, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button8, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button9, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(button0, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(buttondot, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
      gtk_widget_set_size_request(buttonslash, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   }
}

