/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */


#include <gtk/gtkmain.h>
#include <gtk/gtkbutton.h>
#include <gtk/gtktoolbar.h>
#include <gtk/gtk.h>

#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "entry_tab.h"
#include "common_tab.h"
#include "mileagefile.h"

#define NUM_BUTTON_SIZE 45

static GtkWidget *car_selector;
static GtkWidget *tablel;
static GtkWidget *date_text;
static GtkWidget *odo_text;
static GtkWidget *gal_text;
static GtkWidget *cost_text;
static GtkWidget *cur_selected_text = NULL;
static GtkWidget *previous_but;
static GtkWidget *label3;
static int        car_inserted = FALSE;

static void car_selector_clicked_cb(GtkWidget* w, gpointer data);
static void entry_today_date_clicked_cb(GtkWidget* w, gpointer data);
static void entry_key_press_clicked_cb(GtkWidget* w, gpointer data);
static void entry_backspace_clicked_cb(GtkWidget* w, gpointer data);
static void entry_process_clicked_cb(GtkWidget* w, gpointer data);
static gboolean text_clicked_cb(GtkWidget* w, gpointer data);

void entry_tab_layout(GtkWidget *window)
{
   /* Create needed variables */
   GtkWidget *vboxl;
   GtkWidget *vboxr;
   GtkWidget *vsep;
   GtkWidget *label1, *label2, *label4, *label6;
   GtkTable *table1;
   GtkWidget *button0, *button1, *button2, *button3, *button4, *button5, *button6, *button7, *button8, *button9, *buttondot, *buttonslash;
   GtkWidget *buttona, *buttonb, *buttonc;

   vboxl = gtk_vbox_new(FALSE, 10);
   gtk_container_add(GTK_CONTAINER(window), vboxl);

   vsep = gtk_vseparator_new();
   gtk_container_add(GTK_CONTAINER(window), vsep);

   vboxr = gtk_vbox_new(FALSE, 10);
   gtk_container_add(GTK_CONTAINER(window), vboxr);

   tablel = gtk_table_new(5,6,FALSE);
   gtk_container_add(GTK_CONTAINER(vboxl), tablel);

   car_selector = gtk_combo_box_new_text();
   gtk_table_attach(GTK_TABLE(tablel), car_selector, 0, 4, 0, 1, GTK_FILL, GTK_FILL, 2, 2);
   gtk_signal_connect(GTK_OBJECT(car_selector),
                     "changed",
                     GTK_SIGNAL_FUNC(car_selector_clicked_cb),
                     car_selector);

   label1 = gtk_label_new("Enter New Date\nYYYY/MM/DD");
   gtk_table_attach(GTK_TABLE(tablel), label1, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   date_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(date_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     date_text);
   gtk_table_attach(GTK_TABLE(tablel), date_text, 1, 4, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   label2 = gtk_label_new("Enter Odometer");
   gtk_table_attach(GTK_TABLE(tablel), label2, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   odo_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(odo_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     odo_text);
   gtk_table_attach(GTK_TABLE(tablel), odo_text, 1, 4, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   label3 = gtk_label_new("Enter Gallons");
   gtk_table_attach(GTK_TABLE(tablel), label3, 0, 1, 3, 4, GTK_FILL, GTK_FILL, 2, 2);

   gal_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(gal_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     gal_text);
   gtk_table_attach(GTK_TABLE(tablel), gal_text, 1, 4, 3, 4, GTK_FILL, GTK_FILL, 2, 2);

   label4 = gtk_label_new("Cost");
   gtk_table_attach(GTK_TABLE(tablel), label4, 0, 1, 4, 5, GTK_FILL, GTK_FILL, 2, 2);

   cost_text = gtk_entry_new_with_max_length(15);
   gtk_signal_connect(GTK_OBJECT(cost_text),
                     "button-press-event",
                     GTK_SIGNAL_FUNC(text_clicked_cb),
                     cost_text);
   gtk_table_attach(GTK_TABLE(tablel), cost_text, 1, 4, 4, 5, GTK_FILL, GTK_FILL, 2, 2);

   label6 = gtk_label_new("Check if no Previous Entry");
   gtk_table_attach(GTK_TABLE(tablel), label6, 0, 3, 5, 6, GTK_FILL, GTK_FILL, 2, 2);

   previous_but = gtk_check_button_new();
   gtk_table_attach(GTK_TABLE(tablel), previous_but, 3, 4, 5, 6, GTK_FILL, GTK_FILL, 2, 2);

   table1 = (GtkTable *)gtk_table_new(5,6,FALSE);
   gtk_container_add(GTK_CONTAINER(vboxr), (GtkWidget *)table1);

   button1 = gtk_button_new_with_label("1");
   gtk_widget_set_size_request(button1, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button1),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "1");
   gtk_table_attach(table1, button1, 0, 1, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button2 = gtk_button_new_with_label("2");
   gtk_widget_set_size_request(button2, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button2),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "2");
   gtk_table_attach(table1, button2, 1, 2, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button3 = gtk_button_new_with_label("3");
   gtk_widget_set_size_request(button3, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button3),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "3");
   gtk_table_attach(table1, button3, 2, 3, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button0 = gtk_button_new_with_label("0");
   gtk_widget_set_size_request(button0, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button0),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "0");
   gtk_table_attach(table1, button0, 3, 4, 0, 1, GTK_FILL, GTK_FILL, 2, 2);

   button4 = gtk_button_new_with_label("4");
   gtk_widget_set_size_request(button4, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button4),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "4");
   gtk_table_attach(table1, button4, 0, 1, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   button5 = gtk_button_new_with_label("5");
   gtk_widget_set_size_request(button5, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button5),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "5");
   gtk_table_attach(table1, button5, 1, 2, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   button6 = gtk_button_new_with_label("6");
   gtk_widget_set_size_request(button6, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button6),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "6");
   gtk_table_attach(table1, button6, 2, 3, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   buttondot = gtk_button_new_with_label(".");
   gtk_widget_set_size_request(buttondot, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(buttondot),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     ".");
   gtk_table_attach(table1, buttondot, 3, 4, 1, 2, GTK_FILL, GTK_FILL, 2, 2);

   button7 = gtk_button_new_with_label("7");
   gtk_widget_set_size_request(button7, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button7),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "7");
   gtk_table_attach(table1, button7, 0, 1, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   button8 = gtk_button_new_with_label("8");
   gtk_widget_set_size_request(button8, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button8),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "8");
   gtk_table_attach(table1, button8, 1, 2, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   button9 = gtk_button_new_with_label("9");
   gtk_widget_set_size_request(button9, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(button9),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "9");
   gtk_table_attach(table1, button9, 2, 3, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   buttonslash = gtk_button_new_with_label("/");
   gtk_widget_set_size_request(buttonslash, NUM_BUTTON_SIZE, NUM_BUTTON_SIZE);
   gtk_signal_connect(GTK_OBJECT(buttonslash),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_key_press_clicked_cb),
                     "/");
   gtk_table_attach(table1, buttonslash, 3, 4, 2, 3, GTK_FILL, GTK_FILL, 2, 2);

   buttona = gtk_button_new_with_label("Today's Date");
   gtk_widget_set_size_request(buttona, -1, 30);
   gtk_signal_connect(GTK_OBJECT(buttona),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_today_date_clicked_cb),
                     date_text);
   gtk_table_attach(table1, buttona, 0, 2, 3, 4, GTK_FILL, GTK_FILL, 2, 2);

   buttonb = gtk_button_new_with_label("<-Backspace");
   gtk_widget_set_size_request(buttonb, -1, 30);
   gtk_signal_connect(GTK_OBJECT(buttonb),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_backspace_clicked_cb),
                     "B");
   gtk_table_attach(table1, buttonb, 2, 5, 3, 4, GTK_FILL, GTK_FILL, 2, 2);

   buttonc = gtk_button_new_with_label("Submit Entry");
   gtk_widget_set_size_request(buttonc, -1, 30);
   gtk_signal_connect(GTK_OBJECT(buttonc),
                     "clicked",
                     GTK_SIGNAL_FUNC(entry_process_clicked_cb),
                     NULL);
   gtk_table_attach(table1, buttonc, 0, 5, 4, 5, GTK_FILL, GTK_FILL, 2, 2);
}

void
entry_tab_load_car(char * car)
{
   if (car == NULL)
   {
      gtk_widget_destroy(car_selector);
      car_selector = gtk_combo_box_new_text();
      gtk_table_attach(GTK_TABLE(tablel), car_selector, 0, 4, 0, 1, GTK_FILL, GTK_FILL, 2, 2);
      gtk_signal_connect(GTK_OBJECT(car_selector),
                     "changed",
                     GTK_SIGNAL_FUNC(car_selector_clicked_cb),
                     car_selector);
      gtk_widget_show_all(car_selector);
      car_inserted = FALSE;
   }
   else
   {
      gtk_combo_box_append_text((GtkComboBox *)car_selector, car);
      car_inserted = TRUE;
   }
}

GtkWidget *
entry_tab_get_car_selector()
{  
   return car_selector;
}

int
entry_tab_get_car_inserted()
{
   return car_inserted;
}  

void
entry_tab_update_car_combo_box(int value)
{
   gtk_combo_box_set_active((GtkComboBox *)car_selector, value);
}

void
car_selector_clicked_cb(GtkWidget* w, gpointer data)
{
   char *car;

   /* Update all combo boxes to the same value */
   common_tab_update_car_combo_box(gtk_combo_box_get_active((GtkComboBox *)car_selector));

   if (data)
   {
      car = gtk_combo_box_get_active_text(data);
      if (car[strlen(car) - 1] == '\n')
      {
         car[strlen(car) - 1] = '\0';
      }

#ifdef DEBUG
      fprintf(stdout, "Car Selector choosen %s.\n", car);
#endif
#if 0
      /* Only called once in car_tab.c */
      common_tab_load_data(car);
#endif

      if (car)
         free(car);
   }
}

void
entry_today_date_clicked_cb(GtkWidget* w, gpointer data)
{
   GDate  *date = NULL;
   GDateYear  year;
   GDateMonth month;
   GDateDay   day;
   char       str[512];

#ifdef DEBUG
   fprintf(stdout, "Todays Date\n");
#endif

   date = g_date_new();
   if (date)
   {


      /* IF GLIB 2.10 or later */
      if (GLIB_CHECK_VERSION(2,10,0))
         g_date_set_time_t(date, time(NULL));
      else
         g_date_set_time(date, (GTime)time(NULL));
      year = g_date_get_year(date);
      month= g_date_get_month(date);
      day  = g_date_get_day(date);
      g_date_free(date);
      sprintf(str, "%d/%d/%d", (int)year, (int)month, (int)day);
      gtk_entry_set_text((GtkEntry *)data, str);
   }
}

void
entry_key_press_clicked_cb(GtkWidget* w, gpointer data)
{
   GtkWidget  *dialog;

   if (cur_selected_text == date_text)
      gtk_entry_append_text(GTK_ENTRY(date_text), data);
   else if (cur_selected_text == odo_text)
      gtk_entry_append_text(GTK_ENTRY(odo_text), data);
   else if (cur_selected_text == gal_text)
      gtk_entry_append_text(GTK_ENTRY(gal_text), data);
   else if (cur_selected_text == cost_text)
      gtk_entry_append_text(GTK_ENTRY(cost_text), data);
   else
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Please select a text field.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
   }
}

void
entry_backspace_clicked_cb(GtkWidget* w, gpointer data)
{
   GtkWidget  *dialog;
   char       *cur_text;
   char        buf[1024];
   int         position;

   /* See if there is a currently selected text item */
   if (cur_selected_text == NULL)
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Please select a text field.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
   }
   else
   {
      /* delete a character from the current position of the currect text item */
      g_object_get(cur_selected_text, "cursor-position", &position, NULL);
      cur_text = (char *)gtk_entry_get_text(GTK_ENTRY(cur_selected_text));
      memset(buf, 0, 1024);
      if (position != 0)
         strncpy(buf, cur_text, position - 1);
      strncat(buf, cur_text + position, strlen(cur_text) - position);
      gtk_entry_set_text(GTK_ENTRY(cur_selected_text), buf);
      /* Set edit position again on this entry so we can backspace again */
      gtk_editable_set_position(GTK_EDITABLE(cur_selected_text), -1);
   }
}

void
entry_process_clicked_cb(GtkWidget* w, gpointer data)
{
   char  *odo_str = NULL;
   char  *gal_str = NULL;
   char  *cost_str = NULL;
   GtkWidget  *dialog = NULL;
   char   total_str[1024];
   char  *car = NULL;
   char  *orig_date_str;

   /* Validate the date, odo, fuel, and cost */
   orig_date_str = (char *)gtk_entry_get_text(GTK_ENTRY(date_text));
   if (common_valid_date(orig_date_str) == FALSE)
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Entry not Stored! Invalid date.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      return;
   }

   /* check for a valid odo string */
   odo_str = (char *)gtk_entry_get_text(GTK_ENTRY(odo_text));
   if ((odo_str == NULL) || (atof(odo_str) <= 0.0))
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Entry not Stored! Invalid odometer.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      return;
   }

   /* check for a valid fuel string */
   gal_str = (char *)gtk_entry_get_text(GTK_ENTRY(gal_text));
   if ((gal_str == NULL) || (atof(gal_str) <= 0.0))
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Entry not Stored! Invalid fuel.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      return;
   }

   cost_str = (char *)gtk_entry_get_text(GTK_ENTRY(cost_text));
/* don't check for cost. Empty field allowed */
#if 0
   /* check for a valid cost string */
   if ((cost_str == NULL) || (atof(cost_str) <= 0.0))
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Entry not Stored! Invalid cost.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      return;
   }
#endif

   /* Save this mileage entry */
   strncpy(total_str, orig_date_str, sizeof(total_str));
   strncat(total_str, " ", sizeof(total_str) - strlen(total_str));
   strncat(total_str, odo_str, sizeof(total_str) - strlen(total_str));
   strncat(total_str, " ", sizeof(total_str) - strlen(total_str));
   strncat(total_str, gal_str, sizeof(total_str) - strlen(total_str));
   strncat(total_str, " ", sizeof(total_str) - strlen(total_str));
   strncat(total_str, cost_str, sizeof(total_str) - strlen(total_str));
   car = gtk_combo_box_get_active_text(GTK_COMBO_BOX(car_selector));
   if (car != NULL)
   {
      if (car[strlen(car) - 1] == '\n')
      {
         car[strlen(car) - 1] = '\0';
      }
      addMileEntry(car, total_str,
            gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(previous_but)));
      common_tab_updateDisplayTab(car);
      free(car);

      /* Clear all text fields */
      gtk_entry_set_text(GTK_ENTRY(date_text), "");
      gtk_entry_set_text(GTK_ENTRY(odo_text), "");
      gtk_entry_set_text(GTK_ENTRY(gal_text), "");
      gtk_entry_set_text(GTK_ENTRY(cost_text), "");
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(previous_but), FALSE);
   }
   else
   {
      dialog = gtk_message_dialog_new (NULL,
                                  GTK_DIALOG_DESTROY_WITH_PARENT,
                                  GTK_MESSAGE_ERROR,
                                  GTK_BUTTONS_CLOSE,
                                  "Warning, Entry not Stored! Please Create a Car first.");
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
   }
}

gboolean
text_clicked_cb(GtkWidget* w, gpointer data)
{
   /* Save the last selected field so we know what field to edit */
   if (w == date_text)
      cur_selected_text = date_text;
   else if (w == odo_text)
      cur_selected_text = odo_text;
   else if (w == gal_text)
      cur_selected_text = gal_text;
   else if (w == cost_text)
      cur_selected_text = cost_text;

   return FALSE;
}

void
entry_tab_update_text_label(char  *fuel_label)
{
   gtk_label_set_text(GTK_LABEL(label3), fuel_label);
}

