/*
 * Copyright: (C) 2008 Bruce W. Forsberg
 *
 *   This library is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU Lesser General Public
 *   License as published by the Free Software Foundation; either
 *   version 2.1 of the License, or any later version.
 *
 *   This library is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *   Lesser General Public License for more details.
 *
 *   You should have received a copy of the GNU Lesser General Public
 *   License along with this library; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 *
 *   Bruce Forsberg  bruce.forsberg@gmail.com
 *
 */
#ifndef CAR_TAB_H
#define CAR_TAB_H


#include <gtk/gtk.h>

extern void car_tab_layout(GtkWidget *window);
extern void car_tab_load_car(char *);
extern GtkWidget *car_tab_get_car_selector();
extern GtkWidget *car_tab_get_text_buffer();
extern int  car_tab_get_car_inserted();
extern void car_tab_update_units(int units);
extern void car_tab_update_cost_units(int units);
extern void car_tab_update_car_combo_box(int);
extern void car_tab_set_life_MPG(char *text);
extern void car_tab_set_last_MPG(char *text);
extern void car_tab_set_miles_month(char *text);
extern void car_tab_update_text_labels(
   char     *lifetime_label,
   char     *last_label,
   char     *miles_month_label);

#endif
