#!/usr/bin/python2.5

import os
from os import path
import pango
import pygtk
pygtk.require('2.0')
import gtk
import datetime
import sqlite3
try:
    import hildondesktop
    HILDON_SUPPORT = True
except:
    HILDON_SUPPORT = False

try:
  from xml.etree import ElementTree
except ImportError:
  from elementtree import ElementTree
import gdata.calendar.service
import gdata.service
import atom.service
import gdata.calendar
import atom

icon_path = "/usr/share/pixmaps/mgcal/"
db_path = "/home/user/.mgcal/"
db_name = "mgcal.db"


class mgCal(hildondesktop.HomeItem):

    ################################################
    # constructor
    def __init__(self):
        hildondesktop.HomeItem.__init__(self)

        self._GetConfig()

        self.connect("settings",self.SettingsMenu)

        self.vbox = gtk.VBox(False,0)
        self.add(self.vbox)

        self.hboxtop = gtk.HBox(False,0)
        self.evbox = gtk.EventBox()
        self.lbltop = gtk.Label("Updated: ")
        self.evbox.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(13000,13000,13000,0))
        self.lbltop.modify_fg(gtk.STATE_NORMAL,gtk.gdk.Color(50000,40000,20000,0))
        self.evbox.add(self.lbltop)
        self.hboxtop.pack_start(self.evbox,True,True,0)
        self.vbox.pack_start(self.hboxtop,False,False,0)
        self.lbltop.show()

        self.tb = gtk.TextBuffer(None)
        self.tv = gtk.TextView(self.tb)
        self.mark = self.tb.create_mark("start",self.tb.get_start_iter(),True)

        self.DoFontTags()
        self.tv.set_editable(False)
        self.tv.set_cursor_visible(False)
        self.tv.set_wrap_mode(gtk.WRAP_WORD)
        self.tv.modify_base(gtk.STATE_NORMAL,gtk.gdk.Color(10000,10000,10000,0))
        self.tv.modify_text(gtk.STATE_NORMAL,gtk.gdk.Color(-1,-1,-1,0))
        self.tv.set_left_margin(5)
        self.tv.set_right_margin(0)
        self.vbox.pack_start(self.tv,True,True,0)

        self.eb = gtk.EventBox()
        self.toolbar = gtk.Toolbar()
        self.eb.add(self.toolbar)
        self.toolbar.set_orientation(gtk.ORIENTATION_HORIZONTAL)
        self.toolbar.set_style(gtk.TOOLBAR_ICONS)
        self.toolbar.set_border_width(0)
        self.eb.modify_bg(gtk.STATE_NORMAL,gtk.gdk.Color(13000,13000,13000,0))

        self.ti1 = gtk.ToolItem()
        self.ti1.set_expand(True)
        self.eb1 = gtk.EventBox()
        self.eb1.set_visible_window(False)
        self.eb1.connect("button_press_event",self._MoveUp)
        self.r1 = gtk.Image()
        self.r1.set_from_file(icon_path+"mgcal_up.png")
        #self.r1h = gtk.Image()
        #self.r1h.set_from_file(icon_path+"mgcal_up_hi.png")
        self.eb1.add(self.r1)
        self.ti1.add(self.eb1)
        self.toolbar.insert(self.ti1,-1)

        self.ti2 = gtk.ToolItem()
        self.ti2.set_expand(True)
        self.eb2 = gtk.EventBox()
        self.eb2.set_visible_window(False)
        self.eb2.connect("button_press_event",self._Refresh)
        self.r2 = gtk.Image()
        self.r2.set_from_file(icon_path+"mgcal_refresh.png")
        #self.r2h = gtk.Image()
        #self.r2h.set_from_file(icon_path+"mgcal_refresh_hi.png")
        self.eb2.add(self.r2)
        self.ti2.add(self.eb2)
        self.toolbar.insert(self.ti2,-1)

        self.ti3 = gtk.ToolItem()
        self.ti3.set_expand(True)
        self.eb3 = gtk.EventBox()
        self.eb3.set_visible_window(False)
        self.eb3.connect("button_press_event",self._MoveDn)
        self.r3 = gtk.Image()
        self.r3.set_from_file(icon_path+"mgcal_down.png")
        #self.r3h = gtk.Image()
        #self.r3h.set_from_file(icon_path+"mgcal_down_hi.png")
        self.eb3.add(self.r3)
        self.ti3.add(self.eb3)
        self.toolbar.insert(self.ti3,-1)
        self.vbox.pack_start(self.eb,False,False,0)

        self.set_size_request(400,300)
        self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)
        self._Refresh(self)
        self.show_all()


    ################################################
    # handle the settings menu by returning
    # a gtkmenuitem that runs the settings dialog
    def SettingsMenu(self,widget,data=None):
        mi = gtk.MenuItem("mgCal Settings")
        mi.connect_object("activate",self._Settings,None)
        return mi


    ################################################
    # send destroy event
    def _Delete(self,widget,event,data=None):
        return False;

    ################################################
    # close the app
    def _Destroy(self,widget,data=None):
        gtk.main_quit()


    ################################################
    # get all the config data
    def _GetConfig(self):
        if not os.path.exists(db_path):
            os.mkdir(db_path)
        self.db = sqlite3.connect(db_path + db_name)
        self.db.execute("""create table if not exists history (hid integer primary key autoincrement,hdatetime text)""")
        self.db.execute("""create table if not exists config (email text,pw text,font text,refresh int)""")
        self.db.execute("""create table if not exists events (eid integer primary key autoincrement,hid int,start text,end text,title text,location text)""")
        print "made db"
        row = self.db.execute("""select email,pw,font,refresh from config""").fetchall()
        try:
            self.cfg_email = row[0][0]
            self.cfg_pw = row[0][1]
            try:
                self.cfg_refresh = row[0][3]
            except:
                self.cfg_refresh = 0;
            self.cfg_font = row[0][2]
            if self.cfg_font == '':
                self.cfg_font = 'Sans 10'
        except:
            self.cfg_email = 'dummy'
            self.cfg_pw = ''
            self.cfg_refresh = 0
            self.cfg_font = 'Sans 10'
            # insert dummy data into the table
            self.db.execute("""insert into config values ('dummy','','sans 10',0)""")
            self.db.commit()
        #done for now
        self.data_start = 0
        self.db.close()


    ################################################
    # configure font tags etc from font desc
    def DoFontTags(self):
        # figure out the actual font size
        z = self.cfg_font.split()
        self.cfg_fontsize = int(z[len(z)-1])
        # modify all the textview tags and sizes
        tbl = self.tb.get_tag_table()
        tag = tbl.lookup('date')
        if tag != None:
            tbl.remove(tag)
        tag = tbl.lookup('time')
        if tag != None:
            tbl.remove(tag)
        tag = tbl.lookup('title')
        if tag != None:
            tbl.remove(tag)
        tag = tbl.lookup('location')
        if tag != None:
            tbl.remove(tag)
        #now create them again with new settings
        self.tb.create_tag('title',size_points=self.cfg_fontsize)
        self.tb.create_tag('date',weight=pango.WEIGHT_BOLD,foreground='gray',size_points=self.cfg_fontsize-1,pixels_above_lines=7)
        self.tb.create_tag('time',size_points=self.cfg_fontsize-1,foreground='gray',left_margin=7)
        self.tb.create_tag('location',size_points=self.cfg_fontsize-1,foreground='gray')


    ################################################
    # run the settings dialog
    def _Settings(self,widget,data=None):
        dlgS = gtk.Dialog('mgCal Settings',None,
                     gtk.DIALOG_MODAL | gtk.DIALOG_DESTROY_WITH_PARENT,
                     (gtk.STOCK_CANCEL,gtk.RESPONSE_REJECT,gtk.STOCK_OK,gtk.RESPONSE_ACCEPT))
        # email
        dlgS.vbox.pack_start(gtk.Label('email address'),False,False,0)
        email = gtk.Entry(40)
        email.set_text(self.cfg_email)
        dlgS.vbox.pack_start(email,False,False,0)
        # password
        dlgS.vbox.pack_start(gtk.Label('password'),False,False,0)
        pw = gtk.Entry(20)
        pw.set_visibility(False)
        pw.set_text(self.cfg_pw)
        dlgS.vbox.pack_start(pw,False,False,0)
        # refresh period
        dlgS.vbox.pack_start(gtk.Label('auto refresh period (hours)'),False,False,0)
        refresh = gtk.SpinButton(None,0,0)
        refresh.set_increments(1,1)
        refresh.set_range(0,24)
        refresh.set_numeric(True)
        refresh.set_wrap(True)
        refresh.set_snap_to_ticks(True)
        refresh.set_value(self.cfg_refresh)
        dlgS.vbox.pack_start(refresh,False,False,0)
        #font
        dlgS.vbox.pack_start(gtk.Label('Change Base Font'),False,False,0)
        font = gtk.Button(self.cfg_font)
        font.connect("clicked",self._ChooseFont,None)
        dlgS.vbox.pack_start(font,False,False,0)
        # show all widgets
        dlgS.vbox.show_all()
        # now run the dialog
        if dlgS.run() == gtk.RESPONSE_ACCEPT:
            # save settings
            self.cfg_email = email.get_text()
            self.cfg_pw = pw.get_text()
            self.cfg_refresh = refresh.get_value_as_int()
            self.db = sqlite3.connect(db_path + db_name)
            self.db.execute("""update config set email=?,pw=?,font=?,refresh=?""",(self.cfg_email,self.cfg_pw,self.cfg_font,self.cfg_refresh))
            self.db.commit()
            self.db.close()
        # bye bye...
        dlgS.destroy()


    ################################################
    # run the font chooser dialog
    def _ChooseFont(self,widget,data=None):
        dlgF = gtk.FontSelectionDialog('Choose Font')
        dlgF.set_font_name(self.cfg_font)
        if dlgF.run() == gtk.RESPONSE_OK:
            self.cfg_font = dlgF.get_font_name()
            self.DoFontTags()
            self._DrawEvents()
        dlgF.destroy()


    ################################################
    # get and draw the calendar
    def _Refresh(self,widget,data=None):
        self.data_start = 0
        self._GetEvents()
        self._DrawEvents()


    ################################################
    # read calendar events from google
    def _GetEvents(self):
        self.dnow = datetime.datetime.now()
        self.start_date = self.dnow.date()
        self.end_date = self.dnow.date() + datetime.timedelta(30)
        self.cal_client = gdata.calendar.service.CalendarService()
        self.cal_client.email = self.cfg_email
        self.cal_client.password = self.cfg_pw
        self.cal_client.source = 'mgCal'
        try:
            self.cal_client.ProgrammaticLogin()
        except:
            return False
        self.query = gdata.calendar.service.CalendarEventQuery('default','private','full-noattendees')
        #self.query.start_min = start_date.isoformat()
        #self.query.start_max = end_date.isoformat()
        self.query.orderby = 'starttime'
        self.query.sortorder = 'a'
        self.query.futureevents = 'true'
        self.query.singleevents = 'true'
        self.feed = self.cal_client.CalendarQuery(self.query)
        if self.feed == None:
            return False;
        #insert into the "history" table for an update id
        self.db = sqlite3.connect(db_path + db_name)
        self.db.execute("""insert into history (hdatetime) values (datetime('now','localtime'))""")
        self.db.commit()
        hid = self.db.execute("""select last_insert_rowid()""").fetchall()[0][0]
        # ok here we go
        for i, event in zip(xrange(len(self.feed.entry)),self.feed.entry):
            for j, when in zip(xrange(len(event.when)), event.when):
                for k, where in zip(xrange(len(event.where)), event.where):
                    # figure out the date objects
                    sd = when.start_time[:10] + 'T00:00'
                    if len(when.start_time) > 10:
                        sd = when.start_time[:16]
                    ed = when.end_time[:10] + 'T00:00'
                    if len(when.end_time) > 10:
                        ed = when.end_time[:16]
                    # insert row into db
                    self.db.execute("""insert into events (hid,start,end,title,location) values (?,?,?,?,?)""",(hid,sd,ed,event.title.text,where.value_string))
        self.db.commit()
        # now delete all events NOT from this refresh
        self.db.execute("""delete from events where hid != ?""",[hid])
        self.db.execute("""delete from history where hid != ?""",[hid])
        self.db.commit()
        self.db.close()
        return True


    ################################################
    # draw calendar events from data store
    def _DrawEvents(self):
        cur_start = datetime.date.min
        cur_end = datetime.date.min
        ls = ''
        (st,en) = self.tb.get_bounds()
        self.tb.delete(st,en)
        iter = self.tb.get_iter_at_offset(0)
        # set updated time
        self.db = sqlite3.connect(db_path + db_name)
        try:
            hdate = datetime.datetime.strptime(self.db.execute("""select hdatetime from history order by hdatetime desc limit 1""").fetchall()[0][0],'%Y-%m-%d %H:%M:%S')
            self.lbltop.set_text(hdate.strftime('Updated: %a, %d %b @%H:%M'))
        except:
            self.lbltop.set_text('No Data Available')
            self.tb.set_text("\rPlease check that you have configured mgCal properly using the 'Settings' menu")
            return False
        # and off we go...
        c = self.db.cursor()
        c.execute("select start,end,title,location from events order by start,end limit -1 offset ?",[self.data_start])
        for row in c:
            sd = datetime.datetime.strptime(row[0],'%Y-%m-%dT%H:%M')
            ed = datetime.datetime.strptime(row[1],'%Y-%m-%dT%H:%M')
            # now what do we draw...
            if ed > self.dnow:
                if sd.date() >= cur_start and ed.date() != cur_end:
                    cur_start = sd.date()
                    cur_end = ed.date()
                    # start date
                    self.tb.insert_with_tags_by_name(iter,ls+sd.strftime('%a, %d %b'),'date')
                    ls = '\r'
                    # do we draw an end date?
                    if ed.date() > sd.date():
                        self.tb.insert_with_tags_by_name(iter,' - ' + ed.strftime('%a, %d %b'),'date')
                # now the item
                if sd.time() == datetime.time.min and ed.time() == datetime.time.min:
                    self.tb.insert_with_tags_by_name(iter,'\rAll Day  ','time')
                    all_day = True
                else:
                    self.tb.insert_with_tags_by_name(iter,sd.strftime('\r%H:%M') + ' - ' + ed.strftime('%H:%M  '),'time')
                    all_day = False
                # now the event title
                if row[2]:
                    self.tb.insert_with_tags_by_name(iter,row[2],'title')
                # if we have a "where" show it
                if row[3]:
                    self.tb.insert_with_tags_by_name(iter,'  ('+row[3]+')','location')
        c.close()
        self.tv.scroll_to_mark(self.mark,0.05,True,0.0,1.0)
        self.db.close()

    ################################################
    # draw calendar events from data store
    def _MoveUp(self,widget,data=None):
        if self.data_start > 0:
            self.data_start -= 1
            self._DrawEvents()
        return True

    ################################################
    # draw calendar events from data store
    def _MoveDn(self,widget,data=None):
        self.db = sqlite3.connect(db_path + db_name)
        numev = self.db.execute("""select count(eid) from events""").fetchall()[0][0]
        self.db.close()
        if self.data_start < (numev - 2):
            self.data_start += 1
            self._DrawEvents()
        return True


def hd_plugin_get_objects():
    plugin = mgCal()
    return [plugin]




