#! /bin/bash

# Helper script for building deb packages for MediaBox extensions.
# (c) 2008 Martin Grimme  <martin.grimme@lintegra.de>


NAME_PREFIX="mediabox"

BUILD_HOME=`dirname $0`
DEBIAN_DIR=${BUILD_HOME}/debian
DATA_DIR=${BUILD_HOME}/data
CONFIG=${BUILD_HOME}/configuration.properties

. ${CONFIG}


#
# write debian/changelog
#
echo "writing debian/changelog ..."
CURRENT_TIME=`LANG=C date +"%a, %d %b %Y %T %z"`
mv ${DEBIAN_DIR}/changelog ${DEBIAN_DIR}/changelog.orig

cat >${DEBIAN_DIR}/changelog <<END_OF_INLINE
${NAME_PREFIX}-${NAME} (${VERSION}) unstable; urgency=low

  No changelog recorded

 -- ${MAINTAINER} <${EMAIL}>  ${CURRENT_TIME}
 
END_OF_INLINE

cat ${DEBIAN_DIR}/changelog.orig >>${DEBIAN_DIR}/changelog
rm ${DEBIAN_DIR}/changelog.orig



#
# write debian/control
#
echo "writing debian/control ..."
MAEMO_ICON=`python2.5 -c "import base64; print base64.encodestring(open('${ICON}').read()).replace('\n', '')"`

cat >${DEBIAN_DIR}/control <<END_OF_INLINE
Source: ${NAME_PREFIX}-${NAME}
Section: user/multimedia
Priority: optional
Maintainer: ${MAINTAINER} <${EMAIL}>
Build-Depends: debhelper (>= 5)
Standards-Version: 3.7.2

Package: ${NAME_PREFIX}-${NAME}
Architecture: any
Depends: ${DEPENDENCIES}
Description: ${DESCRIPTION}
XB-Maemo-Icon-26: ${MAEMO_ICON}
END_OF_INLINE



#
# write debian/copyright
#
echo "writing debian/copyright ..."
cat >${DEBIAN_DIR}/copyright <<END_OF_INLINE
Copyright (c) ${MAINTAINER} <${EMAIL}>

This extension for MediaBox is licensed under the terms of the GNU GPL.
END_OF_INLINE



#
# build package
#
echo "building package ..."
export EXTENSION_NAME="${NAME_PREFIX}-${NAME}"
dpkg-buildpackage -rfakeroot -sa -S

