#/usr/bin/env python2.5

"""
mchronos.py
version 0.37

This is a simple PyGTK GUI applet intended to display astronomical
time information.  The application relies heavily upon a ported
version of the 'PyEphem' library created by Brandon Craig Rhodes.

More information about PyEphem is available at:

http://rhodesmill.org/pyephem/

More information about Python and PyGTK is available at:

http://www.python.org/
http://www.pygtk.org/

Copyright (C) 2008-2009 Darren Enns <dmenns1@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
USA.
"""

import sys
import gobject
import pango
import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk
import hildondesktop
import cairo
from datetime import datetime
import gobject
import math
import ephem
from ephem import stars
import os
import time
from math import pi, sin, cos, asin, atan2
import calendar
import ConfigParser
import string

try:
        import gpsbt
        gpsbt_flag = True
except ImportError:
        gpsbt_flag = False

supports_alpha = False
gps_lock = False

class mchronos(hildondesktop.HomeItem):
	def __init__(self):
		hildondesktop.HomeItem.__init__(self)
	
		self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH) # unnecessary

		self.resize_window()

		self.connect("expose-event", self.expose)
		self.connect("screen-changed", self.screen_changed)
		self.connect ("background", self.set_timer, False)
		self.connect ("foreground", self.set_timer, True)
		self.connect ("unrealize", self.unrealize)
		self.connect ("button_press_event", self.button_press_event)

		# set a timeout to update the clock, depending
		# on whether we are in the foreground or background
		self.timer = None
		self.set_timer(self, True)

		self.show_all()

        def button_press_event(self, widget, event):
		global graphics_style_pos 
		global graphics_style
		global text_flag
		global planet_flag
		global star_flag
		global full_window_flag
		global clock_flag
		global grid_flag
		global gps_mode
                global event_x
                global event_y
                global prev_event_x
                global prev_event_y

                prev_event_x = event_x
                prev_event_y = event_y

                event_x = event.x
                event_y = event.y

		global counter

		toggle_x = 0

                if (prev_event_x != event.x) or (prev_event_y != event.y):
			if event.button == 1:
				if event.x >= toggle_x and event.x <= (toggle_x + 20) and event.y >= (height-20):
					if text_flag == "on":
						text_flag = "off"
					else:
						text_flag = "on"
					self.resize_window()

				toggle_x = toggle_x + 25
				if event.x >= toggle_x and event.x <= (toggle_x + 20) and event.y >= (height-20):
					if full_window_flag == "on":
						full_window_flag = "off"
					else:
						full_window_flag = "on"
					self.resize_window()

				toggle_x = toggle_x + 25
				if event.x >= toggle_x and event.x <= (toggle_x + 20) and event.y >= (height-20):
					if clock_flag == "on":
						clock_flag = "off"
					else:
						clock_flag = "on"
					self.resize_window()

				toggle_x = toggle_x + 25
				if event.x >= toggle_x and event.x <= (toggle_x + 20) and event.y >= (height-20):
					if gps_mode in ["on", "lock"]:
						gps_mode = "off"
					else:
						gps_mode = "lock"
					self.resize_window()

				#toggle_x = toggle_x + 25
				#if event.x >= toggle_x and event.x <= (toggle_x + 20) and event.y >= (height-20):
				#	if grid_flag == "on":
				#		grid_flag = "off"
				#	else:
				#		grid_flag = "on"
				#	self.resize_window()

				choice_x = toggle_x + 30

				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 0
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 1
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 2
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 3
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 4
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 5
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 6
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				choice_x = choice_x + 25
				if event.x >= choice_x and event.x <= (choice_x + 20) and event.y >= (height-20):
					graphics_style_pos = 7
					graphics_style = graphics_style_all[graphics_style_pos]
					self.resize_window()

				counter = counter + 1

                return False

	def expose(self, widget, event):

		global supports_alpha
		global local
		global width, height
		global cr
		global circle_x_center, circle_y_center
		global graphics_style_pos 
		global graphics_style
		global gps_lock
		global reset_flag

		if gpsbt_flag == True and (gps_mode == "on" or (gps_mode == "lock" and gps_lock == False)):
			context = gpsbt.start()

			if context == None:
				gps_lock = False
				local.date = ephem.now()
			else:
				# ensure that GPS device is ready to connect and to receive commands
				time.sleep(2)
				gpsdevice = gpsbt.gps()

				gpsdevice.get_fix()

				gps_timer = 0

				while gpsdevice.get_position()[0] == 0.0:
					time.sleep(1)
					gps_timer = gps_timer + 1
					if gps_timer > int(gps_timeout):
						break

				if gpsdevice.fix.latitude == 0.0:
					local.lat = startup_lat
					local.long = startup_long
					gps_lock = False
					local.date = ephem.now()
				else:
					local.lat = str(gpsdevice.fix.latitude)
					local.long = str(gpsdevice.fix.longitude)
					if gps_time == "on":
						gps_seconds = gpsdevice.fix.time
						if gps_seconds != 10000000000.0:
							local.date = time.gmtime(gps_seconds)[0:6]
					else:
						local.date = ephem.now()
					gps_lock = True

				# ends Bluetooth connection
				gpsbt.stop(context)
		else:
			local.date = ephem.now()

		width, height = self.allocation[2], self.allocation[3]

		#Get a cairo context
		cr = widget.window.cairo_create()

		if supports_alpha == True:
			#if text_flag == "on" or graphics_style == "bar":
			if text_flag == "on" or graphics_style in ["bar", "info"]:
				cr.set_source_rgba(.0, .0, .0, 0.5) # Transparent black
			else:
				cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent white
		else:
			cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

		# Draw the background
		cr.set_operator(cairo.OPERATOR_SOURCE)
		if graphics_style != "moon":
			cr.paint()

		screen_size = self.get_size_request()
		screen_width = screen_size[0]
		screen_height = screen_size[1]
		screen_ratio = 400.0 / screen_height

		if graphics_style in ["earth", "horizon"]:
			if full_window_flag == "off":
				top_start = height * 0.52
			else:
				top_start = height * 0.47
		elif graphics_style == "info":
			top_start = height * 0.30
		else:
			top_start = height * 0.03 

		font_size = 11
		cr.set_font_size(font_size)
		cr.select_font_face("Courier", cairo.FONT_SLANT_NORMAL, cairo.FONT_WEIGHT_BOLD)

		if text_flag == "on":
			#text_height = height * 0.015 * screen_ratio
			text_height = height * 0.013 * screen_ratio
			#circle_x_center = width * 0.5
			if full_window_flag == "off":
				circle_x_center = width * 0.5
				if graphics_style == "pole":
					circle_y_center = height * 0.45
				else:
					circle_y_center = height * 0.3
			else:
				circle_x_center = width - (height / 2.0)
				if graphics_style == "pole":
					circle_y_center = height * 0.5
				else:
					circle_y_center = height * 0.5
		else:
			text_height = 0.0
			circle_x_center = width * 0.5
			circle_y_center = height * 0.5

		if graphics_style == "bar":
			bar_height = height * 0.07 * screen_ratio
			tic_height = height * 0.02 * screen_ratio
			section_gap = height * 0.02 * screen_ratio
		else:
			bar_height = 0.0
			tic_height = 0.0
			section_gap = height * 0.01 * screen_ratio

		if graphics_style in ["sphere", "dome", "pole"]:
			if text_flag == "off":
				if full_window_flag == "off":
					circle1 = width / 2
				else:
					circle1 = height / 2
			else:
				if graphics_style == "pole":
					if full_window_flag == "off":
						circle1 = width / 4.0
					else:
						circle1 = width / 4.0
				else:
					circle1 = width / 4.5
			circle2 = circle1 * 2/3
			circle3 = circle1 * 1/3
			circ_diff = (circle1 - circle2)/2

			sun_day_circle = circle1
			sun_year_circle = circle2
			moon_month_circle = circle3

		if graphics_style == "bar":
			size = height * 0.035 * screen_ratio
		elif graphics_style == "sphere":
			size = circle1 / 6
		elif graphics_style == "dome":
			size = circle1 / 10

		if graphics_style == "bar":
			bar1_start = top_start + (text_height*6) + section_gap
		elif graphics_style == "info":
			bar1_start = top_start + (text_height*4) + section_gap
			#bar1_start = top_start + (text_height*10) + section_gap
		elif graphics_style in ["earth", "horizon"]:
			if full_window_flag == "off":
				bar1_start = height * 0.58
			else:
				bar1_start = height * 0.54
		else:
			if full_window_flag == "off":
				bar1_start = height * 0.45
			else:
				bar1_start = top_start + (text_height*5) + section_gap

		if graphics_style == "info":
			bar2_start = bar_height + tic_height*2 + (text_height * 20) + section_gap + bar1_start + section_gap
		else:
			bar2_start = bar_height + tic_height*2 + (text_height * 14) + section_gap + bar1_start

		if graphics_style == "moon":
			bar3_start = 200
		elif graphics_style in ["earth", "horizon"]:
			if full_window_flag == "off":
				bar3_start = height * 0.78
			else:
				bar3_start = height * 0.74
		else:
			bar3_start = bar_height + tic_height*2 + (text_height * 10) + section_gap + bar2_start

		save = local.date
		
		sun = ephem.Sun()
		sun.compute(local)
		
		sun_alt = float(sun.alt) * 180/pi
		sun_az = float(sun.az) * 180/pi

		moon = ephem.Moon()
		moon.compute(local)

		moon_alt = float(moon.alt) * 180/pi
		moon_az = float(moon.az) * 180/pi

		# day section

		timezone_offset = ephem.date(local.date)-ephem.date(ephem.localtime(local.date))
		timezone_hour = round(-timezone_offset * 24)
		start_of_day = ephem.date(str(local.date.tuple()[0])+'/'+str(local.date.tuple()[1])+'/'+str(local.date.tuple()[2])+' 00:00') #reset to start of day GMT
		local.date = start_of_day+timezone_offset # compensate for differing time zone

		sun_antitransit = local.next_antitransit(sun)
		save2 = ephem.date(local.date + 0.001) # this is the best time to set the start of day to since it avoids events from previous day
		
		sun_transit = local.next_transit(sun)
		local.date = save2
		
		sun_next_antitransit = local.next_antitransit(sun)

		local.horizon = '-18:00:00'
		try:
			sun_astro_twilight_dawn_txt = "OK"
			sun_astro_twilight_dawn = local.next_rising(sun)
		except ephem.AlwaysUpError:
			sun_astro_twilight_dawn_txt = "Always Up"
			sun_astro_twilight_dawn = sun_next_antitransit
		except ephem.NeverUpError:
			sun_astro_twilight_dawn_txt = "Never Up"
			sun_astro_twilight_dawn = sun_transit
		local.date = save2
		try:
			sun_astro_twilight_dusk_txt = "OK"
			sun_astro_twilight_dusk = local.next_setting(sun)
		except ephem.AlwaysUpError:
			sun_astro_twilight_dusk_txt = "Always Up"
			sun_astro_twilight_dusk = sun_next_antitransit
		except ephem.NeverUpError:
			sun_astro_twilight_dusk_txt = "Never Up"
			sun_astro_twilight_dusk = sun_transit
		local.date = save2
	
		local.horizon = '-12:00:00'
		try:
			sun_naut_twilight_dawn_txt = "OK"
			sun_naut_twilight_dawn = local.next_rising(sun)
		except ephem.AlwaysUpError:
			sun_naut_twilight_dawn_txt = "Always Up"
			sun_naut_twilight_dawn = sun_next_antitransit
		except ephem.NeverUpError:
			sun_naut_twilight_dawn_txt = "Never Up"
			sun_naut_twilight_dawn = sun_transit
		local.date = save2
		try:
			sun_naut_twilight_dusk_txt = "OK"
			sun_naut_twilight_dusk = local.next_setting(sun)
		except ephem.AlwaysUpError:
			sun_naut_twilight_dusk_txt = "Always Up"
			sun_naut_twilight_dusk = sun_next_antitransit
		except ephem.NeverUpError:
			sun_naut_twilight_dusk_txt = "Never Up"
			sun_naut_twilight_dusk = sun_transit
		local.date = save2
		
		local.horizon = '-06:00:00'
		try:
			sun_civil_twilight_dawn_txt = "OK"
			sun_civil_twilight_dawn = local.next_rising(sun)
		except ephem.AlwaysUpError:
			sun_civil_twilight_dawn_txt = "Always Up"
			sun_civil_twilight_dawn = sun_next_antitransit
		except ephem.NeverUpError:
			sun_civil_twilight_dawn_txt = "Never Up"
			sun_civil_twilight_dawn = sun_transit
		local.date = save2
		try:
			sun_civil_twilight_dusk_txt = "OK"
			sun_civil_twilight_dusk = local.next_setting(sun)
		except ephem.AlwaysUpError:
			sun_civil_twilight_dusk_txt = "Always Up"
			sun_civil_twilight_dusk = sun_next_antitransit
		except ephem.NeverUpError:
			sun_civil_twilight_dusk_txt = "Never Up"
			sun_civil_twilight_dusk = sun_transit
		local.date = save2
	
                sun_always_up_flag = False
                sun_always_down_flag = False

                local.horizon = '00:00:00'
                try:
                        sun_rise_txt = "OK"
                        sun_rise = local.next_rising(sun)
                except ephem.AlwaysUpError:
                        sun_rise_txt = "Always Up"
                        sun_rise = sun_next_antitransit
                        sun_always_up_flag = True
                except ephem.NeverUpError:
                        sun_rise_txt = "Never Up"
                        sun_rise = sun_transit
                        sun_always_down_flag = True
                local.date = save2
		try:
			sun_set_txt = "OK"
			sun_set = local.next_setting(sun)
		except ephem.AlwaysUpError:
			sun_set_txt = "Always Up"
			sun_set = sun_next_antitransit
		except ephem.NeverUpError:
			sun_set_txt = "Never Up"
			sun_set = sun_transit
		local.date = save2

		moon_antitransit = local.next_antitransit(moon)
		save2 = ephem.date(local.date + 0.001) # this is the best time to set the start of day to since it avoids events from previous day
		local.date = save2
		
		moon_transit = local.next_transit(moon)
		local.date = save2
		
		moon_next_antitransit = local.next_antitransit(moon)
		local.date = save2
		
		try:
			moon_rise_txt = "OK"
			moon_rise = local.next_rising(moon)
		except ephem.AlwaysUpError:
			moon_rise_txt = "Always Up"
			moon_rise = moon_antitransit
		except ephem.NeverUpError:
			moon_rise_txt = "Never Up"
			moon_rise = moon_transit
		try:
			moon_set_txt = "OK"
			moon_set = local.next_setting(moon)
		except ephem.AlwaysUpError:
			moon_set_txt = "Always Up"
			moon_set = moon_antitransit
		except ephem.NeverUpError:
			moon_set_txt = "Never Up"
			moon_set = moon_transit

		local.date = save
	
	 	sun_now = local.date
 	
		local_sun_antitransit = ephem.Date(ephem.localtime(sun_antitransit))
		local_sun_astro_twilight_dawn = ephem.Date(ephem.localtime(sun_astro_twilight_dawn))
		local_sun_naut_twilight_dawn = ephem.Date(ephem.localtime(sun_naut_twilight_dawn))
		local_sun_civil_twilight_dawn = ephem.Date(ephem.localtime(sun_civil_twilight_dawn))
		local_sun_rise = ephem.Date(ephem.localtime(sun_rise))
		local_sun_transit = ephem.Date(ephem.localtime(sun_transit))
		local_sun_set = ephem.Date(ephem.localtime(sun_set))
		local_sun_civil_twilight_dusk = ephem.Date(ephem.localtime(sun_civil_twilight_dusk))
		local_sun_naut_twilight_dusk = ephem.Date(ephem.localtime(sun_naut_twilight_dusk))
		local_sun_astro_twilight_dusk = ephem.Date(ephem.localtime(sun_astro_twilight_dusk))
		local_sun_now = ephem.Date(ephem.localtime(local.date))
	
		local_moon_antitransit = ephem.Date(ephem.localtime(moon_antitransit))
		local_moon_rise = ephem.Date(ephem.localtime(moon_rise))
		local_moon_transit = ephem.Date(ephem.localtime(moon_transit))
		local_moon_set = ephem.Date(ephem.localtime(moon_set))

		local_sun_antitransit_hour = local_sun_antitransit.triple()[2] - int(local_sun_antitransit.triple()[2])
		local_sun_astro_twilight_dawn_hour = local_sun_astro_twilight_dawn.triple()[2] - int(local_sun_astro_twilight_dawn.triple()[2])
		local_sun_naut_twilight_dawn_hour = local_sun_naut_twilight_dawn.triple()[2] - int(local_sun_naut_twilight_dawn.triple()[2])
		local_sun_civil_twilight_dawn_hour = local_sun_civil_twilight_dawn.triple()[2] - int(local_sun_civil_twilight_dawn.triple()[2])
		local_sun_rise_hour = local_sun_rise.triple()[2] - int(local_sun_rise.triple()[2])
		local_sun_transit_hour = local_sun_transit.triple()[2] - int(local_sun_transit.triple()[2])

		local_sun_set_hour = local_sun_set.triple()[2] - int(local_sun_set.triple()[2])
		if int(local_sun_set.triple()[2]) != int(local_sun_transit.triple()[2]):
			local_sun_set_hour = 1.0

		local_sun_civil_twilight_dusk_hour = local_sun_civil_twilight_dusk.triple()[2] - int(local_sun_civil_twilight_dusk.triple()[2])
		if int(local_sun_civil_twilight_dusk.triple()[2]) != int(local_sun_transit.triple()[2]):
			local_sun_civil_twilight_dusk_hour = 1.0

		local_sun_naut_twilight_dusk_hour = local_sun_naut_twilight_dusk.triple()[2] - int(local_sun_naut_twilight_dusk.triple()[2])
		if int(local_sun_naut_twilight_dusk.triple()[2]) != int(local_sun_transit.triple()[2]):
			local_sun_naut_twilight_dusk_hour = 1.0

		local_sun_astro_twilight_dusk_hour = local_sun_astro_twilight_dusk.triple()[2] - int(local_sun_astro_twilight_dusk.triple()[2])
		if int(local_sun_astro_twilight_dusk.triple()[2]) != int(local_sun_transit.triple()[2]):
			local_sun_astro_twilight_dusk_hour = 1.0 
		local_sun_now_hour = local_sun_now.triple()[2] - int(local_sun_now.triple()[2])

                if sun_always_up_flag == True:
                        local_sun_rise_hour = 0.0
                        local_sun_civil_twilight_dawn_hour = 0.0
                        local_sun_naut_twilight_dawn_hour = 0.0
                        local_sun_astro_twilight_dawn_hour = 0.0

		day_length = round((local_sun_set_hour - local_sun_rise_hour) * 24,1)
	
		current_local_date = sun_now
	
		if (local_sun_now_hour < local_sun_astro_twilight_dawn_hour):
			sun_phase = " Night"
		if (local_sun_now_hour >= local_sun_astro_twilight_dawn_hour) and (local_sun_now_hour < local_sun_naut_twilight_dawn_hour):
			#sun_phase = " Astronomical Twilight"
			sun_phase = " Dawn"
		if (local_sun_now_hour >= local_sun_naut_twilight_dawn_hour) and (local_sun_now_hour < local_sun_civil_twilight_dawn_hour):
			#sun_phase = " Nautical Twilight"
			sun_phase = " Dawn"
		if (local_sun_now_hour >= local_sun_civil_twilight_dawn_hour) and (local_sun_now_hour < local_sun_rise_hour):
			#sun_phase = " Civil Twilight"
			sun_phase = " Dawn"
		if (local_sun_now_hour >= local_sun_rise_hour) and (local_sun_now_hour < local_sun_set_hour):
			sun_phase = " Daylight"
		if (local_sun_now_hour >= local_sun_set_hour) and (local_sun_now_hour < local_sun_civil_twilight_dusk_hour):
			#sun_phase = " Civil Twilight"
			sun_phase = " Dusk"
		if (local_sun_now_hour >= local_sun_civil_twilight_dusk_hour) and (local_sun_now_hour < local_sun_naut_twilight_dusk_hour):
			#sun_phase = " Nautical Twilight"
			sun_phase = " Dusk"
		if (local_sun_now_hour >= local_sun_naut_twilight_dusk_hour) and (local_sun_now_hour < local_sun_astro_twilight_dusk_hour):
			#sun_phase = " Astronomical Twilight"
			sun_phase = " Dusk"
		if (local_sun_now_hour >= local_sun_astro_twilight_dusk_hour):
			sun_phase = " Night"

		if ((ephem.date(local.date)-ephem.date(ephem.localtime(local.date)))*24) == (time.timezone/60/60):
			local_time_zone_daylight_flag = 0
		else:
			local_time_zone_daylight_flag = time.daylight

		local_time_zone_name = time.tzname
		zone = local_time_zone_name[local_time_zone_daylight_flag]

		week_days = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]
		day_of_week = week_days[time.localtime(time.time())[6]]
	
		# pole circle
		if graphics_style == "pole":
			radius = sun_day_circle
	
			cr.set_source_rgb(0, 0, 0)

			cr.move_to(circle_x_center, circle_y_center)
			cr.arc(circle_x_center, circle_y_center, radius, 0, 2.0*3.14)
			cr.fill()
			cr.stroke()

			cr.set_source_rgb(1.0, 1.0, 1.0)
			cr.move_to(circle_x_center - 5, circle_y_center - radius + 10)
			cr.text_path("N")
			cr.fill()
			cr.stroke()
			cr.move_to(circle_x_center + radius - 10, circle_y_center + 5)
			if astro_sign == 1:
				cr.text_path("E")
			else:
				cr.text_path("W")
			cr.fill()
			cr.stroke()
			cr.move_to(circle_x_center - 5, circle_y_center + radius - 2)
			cr.text_path("S")
			cr.fill()
			cr.stroke()
			cr.move_to(circle_x_center - radius, circle_y_center + 5)
			if astro_sign == 1:
				cr.text_path("W")
			else:
				cr.text_path("E")
			cr.fill()
			cr.stroke()

			cr.set_source_rgb(1.0, 0.0, 0.0)
			cr.set_line_width(1.0)
			for alt in range (890, 895, 1):
				sub_alt = alt/10.0
				radius = sun_day_circle * ((90.0 - sub_alt) / 1.0)
				cr.arc(circle_x_center, circle_y_center, radius, 0, 2.0*3.14)
				cr.stroke()
				
			color = [1.00, 0.00, 0.00]
			radius = sun_day_circle
			for az in range (0, 360, 15):
				pos = az / 360.0
				self.radial_line(pos, radius, color)

			size = radius * 0.60
			radius = 0.0
			color = [0, 0, 0]
			self.radial_ball(pos, radius, size, color, True)

			color = [1.00, 0.00, 0.00]
			radius = sun_day_circle
			for az in range (0, 360, 90):
				pos = az / 360.0
				self.radial_line(pos, radius, color)

			lat_save = local.lat
			local.lat = "90"
			star = ephem.star("Polaris")
			star.compute(local)
			star_alt = float(star.alt) * 180/pi
			star_az = astro_sign * float(star.az) * 180/pi
			pos = (star_az - 180.0) / 360.0
			color = [1.0, 1.0, 1.0]
			radius2 = sun_day_circle * ((90.0 - star_alt) / 1.0)
			dot = 5
			self.radial_ball(pos, radius2, dot, color, True)
			self.radial_text(pos, radius2 * 0.8, color, "Polaris")
			self.radial_text(0.5, radius2 * 0.1, color, "Celestial")
			self.radial_text(0.0, radius2 * 0.2, color, "Pole")
			local.lat = lat_save
			star.compute(local)

		# earth map
		if graphics_style == "earth":
			if full_window_flag == "off":
				image = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_earth_400x200.png")
				image2 = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_earth_400x200.png")
			else:
				image = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_earth_720x360.png")
				image2 = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_earth_720x360.png")

			image_width = image.get_width()
			image_height = image.get_height()

			cr.set_source_surface(image, 0, 0)
			cr.paint()

	                size = width / 50

			# Calculate sub-solar point
			sun_date_save = local.date
			long_save = local.long

			# temporarily set longitude to 0 so as to calculate sun transit even without local longitude being set correctly
			local.long = "0"
			start_of_day = ephem.date(str(local.date.tuple()[0])+'/'+str(local.date.tuple()[1])+'/'+str(local.date.tuple()[2])+' 00:00') #reset to start of day GMT
			local.date = start_of_day
			sun = ephem.Sun()
			sun.compute(local)
			sun_next_transit = local.next_transit(sun)
			local.date = sun_date_save
			sun_long = -(((local.date - sun_next_transit) * 24) - (local.long * 180/pi)/15) * 15
			sun_lat = -sun.dec * 180/pi
			local.long = long_save

			# temporarily set longitude to 0 so as to calculate moon transit even without local longitude being set correctly
			local.long = "0"
			start_of_day = ephem.date(str(local.date.tuple()[0])+'/'+str(local.date.tuple()[1])+'/'+str(local.date.tuple()[2])+' 00:00') #reset to start of day GMT
			local.date = start_of_day
			moon = ephem.Moon()
			moon.compute(local)
			moon_next_transit = local.next_transit(moon)
			moon_next_transit2 = local.next_transit(moon)
			moon_speed = 360 / ((moon_next_transit2 - moon_next_transit) * 24.0)
			local.date = sun_date_save
			moon_long = -(((local.date - moon_next_transit) * 24) - (local.long * 180/pi)/15) * moon_speed
			moon_lat = -moon.dec * 180/pi
			local.long = long_save

			if moon_long < -180:
				moon_long = moon_long + 360

                        prev_x = -999
                        prev_y = -999
                        prev_dest_lon = -999
                        d = pi/2
                        for tc in range(0,365,5):
                                dest_lat = asin(sin(sun_lat*pi/180)*cos(d)+cos(sun_lat*pi/180)*sin(d)*cos(tc*pi/180))
                                temp_lon = atan2(sin(tc*pi/180)*sin(d)*cos(sun_lat*pi/180),cos(d)-sin(sun_lat*pi/180)*sin(dest_lat))
                                dest_lon = ((sun_long*pi/180)+temp_lon+pi) % (2*pi) - pi

                                dest_lat = dest_lat * 180/pi
                                dest_lon = dest_lon * 180/pi

                                x = (dest_lon/180.0) * (image_width/2.0) + (image_width/2.0)
                                y = ((dest_lat/90.0) * (image_height/2.0) + (image_height/2.0)) 

                                if (prev_dest_lon - dest_lon) > 180 and (prev_dest_lon != -999):
                                        cr.line_to(image_width-1,y)
                                        cr.line_to(image_width-1,image_height-1)
                                        cr.line_to(1,image_height-1)
                                        cr.line_to(1,y)
                                        prev_x = x
                                        prev_y = y
                                elif (dest_lon - prev_dest_lon) > 180 and (prev_dest_lon != -999):
                                        cr.line_to(1,y)
                                        cr.line_to(1,1)
                                        cr.line_to(image_width-1,1)
                                        cr.line_to(image_width-1,y)
                                        prev_x = x
                                        prev_y = y
                                if prev_x != -999:
                                        cr.line_to(x,y)
                                prev_x = x
                                prev_y = y
                                prev_dest_lon = dest_lon

			cr.set_source_rgb(0,0,0)
                        cr.paint_with_alpha(0.1)
                        #cr.paint()
                        cr.fill()
                        cr.stroke()
			cr.set_source_surface(image2, 0, 0)
			cr.paint_with_alpha(0.3)

			if grid_flag == "on":
				cr.set_line_width(0.3)
				cr.set_source_rgb(1.0, 1.0, 1.0)
				for long in range (-180, 180, 15):
					lat = 90
					x = (long/180.0) * (image_width/2.0) + (image_width/2.0)
					y = ((lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
					cr.move_to(x, y)
					lat = -90
					x = (long/180.0) * (image_width/2.0) + (image_width/2.0)
					y = ((lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
					cr.line_to(x, y)
					cr.stroke()
				for lat in range (-90, 90, 15):
					long = -180
					x = (long/180.0) * (image_width/2.0) + (image_width/2.0)
					y = ((lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
					cr.move_to(x, y)
					long = 180
					x = (long/180.0) * (image_width/2.0) + (image_width/2.0)
					y = ((lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
					cr.line_to(x, y)
					cr.stroke()

                        # plot sub-solar image
                        x = (sun_long/180.0) * (image_width/2.0) + (image_width/2.0)
                        y = ((sun_lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
                        cr.set_source_rgb(1.0, 1.0, 0.0)
                        cr.arc(x, y, size, 0, 2 * math.pi)
                        cr.fill()
                        cr.stroke()
			
                        # plot sub-lunar image
                        #x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0)
                        #y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
                        #cr.set_source_rgb(0.5, 0.5, 0.5)
                        #cr.arc(x, y, size, 0, 2 * math.pi)
                        #cr.fill()
                        #cr.stroke()

			if (event_x <= image_width) and (event_y <= image_height):		
				if reset_flag == "off":
					font_size = 25
					cr.set_font_size(font_size)

					long = int(round((event_x - (image_width / 2.0)) / (image_width / 2.0) * 180, 0))
					lat = -int(round((event_y - (image_height / 2.0)) / (image_height / 2.0) * 90, 0))

					cr.move_to(image_width * 0.5, image_height * 0.65)
					if lat >= 0:
						lat_dir = "N"
					else:
						lat_dir = "S"
					cr.fill()
					cr.stroke()

					cr.move_to(image_width * 0.5, image_height * 0.65)
					if long >= 0:
						long_dir = "E"
					else:
						long_dir = "W"
					cr.text_path(str(lat).zfill(2) + u"\xb0" + lat_dir + " " + str(long).zfill(3) + u"\xb0" + long_dir)
					cr.fill()
					cr.stroke()

					font_size = 11
					cr.set_font_size(font_size)

					local.lat = str(lat)
					local.long = str(long)
					reset_flag = "on"
				else:
					reset_flag = "off"
					local.lat = startup_lat
					local.long = startup_long

                        # plot observer location
                        latitude = -local.lat * 180/pi
                        longitude = local.long * 180/pi
                        x = (longitude/180.0) * (image_width/2.0) + (image_width/2.0)
                        y = ((latitude/90.0) * (image_height/2.0) + (image_height/2.0)) 
			# plot gps status indicator
			if gps_mode == "on" or gps_mode == "lock":
				if gps_mode == "on":
					if gps_lock == True: 
						cr.set_source_rgb(0.00, 1.00, 0.00)
					else:
						cr.set_source_rgb(1.00, 0.00, 0.00)

				if gps_mode == "lock":
					if gps_lock == True: 
						cr.set_source_rgb(1.00, 0.65, 0.00)
					else:
						cr.set_source_rgb(1.00, 0.00, 0.00)
			else:
				cr.set_source_rgb(1.00, 1.00, 1.00)
                        cr.arc(x, y, size/2, 0, 2 * math.pi)
                        cr.fill()
                        cr.stroke()

			if clock_flag == "on":	
				#if (gps_lock == False) or (gps_time == "off"):
				#	cr.set_source_rgb(1.0, 1.0, 1.0)
				#else:
				#	cr.set_source_rgb(0.0, 1.0, 0.0)

				#cr.set_source_rgb(1.0, 1.0, 1.0) # inherit color from gps status above instead
				font_size = 25
				cr.set_font_size(font_size)

				cr.move_to(image_width * 0.6, image_height * 0.85)
				cr.text_path(str(local_sun_now)[:10])
				cr.fill()
				cr.stroke()

				cr.move_to(image_width * 0.6, image_height * 0.95)
				cr.text_path(str(local_sun_now.tuple()[3]).zfill(2)+":"+str(local_sun_now.tuple()[4]).zfill(2) + " " + zone)
				cr.fill()
				cr.stroke()

				font_size = 11
				cr.set_font_size(font_size)

		# sky horizon
		if graphics_style == "horizon":
			if sun_alt > 0:	
				cr.set_source_rgb(0.015625, 0.515625, 0.984375)
				star_flag = "off"
				planet_flag = "off"
				#star_flag = "on"
				#planet_flag = "on"
			elif sun_alt < -18:	
				cr.set_source_rgb(0, 0, 0)
				star_flag = "on"
				planet_flag = "on"
			else:
				dim_factor = 1.0 - (abs(sun_alt) / 18.0)
				cr.set_source_rgb(0.015625 * dim_factor, 0.515625 * dim_factor, 0.984375 * dim_factor)
				star_flag = "on"
				planet_flag = "on"

			cr.rectangle(0, 0, width, width/4.0)
			cr.fill()
			cr.stroke()

			cr.set_source_rgb(0.0, 0.0, 0.0)
			cr.rectangle(0, width/4.0, width, width/4.0)
			cr.fill()
			cr.stroke()

			if grid_flag == "on":
				cr.set_source_rgb(1.0, 1.0, 1.0)
				cr.set_line_width(0.3)

				for alt in range (-90, 90, 10):
					cr.move_to(0, ((90 - alt) / 90.0) * (width / 4.0))
					cr.line_to(width, ((90 - alt) / 90.0) * (width / 4.0))
					cr.stroke()
					
				for az in range (0, 360, 10):
					cr.move_to((az / 360.0) * width, 0)
					cr.line_to((az / 360.0) * width, (width / 2.0))
					cr.stroke()

				cr.set_line_width(1.0)

				cr.move_to((width * 0.25) - 5, 10)
				cr.text_path("E")
				cr.fill()
				cr.stroke()

				cr.move_to((width * 0.5) - 5, 10)
				cr.text_path("S")
				cr.fill()
				cr.stroke()

				cr.move_to((width * 0.75) - 5, 10)
				cr.text_path("W")
				cr.fill()
				cr.stroke()

			sun.compute(local)
			sun_alt = float(sun.alt) * 180/pi
			sun_az = astro_sign * float(sun.az) * 180/pi
			#if local.lat < 0:
			#	sun_az = sun_az + 180.0

			moon.compute(local)
			moon_alt = float(moon.alt) * 180/pi
			moon_az = astro_sign * float(moon.az) * 180/pi
			#if local.lat < 0:
			#	moon_az = moon_az + 180.0
		
			size = width / 40	
			cr.arc((sun_az / 360.0) * width, ((90 - sun_alt) / 90.0) * (width / 4.0), size, 0, 2.0*3.14)
			cr.set_source_rgb(1.00, 1.00, 0.00)
			cr.fill()
			cr.stroke()

			if sun_alt > 0:	
				if trails_flag == "on":
					# plot sun and moon trails
					size = width / 40	
					local.date = local.date - 0.5
					for hour in range (0, 24, 1):
						local.date = local.date + (1.0 / 24.0)
						sun.compute(local)  
						sun_alt = float(sun.alt) * 180/pi
						if sun_alt >= 0.0:
							sun_az = astro_sign * float(sun.az) * 180/pi
							cr.set_source_rgb(1.00, 1.00, 0.00)
							cr.arc((sun_az / 360.0) * width, ((90 - sun_alt) / 90.0) * (width / 4.0), size/4, 0, 2.0*3.14)
							cr.fill()
							cr.stroke()

						#moon.compute(local)  
						#moon_alt = float(moon.alt) * 180/pi
						#if moon_alt >= 0.0:
						#	moon_az = astro_sign * float(moon.az) * 180/pi
						#	cr.set_source_rgb(0.7, 0.7, 0.7)
						#	cr.arc((moon_az / 360.0) * width, ((90 - moon_alt) / 90.0) * (width / 4.0), size/4, 0, 2.0*3.14)
						#	cr.fill()
						#	cr.stroke()

					local.date = save

			#if moon_alt >= 0:	
			#	cr.arc((moon_az / 360.0) * width, ((90 -moon_alt) / 90.0) * (width / 4.0), size, 0, 2.0*3.14)
			#	cr.set_source_rgb(0.3, 0.3, 0.3)
			#	cr.fill()
			#	cr.stroke()

			if planet_flag == "on":
				mercury = ephem.Mercury()
				mercury.compute(local)
				mercury_alt = float(mercury.alt) * 180/pi
				mercury_az = astro_sign * float(mercury.az) * 180/pi
				cr.set_source_rgb(0.4, 0.4, 0.4)
				cr.arc((mercury_az / 360.0) * width, ((90 - mercury_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				venus = ephem.Venus()
				venus.compute(local)
				venus_alt = float(venus.alt) * 180/pi
				venus_az = astro_sign * float(venus.az) * 180/pi
				cr.set_source_rgb(0.6, 0.6, 0.6)
				cr.arc((venus_az / 360.0) * width, ((90 - venus_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				mars = ephem.Mars()
				mars.compute(local)
				mars_alt = float(mars.alt) * 180/pi
				mars_az = astro_sign * float(mars.az) * 180/pi
				cr.set_source_rgb(1.0, 0.0, 0.0)
				cr.arc((mars_az / 360.0) * width, ((90 - mars_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				jupiter = ephem.Jupiter()
				jupiter.compute(local)
				jupiter_alt = float(jupiter.alt) * 180/pi
				jupiter_az = astro_sign * float(jupiter.az) * 180/pi
				cr.set_source_rgb(1.0, 0.6, 0.0)
				cr.arc((jupiter_az / 360.0) * width, ((90 - jupiter_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				saturn = ephem.Saturn()
				saturn.compute(local)
				saturn_alt = float(saturn.alt) * 180/pi
				saturn_az = astro_sign * float(saturn.az) * 180/pi
				cr.set_source_rgb(0.8, 0.8, 0.0)
				cr.arc((saturn_az / 360.0) * width, ((90 - saturn_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				uranus = ephem.Uranus()
				uranus.compute(local)
				uranus_alt = float(uranus.alt) * 180/pi
				uranus_az = astro_sign * float(uranus.az) * 180/pi
				cr.set_source_rgb(0.0, 0.6, 0.6)
				cr.arc((uranus_az / 360.0) * width, ((90 - uranus_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				neptune = ephem.Neptune()
				neptune.compute(local)
				neptune_alt = float(neptune.alt) * 180/pi
				neptune_az = astro_sign * float(neptune.az) * 180/pi
				cr.set_source_rgb(0.0, 0.6, 0.6)
				cr.arc((neptune_az / 360.0) * width, ((90 - neptune_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

				pluto = ephem.Pluto()
				pluto.compute(local)
				pluto_alt = float(pluto.alt) * 180/pi
				pluto_az = astro_sign * float(pluto.az) * 180/pi
				cr.set_source_rgb(0.5, 0.5, 0.5)
				cr.arc((pluto_az / 360.0) * width, ((90 - pluto_alt) / 90.0) * (width / 4.0), size/3, 0, 2.0*3.14)
				cr.fill()
				cr.stroke()

			if star_flag == "on":
				for body in stars.stars:
					star = ephem.star(body)
					star.compute(local)
					star_alt = float(star.alt) * 180/pi
					star_az = astro_sign * float(star.az) * 180/pi
					#if local.lat < 0:
					#	star_az = star_az + 180.0
					cr.set_source_rgb(1.00, 1.00, 1.00)
					#dot = (width / 100.0) - float(star.mag)
					dot = 4 - float(star.mag)
					cr.arc((star_az / 360.0) * width, ((90 - star_alt) / 90.0) * (width / 4.0), dot, 0, 2.0*3.14)
					cr.fill()
					cr.stroke()

		# sky dome
		if graphics_style == "dome":
			radius = sun_day_circle
			radius2 = sun_day_circle * ((90 - sun_alt) / 90.0)
	
			if sun_alt > 0:	
				cr.set_source_rgb(0.015625, 0.515625, 0.984375)
				star_flag = "off"
				planet_flag = "off"
				#star_flag = "on"
				#planet_flag = "on"
			elif sun_alt < -18:	
				cr.set_source_rgb(0, 0, 0)
				star_flag = "on"
				planet_flag = "on"
			else:
				dim_factor = 1.0 - (abs(sun_alt) / 18.0)
				cr.set_source_rgb(0.015625 * dim_factor, 0.515625 * dim_factor, 0.984375 * dim_factor)
				star_flag = "on"
				planet_flag = "on"

			cr.move_to(circle_x_center, circle_y_center)
			cr.arc(circle_x_center, circle_y_center, radius, 0, 2.0*3.14)
			cr.fill()
			cr.stroke()

			if grid_flag == "on":
				cr.set_source_rgb(1.0, 1.0, 1.0)
				cr.move_to(circle_x_center - 5, circle_y_center - radius + 10)
				cr.text_path("N")
				cr.fill()
				cr.stroke()
				cr.move_to(circle_x_center + radius - 10, circle_y_center + 5)
				if astro_sign == 1:
					cr.text_path("E")
				else:
					cr.text_path("W")
				cr.fill()
				cr.stroke()
				cr.move_to(circle_x_center - 5, circle_y_center + radius - 2)
				cr.text_path("S")
				cr.fill()
				cr.stroke()
				cr.move_to(circle_x_center - radius, circle_y_center)
				if astro_sign == 1:
					cr.text_path("W")
				else:
					cr.text_path("E")
				cr.fill()
				cr.stroke()

			cr.set_source_rgb(1.0, 1.0, 1.0)
			cr.set_line_width(0.3)

			if grid_flag == "on":
				for alt in range (0, 90, 10):
					radius = sun_day_circle * ((90 - alt) / 90.0)
					cr.arc(circle_x_center, circle_y_center, radius, 0, 2.0*3.14)
					cr.stroke()
					
				color = [1.00, 1.00, 1.00]
				for az in range (0, 360, 10):
					radius = sun_day_circle
					pos = az / 360.0
					self.radial_line(pos, radius, color)

			cr.set_source_rgb(1.0, 1.0, 0.0)

			sun.compute(local)
			sun_alt = float(sun.alt) * 180/pi
			sun_az = astro_sign * float(sun.az) * 180/pi

			moon.compute(local)
			moon_alt = float(moon.alt) * 180/pi
			moon_az = astro_sign * float(moon.az) * 180/pi
				
			radius = sun_day_circle
			radius2 = sun_day_circle * ((90 - sun_alt) / 90.0)

			if sun_alt > 0:	
				pos = (sun_az - 180.0) / 360.0
				color = [1.00, 1.00, 0.00]
				self.radial_ball(pos, radius2, size, color, True)
				color = [1.00, 0.50, 0.50]
				self.radial_ball(pos, radius2, size, color, False)

				if trails_flag == "on":
					# plot sun and moon trails
					local.date = local.date - 0.5
					for hour in range (0, 24, 1):
						local.date = local.date + (1.0 / 24.0)
						sun.compute(local)  
						sun_alt = float(sun.alt) * 180/pi
						if sun_alt >= 0.0:
							sun_az = float(sun.az) * 180/pi
							radius2 = sun_day_circle * ((90 - sun_alt) / 90.0)
							pos = (sun_az - 180.0) / 360.0
							color = [1.00, 1.00, 0.00]
							self.radial_ball(pos, radius2, 2, color, True)

					#	moon.compute(local)  
					#	moon_alt = float(moon.alt) * 180/pi
					#	if moon_alt >= 0.0:
					#		moon_az = float(moon.az) * 180/pi
					#		radius2 = sun_day_circle * ((90 - moon_alt) / 90.0)
					#		pos = (moon_az - 180.0) / 360.0
					#		color = [0.70, 0.70, 0.70]
					#		self.radial_ball(pos, radius2, 2, color, True)

					local.date = save

			#radius = sun_day_circle
			#radius2 = sun_day_circle * ((90 - moon_alt) / 90.0)
			#pos = (moon_az - 180.0) / 360.0
			#color = [0.5, 0.5, 0.5]
			#self.radial_ball(pos, radius2, size, color, True)
			#color = [1.00, 0.50, 0.50]
			#self.radial_ball(pos, radius2, size, color, False)

			if planet_flag == "on":
				mercury = ephem.Mercury()
				mercury.compute(local)
				mercury_alt = float(mercury.alt) * 180/pi
				if mercury_alt >= 0.0:
					mercury_az = astro_sign * float(mercury.az) * 180/pi
					pos = (mercury_az - 180.0) / 360.0
					color = [0.4,0.4,0.4]
					radius2 = sun_day_circle * ((90 - mercury_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				venus = ephem.Venus()
				venus.compute(local)
				venus_alt = float(venus.alt) * 180/pi
				if venus_alt >= 0.0:
					venus_az = astro_sign * float(venus.az) * 180/pi
					pos = (venus_az - 180.0) / 360.0
					color = [0.6,0.6,0]
					radius2 = sun_day_circle * ((90 - venus_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				mars = ephem.Mars()
				mars.compute(local)
				mars_alt = float(mars.alt) * 180/pi
				if mars_alt >= 0.0:
					mars_az = astro_sign * float(mars.az) * 180/pi
					pos = (mars_az - 180.0) / 360.0
					color = [1,0,0]
					radius2 = sun_day_circle * ((90 - mars_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				jupiter = ephem.Jupiter()
				jupiter.compute(local)
				jupiter_alt = float(jupiter.alt) * 180/pi
				if jupiter_alt >= 0.0:
					jupiter_az = astro_sign * float(jupiter.az) * 180/pi
					pos = (jupiter_az - 180.0) / 360.0
					color = [1,0.6,0]
					radius2 = sun_day_circle * ((90 - jupiter_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				saturn = ephem.Saturn()
				saturn.compute(local)
				saturn_alt = float(saturn.alt) * 180/pi
				if saturn_alt >= 0.0:
					saturn_az = astro_sign * float(saturn.az) * 180/pi
					pos = (saturn_az - 180.0) / 360.0
					color = [0.8,0.8,0]
					radius2 = sun_day_circle * ((90 - saturn_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				uranus = ephem.Uranus()
				uranus.compute(local)
				uranus_alt = float(uranus.alt) * 180/pi
				if uranus_alt >= 0.0:
					uranus_az = astro_sign * float(uranus.az) * 180/pi
					pos = (uranus_az - 180.0) / 360.0
					color = [0,0.6,0.6]
					radius2 = sun_day_circle * ((90 - uranus_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				neptune = ephem.Neptune()
				neptune.compute(local)
				neptune_alt = float(neptune.alt) * 180/pi
				if neptune_alt >= 0.0:
					neptune_az = astro_sign * float(neptune.az) * 180/pi
					pos = (neptune_az - 180.0) / 360.0
					color = [0,0.6,0.6]
					radius2 = sun_day_circle * ((90 - neptune_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

				pluto = ephem.Pluto()
				pluto.compute(local)
				pluto_alt = float(pluto.alt) * 180/pi
				if pluto_alt >= 0.0:
					pluto_az = astro_sign * float(pluto.az) * 180/pi
					pos = (pluto_az - 180.0) / 360.0
					color = [0.5,0.5,0.5]
					radius2 = sun_day_circle * ((90 - pluto_alt) / 90.0)
					self.radial_ball(pos, radius2, size/3, color, True)

			if star_flag == "on":
				for body in stars.stars:
					star = ephem.star(body)
					star.compute(local)
					star_alt = float(star.alt) * 180/pi
					if star_alt >= 0.0:
						star_az = astro_sign * float(star.az) * 180/pi
						pos = (star_az - 180.0) / 360.0
						color = [1.0,1.0,1.0]
						radius2 = sun_day_circle * ((90 - star_alt) / 90.0)
						#dot = 4 - float(star.mag)
						dot = circle1 / 40 - float(star.mag)
						self.radial_ball(pos, radius2, dot, color, True)

		# day circle
		if graphics_style == "sphere":
			# night slice

			radius = sun_day_circle
			radius2 = sun_day_circle - circ_diff

			red_inc = 0
			green_inc = 0
			blue_inc = 0

			for mult_pos in range(int(local_sun_astro_twilight_dawn_hour*10000), int(local_sun_rise_hour*10000), int((local_sun_rise_hour-local_sun_astro_twilight_dawn_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_rise_hour-local_sun_astro_twilight_dawn_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.0015625
				green_inc = green_inc + 0.0515625
				blue_inc = blue_inc + 0.0984375
				self.pie_slice(start_pos, stop_pos, radius, color)

			start_pos = 0
			stop_pos = local_sun_astro_twilight_dawn_hour
			color = [0,0,0]
			self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 0.015625
			green_inc = 0.515625
			blue_inc = 0.984375

			for mult_pos in range(int(local_sun_rise_hour*10000), int(local_sun_transit_hour*10000), int((local_sun_transit_hour-local_sun_rise_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_transit_hour-local_sun_rise_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.0984375
				green_inc = green_inc + 0.0484375
				blue_inc = blue_inc + 0.0015625
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 1 
			blue_inc = 1

			for mult_pos in range(int(local_sun_transit_hour*10000), int(local_sun_set_hour*10000), int((local_sun_set_hour-local_sun_transit_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_set_hour-local_sun_transit_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.0984375
				green_inc = green_inc - 0.0484375
				blue_inc = blue_inc - 0.0015625
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 0.015625
			green_inc = 0.515625
			blue_inc = 0.984375

			for mult_pos in range(int(local_sun_set_hour*10000), int(local_sun_astro_twilight_dusk_hour*10000), int((local_sun_astro_twilight_dusk_hour-local_sun_set_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_astro_twilight_dusk_hour-local_sun_set_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.0015625
				green_inc = green_inc - 0.0515625
				blue_inc = blue_inc - 0.0984375
				self.pie_slice(start_pos, stop_pos, radius, color)

			start_pos = local_sun_astro_twilight_dusk_hour
			stop_pos = 1
			color = [0, 0, 0]
			self.pie_slice(start_pos, stop_pos, radius, color)

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.set_line_width(1.0)

			pos = local_sun_antitransit_hour
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = local_sun_astro_twilight_dawn_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_naut_twilight_dawn_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_civil_twilight_dawn_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_rise_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_transit_hour
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = local_sun_set_hour
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = local_sun_civil_twilight_dusk_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_naut_twilight_dusk_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_astro_twilight_dusk_hour
			self.radial_line(pos, radius, color)

			#pos = local_sun_now_hour
			#self.radial_line(pos, radius, color)

			pos = local_sun_now_hour
			color = [1.00, 1.00, 0.00]
			self.radial_ball(pos, radius2, size, color, True)

			if gps_mode == "on" or gps_mode == "lock":
				if gps_mode == "on":
					if gps_lock == True: 
						color = [0.00, 1.00, 0.00]
					else:
						color = [1.00, 0.00, 0.00]

				if gps_mode == "lock":
					if gps_lock == True: 
						color = [1.00, 0.65, 0.00]
					else:
						color = [1.00, 0.00, 0.00]

				self.radial_ball(pos, radius2, size/2, color, True)

			pos = local_sun_now_hour
			color = [1.00, 0.50, 0.50]
			self.radial_ball(pos, radius2, size, color, False)

		# day bars
		if graphics_style == "bar":
			cr.set_source_rgb(0.00, 0.00, 0.00)

			cr.rectangle(width*0.05,bar1_start,width*0.90*local_sun_astro_twilight_dawn_hour,bar_height)
			cr.fill()
			cr.stroke()
			
			pat = cairo.LinearGradient(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,0,width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05+width*0.9*(local_sun_rise_hour-local_sun_astro_twilight_dawn_hour),0)
			pat.add_color_stop_rgb(0.0, 0, 0, 0)
			pat.add_color_stop_rgb(1.0, 0.015625,0.515625,0.984375)

			cr.rectangle(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,bar1_start,width*0.9*(local_sun_rise_hour-local_sun_astro_twilight_dawn_hour),bar_height)
			cr.set_source(pat)
			cr.fill()

			pat = cairo.LinearGradient(width*0.9*local_sun_rise_hour+width*0.05,0,width*0.9*local_sun_rise_hour+width*0.05+width*0.9*(local_sun_set_hour-local_sun_rise_hour),0)
			pat.add_color_stop_rgb(0.0, 0.015625,0.515625,0.984375)
			pat.add_color_stop_rgb(0.5, 1, 1, 1)
			pat.add_color_stop_rgb(1.0, 0.015625,0.515625,0.984375)

			cr.rectangle(width*0.9*local_sun_rise_hour+width*0.05,bar1_start,width*0.9*(local_sun_set_hour-local_sun_rise_hour),bar_height)
			cr.set_source(pat)
			cr.fill()
			
			pat = cairo.LinearGradient(width*0.9*local_sun_set_hour+width*0.05,0,width*0.9*local_sun_set_hour+width*0.05+width*0.9*(local_sun_astro_twilight_dusk_hour-local_sun_set_hour),0)
			pat.add_color_stop_rgb(0.0, 0.015625,0.515625,0.984375)
			pat.add_color_stop_rgb(1.0, 0, 0, 0)

			cr.rectangle(width*0.9*local_sun_set_hour+width*0.05,bar1_start,width*0.9*(local_sun_astro_twilight_dusk_hour-local_sun_set_hour),bar_height)
			cr.set_source(pat)
			cr.fill()
			
			cr.rectangle(width*0.9*local_sun_astro_twilight_dusk_hour+width*0.05,bar1_start,width*0.9*(1-local_sun_astro_twilight_dusk_hour),bar_height)
			cr.set_source_rgb(0.00, 0.00, 0.00)
			cr.fill()
			cr.stroke()
	
			cr.move_to(width*0.9*local_sun_antitransit_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_antitransit_hour+width*0.05,bar1_start+bar_height)
			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_naut_twilight_dawn_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_naut_twilight_dawn_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_civil_twilight_dawn_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_civil_twilight_dawn_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_rise_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_rise_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_transit_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_transit_hour+width*0.05,bar1_start+bar_height)
			cr.set_source_rgb(0.00, 0.00, 0.00)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_set_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_set_hour+width*0.05,bar1_start+bar_height)
			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_civil_twilight_dusk_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_civil_twilight_dusk_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_naut_twilight_dusk_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_naut_twilight_dusk_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_astro_twilight_dusk_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_astro_twilight_dusk_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_now_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()

			cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(1.00, 1.00, 0.00)
			cr.fill()
			cr.stroke()

			if gps_mode == "on" or gps_mode == "lock":
				if gps_mode == "on":
					cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size/2, 0, 2.0*3.14)
					if gps_lock == True: 
						cr.set_source_rgb(0.00, 1.00, 0.00)
						#if gps_time == "on":
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.03,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("LT")
						#else:
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.04,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("L")
						#cr.fill()
						#cr.stroke()
						cr.set_source_rgb(0.00, 1.00, 0.00)
					else:
						cr.set_source_rgb(1.00, 0.00, 0.00)
					cr.fill()
					cr.stroke()

				if gps_mode == "lock":
					cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size/2, 0, 2.0*3.14)
					if gps_lock == True: 
						cr.set_source_rgb(1.00, 0.65, 0.00)
						#if gps_time == "on":
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.03,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("LT")
						#else:
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.04,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("L")
						#cr.fill()
						#cr.stroke()
						cr.set_source_rgb(1.00, 0.65, 0.00)
					else:
						cr.set_source_rgb(1.00, 0.00, 0.00)
					cr.fill()
					cr.stroke()

			cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(1.00, 0.50, 0.50)
			cr.set_line_width(0.8)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)

			for hour in range(0,25,1):
				sun_hour = hour/24.0
				cr.move_to(width*0.9*sun_hour+width*0.05,bar1_start+bar_height)
				cr.line_to(width*0.9*sun_hour+width*0.05,bar1_start+bar_height+tic_height)
				cr.set_line_width(1.0)
				cr.stroke()
				if hour%3 == 0:
					cr.move_to(width*0.9*sun_hour-width/50+width*0.05,bar1_start+bar_height+tic_height*2)
					cr.text_path(str(hour))
					cr.fill()
					cr.stroke()
		
		# day text
		if text_flag == "on":
			sun.compute(local)
			sun_alt = float(sun.alt) * 180/pi
			sun_az = float(sun.az) * 180/pi

			moon.compute(local)
			moon_alt = float(moon.alt) * 180/pi
			moon_az = float(moon.az) * 180/pi
				
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.move_to(width*0.01,top_start)
			cr.text_path("LOCAL DATE:      " + str(local_sun_now)[:10] + " " + day_of_week)
			#cr.text_path(str(counter) + " " + str(full_window_flag) + " " + str(gps_lock))
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,top_start+text_height*2)
			cr.text_path("LOCAL TIME:      " + str(local_sun_now.tuple()[3]).zfill(2)+":"+str(local_sun_now.tuple()[4]).zfill(2) + " " + zone + " [UTC" + '%+2.1f' % timezone_hour + "]")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,top_start+text_height*4)
			cr.text_path("LOCAL LATITUDE:  " + str(local.lat) + u"\xb0")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,top_start+text_height*6)
			cr.text_path("LOCAL LONGITUDE: " + str(local.long) + u"\xb0")
			cr.fill()
			cr.stroke()

			if graphics_style != "pole":
				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*4)
				cr.text_path("SUN PHASE:" + sun_phase)
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*6)
				cr.text_path("SUN AZ:   " + str(sun.az) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*8)
				cr.text_path("SUN ALT:  " + str(sun.alt) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*10)
				if sun_rise_txt == "OK":
					cr.text_path("SUN RISE: " + str(local_sun_rise)[10:])
				else:
					cr.text_path("SUN RISE: " + "N/A")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*12)
				if sun_set_txt == "OK":
					cr.text_path("SUN SET:  " + str(local_sun_set)[10:])
				else:
					cr.text_path("SUN SET:  " + "N/A")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*14)
				cr.text_path("SUN MIN:  " + str(local_sun_antitransit)[10:])
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*16)
				cr.text_path("SUN MAX:  " + str(local_sun_transit)[10:])
				cr.fill()
				cr.stroke()

				if full_window_flag == "off":
					text_start_x = width*0.5
				else:	
					text_start_x = width*0.25

				if graphics_style == "info":
					cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*18+section_gap)
					if sun_astro_twilight_dawn_txt == "OK":
						cr.text_path("SUN AST DAWN: " + str(local_sun_astro_twilight_dawn)[10:])
					else:
						#cr.text_path("SUN AST DAWN: " + sun_astro_twilight_dawn_txt)
						cr.text_path("SUN AST DAWN: " + "N/A")
					cr.fill()
					cr.stroke()

					cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*20+section_gap)
					if sun_naut_twilight_dawn_txt == "OK":
						cr.text_path("SUN NAU DAWN: " + str(local_sun_naut_twilight_dawn)[10:])
					else:
						#cr.text_path("SUN NAU DAWN: " + sun_naut_twilight_dawn_txt)
						cr.text_path("SUN NAU DAWN: " + "N/A")
					cr.fill()
					cr.stroke()

					cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*22+section_gap)
					if sun_civil_twilight_dawn_txt == "OK":
						cr.text_path("SUN CIV DAWN: " + str(local_sun_civil_twilight_dawn)[10:])
					else:
						#cr.text_path("SUN CIV DAWN: " + sun_civil_twilight_dawn_txt)
						cr.text_path("SUN CIV DAWN: " + "N/A")
					cr.fill()
					cr.stroke()

					cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*18+section_gap)
					if sun_astro_twilight_dawn_txt == "OK":
						cr.text_path("SUN AST DUSK: " + str(local_sun_astro_twilight_dusk)[10:])
					else:
						#cr.text_path("SUN AST DUSK: " + sun_astro_twilight_dawn_txt)
						cr.text_path("SUN AST DUSK: " + "N/A")
					cr.fill()
					cr.stroke()

					cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*20+section_gap)
					if sun_naut_twilight_dusk_txt == "OK":
						cr.text_path("SUN NAU DUSK: " + str(local_sun_naut_twilight_dusk)[10:])
					else:
						#cr.text_path("SUN NAU DUSK: " + sun_naut_twilight_dusk_txt)
						cr.text_path("SUN NAU DUSK: " + "N/A")
					cr.fill()
					cr.stroke()

					cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*22+section_gap)
					if sun_civil_twilight_dusk_txt == "OK":
						cr.text_path("SUN CIV DUSK: " + str(local_sun_civil_twilight_dusk)[10:])
					else:
						#cr.text_path("SUN CIV DUSK: " + sun_civil_twilight_dusk_txt)
						cr.text_path("SUN CIV DUSK: " + "N/A")
					cr.fill()
					cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*4)
				cr.text_path("DAYLENGTH: " + str(day_length) + " hrs")
				cr.fill()
				cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*6)
				cr.text_path("MOON AZ:  " + str(moon.az) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*8)
				cr.text_path("MOON ALT: " + str(moon.alt) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*10)
				if moon_rise_txt == "OK":
					cr.text_path("MOON RISE:" + str(local_moon_rise)[10:])
				else:
					cr.text_path("MOON RISE:" + "N/A")
				cr.fill()
				cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*12)
				if moon_set_txt == "OK":
					cr.text_path("MOON SET: " + str(local_moon_set)[10:])
				else:
					cr.text_path("MOON SET: " + "N/A")
				cr.fill()
				cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*14)
				cr.text_path("MOON MIN: " + str(local_moon_antitransit)[10:])
				cr.fill()
				cr.stroke()

				cr.move_to(text_start_x,bar1_start+bar_height+tic_height+text_height*16)
				cr.text_path("MOON MAX: " + str(local_moon_transit)[10:])
				cr.fill()
				cr.stroke()

			else:
				cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*4)
				cr.text_path("SIDEREAL TIME:" + str(local.sidereal_time()))
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*6)
				cr.text_path("POLARIS AZ:   " + str(star.az) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*8)
				cr.text_path("POLARIS ALT:  " + str(star.alt) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*10)
				cr.text_path("POLARIS RA:  " + str(star.ra) + u"\xb0")
				cr.fill()
				cr.stroke()

				cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*12)
				cr.text_path("POLARIS DEC: " + str(star.dec) + u"\xb0")
				cr.fill()
				cr.stroke()

		if graphics_style == "info":
			cr.set_source_rgb(1.00, 1.00, 1.00)
			text_height = height * 0.013 * screen_ratio
			font_size = 25
			cr.set_font_size(font_size)

			line_len = 21

			cr.move_to(width*0.01, text_height*6)
			#cr.text_path(string.center(str(local_sun_now)[:10] + " " + day_of_week, line_len))
			cr.text_path(string.center(str(local_sun_now)[:10] + " GD", line_len))
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01, text_height*10)
			cr.text_path(string.center(str(ephem.julian_date()) + " JD", line_len))
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,text_height*16)
			cr.text_path(string.center(str(local_sun_now.tuple()[3]).zfill(2) + ":" + str(local_sun_now.tuple()[4]).zfill(2) + " " + zone, line_len))
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,text_height*20)
			cr.text_path(string.center(str(local.sidereal_time()) + " LST", line_len))
			cr.fill()
			cr.stroke()

			font_size = 11
			cr.set_font_size(font_size)

		# season section

		local.date = save

		current_year = local.date.tuple()[0]
		first_year_day = ephem.date(str(current_year)+"/01/01")
		last_year_day = ephem.date(str(current_year+1)+"/01/01")
		days_in_year = last_year_day-first_year_day
		local_date = ephem.localtime(local.date)
		current_year_day = ephem.date(local_date) - first_year_day
		local_year_day = current_year_day / days_in_year
	
		spring_date = ephem.localtime(ephem.next_equinox(ephem.date(str(first_year_day.tuple()[0]))))
		summer_date = ephem.localtime(ephem.next_solstice(spring_date))
		fall_date = ephem.localtime(ephem.next_equinox(summer_date))
		winter_date = ephem.localtime(ephem.next_solstice(fall_date))
		spring_year_day = (ephem.date(spring_date) - first_year_day) / days_in_year
		summer_year_day = (ephem.date(summer_date) - first_year_day) / days_in_year
		fall_year_day = (ephem.date(fall_date) - first_year_day) / days_in_year
		winter_year_day = (ephem.date(winter_date) - first_year_day) / days_in_year

		if (local_year_day >= spring_year_day) and (local_year_day < summer_year_day):
			season = "Spring"
		if (local_year_day >= summer_year_day) and (local_year_day < fall_year_day):
			season = "Summer"
		if (local_year_day >= fall_year_day) and (local_year_day < winter_year_day):
			season = "Fall"
		if (local_year_day >= winter_year_day) or (local_year_day < spring_year_day):
			season = "Winter"
			
		month_year_day = ([])
	
		jan_date = ephem.date(str(current_year)+"/01/01")
		feb_date = ephem.date(str(current_year)+"/02/01")	
		mar_date = ephem.date(str(current_year)+"/03/01")	
		apr_date = ephem.date(str(current_year)+"/04/01")	
		may_date = ephem.date(str(current_year)+"/05/01")	
		jun_date = ephem.date(str(current_year)+"/06/01")	
		jul_date = ephem.date(str(current_year)+"/07/01")	
		aug_date = ephem.date(str(current_year)+"/08/01")	
		sep_date = ephem.date(str(current_year)+"/09/01")	
		oct_date = ephem.date(str(current_year)+"/10/01")	
		nov_date = ephem.date(str(current_year)+"/11/01")	
		dec_date = ephem.date(str(current_year)+"/12/01")	

		jan_year_day = (jan_date - first_year_day + 1) / days_in_year
		month_year_day.append([jan_year_day, "J"])
		feb_year_day = (feb_date - first_year_day + 1) / days_in_year
		month_year_day.append([feb_year_day, "F"])
		mar_year_day = (mar_date - first_year_day + 1) / days_in_year
		month_year_day.append([mar_year_day, "M"])
		apr_year_day = (apr_date - first_year_day + 1) / days_in_year
		month_year_day.append([apr_year_day, "A"])
		may_year_day = (may_date - first_year_day + 1) / days_in_year
		month_year_day.append([may_year_day, "M"])
		jun_year_day = (jun_date - first_year_day + 1) / days_in_year
		month_year_day.append([jun_year_day, "J"])
		jul_year_day = (jul_date - first_year_day + 1) / days_in_year
		month_year_day.append([jul_year_day, "J"])
		aug_year_day = (aug_date - first_year_day + 1) / days_in_year
		month_year_day.append([aug_year_day, "A"])
		sep_year_day = (sep_date - first_year_day + 1) / days_in_year
		month_year_day.append([sep_year_day, "S"])
		oct_year_day = (oct_date - first_year_day + 1) / days_in_year
		month_year_day.append([oct_year_day, "O"])
		nov_year_day = (nov_date - first_year_day + 1) / days_in_year
		month_year_day.append([nov_year_day, "N"])
		dec_year_day = (dec_date - first_year_day + 1) / days_in_year
		month_year_day.append([dec_year_day, "D"])

		cr.set_source_rgb(1.00, 1.00, 1.00)

		# season bars
		if graphics_style == "bar":
			pat = cairo.LinearGradient(width*0.05,0,width*0.05+width*0.9,0)
			pat.add_color_stop_rgb(0.00, 1.00, 1.00, 1.00)
			pat.add_color_stop_rgb(spring_year_day, 0.00, 1.00, 0.00)
			pat.add_color_stop_rgb(summer_year_day, 1.00, 0.00, 0.00)
			pat.add_color_stop_rgb(fall_year_day, 1.00, 1.00, 0.00)
			pat.add_color_stop_rgb(winter_year_day, 1.00, 1.00, 1.00)

			cr.rectangle(width*0.05,bar2_start,width*0.9,bar_height)
			cr.set_source(pat)
			cr.fill()

			#cr.set_dash([1],1) 	
			cr.set_line_width(1.0)
			cr.set_source_rgb(0.00, 0.00, 0.00)

			cr.move_to(width*0.9*spring_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*spring_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*summer_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*summer_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*fall_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*fall_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*winter_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*winter_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*local_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*local_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.arc(width*0.9*local_year_day+width*0.05,bar2_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(0.015625,0.515625,0.984375) # light blue dome color
			cr.fill()
			cr.stroke()
		
			cr.arc(width*0.9*local_year_day+width*0.05,bar2_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(0.00, 0.00, 1.00)
			cr.set_line_width(0.5)
			cr.stroke()
	
			for month_start in month_year_day:
				cr.move_to(width*0.9*month_start[0]+width*0.05,bar2_start+bar_height)
				cr.line_to(width*0.9*month_start[0]+width*0.05,bar2_start+bar_height+tic_height)
				cr.stroke()

				cr.move_to(width*0.9*month_start[0]+width/30+width*0.05,bar2_start+bar_height+tic_height*2)
				cr.text_path(month_start[1])
				cr.set_source_rgb(1.00, 1.00, 1.00)
				cr.fill()
				cr.stroke()

		# season circle
		if graphics_style == "sphere":
			radius = sun_year_circle
			radius2 = sun_year_circle - circ_diff

			red_inc = 1
			green_inc = 1 
			blue_inc = 1

			for mult_pos in range(0, int(spring_year_day*10000), int((spring_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (spring_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.1
				green_inc = green_inc - 0
				blue_inc = blue_inc - 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 0
			green_inc = 1 
			blue_inc = 0

			for mult_pos in range(int(spring_year_day*10000), int(summer_year_day*10000), int((summer_year_day-spring_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (summer_year_day-spring_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.1
				green_inc = green_inc - 0.1
				blue_inc = blue_inc - 0
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 0 
			blue_inc = 0

			for mult_pos in range(int(summer_year_day*10000), int(fall_year_day*10000), int((fall_year_day-summer_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (fall_year_day-summer_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0
				green_inc = green_inc + 0.1
				blue_inc = blue_inc - 0
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 1 
			blue_inc = 0

			for mult_pos in range(int(fall_year_day*10000), int(winter_year_day*10000), int((winter_year_day-fall_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (winter_year_day-fall_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0
				green_inc = green_inc + 0
				blue_inc = blue_inc + 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			start_pos = winter_year_day
			stop_pos = 1
			color = [1, 1, 1]
			self.pie_slice(start_pos, stop_pos, radius, color)

			pos = spring_year_day
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = summer_year_day
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = fall_year_day
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = winter_year_day
			self.radial_line(pos, radius, color)

			pos = local_year_day
			color = [0.015625,0.515625,0.984375]
			self.radial_ball(pos, radius2, size, color, True)

			pos = local_year_day
			color = [0.00, 0.00, 1.00]
			self.radial_ball(pos, radius2, size, color, False)

		# season text info
		if text_flag == "on" and graphics_style not in ["earth", "moon", "pole", "horizon"]:
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*4)
			cr.text_path("SEASON/DAY: " + season + " / " + "%1.2f" % current_year_day + " [" + str(int(current_year_day)+1) +"]")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*6)
			cr.text_path("SPRING:     " + str(spring_date)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*8)
			cr.text_path("SUMMER:     " + str(summer_date)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*10)
			cr.text_path("FALL:       " + str(fall_date)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*12)
			cr.text_path("WINTER:     " + str(winter_date)[:19])
			cr.fill()
			cr.stroke()

		# moon section

		moon = ephem.Moon()
		moon.compute(local)
		moon_full_pct = moon.phase

		nm = 0.00
		fq = 0.25
		fm = 0.50
		lq = 0.75
		nm2 = 1.00
	
		# dome circle
		if graphics_style == "dome":
			moon.compute(local)
			moon_alt = float(moon.alt) * 180/pi
			moon_az = astro_sign * float(moon.az) * 180/pi
			radius = sun_day_circle
			radius2 = sun_day_circle * ((90 - moon_alt) / 90.0)

		# moon circle
		if graphics_style == "sphere":
			radius = moon_month_circle
			radius2 = moon_month_circle - circ_diff

			red_inc = 0
			green_inc = 0 
			blue_inc = 0

			for mult_pos in range(0, 50, 5):
				start_pos = mult_pos/100.0
				stop_pos = start_pos + 0.1
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.1
				green_inc = green_inc + 0.1
				blue_inc = blue_inc + 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 1 
			blue_inc = 1

			for mult_pos in range(50, 100, 5):
				start_pos = mult_pos/100.0
				stop_pos = start_pos + 0.1
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.1
				green_inc = green_inc - 0.1
				blue_inc = blue_inc - 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			pos = nm
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = fq
			self.radial_line(pos, radius, color)

			pos = fm
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = lq
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = nm2
			self.radial_line(pos, radius, color)

		# moon bar
		if graphics_style in ["bar", "moon"]:
			pat = cairo.LinearGradient(width*0.05,bar3_start,width*.90+width*0.05,bar3_start)
			pat.add_color_stop_rgb(0.0, 0, 0, 0)
			pat.add_color_stop_rgb(0.5, 1, 1, 1)
			pat.add_color_stop_rgb(1.0, 0, 0, 0)

			cr.rectangle(width*0.05,bar3_start,width*0.90,bar_height)
			cr.set_source(pat)
			cr.fill()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm+width*0.05,bar3_start)
			cr.line_to(width*0.9*nm+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*fq+width*0.05,bar3_start)
			cr.line_to(width*0.9*fq+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(0.00, 0.00, 0.00)
			cr.move_to(width*0.9*fm+width*0.05,bar3_start)
			cr.line_to(width*0.9*fm+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*lq+width*0.05,bar3_start)
			cr.line_to(width*0.9*lq+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm2+width*0.05,bar3_start)
			cr.line_to(width*0.9*nm2+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*nm+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*fq+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*fq+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*fm+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*fm+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*lq+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*lq+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm2+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*nm2+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.set_line_width(1.0)

			cr.move_to(width*0.9*nm-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("NM")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*fq-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("FQ")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*fm-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("FM")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*lq-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("LQ")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*nm2-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("NM")
			cr.fill()
			cr.stroke()

		save = local.date

		local.date = start_of_day+timezone_offset # compensate for differing time zone

		moon_next_full = ephem.next_full_moon(local.date)
		moon_next_new = ephem.next_new_moon(local.date)

		local.date = save

		if graphics_style == "moon":
			if full_window_flag == "off":
				image = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_moon_250x200.png")
				image2 = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_moon_250x200.png")
			else:
				image = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_moon_720x400.png")
				image2 = cairo.ImageSurface.create_from_png("/usr/lib/hildon-desktop/mchronos_moon_720x400.png")

			cr.set_source_surface(image, 0, 0)
			cr.paint()

			image_width = image.get_width()
			image_height = image.get_height()

	                #size = height * 0.25 * screen_ratio   
	                #size = 100
			size = image_height / 2.0

		# moon special bar & circle & moon & dome
		if graphics_style in ["bar", "sphere", "moon", "dome", "earth", "horizon"]:
			if not (graphics_style  == "dome" and moon_alt < 0):
			#if not (graphics_style in ["dome", "horizon"] and moon_alt < 0):
				if moon_next_full < moon_next_new:
					mp = (moon_full_pct/100)/2
					moon_phase = "Waxing"
					arc_start = True

					if graphics_style == "horizon":
						x = (moon_az / 360.0) * width
						y = ((90 -moon_alt) / 90.0) * (width / 4.0)
						cr.set_source_rgb(0.3, 0.3, 0.3)
						cr.arc(x, y, size, 0, 2 * math.pi)
						cr.fill()
						cr.stroke()

					if graphics_style == "earth":
						x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0)
						y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
						cr.set_source_rgb(0.3, 0.3, 0.3)
						cr.arc(x, y, size, 0, 2 * math.pi)
						cr.fill()
						cr.stroke()

					if graphics_style == "dome":
						pos = (moon_az - 180.0) / 360.0
						color = [0.3, 0.3, 0.3]
						self.radial_ball(pos, radius2, size, color, True)
						color = [1, 1, 1]
						self.radial_ball(pos, radius2, size, color, False)
						x1 = circle_x_center
						y1 = circle_y_center
						angle1a = pos * 360
						angle1b = (angle1a+90)*pi/180

					if graphics_style == "bar":
						cr.set_source_rgb(1.00, 0.00, 0.00)
						cr.move_to(width*0.9*mp+width*0.05,bar3_start)
						cr.line_to(width*0.9*mp+width*0.05,bar3_start+bar_height)
						cr.set_line_width(1.0)
						cr.stroke()

						cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
						cr.set_source_rgb(0.00, 0.00, 0.00)
						cr.fill()
						cr.stroke()

						cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
						if moon_full_pct < 25 or moon_full_pct > 75:
							cr.set_source_rgb(1.00, 1.00, 1.00)
						else:
							cr.set_source_rgb(0.00, 0.00, 0.00)
						cr.set_line_width(0.5)
						cr.stroke()

					if graphics_style == "sphere":
						pos = mp
						color = [0, 0, 0]
						self.radial_ball(pos, radius2, size, color, True)
						color = [1, 1, 1]
						self.radial_ball(pos, radius2, size, color, False)
						x1 = circle_x_center
						y1 = circle_y_center
						angle1a = pos * 360
						angle1b = (angle1a+90)*pi/180

					view_az = 0
					view_alt = 0
					if graphics_style == "moon":
						az_degrees = -90
					else:
						az_degrees = 90
					az = az_degrees * pi/180
					for alt_degrees in range(90,-90,-9):
						alt = alt_degrees * pi/180
						arc_x = size * cos(alt)*sin(az-view_az)
						arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
						if graphics_style == "moon":
							x = ((image_width / 2.0) + arc_x)
							y = ((image_height / 2.0) - arc_y)
						if graphics_style == "bar":
							x = ((width*0.9*mp+width*0.05) + arc_x)
							y = ((bar3_start+bar_height/2) - arc_y)
						if graphics_style == "sphere":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "dome":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "earth":
							x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0) + arc_x
							y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) - arc_y
						if graphics_style == "horizon":
							x = (moon_az / 360.0) * width + arc_x
							y = ((90 -moon_alt) / 90.0) * (width / 4.0) - arc_y
						if arc_start == True:
							cr.move_to(x,y)
							arc_start = False
						else:
							cr.line_to(x,y)

					view_az = 0
					view_alt = 0
					az_degrees = -asin((moon_full_pct - 50)/50) * 180/pi

					az = az_degrees * pi/180
					for alt_degrees in range(-90,90,9):
						alt = alt_degrees * pi/180
						arc_x = size * cos(alt)*sin(az-view_az)
						arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
						if graphics_style == "moon":
							x = ((image_width / 2.0) + arc_x)
							y = ((image_height / 2.0) - arc_y)
						if graphics_style == "bar":
							x = ((width*0.9*mp+width*0.05) + arc_x)
							y = ((bar3_start+bar_height/2) - arc_y)
						if graphics_style == "sphere":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "dome":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "earth":
							x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0) + arc_x
							y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) - arc_y
						if graphics_style == "horizon":
							x = (moon_az / 360.0) * width + arc_x
							y = ((90 -moon_alt) / 90.0) * (width / 4.0) - arc_y
						cr.line_to(x,y)

				else:
					mp = (1-(moon_full_pct/100))/2+0.5
					moon_phase = "Waning"
					arc_start = True

					if graphics_style == "horizon":
						x = (moon_az / 360.0) * width
						y = ((90 -moon_alt) / 90.0) * (width / 4.0)
						cr.set_source_rgb(0.3, 0.3, 0.3)
						cr.arc(x, y, size, 0, 2 * math.pi)
						cr.fill()
						cr.stroke()

					if graphics_style == "earth":
						x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0)
						y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) 
						cr.set_source_rgb(0.3, 0.3, 0.3)
						cr.arc(x, y, size, 0, 2 * math.pi)
						cr.fill()
						cr.stroke()

					if graphics_style == "dome":
						pos = (moon_az - 180.0) / 360.0
						color = [0.3, 0.3, 0.3]
						self.radial_ball(pos, radius2, size, color, True)
						color = [1, 1, 1]
						self.radial_ball(pos, radius2, size, color, False)
						x1 = circle_x_center
						y1 = circle_y_center
						angle1a = pos * 360
						angle1b = (angle1a+90)*pi/180

					if graphics_style == "bar":
						cr.set_source_rgb(1.00, 0.00, 0.00)
						cr.move_to(width*0.9*mp+width*0.05,bar3_start)
						cr.line_to(width*0.9*mp+width*0.05,bar3_start+bar_height)
						cr.set_line_width(1.0)
						cr.stroke()

						cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
						cr.set_source_rgb(0.00, 0.00, 0.00)
						cr.fill()
						cr.stroke()

						cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
						if moon_full_pct < 25 or moon_full_pct > 75:
							cr.set_source_rgb(1.00, 1.00, 1.00)
						else:
							cr.set_source_rgb(0.00, 0.00, 0.00)
						cr.set_line_width(0.5)
						cr.stroke()

					if graphics_style == "sphere":
						pos = mp
						color = [0, 0, 0]
						self.radial_ball(pos, radius2, size, color, True)
						color = [1, 1, 1]
						self.radial_ball(pos, radius2, size, color, False)
						x1 = circle_x_center
						y1 = circle_y_center
						angle1a = pos * 360
						angle1b = (angle1a+90)*pi/180

					view_az = 0
					view_alt = 0
					if graphics_style == "moon":
						az_degrees = 90
					else:
						az_degrees = -90
					az = az_degrees * pi/180
					for alt_degrees in range(90,-90,-9):
						alt = alt_degrees * pi/180
						arc_x = size * cos(alt)*sin(az-view_az)
						arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
						if graphics_style == "moon":
							x = ((image_width / 2.0) + arc_x)
							y = ((image_height / 2.0) - arc_y)
						if graphics_style == "bar":
							x = ((width*0.9*mp+width*0.05) + arc_x)
							y = ((bar3_start+bar_height/2) - arc_y)
						if graphics_style == "sphere":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "dome":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "earth":
							x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0) + arc_x
							y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) - arc_y
						if graphics_style == "horizon":
							x = (moon_az / 360.0) * width + arc_x
							y = ((90 -moon_alt) / 90.0) * (width / 4.0) - arc_y
						if arc_start == True:
							cr.move_to(x,y)
							arc_start = False
						else:
							cr.line_to(x,y)

					view_az = 0
					view_alt = 0
					az_degrees = asin((moon_full_pct - 50)/50) * 180/pi
					az = az_degrees * pi/180
					for alt_degrees in range(-90,90,9):
						alt = alt_degrees * pi/180
						arc_x = size * cos(alt)*sin(az-view_az)
						arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
						if graphics_style == "moon":
							x = ((image_width / 2.0) + arc_x)
							y = ((image_height / 2.0) - arc_y)
						if graphics_style == "bar":
							x = ((width*0.9*mp+width*0.05) + arc_x)
							y = ((bar3_start+bar_height/2) - arc_y)
						if graphics_style == "sphere":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "dome":
							x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
							y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
						if graphics_style == "earth":
							x = (moon_long/180.0) * (image_width/2.0) + (image_width/2.0) + arc_x
							y = ((moon_lat/90.0) * (image_height/2.0) + (image_height/2.0)) - arc_y
						if graphics_style == "horizon":
							x = (moon_az / 360.0) * width + arc_x
							y = ((90 -moon_alt) / 90.0) * (width / 4.0) - arc_y
						cr.line_to(x,y)

				if graphics_style in ["bar", "sphere", "dome", "earth", "horizon"]:
					cr.set_source_rgb(1,1,1)

				if graphics_style == "moon":
					cr.set_source_rgb(0,0,0)

				cr.paint_with_alpha(0.1)
				cr.fill()
				cr.stroke()
				cr.close_path()

				if graphics_style == "moon":
					cr.set_source_surface(image2, 0, 0)
					cr.paint_with_alpha(0.3)

		moon_previous_new = ephem.localtime(ephem.previous_new_moon(local.date))
		moon_previous_first_quarter = ephem.localtime(ephem.previous_first_quarter_moon(local.date))
		moon_previous_full = ephem.localtime(ephem.previous_full_moon(local.date))
		moon_previous_last_quarter = ephem.localtime(ephem.previous_last_quarter_moon(local.date))

		moon_next_last_quarter = ephem.localtime(ephem.next_last_quarter_moon(local.date))
		moon_next_new = ephem.localtime(ephem.next_new_moon(local.date))
		moon_next_first_quarter = ephem.localtime(ephem.next_first_quarter_moon(local.date))
		moon_next_full = ephem.localtime(ephem.next_full_moon(local.date))
	
		moon_age = local.date - ephem.date(moon_previous_new)

		if text_flag == "on" and graphics_style not in ["pole"]:
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.set_line_width(1.0)
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*4)
			cr.text_path("MOON FULL/AGE: " + str(round(moon_full_pct)) + "%" + " / " + "%1.1f" % moon_age + " days")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*6)
			cr.text_path("NEW MOON:      " + str(moon_next_new)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*8)
			cr.text_path("FIRST QUARTER: " + str(moon_next_first_quarter)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*10)
			cr.text_path("FULL MOON:     " + str(moon_next_full)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*12)
			cr.text_path("LAST QUARTER:  " + str(moon_next_last_quarter)[:19])
			cr.fill()
			cr.stroke()

		toggle_x = 0

		if text_flag == "on":
			cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
		else:
                        cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
		cr.rectangle(toggle_x, height-20, 20, 20)
		cr.fill()
		cr.stroke()
                cr.set_source_rgb(1.00, 1.00, 1.00)
		cr.move_to(toggle_x + 5, height-7)
		cr.text_path("T")
		cr.fill()
		cr.stroke()

		toggle_x = toggle_x + 25
		if full_window_flag == "on":
			cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
		else:
                        cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
		cr.rectangle(toggle_x, height-20, 20, 20)
		cr.fill()
		cr.stroke()
                cr.set_source_rgb(1.00, 1.00, 1.00)
		cr.move_to(toggle_x + 5, height-7)
		cr.text_path("F")
		cr.fill()
		cr.stroke()

		toggle_x = toggle_x + 25
		if clock_flag == "on":
			cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
		else:
                        cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
		cr.rectangle(toggle_x, height-20, 20, 20)
		cr.fill()
		cr.stroke()
                cr.set_source_rgb(1.00, 1.00, 1.00)
		cr.move_to(toggle_x + 5, height-7)
		cr.text_path("C")
		cr.fill()
		cr.stroke()

		toggle_x = toggle_x + 25
		if gps_mode in ["on", "lock"]:
			cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
		else:
                        cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
		cr.rectangle(toggle_x, height-20, 20, 20)
		cr.fill()
		cr.stroke()
                cr.set_source_rgb(1.00, 1.00, 1.00)
		cr.move_to(toggle_x + 5, height-7)
		cr.text_path("G")
		cr.fill()
		cr.stroke()

		#toggle_x = toggle_x + 25
		#if grid_flag == "on":
		#	cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
		#else:
                #        cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
		#cr.rectangle(toggle_x, height-20, 20, 20)
		#cr.fill()
		#cr.stroke()
                #cr.set_source_rgb(1.00, 1.00, 1.00)
		#cr.move_to(toggle_x + 5, height-7)
		#cr.text_path("G")
		#cr.fill()
		#cr.stroke()

                if len(graphics_style_all) >= 2: # do not draw label if only one choice
			choice_x = toggle_x + 30
			if graphics_style == graphics_style_all[0]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[0][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[1]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[1][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                if len(graphics_style_all) >= 3:
			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[2]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[2][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                if len(graphics_style_all) >= 4:
			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[3]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[3][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                if len(graphics_style_all) >= 5:
			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[4]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[4][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                if len(graphics_style_all) >= 6:
			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[5]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[5][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                if len(graphics_style_all) >= 7:
			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[6]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[6][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                if len(graphics_style_all) >= 8:
			choice_x = choice_x + 25
			if graphics_style == graphics_style_all[7]:
				cr.set_source_rgba(0.00, 1.00, 0.00, 0.50)
			else:
                        	cr.set_source_rgba(0.00, 0.00, 1.00, 0.50) 
                        cr.rectangle(choice_x, height-20, 20, 20)
                        cr.fill()
                        cr.stroke()
                	cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(choice_x + 5, height-7)
                        label = string.upper(graphics_style_all[7][:1])
                        cr.text_path(label)
                        cr.fill()
                        cr.stroke()

                cr.set_source_rgb(1.00, 1.00, 1.00)

		return False

	def pie_slice(self, start_pos, stop_pos, radius, color):

		angle1a = start_pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])

		cr.move_to(circle_x_center, circle_y_center)
		cr.rel_line_to(radius * math.cos(angle1b), radius * math.sin(angle1b))

		angle2a = stop_pos * 360
		angle2b = (angle2a+90)*pi/180

		cr.arc(circle_x_center, circle_y_center, radius, angle1b, angle2b)

		cr.move_to(circle_x_center, circle_y_center)

		cr.fill()
		cr.stroke()
		cr.close_path()

		return

	def radial_line(self, pos, radius, color):

		angle1a = pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])

		cr.move_to(circle_x_center, circle_y_center)
		cr.rel_line_to(radius * math.cos(angle1b), radius * math.sin(angle1b))
		cr.stroke()

		return

	def radial_ball(self, pos, radius1, radius2, color, fill):

		angle1a = pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])
		cr.arc(circle_x_center + (radius1 * math.cos(angle1b)), circle_y_center + (radius1 * math.sin(angle1b)), radius2, 0, 2.0*3.14)
		if fill == True:
			cr.fill()	
		cr.stroke()

		return

	def radial_text(self, pos, radius1, color, text):

		angle1a = pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])
		cr.move_to(circle_x_center + (radius1 * math.cos(angle1b)), circle_y_center + (radius1 * math.sin(angle1b)))
		cr.text_path(text)
		cr.fill()	
		cr.stroke()

		return

	def resize_window(self):

		if text_flag == "on":
			if graphics_style == "info":
				#self.set_size_request(330, 300)
				self.set_size_request(330, 400)
			if graphics_style == "bar":
				self.set_size_request(330, 400)
			if graphics_style == "sphere":
				self.set_size_request(330, 400)
			if graphics_style == "dome":
				self.set_size_request(330, 400)
			if graphics_style == "moon":
				self.set_size_request(330, 290)
			if graphics_style == "earth":
				self.set_size_request(400, 400)
			if graphics_style == "horizon":
				self.set_size_request(400, 400)
			if graphics_style == "pole":
				self.set_size_request(330, 300)
			if full_window_flag == "on":
				self.set_size_request(720, 400)
		else:
			if graphics_style == "info":
				#self.set_size_request(330, 190)
				self.set_size_request(330, 140)
			if graphics_style == "bar":
				self.set_size_request(330, 190)
			if graphics_style == "sphere":
				self.set_size_request(330, 370)
			if graphics_style == "dome":
				self.set_size_request(330, 370)
			if graphics_style == "moon":
				self.set_size_request(300, 220)
			if graphics_style == "earth":
				self.set_size_request(400, 220)
			if graphics_style == "horizon":
				self.set_size_request(400, 220)
			if graphics_style == "pole":
				self.set_size_request(330, 370)
			if full_window_flag == "on":
				self.set_size_request(720, 400)

		return

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha

		# To check if the display supports alpha channels, get the colormap
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
			supports_alpha = True
    
		# Now we have a colormap appropriate for the screen, use it
		self.set_colormap(colormap)
    
		return False
	
	def unrealize(self, widget, date=None):
		# cancel timeout
		if self.timer:
			v = gobject.source_remove(self.timer)
			self.timer = None

	def set_timer(self, widget, on):
		global graphics_style_pos 
		global graphics_style

		# when called first time from __init__ widget is None
		if self.timer != None:
			gobject.source_remove(self.timer)
		if on:
			delay = 60000 
			self.timer = gobject.timeout_add(delay, self.update)
			# repaint immediately when coming to the foreground
			self.update()

	def update(self):
		self.queue_draw()
		return True

def hd_plugin_get_objects():
	global local
	global graphics_style_all 
	global graphics_style_pos 
	global graphics_style
	global text_flag
	global gps_mode
	global gps_timeout
	global gps_time
	global startup_lat
	global startup_long
	global planet_flag
	global star_flag
	global astro_sign
	global trails_flag
	global full_window_flag
	global clock_flag
	global grid_flag
	global reset_flag
	global event_x
	global event_y
	global prev_event_x
	global prev_event_y
	global counter

	config = ConfigParser.ConfigParser()
	ini_file = '/usr/lib/hildon-desktop/mchronos.ini'
	config.read(ini_file)
	startup_long = config.get("location","longitude")
	startup_lat = config.get("location","latitude")
	gps_mode = config.get("gps","mode")
	gps_timeout = config.get("gps","timeout")
	gps_time = config.get("gps","time")
	graphics_style_all = config.get("style","graphics").split()
	text_flag = config.get("style","text")
	astro_flag = config.get("style","astro")
	trails_flag = config.get("style","trails")
	grid_flag = config.get("style","grid")

	graphics_style_pos = 0 # test
	graphics_style = graphics_style_all[graphics_style_pos] # test

	local = ephem.Observer()
	local.long = startup_long
	local.lat = startup_lat

	planet_flag = "off"
	star_flag = "off"
	full_window_flag = "off"
	clock_flag = "off"
	reset_flag = "off"

	if astro_flag == "on":
		astro_sign = -1
	else:
		astro_sign = 1

	event_x = 0
	event_y = 0

	prev_event_x = 0
	prev_event_y = 0

	counter = 0

	plugin = mchronos()
	return [plugin]
