#/usr/bin/env python2.5

"""
mchronos.py
version 0.22

This is a simple PyGTK GUI applet intended to display astronomical
time information.  The application relies heavily upon a ported
version of the 'PyEphem' library created by Brandon Craig Rhodes.

More information about PyEphem is available at:

http://rhodesmill.org/pyephem/

More information about Python and PyGTK is available at:

http://www.python.org/
http://www.pygtk.org/

Copyright (C) 2008 Darren Enns <dmenns1@gmail.com>

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or (at
your option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
USA.
"""

import sys
import gobject
import pango
import pygtk
pygtk.require('2.0')
import gtk
from gtk import gdk
import hildondesktop
import cairo
from datetime import datetime
import gobject
import math
import ephem
import os
import time
from math import pi, sin, cos, asin
import calendar
import ConfigParser

try:
        import gpsbt
        gpsbt_flag = True
except ImportError:
        gpsbt_flag = False

# set this to False to disable display of seconds and update 
# only once per minute (saves CPU cycles on the tablet)
enable_seconds = False

supports_alpha = False
gps_lock = False

class mchronos(hildondesktop.HomeItem):
	def __init__(self):
		hildondesktop.HomeItem.__init__(self)
	
		self.set_resize_type(hildondesktop.HOME_ITEM_RESIZE_BOTH)

		if text_flag == "on":
			if graphics_style == "bar":
				self.set_size_request(300, 400)
			if graphics_style == "circle":
				self.set_size_request(300, 440)
		else:
			if graphics_style == "bar":
				self.set_size_request(300, 170)
			if graphics_style == "circle":
				self.set_size_request(300, 300)

		self.connect("expose-event", self.expose)
		self.connect("screen-changed", self.screen_changed)
		self.connect ("background", self.set_timer, False)
		self.connect ("foreground", self.set_timer, True)
		self.connect ("unrealize", self.unrealize)

		# set a timeout to update the clock, depending
		# on whether we are in the foreground or background
		self.timer = None
		self.set_timer(self, True)

		self.show_all()

	def expose(self, widget, event):

		global supports_alpha
		global local
		global width, height
		global cr
		global circle_x_center, circle_y_center

		gps_lock = False

		if gpsbt_flag == True and (gps_mode == "on" or (gps_mode == "lock" and gps_lock == False)):
			context = gpsbt.start()

			if context == None:
				#local.lat = startup_lat
				#local.long = startup_long
				gps_lock = False
			else:
				# ensure that GPS device is ready to connect and to receive commands
				time.sleep(2)
				gpsdevice = gpsbt.gps()

				gpsdevice.get_fix()

				gps_timer = 0

				while gpsdevice.get_position()[0] == 0.0:
					time.sleep(1)
					gps_timer = gps_timer + 1
					if gps_timer > int(gps_timeout):
						break

				if gpsdevice.fix.latitude == 0.0:
					local.lat = startup_lat
					local.long = startup_long
					gps_lock = False
				else:
					local.lat = str(gpsdevice.fix.latitude)
					local.long = str(gpsdevice.fix.longitude)
					if gps_time == "on":
						gps_seconds = gpsdevice.fix.time
						if gps_seconds != 10000000000.0:
							local.date = time.gmtime(gps_seconds)[0:6]
					else:
						local.date = ephem.now()
					gps_lock = True

				# ends Bluetooth connection
				gpsbt.stop(context)
		else:
			local.date = ephem.now()

		width, height = self.allocation[2], self.allocation[3]

		#Get a cairo context
		cr = widget.window.cairo_create()

		if supports_alpha == True:
			if text_flag == "on" or graphics_style == "bar":
				cr.set_source_rgba(.0, .0, .0, 0.5) # Transparent black
			else:
				cr.set_source_rgba(1.0, 1.0, 1.0, 0.0) # Transparent white
		else:
			cr.set_source_rgb(1.0, 1.0, 1.0) # Opaque white

		# Draw the background
		cr.set_operator(cairo.OPERATOR_SOURCE)
		cr.paint()

		screen_size = self.get_size_request()
		screen_width = screen_size[0]
		screen_height = screen_size[1]
		screen_ratio = 400.0 / screen_height
	
		top_start = height * 0.03 
		font_size = 11

		if text_flag == "on":
			text_height = height * 0.015 * screen_ratio
			circle_x_center = width * 0.5
			circle_y_center = height * 0.3
		else:
			text_height = 0.0
			circle_x_center = width * 0.5
			circle_y_center = height * 0.5

		if graphics_style == "bar":
			bar_height = height * 0.07 * screen_ratio
			tic_height = height * 0.02 * screen_ratio
			section_gap = height * 0.02 * screen_ratio
		else:
			bar_height = 0.0
			tic_height = 0.0
			section_gap = height * 0.01 * screen_ratio

		if graphics_style == "circle":
			if text_flag == "off":
				circle1 = width / 2
			else:
				circle1 = width / 3
			circle2 = circle1 * 2/3
			circle3 = circle1 * 1/3
			circ_diff = (circle1 - circle2)/2

			sun_day_circle = circle1
			sun_year_circle = circle2
			moon_month_circle = circle3
			#sun_day_circle = circle1
			#moon_month_circle = circle2
			#sun_year_circle = circle3

		size = height * 0.035 * screen_ratio

		if graphics_style == "bar":
			bar1_start = top_start + (text_height*6) + section_gap
		else:
			bar1_start = height * 0.5
		bar2_start = bar_height + tic_height*2 + (text_height * 10) + section_gap + bar1_start
		bar3_start = bar_height + tic_height*2 + (text_height * 10) + section_gap + bar2_start

		save = local.date
		
		sun = ephem.Sun()
		sun.compute(local)
		
		moon = ephem.Moon()
		moon.compute(local)

		# day section

		timezone_offset = ephem.date(local.date)-ephem.date(ephem.localtime(local.date))
		timezone_hour = round(-timezone_offset * 24)
		start_of_day = ephem.date(str(local.date.tuple()[0])+'/'+str(local.date.tuple()[1])+'/'+str(local.date.tuple()[2])+' 00:00') #reset to start of day GMT
		local.date = start_of_day+timezone_offset # compensate for differing time zone

		sun_antitransit = local.next_antitransit(sun)
		local.date = save
		
		sun_transit = local.next_transit(sun)
		local.date = save
		
		local.horizon = '-18:00:00'
		sun_astro_twilight_dawn = local.next_rising(sun)
		sun_astro_twilight_dusk = local.next_setting(sun)
		
		local.horizon = '-12:00:00'
		sun_naut_twilight_dawn = local.next_rising(sun)
		sun_naut_twilight_dusk = local.next_setting(sun)
		
		local.horizon = '-06:00:00'
		sun_civil_twilight_dawn = local.next_rising(sun)
		sun_civil_twilight_dusk = local.next_setting(sun)
		
		local.horizon = '00:00:00'
		sun_rise = local.next_rising(sun)
		sun_set = local.next_setting(sun)
		
		moon_antitransit = local.next_antitransit(moon)
		local.date = save
		
		moon_transit = local.next_transit(moon)
		local.date = save
		
		moon_rise = local.next_rising(moon)	
		moon_set = local.next_setting(moon)	

		#local.date = ephem.now()
		local.date = save
	
	 	sun_now = local.date
 	
		local_sun_antitransit = ephem.Date(ephem.localtime(sun_antitransit))
		local_sun_astro_twilight_dawn = ephem.Date(ephem.localtime(sun_astro_twilight_dawn))
		local_sun_naut_twilight_dawn = ephem.Date(ephem.localtime(sun_naut_twilight_dawn))
		local_sun_civil_twilight_dawn = ephem.Date(ephem.localtime(sun_civil_twilight_dawn))
		local_sun_rise = ephem.Date(ephem.localtime(sun_rise))
		local_sun_transit = ephem.Date(ephem.localtime(sun_transit))
		local_sun_set = ephem.Date(ephem.localtime(sun_set))
		local_sun_civil_twilight_dusk = ephem.Date(ephem.localtime(sun_civil_twilight_dusk))
		local_sun_naut_twilight_dusk = ephem.Date(ephem.localtime(sun_naut_twilight_dusk))
		local_sun_astro_twilight_dusk = ephem.Date(ephem.localtime(sun_astro_twilight_dusk))
		local_sun_now = ephem.Date(ephem.localtime(local.date))
		
		local_moon_antitransit = ephem.Date(ephem.localtime(moon_antitransit))
		local_moon_rise = ephem.Date(ephem.localtime(moon_rise))
		local_moon_transit = ephem.Date(ephem.localtime(moon_transit))
		local_moon_set = ephem.Date(ephem.localtime(moon_set))

		local_sun_antitransit_hour = local_sun_antitransit.triple()[2] - int(local_sun_antitransit.triple()[2])
		local_sun_astro_twilight_dawn_hour = local_sun_astro_twilight_dawn.triple()[2] - int(local_sun_astro_twilight_dawn.triple()[2])
		local_sun_naut_twilight_dawn_hour = local_sun_naut_twilight_dawn.triple()[2] - int(local_sun_naut_twilight_dawn.triple()[2])
		local_sun_civil_twilight_dawn_hour = local_sun_civil_twilight_dawn.triple()[2] - int(local_sun_civil_twilight_dawn.triple()[2])
		local_sun_rise_hour = local_sun_rise.triple()[2] - int(local_sun_rise.triple()[2])
		local_sun_transit_hour = local_sun_transit.triple()[2] - int(local_sun_transit.triple()[2])
		local_sun_set_hour = local_sun_set.triple()[2] - int(local_sun_set.triple()[2])
		local_sun_civil_twilight_dusk_hour = local_sun_civil_twilight_dusk.triple()[2] - int(local_sun_civil_twilight_dusk.triple()[2])
		local_sun_naut_twilight_dusk_hour = local_sun_naut_twilight_dusk.triple()[2] - int(local_sun_naut_twilight_dusk.triple()[2])
		local_sun_astro_twilight_dusk_hour = local_sun_astro_twilight_dusk.triple()[2] - int(local_sun_astro_twilight_dusk.triple()[2])
		local_sun_now_hour = local_sun_now.triple()[2] - int(local_sun_now.triple()[2])
	
		day_length = round((local_sun_set_hour - local_sun_rise_hour) * 24,1)
	
		#current_local_date = ephem.now()
		current_local_date = sun_now
	
		if (local_sun_now_hour < local_sun_astro_twilight_dawn_hour):
			sun_phase = " Night"
		if (local_sun_now_hour >= local_sun_astro_twilight_dawn_hour) and (local_sun_now_hour < local_sun_naut_twilight_dawn_hour):
			#sun_phase = " Astronomical Twilight"
			sun_phase = " Dawn"
		if (local_sun_now_hour >= local_sun_naut_twilight_dawn_hour) and (local_sun_now_hour < local_sun_civil_twilight_dawn_hour):
			#sun_phase = " Nautical Twilight"
			sun_phase = " Dawn"
		if (local_sun_now_hour >= local_sun_civil_twilight_dawn_hour) and (local_sun_now_hour < local_sun_rise_hour):
			#sun_phase = " Civil Twilight"
			sun_phase = " Dawn"
		if (local_sun_now_hour >= local_sun_rise_hour) and (local_sun_now_hour < local_sun_set_hour):
			sun_phase = " Daylight"
		if (local_sun_now_hour >= local_sun_set_hour) and (local_sun_now_hour < local_sun_civil_twilight_dusk_hour):
			#sun_phase = " Civil Twilight"
			sun_phase = " Dusk"
		if (local_sun_now_hour >= local_sun_civil_twilight_dusk_hour) and (local_sun_now_hour < local_sun_naut_twilight_dusk_hour):
			#sun_phase = " Nautical Twilight"
			sun_phase = " Dusk"
		if (local_sun_now_hour >= local_sun_naut_twilight_dusk_hour) and (local_sun_now_hour < local_sun_astro_twilight_dusk_hour):
			#sun_phase = " Astronomical Twilight"
			sun_phase = " Dusk"
		if (local_sun_now_hour >= local_sun_astro_twilight_dusk_hour):
			sun_phase = " Night"

		if ((ephem.date(local.date)-ephem.date(ephem.localtime(local.date)))*24) == (time.timezone/60/60):
			local_time_zone_daylight_flag = 0
		else:
			local_time_zone_daylight_flag = time.daylight

		local_time_zone_name = time.tzname
		zone = local_time_zone_name[local_time_zone_daylight_flag]

		week_days = ["Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"]
		day_of_week = week_days[time.localtime(time.time())[6]]
	
		cr.set_source_rgb(1.00, 1.00, 1.00)
		cr.select_font_face("Courier", cairo.FONT_SLANT_NORMAL, cairo.FONT_WEIGHT_BOLD)
		cr.set_font_size(font_size*1.3)

		# day circle
		if graphics_style == "circle":
			# night slice

			radius = sun_day_circle
			radius2 = sun_day_circle - circ_diff

			red_inc = 0
			green_inc = 0
			blue_inc = 0

			for mult_pos in range(int(local_sun_astro_twilight_dawn_hour*10000), int(local_sun_rise_hour*10000), int((local_sun_rise_hour-local_sun_astro_twilight_dawn_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_rise_hour-local_sun_astro_twilight_dawn_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.0015625
				green_inc = green_inc + 0.0515625
				blue_inc = blue_inc + 0.0984375
				self.pie_slice(start_pos, stop_pos, radius, color)

			start_pos = 0
			stop_pos = local_sun_astro_twilight_dawn_hour
			color = [0,0,0]
			self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 0.015625
			green_inc = 0.515625
			blue_inc = 0.984375

			for mult_pos in range(int(local_sun_rise_hour*10000), int(local_sun_transit_hour*10000), int((local_sun_transit_hour-local_sun_rise_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_transit_hour-local_sun_rise_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.0984375
				green_inc = green_inc + 0.0484375
				blue_inc = blue_inc + 0.0015625
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 1 
			blue_inc = 1

			for mult_pos in range(int(local_sun_transit_hour*10000), int(local_sun_set_hour*10000), int((local_sun_set_hour-local_sun_transit_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_set_hour-local_sun_transit_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.0984375
				green_inc = green_inc - 0.0484375
				blue_inc = blue_inc - 0.0015625
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 0.015625
			green_inc = 0.515625
			blue_inc = 0.984375

			for mult_pos in range(int(local_sun_set_hour*10000), int(local_sun_astro_twilight_dusk_hour*10000), int((local_sun_astro_twilight_dusk_hour-local_sun_set_hour)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (local_sun_astro_twilight_dusk_hour-local_sun_set_hour)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.0015625
				green_inc = green_inc - 0.0515625
				blue_inc = blue_inc - 0.0984375
				self.pie_slice(start_pos, stop_pos, radius, color)

			start_pos = local_sun_astro_twilight_dusk_hour
			stop_pos = 1
			color = [0, 0, 0]
			self.pie_slice(start_pos, stop_pos, radius, color)

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.set_line_width(1.0)

			pos = local_sun_antitransit_hour
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = local_sun_astro_twilight_dawn_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_naut_twilight_dawn_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_civil_twilight_dawn_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_rise_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_transit_hour
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = local_sun_set_hour
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = local_sun_civil_twilight_dusk_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_naut_twilight_dusk_hour
			self.radial_line(pos, radius, color)

			pos = local_sun_astro_twilight_dusk_hour
			self.radial_line(pos, radius, color)

			#pos = local_sun_now_hour
			#self.radial_line(pos, radius, color)

			pos = local_sun_now_hour
			color = [1.00, 1.00, 0.00]
			self.radial_ball(pos, radius2, size, color, True)

			if gps_mode == "on" or gps_mode == "lock":
				if gps_mode == "on":
					if gps_lock == True: 
						color = [0.00, 1.00, 0.00]
					else:
						color = [1.00, 0.00, 0.00]

				if gps_mode == "lock":
					if gps_lock == True: 
						color = [1.00, 0.65, 0.00]
					else:
						color = [1.00, 0.00, 0.00]

				self.radial_ball(pos, radius2, size/2, color, True)

			pos = local_sun_now_hour
			color = [1.00, 0.50, 0.50]
			self.radial_ball(pos, radius2, size, color, False)

		# day bars
		if graphics_style == "bar":
			cr.set_source_rgb(0.00, 0.00, 0.00)

			cr.rectangle(width*0.05,bar1_start,width*0.90*local_sun_astro_twilight_dawn_hour,bar_height)
			cr.fill()
			cr.stroke()
			
			pat = cairo.LinearGradient(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,0,width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05+width*0.9*(local_sun_rise_hour-local_sun_astro_twilight_dawn_hour),0)
			pat.add_color_stop_rgb(0.0, 0, 0, 0)
			pat.add_color_stop_rgb(1.0, 0.015625,0.515625,0.984375)

			cr.rectangle(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,bar1_start,width*0.9*(local_sun_rise_hour-local_sun_astro_twilight_dawn_hour),bar_height)
			cr.set_source(pat)
			cr.fill()

			pat = cairo.LinearGradient(width*0.9*local_sun_rise_hour+width*0.05,0,width*0.9*local_sun_rise_hour+width*0.05+width*0.9*(local_sun_set_hour-local_sun_rise_hour),0)
			pat.add_color_stop_rgb(0.0, 0.015625,0.515625,0.984375)
			pat.add_color_stop_rgb(0.5, 1, 1, 1)
			pat.add_color_stop_rgb(1.0, 0.015625,0.515625,0.984375)

			cr.rectangle(width*0.9*local_sun_rise_hour+width*0.05,bar1_start,width*0.9*(local_sun_set_hour-local_sun_rise_hour),bar_height)
			cr.set_source(pat)
			cr.fill()
			
			pat = cairo.LinearGradient(width*0.9*local_sun_set_hour+width*0.05,0,width*0.9*local_sun_set_hour+width*0.05+width*0.9*(local_sun_astro_twilight_dusk_hour-local_sun_set_hour),0)
			pat.add_color_stop_rgb(0.0, 0.015625,0.515625,0.984375)
			pat.add_color_stop_rgb(1.0, 0, 0, 0)

			cr.rectangle(width*0.9*local_sun_set_hour+width*0.05,bar1_start,width*0.9*(local_sun_astro_twilight_dusk_hour-local_sun_set_hour),bar_height)
			cr.set_source(pat)
			cr.fill()
			
			cr.rectangle(width*0.9*local_sun_astro_twilight_dusk_hour+width*0.05,bar1_start,width*0.9*(1-local_sun_astro_twilight_dusk_hour),bar_height)
			cr.set_source_rgb(0.00, 0.00, 0.00)
			cr.fill()
			cr.stroke()
	
			cr.move_to(width*0.9*local_sun_antitransit_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_antitransit_hour+width*0.05,bar1_start+bar_height)
			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_astro_twilight_dawn_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_naut_twilight_dawn_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_naut_twilight_dawn_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_civil_twilight_dawn_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_civil_twilight_dawn_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_rise_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_rise_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_transit_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_transit_hour+width*0.05,bar1_start+bar_height)
			cr.set_source_rgb(0.00, 0.00, 0.00)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_set_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_set_hour+width*0.05,bar1_start+bar_height)
			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_civil_twilight_dusk_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_civil_twilight_dusk_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_naut_twilight_dusk_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_naut_twilight_dusk_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_astro_twilight_dusk_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_astro_twilight_dusk_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()
			
			cr.move_to(width*0.9*local_sun_now_hour+width*0.05,bar1_start)
			cr.line_to(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height)
			cr.stroke()

			cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(1.00, 1.00, 0.00)
			cr.fill()
			cr.stroke()

			if gps_mode == "on" or gps_mode == "lock":
				#cr.set_font_size(font_size*1.3)

				if gps_mode == "on":
					cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size/2, 0, 2.0*3.14)
					if gps_lock == True: 
						cr.set_source_rgb(0.00, 1.00, 0.00)
						#if gps_time == "on":
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.03,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("LT")
						#else:
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.04,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("L")
						#cr.fill()
						#cr.stroke()
						cr.set_source_rgb(0.00, 1.00, 0.00)
					else:
						cr.set_source_rgb(1.00, 0.00, 0.00)
					cr.fill()
					cr.stroke()

				if gps_mode == "lock":
					cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size/2, 0, 2.0*3.14)
					if gps_lock == True: 
						cr.set_source_rgb(1.00, 0.65, 0.00)
						#if gps_time == "on":
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.03,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("LT")
						#else:
						#	cr.move_to(width*0.9*local_sun_now_hour+width*0.04,bar1_start+bar_height/2+height*0.02)
						#	cr.text_path("L")
						#cr.fill()
						#cr.stroke()
						cr.set_source_rgb(1.00, 0.65, 0.00)
					else:
						cr.set_source_rgb(1.00, 0.00, 0.00)
					cr.fill()
					cr.stroke()

				#cr.set_font_size(font_size)

			cr.arc(width*0.9*local_sun_now_hour+width*0.05,bar1_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(1.00, 0.50, 0.50)
			cr.set_line_width(0.8)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)

			for hour in range(0,25,1):
				sun_hour = hour/24.0
				cr.move_to(width*0.9*sun_hour+width*0.05,bar1_start+bar_height)
				cr.line_to(width*0.9*sun_hour+width*0.05,bar1_start+bar_height+tic_height)
				cr.set_line_width(1.0)
				cr.stroke()
				if hour%3 == 0:
					#cr.move_to(width*0.9*sun_hour-width/50+width*0.05,bar1_start+bar_height+tic_height+text_height*1.5)
					cr.move_to(width*0.9*sun_hour-width/50+width*0.05,bar1_start+bar_height+tic_height*2)
					cr.set_font_size(font_size)
					cr.text_path(str(hour))
					cr.fill()
					cr.stroke()
		
		# day text
		if text_flag == "on":
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.move_to(width*0.01,top_start)
			cr.text_path("LOCAL DATE:      " + str(local_sun_now)[:10] + " " + day_of_week)
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,top_start+text_height*2)
			cr.text_path("LOCAL TIME:      " + str(local_sun_now.tuple()[3]).zfill(2)+":"+str(local_sun_now.tuple()[4]).zfill(2) + " " + zone + " [UTC" + '%+2.1f' % timezone_hour + "]")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,top_start+text_height*4)
			cr.text_path("LOCAL LATITUDE:  " + str(local.lat) + u"\xb0")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,top_start+text_height*6)
			cr.text_path("LOCAL LONGITUDE: " + str(local.long) + u"\xb0")
			cr.fill()
			cr.stroke()

			cr.set_font_size(font_size)

			cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*4)
			cr.text_path("SUN PHASE:" + sun_phase)
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*6)
			cr.text_path("SUN RISE: " + str(local_sun_rise)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*8)
			cr.text_path("SUN SET:  " + str(local_sun_set)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*10)
			cr.text_path("SUN MIN:  " + str(local_sun_antitransit)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar1_start+bar_height+tic_height+text_height*12)
			cr.text_path("SUN MAX:  " + str(local_sun_transit)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.5+width*0.05,bar1_start+bar_height+tic_height+text_height*4)
			cr.text_path("DAYLENGTH: " + str(day_length) + " hrs")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.5+width*0.05,bar1_start+bar_height+tic_height+text_height*6)
			cr.text_path("MOON RISE:" + str(local_moon_rise)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.5+width*0.05,bar1_start+bar_height+tic_height+text_height*8)
			cr.text_path("MOON SET: " + str(local_moon_set)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.5+width*0.05,bar1_start+bar_height+tic_height+text_height*10)
			cr.text_path("MOON MIN: " + str(local_moon_antitransit)[10:])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.5+width*0.05,bar1_start+bar_height+tic_height+text_height*12)
			cr.text_path("MOON MAX: " + str(local_moon_transit)[10:])
			cr.fill()
			cr.stroke()

		# season section

		local.date = save

		current_year = local.date.tuple()[0]
		first_year_day = ephem.date(str(current_year)+"/01/01")
		last_year_day = ephem.date(str(current_year+1)+"/01/01")
		days_in_year = last_year_day-first_year_day
		#local_date = ephem.localtime(ephem.now())
		local_date = ephem.localtime(local.date)
		current_year_day = ephem.date(local_date) - first_year_day
		local_year_day = current_year_day / days_in_year
	
		spring_date = ephem.localtime(ephem.next_equinox(ephem.date(str(first_year_day.tuple()[0]))))
		summer_date = ephem.localtime(ephem.next_solstice(spring_date))
		fall_date = ephem.localtime(ephem.next_equinox(summer_date))
		winter_date = ephem.localtime(ephem.next_solstice(fall_date))
		spring_year_day = (ephem.date(spring_date) - first_year_day) / days_in_year
		summer_year_day = (ephem.date(summer_date) - first_year_day) / days_in_year
		fall_year_day = (ephem.date(fall_date) - first_year_day) / days_in_year
		winter_year_day = (ephem.date(winter_date) - first_year_day) / days_in_year

		if (local_year_day >= spring_year_day) and (local_year_day < summer_year_day):
			season = "Spring"
		if (local_year_day >= summer_year_day) and (local_year_day < fall_year_day):
			season = "Summer"
		if (local_year_day >= fall_year_day) and (local_year_day < winter_year_day):
			season = "Fall"
		if (local_year_day >= winter_year_day) or (local_year_day < spring_year_day):
			season = "Winter"
			
		month_year_day = ([])
	
		jan_date = ephem.date(str(current_year)+"/01/01")
		feb_date = ephem.date(str(current_year)+"/02/01")	
		mar_date = ephem.date(str(current_year)+"/03/01")	
		apr_date = ephem.date(str(current_year)+"/04/01")	
		may_date = ephem.date(str(current_year)+"/05/01")	
		jun_date = ephem.date(str(current_year)+"/06/01")	
		jul_date = ephem.date(str(current_year)+"/07/01")	
		aug_date = ephem.date(str(current_year)+"/08/01")	
		sep_date = ephem.date(str(current_year)+"/09/01")	
		oct_date = ephem.date(str(current_year)+"/10/01")	
		nov_date = ephem.date(str(current_year)+"/11/01")	
		dec_date = ephem.date(str(current_year)+"/12/01")	

		jan_year_day = (jan_date - first_year_day + 1) / days_in_year
		month_year_day.append([jan_year_day, "J"])
		feb_year_day = (feb_date - first_year_day + 1) / days_in_year
		month_year_day.append([feb_year_day, "F"])
		mar_year_day = (mar_date - first_year_day + 1) / days_in_year
		month_year_day.append([mar_year_day, "M"])
		apr_year_day = (apr_date - first_year_day + 1) / days_in_year
		month_year_day.append([apr_year_day, "A"])
		may_year_day = (may_date - first_year_day + 1) / days_in_year
		month_year_day.append([may_year_day, "M"])
		jun_year_day = (jun_date - first_year_day + 1) / days_in_year
		month_year_day.append([jun_year_day, "J"])
		jul_year_day = (jul_date - first_year_day + 1) / days_in_year
		month_year_day.append([jul_year_day, "J"])
		aug_year_day = (aug_date - first_year_day + 1) / days_in_year
		month_year_day.append([aug_year_day, "A"])
		sep_year_day = (sep_date - first_year_day + 1) / days_in_year
		month_year_day.append([sep_year_day, "S"])
		oct_year_day = (oct_date - first_year_day + 1) / days_in_year
		month_year_day.append([oct_year_day, "O"])
		nov_year_day = (nov_date - first_year_day + 1) / days_in_year
		month_year_day.append([nov_year_day, "N"])
		dec_year_day = (dec_date - first_year_day + 1) / days_in_year
		month_year_day.append([dec_year_day, "D"])

		cr.set_font_size(font_size)
		cr.set_source_rgb(1.00, 1.00, 1.00)

		# season bars
		if graphics_style == "bar":
			pat = cairo.LinearGradient(width*0.05,0,width*0.05+width*0.9,0)
			pat.add_color_stop_rgb(0.00, 1.00, 1.00, 1.00)
			pat.add_color_stop_rgb(spring_year_day, 0.00, 1.00, 0.00)
			pat.add_color_stop_rgb(summer_year_day, 1.00, 0.00, 0.00)
			pat.add_color_stop_rgb(fall_year_day, 1.00, 1.00, 0.00)
			pat.add_color_stop_rgb(winter_year_day, 1.00, 1.00, 1.00)

			cr.rectangle(width*0.05,bar2_start,width*0.9,bar_height)
			cr.set_source(pat)
			cr.fill()

			#cr.set_dash([1],1) 	
			cr.set_line_width(1.0)
			cr.set_source_rgb(0.00, 0.00, 0.00)

			cr.move_to(width*0.9*spring_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*spring_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*summer_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*summer_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*fall_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*fall_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*winter_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*winter_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.move_to(width*0.9*local_year_day+width*0.05,bar2_start)
			cr.line_to(width*0.9*local_year_day+width*0.05,bar2_start+bar_height)
			cr.stroke()

			cr.arc(width*0.9*local_year_day+width*0.05,bar2_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(0.015625,0.515625,0.984375) # light blue sky color
			cr.fill()
			cr.stroke()
		
			cr.arc(width*0.9*local_year_day+width*0.05,bar2_start+bar_height/2, size, 0, 2.0*3.14)
			cr.set_source_rgb(0.00, 0.00, 1.00)
			cr.set_line_width(0.5)
			cr.stroke()
	
			for month_start in month_year_day:
				cr.move_to(width*0.9*month_start[0]+width*0.05,bar2_start+bar_height)
				cr.line_to(width*0.9*month_start[0]+width*0.05,bar2_start+bar_height+tic_height)
				cr.stroke()

				#cr.move_to(width*0.9*month_start[0]-width/50+width*0.05,bar2_start+bar_height+tic_height*2)
				cr.move_to(width*0.9*month_start[0]+width/30+width*0.05,bar2_start+bar_height+tic_height*2)
				cr.text_path(month_start[1])
				cr.set_source_rgb(1.00, 1.00, 1.00)
				cr.fill()
				cr.stroke()

		# season circle
		if graphics_style == "circle":
			radius = sun_year_circle
			radius2 = sun_year_circle - circ_diff

			red_inc = 1
			green_inc = 1 
			blue_inc = 1

			for mult_pos in range(0, int(spring_year_day*10000), int((spring_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (spring_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.1
				green_inc = green_inc - 0
				blue_inc = blue_inc - 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 0
			green_inc = 1 
			blue_inc = 0

			for mult_pos in range(int(spring_year_day*10000), int(summer_year_day*10000), int((summer_year_day-spring_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (summer_year_day-spring_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.1
				green_inc = green_inc - 0.1
				blue_inc = blue_inc - 0
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 0 
			blue_inc = 0

			for mult_pos in range(int(summer_year_day*10000), int(fall_year_day*10000), int((fall_year_day-summer_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (fall_year_day-summer_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0
				green_inc = green_inc + 0.1
				blue_inc = blue_inc - 0
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 1 
			blue_inc = 0

			for mult_pos in range(int(fall_year_day*10000), int(winter_year_day*10000), int((winter_year_day-fall_year_day)*1000)):
				start_pos = mult_pos/10000.0
				stop_pos = start_pos + (winter_year_day-fall_year_day)/10
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0
				green_inc = green_inc + 0
				blue_inc = blue_inc + 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			start_pos = winter_year_day
			stop_pos = 1
			color = [1, 1, 1]
			self.pie_slice(start_pos, stop_pos, radius, color)

			pos = spring_year_day
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = summer_year_day
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = fall_year_day
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = winter_year_day
			self.radial_line(pos, radius, color)

			pos = local_year_day
			color = [0.015625,0.515625,0.984375]
			self.radial_ball(pos, radius2, size, color, True)

			pos = local_year_day
			color = [0.00, 0.00, 1.00]
			self.radial_ball(pos, radius2, size, color, False)

		# season text info
		if text_flag == "on":
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*4)
			cr.text_path("SEASON/DAY: " + season + " / " + "%1.2f" % current_year_day + " [" + str(int(current_year_day)+1) +"]")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*6)
			cr.text_path("SPRING:     " + str(spring_date)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*8)
			cr.text_path("SUMMER:     " + str(summer_date)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*10)
			cr.text_path("FALL:       " + str(fall_date)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar2_start+bar_height+tic_height+text_height*12)
			cr.text_path("WINTER:     " + str(winter_date)[:19])
			cr.fill()
			cr.stroke()

		# moon section

		moon = ephem.Moon()
		moon.compute(local)
		moon_full_pct = moon.phase

		nm = 0.00
		fq = 0.25
		fm = 0.50
		lq = 0.75
		nm2 = 1.00
	
		# moon circle
		if graphics_style == "circle":
			radius = moon_month_circle
			radius2 = moon_month_circle - circ_diff

			red_inc = 0
			green_inc = 0 
			blue_inc = 0

			for mult_pos in range(0, 50, 5):
				start_pos = mult_pos/100.0
				stop_pos = start_pos + 0.1
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc + 0.1
				green_inc = green_inc + 0.1
				blue_inc = blue_inc + 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			red_inc = 1
			green_inc = 1 
			blue_inc = 1

			for mult_pos in range(50, 100, 5):
				start_pos = mult_pos/100.0
				stop_pos = start_pos + 0.1
				color = [red_inc, green_inc, blue_inc]
				red_inc = red_inc - 0.1
				green_inc = green_inc - 0.1
				blue_inc = blue_inc - 0.1
				self.pie_slice(start_pos, stop_pos, radius, color)

			pos = nm
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = fq
			self.radial_line(pos, radius, color)

			pos = fm
			color = [0.00, 0.00, 0.00]
			self.radial_line(pos, radius, color)

			pos = lq
			color = [1.00, 1.00, 1.00]
			self.radial_line(pos, radius, color)

			pos = nm2
			self.radial_line(pos, radius, color)

		# moon bar
		if graphics_style == "bar":
			pat = cairo.LinearGradient(width*0.05,bar3_start,width*.90+width*0.05,bar3_start)
			pat.add_color_stop_rgb(0.0, 0, 0, 0)
			pat.add_color_stop_rgb(0.5, 1, 1, 1)
			pat.add_color_stop_rgb(1.0, 0, 0, 0)

			cr.rectangle(width*0.05,bar3_start,width*0.90,bar_height)
			cr.set_source(pat)
			cr.fill()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm+width*0.05,bar3_start)
			cr.line_to(width*0.9*nm+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*fq+width*0.05,bar3_start)
			cr.line_to(width*0.9*fq+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(0.00, 0.00, 0.00)
			cr.move_to(width*0.9*fm+width*0.05,bar3_start)
			cr.line_to(width*0.9*fm+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*lq+width*0.05,bar3_start)
			cr.line_to(width*0.9*lq+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm2+width*0.05,bar3_start)
			cr.line_to(width*0.9*nm2+width*0.05,bar3_start+bar_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*nm+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*fq+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*fq+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*fm+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*fm+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*lq+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*lq+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.move_to(width*0.9*nm2+width*0.05,bar3_start+bar_height)
			cr.line_to(width*0.9*nm2+width*0.05,bar3_start+bar_height+tic_height)
			cr.stroke()

			cr.set_source_rgb(1.00, 1.00, 1.00)
			cr.set_line_width(1.0)

			cr.move_to(width*0.9*nm-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("NM")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*fq-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("FQ")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*fm-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("FM")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*lq-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("LQ")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.9*nm2-width/50+width*0.05,bar3_start+bar_height+tic_height*2)
			cr.text_path("NM")
			cr.fill()
			cr.stroke()

		save = local.date

		local.date = start_of_day+timezone_offset # compensate for differing time zone

		moon_next_full = ephem.next_full_moon(local.date)
		moon_next_new = ephem.next_new_moon(local.date)

		local.date = save

		# moon special bar & circle
		if graphics_style == "bar" or graphics_style == "circle":
			if moon_next_full < moon_next_new:
				mp = (moon_full_pct/100)/2
				moon_phase = "Waxing"
				arc_start = True

				if graphics_style == "bar":
					cr.set_source_rgb(1.00, 0.00, 0.00)
					cr.move_to(width*0.9*mp+width*0.05,bar3_start)
					cr.line_to(width*0.9*mp+width*0.05,bar3_start+bar_height)
					cr.set_line_width(1.0)
					cr.stroke()

					cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
					cr.set_source_rgb(0.00, 0.00, 0.00)
					cr.fill()
					cr.stroke()

					cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
					if moon_full_pct < 25 or moon_full_pct > 75:
						cr.set_source_rgb(1.00, 1.00, 1.00)
					else:
						cr.set_source_rgb(0.00, 0.00, 0.00)
					cr.set_line_width(0.5)
					cr.stroke()

				if graphics_style == "circle":
					pos = mp
					color = [0, 0, 0]
					self.radial_ball(pos, radius2, size, color, True)
					color = [1, 1, 1]
					self.radial_ball(pos, radius2, size, color, False)
					x1 = circle_x_center
					y1 = circle_y_center
					angle1a = pos * 360
					angle1b = (angle1a+90)*pi/180

				view_az = 0
				view_alt = 0
				az_degrees = 90
				az = az_degrees * pi/180
				for alt_degrees in range(90,-90,-9):
					alt = alt_degrees * pi/180
					arc_x = size * cos(alt)*sin(az-view_az)
					arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
					if graphics_style == "bar":
						x = ((width*0.9*mp+width*0.05) + arc_x)
						y = ((bar3_start+bar_height/2) - arc_y)
					if graphics_style == "circle":
						x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
						y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
					if arc_start == True:
						cr.move_to(x,y)
						arc_start = False
					else:
						cr.line_to(x,y)

				view_az = 0
				view_alt = 0
				az_degrees = -asin((moon_full_pct - 50)/50) * 180/pi

				az = az_degrees * pi/180
				for alt_degrees in range(-90,90,9):
					alt = alt_degrees * pi/180
					arc_x = size * cos(alt)*sin(az-view_az)
					arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
					if graphics_style == "bar":
						x = ((width*0.9*mp+width*0.05) + arc_x)
						y = ((bar3_start+bar_height/2) - arc_y)
					if graphics_style == "circle":
						x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
						y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
					cr.line_to(x,y)

			else:
				mp = (1-(moon_full_pct/100))/2+0.5
				moon_phase = "Waning"
				arc_start = True

				if graphics_style == "bar":
					cr.set_source_rgb(1.00, 0.00, 0.00)
					cr.move_to(width*0.9*mp+width*0.05,bar3_start)
					cr.line_to(width*0.9*mp+width*0.05,bar3_start+bar_height)
					cr.set_line_width(1.0)
					cr.stroke()

					cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
					cr.set_source_rgb(0.00, 0.00, 0.00)
					cr.fill()
					cr.stroke()

					cr.arc(width*0.9*mp+width*0.05,bar3_start+bar_height/2, size, 0, 2.0*3.14)
					if moon_full_pct < 25 or moon_full_pct > 75:
						cr.set_source_rgb(1.00, 1.00, 1.00)
					else:
						cr.set_source_rgb(0.00, 0.00, 0.00)
					cr.set_line_width(0.5)
					cr.stroke()

				if graphics_style == "circle":
					pos = mp
					color = [0, 0, 0]
					self.radial_ball(pos, radius2, size, color, True)
					color = [1, 1, 1]
					self.radial_ball(pos, radius2, size, color, False)
					x1 = circle_x_center
					y1 = circle_y_center
					angle1a = pos * 360
					angle1b = (angle1a+90)*pi/180

				cr.set_source_rgb(1.00, 1.00, 1.00)

				view_az = 0
				view_alt = 0
				az_degrees = -90
				az = az_degrees * pi/180
				for alt_degrees in range(90,-90,-9):
					alt = alt_degrees * pi/180
					arc_x = size * cos(alt)*sin(az-view_az)
					arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
					if graphics_style == "bar":
						x = ((width*0.9*mp+width*0.05) + arc_x)
						y = ((bar3_start+bar_height/2) - arc_y)
					if graphics_style == "circle":
						x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
						y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
					if arc_start == True:
						cr.move_to(x,y)
						arc_start = False
					else:
						cr.line_to(x,y)

				view_az = 0
				view_alt = 0
				az_degrees = asin((moon_full_pct - 50)/50) * 180/pi
				az = az_degrees * pi/180
				for alt_degrees in range(-90,90,9):
					alt = alt_degrees * pi/180
					arc_x = size * cos(alt)*sin(az-view_az)
					arc_y = size * (cos(view_alt)*sin(alt)-sin(view_alt)*cos(alt)*cos(az-view_az))
					if graphics_style == "bar":
						x = ((width*0.9*mp+width*0.05) + arc_x)
						y = ((bar3_start+bar_height/2) - arc_y)
					if graphics_style == "circle":
						x = (x1 + (radius2 * math.cos(angle1b)) + arc_x)
						y = (y1 + (radius2 * math.sin(angle1b)) - arc_y)
					cr.line_to(x,y)

			cr.set_source_rgb(1,1,1)
			cr.fill()
			cr.stroke()
			cr.close_path()

		moon_previous_new = ephem.localtime(ephem.previous_new_moon(local.date))
		moon_previous_first_quarter = ephem.localtime(ephem.previous_first_quarter_moon(local.date))
		moon_previous_full = ephem.localtime(ephem.previous_full_moon(local.date))
		moon_previous_last_quarter = ephem.localtime(ephem.previous_last_quarter_moon(local.date))

		moon_next_last_quarter = ephem.localtime(ephem.next_last_quarter_moon(local.date))
		moon_next_new = ephem.localtime(ephem.next_new_moon(local.date))
		moon_next_first_quarter = ephem.localtime(ephem.next_first_quarter_moon(local.date))
		moon_next_full = ephem.localtime(ephem.next_full_moon(local.date))
	
		moon_age = local.date - ephem.date(moon_previous_new)

		if text_flag == "on":
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.set_line_width(1.0)
			cr.set_font_size(font_size)
			cr.set_source_rgb(1.00, 1.00, 1.00)

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*4)
			cr.text_path("MOON FULL/AGE: " + str(round(moon_full_pct)) + "%" + " / " + "%1.1f" % moon_age + " days")
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*6)
			cr.text_path("NEW MOON:      " + str(moon_next_new)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*8)
			cr.text_path("FIRST QUARTER: " + str(moon_next_first_quarter)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*10)
			cr.text_path("FULL MOON:     " + str(moon_next_full)[:19])
			cr.fill()
			cr.stroke()

			cr.move_to(width*0.01,bar3_start+bar_height+tic_height+text_height*12)
			cr.text_path("LAST QUARTER:  " + str(moon_next_last_quarter)[:19])
			cr.fill()
			cr.stroke()

		return False

	def pie_slice(self, start_pos, stop_pos, radius, color):

		angle1a = start_pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])

		cr.move_to(circle_x_center, circle_y_center)
		cr.rel_line_to(radius * math.cos(angle1b), radius * math.sin(angle1b))

		angle2a = stop_pos * 360
		angle2b = (angle2a+90)*pi/180

		cr.arc(circle_x_center, circle_y_center, radius, angle1b, angle2b)

		cr.move_to(circle_x_center, circle_y_center)

		cr.fill()
		cr.stroke()
		cr.close_path()

		return

	def radial_line(self, pos, radius, color):

		angle1a = pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])

		cr.move_to(circle_x_center, circle_y_center)
		cr.rel_line_to(radius * math.cos(angle1b), radius * math.sin(angle1b))
		cr.stroke()

		return

	def radial_ball(self, pos, radius1, radius2, color, fill):

		angle1a = pos * 360
		angle1b = (angle1a+90)*pi/180

		cr.set_source_rgb(color[0], color[1], color[2])
		cr.arc(circle_x_center + (radius1 * math.cos(angle1b)), circle_y_center + (radius1 * math.sin(angle1b)), radius2, 0, 2.0*3.14)
		if fill == True:
			cr.fill()	
		cr.stroke()

		return

	def screen_changed(self, widget, old_screen=None):
		global supports_alpha
		# print "screen changed"
		

		# To check if the display supports alpha channels, get the colormap
		screen = self.get_screen()
		colormap = screen.get_rgba_colormap()
		if colormap == None:
			# print 'Your screen does not support alpha channels!'
			colormap = screen.get_rgb_colormap()
			supports_alpha = False
		else:
			# print 'Your screen supports alpha channels!'
			supports_alpha = True
    
		# Now we have a colormap appropriate for the screen, use it
		self.set_colormap(colormap)
    
		return False
	
	def unrealize(self, widget, date=None):
		# cancel timeout
		if self.timer:
			v = gobject.source_remove(self.timer)
			print "canceled pyclock timeout:", v
			self.timer = None


	def set_timer(self, widget, on):

		# when called first time from __init__ widget is None
		if self.timer != None:
			# print "removing old timer"
			gobject.source_remove(self.timer)
		#else:
		if on:
			# print "creating new timer"
			delay = 1000 if enable_seconds else 60000
			self.timer = gobject.timeout_add(delay, self.update)
			# repaint immediately when coming to the foreground
			self.update()


	def update(self):
		# print "updating pyclock"
		self.queue_draw()
		return True


def hd_plugin_get_objects():
	global local
	global graphics_style
	global text_flag
        global gps_mode
        global gps_timeout
	global gps_time
	global startup_lat
	global startup_long

	config = ConfigParser.ConfigParser()
	ini_file = '/usr/lib/hildon-desktop/mchronos.ini'
	config.read(ini_file)
	startup_long = config.get("location","longitude")
	startup_lat = config.get("location","latitude")
        gps_mode = config.get("gps","mode")
        gps_timeout = config.get("gps","timeout")
        gps_time = config.get("gps","time")
	graphics_style = config.get("style","graphics")
	text_flag = config.get("style","text")

	local = ephem.Observer()
	#local.long = '-98.1' # morden
	#local.lat = '49.2' # morden
	local.long = startup_long
	local.lat = startup_lat

	plugin = mchronos()
	return [plugin]

