#!/usr/bin/python
import gtk
import ConfigParser
import sys
import csv
import os
import time

# Case-sensitive item config parser
class CaseConfigParser(ConfigParser.RawConfigParser):
    def optionxform(self, optionstr):
        return optionstr

class mcedit:
    def __init__(self):
        #First, read mce.ini
        self.cp = CaseConfigParser()
        if sys.platform == "win32": #I'm testing it on my windows computer
            self.cp.read("mce.ini")
        else:
            self.cp.read("/etc/mce/mce.ini") # This is the normal mce.ini location
        self.sects = self.cp.sections()
        self.sects.sort()
        self.data = {}
        prettysections = {'DevLock': 'Device Lock', 'HomeKey': "Home Key", 'KeyPad': "Key Pad", 'LED': "Generic LED",
                          'LEDPatternMonoRX34': "Mono LED (n800)", 'LEDPatternNJoyRX44': "NJoy LED (n810)",
                          'LEDPatternNJoyRX48': "NJoy LED (n810w)", 'Modules': "Modules", 'PowerKey': "Power Key",
                          'SoftPowerOff': "Soft Power Off", 'TKLock': "Touchscreen/Key Lock"}
        for s in self.sects:
            self.data[s.lower()] = {'pretty':prettysections[s]}

        #Now, load up the help
        self.load_help()

        # Set up a GTK Window, HPaned, and VBox        
        self.w = gtk.Window()
        self.h = gtk.HPaned()
        self.table = None
        self.v = gtk.VBox()

        # Set up the left side of the HPaned -- TreeView to list sections        
        self.t = gtk.TreeView()
        self.c = gtk.TreeViewColumn("section", gtk.CellRendererText(), text=0)
        self.t.append_column(self.c)
        self.model = gtk.ListStore(str)
        self.t.set_model(self.model)
        for s in self.sects:
            self.model.append([self.data[s.lower()]['pretty'],])
        self.t.connect("row-activated", self.load_prefs)
        # Set up the left side of the HPaned -- button bar
        self.b = gtk.Toolbar()
        self.b.set_style(gtk.TOOLBAR_ICONS)
        self._toolbar()
        # Set up the left side of the HPaned -- VBox
        self.v.add(self.t)
        self.v.add(self.b)
        self.v.set_child_packing(self.b, 0, 0, 0, gtk.PACK_END)
            
        self.s = gtk.ScrolledWindow()
        self.s.set_policy(gtk.POLICY_AUTOMATIC, gtk.POLICY_AUTOMATIC)
        self.w.add(self.h)
        self.h.add(self.v)
        self.h.add(self.s)
        self.w.connect('destroy', gtk.main_quit)
        self.w.resize(800,480)
        self.w.show_all()       

    def _toolbar(self):
        # Save Button
        button = gtk.ToolButton(gtk.STOCK_SAVE)
        button.connect("clicked", self.save)
        self.b.insert(button, 0)

        # Separator
        sep = gtk.SeparatorToolItem()
        sep.set_draw(False)
        sep.set_expand(True)
        self.b.insert(sep,-1)
        
        # Help Button
        self.help_button = gtk.ToggleToolButton(gtk.STOCK_HELP)
        self.help_button.connect("clicked", self.help_clicked)
        self.b.insert(self.help_button, -1)
        
        self.help = False

    def save(self,widget):
        # There's no going back after this... are we SURE?
        dlg = gtk.MessageDialog(None,0,gtk.MESSAGE_QUESTION,gtk.BUTTONS_YES_NO,"Are you sure you want to overwrite mce.ini? This cannot be undone!")
        def close(widget,response):
            if response == gtk.RESPONSE_YES:
                if sys.platform == 'win32':
                    self.cp.write(open('newmce.ini','w')) # On my windows box, I always want the original
                else:
                    self.cp.write(open('/tmp/mce.ini','w'))
                    os.system('sudo python /usr/share/mcedit/mcemv.py')
            widget.destroy()
        dlg.connect("response", close)
        dlg.run()

    def help_clicked(self,widget):
        self.help = widget.get_active()

    def load_prefs(self, widget, a, b):
        #Remove the previous table from the scrolled window
        if self.s.get_child() != None:
            self.s.remove(self.s.get_child())
        items = self.cp.items(self.sects[a[0]])
        print items
        self.table = gtk.Table(len(items),3, False)
        #self.table.connect("set-focus-child", self.get_help)
        self.table.set_row_spacings(5)
        row = 0
        for (item,value) in items:
            eb = gtk.EventBox()
            label = gtk.Label(self.data[self.sects[a[0]].lower()][item.lower()]['pretty'])
            eb.add(label)
            eb.set_events(gtk.gdk.BUTTON_PRESS_MASK)
            eb.connect("button_press_event", self.show_help, self.data[self.sects[a[0]].lower()][item.lower()]['help'])
            type = self.data[self.sects[a[0]].lower()][item.lower()]['type']
            if type == 'str':
                edit = gtk.Entry()
                edit.set_text(value)
                edit.connect('changed',self.change_option,self.sects[a[0]],item)
            elif type == 'int':
                edit = gtk.SpinButton(gtk.Adjustment(float(value),0,999999,1,10))
                edit.connect('value-changed',self.change_option,self.sects[a[0]],item)
            elif type[0:5] == "multi":
                s = type.split("|")
                p = s[1].split(";") # Get the allowed values
                edit = gtk.combo_box_new_text()
                rem=0
                j=0
                for i in p:
                    if i == self.data[self.sects[a[0]].lower()][item.lower()]['default']:
                        rem=j
                    edit.append_text(i)
                    j = j+1
                edit.set_active(rem)
                edit.connect('changed', self.change_option, self.sects[a[0]],item)
            elif type == "bool":
                edit = gtk.CheckButton()
                edit.set_active(int(value))
                edit.connect('toggled',self.change_option,self.sects[a[0]],item)
            else:
                edit = gtk.Entry()
                edit.set_text(value)
                edit.connect('changed',self.change_option,self.sects[a[0]],item)
            b = gtk.Button("Default value")
            b.connect('clicked', self.set_default, self.data[self.sects[a[0]].lower()][item.lower()]['default'], edit)
            self.table.attach(eb,0,1,row,row+1)
            self.table.attach(edit,1,2,row,row+1)
            self.table.attach(b, 2,3,row,row+1)
            row = row+1
        self.table.show_all()
        self.s.add_with_viewport(self.table)
        
    def change_option(self,edit,section,item):
        if type(edit) == type(gtk.SpinButton()) or type(edit) == type(gtk.Entry()):
            self.cp.set(section,item,edit.get_text())
        elif type(edit) == type(gtk.ComboBox()):
            self.cp.set(section,item,edit.get_model()[edit.get_active()][0])
            print edit.get_model()[edit.get_active()][0]
        elif type(edit) == type(gtk.CheckButton()):
            if edit.get_active() == True:
                self.cp.set(section,item,"1")
            else:
                self.cp.set(section,item,"0")

    def set_default(self,widget,default,edit):
        if type(edit) == type(gtk.SpinButton()) or type(edit) == type(gtk.Entry()):
            edit.set_text(default)
        elif type(edit) == type(gtk.ComboBox()):
            rem = 0
            j = 0
            for i in edit.get_model():
                if i[0] == default:
                    rem = j
                j = j+1
            edit.set_active(rem)
        elif type(edit) == type(gtk.CheckButton()):
            edit.set_active(int(default))

    def show_help(self,widget,d,help):
        if self.help == True:
            self.PopUp(help, gtk.MESSAGE_INFO)
            self.help = False
            self.help_button.set_active(False)

    def PopUp(self,msg,type=gtk.MESSAGE_ERROR):
        error_dialog = gtk.MessageDialog(None,0,type,gtk.BUTTONS_CLOSE,msg)
        error_dialog.connect("response", lambda w,e: error_dialog.destroy())
        error_dialog.run()

    def load_help(self):
        if sys.platform == "win32":
            data = csv.DictReader(open("data.csv"))
        else:
            data = csv.DictReader(open("/usr/share/mcedit/data.csv"))
        mydata = []
        #Perhaps we would like to use it in more than just this loop?
        for d in data:
            mydata.append(d)        
        for d in mydata:
            self.data[d['section'].lower()][d['name'].lower()] = d


mc = mcedit()
gtk.main()