/*****************************************************************************
 *** Mauku - Micro-blogging client for Maemo devices
 ***
 *** Copyright (c) 2009 Henrik Hedberg <hhedberg@innologies.fi>
 ***
 *** Licensed under the Apache License, Version 2.0 (the "License");
 *** you may not use this file except in compliance with the License.
 *** You may obtain a copy of the License at
 ***
 ***     http://www.apache.org/licenses/LICENSE-2.0
 ***
 *** Unless required by applicable law or agreed to in writing, software
 *** distributed under the License is distributed on an "AS IS" BASIS,
 *** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *** See the License for the specific language governing permissions and
 *** limitations under the License.
 ***
 *****************************************************************************/

#ifndef MICROFEED_THREADS_H
#define MICROFEED_THREADS_H


typedef struct _MicrofeedThread MicrofeedThread;

typedef struct _MicrofeedThreadPool MicrofeedThreadPool;

typedef struct _MicrofeedMutex MicrofeedMutex;

typedef void* (*MicrofeedThreadFunction)(void* data);

typedef void (*MicrofeedThreadExitCallback)(MicrofeedThread* thread, void* user_data);

typedef struct {
	void* (*thread_new)(MicrofeedThreadFunction function, void* data);
	void (*thread_free)(void* thread_implementation);
	void* (*thread_get_current)(void);
	void (*thread_send_signal)(void* thread_implementation, int signal_number);
	void (*thread_join)(void* thread_implementation);
	void* (*mutex_new)(void);
	void (*mutex_free)(void* mutex_implementation);
	void (*mutex_lock)(void* mutex_implementation);
	void (*mutex_unlock)(void* mutex_implementation);
} MicrofeedThreadFunctions;

void microfeed_thread_set_functions(MicrofeedThreadFunctions* thread_functions);

void microfeed_thread_init(void);
void microfeed_thread_cleanup(void);

MicrofeedThread* microfeed_thread_new(MicrofeedThreadFunction function, void* data);
MicrofeedThread* microfeed_thread_new_with_exit_callback(MicrofeedThreadFunction function, void* data, MicrofeedThreadExitCallback exit_callback, void* user_data);
void microfeed_thread_free(MicrofeedThread* thread);
MicrofeedThread* microfeed_thread_ref(MicrofeedThread* thread);
void microfeed_thread_unref(MicrofeedThread* thread);

MicrofeedThread* microfeed_thread_get_current(void);
void microfeed_thread_send_signal(MicrofeedThread* thread, int signal_number);
void microfeed_thread_join(MicrofeedThread* thread);
unsigned long microfeed_thread_get_id(MicrofeedThread* thread);

MicrofeedThreadPool* microfeed_thread_pool_new(unsigned int maximum_thread_count);
MicrofeedThreadPool* microfeed_thread_pool_new_with_exit_callback(unsigned int max_threads, MicrofeedThreadExitCallback exit_callback, void* user_data);
MicrofeedThread* microfeed_thread_pool_queue_thread(MicrofeedThreadPool* thread_pool, MicrofeedThreadFunction function, void* data);
MicrofeedThread* microfeed_thread_pool_queue_thread_with_exit_callback(MicrofeedThreadPool* thread_pool, MicrofeedThreadFunction function, void* data, MicrofeedThreadExitCallback exit_callback, void* user_data);
unsigned int microfeed_thread_pool_get_started_thread_count(MicrofeedThreadPool* thread_pool);
unsigned int microfeed_thread_pool_get_waiting_thread_count(MicrofeedThreadPool* thread_pool);
void microfeed_thread_pool_set_maximum_thread_count(MicrofeedThreadPool* thread_pool, unsigned int maximum_thread_count);

MicrofeedMutex* microfeed_mutex_new(void);
void microfeed_mutex_free(MicrofeedMutex* mutex);
void microfeed_mutex_lock(MicrofeedMutex* mutex);
void microfeed_mutex_unlock(MicrofeedMutex* mutex);

#endif
