/*
  MathJinni - A simple formular calculator
  Copyright (C) 2006  Tim Teulings

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <Lum/Base/L10N.h>
#include <Lum/Base/Path.h>
#include <Lum/Base/String.h>

#include <Lum/Dlg/About.h>

#include <Lum/OS/Main.h>

#include <Lum/Dialog.h>
#include <Lum/Panel.h>
#include <Lum/Tab.h>

#include "Calc.h"
#include "Configuration.h"
#include "FormatConversion.h"
#include "Formula.h"
#include "Plot.h"
#include "UnitConversion.h"

#include "config.h"

static Lum::AppInfo info;

class MainWindow : public Lum::Dialog
{
private:
  std::list<ConfigPlugin*> plugins;
  Lum::Model::ActionRef    aboutAction;

public:
  MainWindow()
   : aboutAction(new Lum::Model::Action())
  {
    Observe(GetOpenedAction());
    Observe(GetClosedAction());

    Observe(aboutAction);
  }

  void PreInit()
  {
    Lum::Panel       *panel;
    Lum::Tab         *tab;

    Calc             *calc;
    FormatConversion *formatConversion;
    FormulaCalc      *formula;
    Plot             *plot;
    UnitConversion   *unitConversion;

    panel=Lum::VPanel::Create(true,true);

    tab=Lum::Tab::Create(true,true);

    calc=new Calc();
    calc->SetFlex(true,true);

    tab->Add(L"Calc",calc);

    formatConversion=new FormatConversion();
    formatConversion->SetFlex(true,true);

    tab->Add(L"Format",formatConversion);

    unitConversion=new UnitConversion();
    unitConversion->SetFlex(true,true);
    plugins.push_back(unitConversion);

    tab->Add(L"Units",unitConversion);

    formula=new FormulaCalc();
    formula->SetFlex(true,true);
    plugins.push_back(formula);

    tab->Add(L"Formula",formula);

    plot=new Plot();
    plot->SetFlex(true,true);
    plugins.push_back(plot);

    tab->Add(L"Plot",plot);

    panel->Add(tab);

    SetMain(panel);

    Lum::MenuDesc *menu=new Lum::MenuDesc();

    menu
      ->AddMenuItemSub(_ld(menuProject))
        ->AddMenuItemAction(_ld(menuProjectQuit),Lum::OS::qualifierControl,L"q",GetClosedAction());
    menu
      ->AddMenuItemSub(_ld(menuHelp))
        ->AddMenuItemAction(_ld(menuHelpHelp),NULL)
        ->AddMenuItemAction(_ld(menuHelpAbout),aboutAction);

    SetMenu(menu);

    Dialog::PreInit();
  }

  void Resync(Lum::Base::Model *model, const Lum::Base::ResyncMsg& msg)
  {
    if (model==GetOpenedAction() && GetOpenedAction()->IsFinished()) {
      LoadData();
      LoadConfig(plugins);
    }
    else if (model==GetClosedAction() && GetClosedAction()->IsFinished()) {
      SaveConfig(plugins);
    }
    else if (model==aboutAction && aboutAction->IsFinished()) {
      Lum::Dlg::About::Show(this,info);
    }

    Dialog::Resync(model,msg);
  }
};

class Main : public Lum::OS::MainDialog<MainWindow>
{
public:
  bool Prepare()
  {
#if defined(APP_DATADIR)
    Lum::Base::Path::SetApplicationDataDir(Lum::Base::StringToWString(APP_DATADIR));
#endif

   return Lum::OS::MainDialog<MainWindow>::Prepare();
  }

  Main()
  {
    info.SetProgram(Lum::Base::StringToWString(PACKAGE_NAME));
    info.SetVersion(Lum::Base::StringToWString(PACKAGE_VERSION));
    info.SetDescription(L"Doing some magic with numbers...");
    info.SetAuthor(L"Tim Teulings");
    info.SetContact(L"Tim Teulings <tim@teulings.org>");
    info.SetCopyright(L"(c) 2007, Tim Teulings");
    info.SetLicense(L"GNU Public License (GPL)");
  }
};

LUM_MAIN(Main,L"MathJinni")
