/*
 * This file is part of mapper
 *
 * Copyright (C) 2007-2010 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"
#include <glib.h>
#include <gconf/gconf-client.h>

#ifndef _MAPPER_SETTINGS_H
#define _MAPPER_SETTINGS_H

#include "settings-gconf.h"
#include "mapper-types.h"

typedef struct _MapperSettings MapperSettings;
struct _MapperSettings {
	GConfClient *gconf_client;

	gchar *route_dir_uri;
	gchar *track_file_uri;
	gchar *route_dl_url;
	guint route_dl_radius;
	guint track_dl_radius;
	gboolean track_store;

	gboolean always_keep_on;
	gboolean fullscreen;

	gboolean enable_gps;
	gboolean gps_info;
	gboolean satdetails_on;

	gboolean auto_download;

	gboolean enable_voice;
	guint announce_notice_ratio;
	guint voice_speed;
	guint voice_pitch;
	guint voice_pitch_range;
	guint voice_volume;

	gboolean announce_waypoints;
	gboolean announce_overspeed;
	gboolean announce_destination;

	gboolean speed_on;
	gboolean speed_excess;
	guint speed_limit;

	guint map_location_sens;

	gchar *http_proxy_host;
	gint http_proxy_port;

	GSList *loc_list;
	GtkListStore *loc_model;

	CustomAction action[CUSTOM_KEY_ENUM_COUNT];
	guint degformat;
	SpeedLocation speed_location;
	InfoFontSize info_font_size;
};

/** CONFIGURATION INFORMATION. */
gchar *_route_dir_uri;
gchar *_track_file_uri;
gchar *_route_dl_url;

guint _route_dl_radius;
guint _track_dl_radius;

gboolean _track_store;

gboolean _always_keep_on;
gboolean _fullscreen;

gboolean _enable_gps;
gboolean _gps_info;
gboolean _satdetails_on;

gboolean _auto_download;

gboolean _enable_voice;
guint _announce_notice_ratio;
guint _voice_speed;
guint _voice_pitch;

gboolean _announce_waypoints;
gboolean _announce_overspeed;
gboolean _announce_destination;

gboolean _speed_on;
gboolean _speed_excess;
guint _speed_limit;

guint _map_location_sens;

gchar *_http_proxy_host;
gint _http_proxy_port;

GSList *_loc_list;
GtkListStore *_loc_model;

CustomAction _action[CUSTOM_KEY_ENUM_COUNT];
guint _degformat;
SpeedLocation _speed_location;
InfoFontSize _info_font_size;

#endif
