/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <glib/gstdio.h>
#include <gtk/gtk.h>

#include "hildon-wrappers.h"
#include "dialogs.h"

/**
 * Pop up a modal dialog box with simple error information in it.
 */
void 
popup_error(GtkWidget *window, const gchar *error)
{
GtkWidget *dialog;

#ifdef WITH_HILDON
dialog=hildon_note_new_information(GTK_WINDOW(window), error);
#else
dialog=gtk_message_dialog_new (GTK_WINDOW(window), GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, error);
#endif
gtk_dialog_run(GTK_DIALOG(dialog));
gtk_widget_destroy(dialog);
}

gboolean
dialog_confirm(GtkWidget *window, const gchar *msg)
{
GtkWidget *confirm;
gboolean r;

confirm=hildon_note_new_confirmation(GTK_WINDOW(window),msg);
r=(GTK_RESPONSE_OK == gtk_dialog_run(GTK_DIALOG(confirm))) ? TRUE : FALSE;
gtk_widget_destroy(confirm);
return r;
}

GtkWidget *
progress_dialog(GtkWidget *window, const gchar *title, GtkWidget *label, GtkWidget *progress)
{
GtkWidget *dialog;

dialog=gtk_dialog_new();
gtk_window_set_title(GTK_WINDOW(dialog), title);
if (window)
	gtk_window_set_transient_for(GTK_WINDOW(dialog), GTK_WINDOW(window));
gtk_window_set_modal(GTK_WINDOW(dialog), TRUE);
#ifndef WITH_HILDON
gtk_window_set_deletable(GTK_WINDOW(dialog), FALSE);
#endif
if (label)
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), label, TRUE, FALSE, 0);
gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->vbox), progress, TRUE, FALSE, 0);
gtk_window_set_default_size(GTK_WINDOW(dialog), 350, -1);
return dialog;
}

void
progress_dialog_remove(GtkWidget *dialog)
{
if (dialog)
	gtk_widget_destroy(dialog);
}
