/*
 * This file is part of mapper
 *
 * Copyright (C) 2007 Kaj-Michael Lang
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
 */

#include "config.h"

#include <glib.h>
#include <glib/gstdio.h>

#include "gps.h"
#include "osm.h"
#include "filter.h"

/** 
 * Check track filter against GPS values
 * return TRUE if point is ok, FALSE if it should be skipped
 */
gboolean 
filter_check(GpsTrackFilter *f, GpsData *gps, osm_location *location)
{
if (f->enabled==FALSE)
	return TRUE;

if (f->drop_cnt>f->maxdrop) {
	f->drop_cnt=0;
	return TRUE;
}

if (gps->speed>=0.1) {
	f->drop_cnt=0;
	return TRUE;
}

if ((gps->hdop<=f->hdop || f->hdop==0.0) && (gps->vdop<=f->vdop || f->vdop==0.0)) {
	f->drop_cnt=0;
	return TRUE;
}

if (fabs(gps->heading-gps->lheading)>=f->angle || f->angle==0.0 ) {
	f->drop_cnt=0;
	return TRUE;
}

if (!location->street) {
	f->drop_cnt=0;
	return TRUE;
}

if (location->street && location->street->dist>=f->osm) {
	f->drop_cnt=0;
	return TRUE;
}

f->drop_cnt++;
g_debug("Filter: [%s %s %s %s] A: %f (%d)\n", 
	gps->hdop>f->hdop ? "HDOP" : "-", 
	gps->vdop>f->vdop ? "VDOP" : "-", 
	(fabs(gps->heading-gps->lheading)<f->angle) ? "Angle" : "-",
	(location->street && (location->street->dist>f->osm)) ? "OSM" : "-", 
	fabs(gps->heading-gps->lheading), f->drop_cnt);
return FALSE;
}

