#ifndef _MAP_REPO_H
#define _MAP_REPO_H

/** This enumerated type defines the supported types of repositories. */
typedef enum {
	REPOTYPE_NONE,		/* No URL set. */
	REPOTYPE_XYZ,		/* x=%d, y=%d, and zoom=%d */
	REPOTYPE_XYZ_INV,	/* zoom=%0d, x=%d, y=%d */
	REPOTYPE_QUAD_QRST,	/* t=%s   (%s = {qrst}*) */
	REPOTYPE_QUAD_ZERO,	/* t=%0s  (%0s = {0123}*) */
	REPOTYPE_WMS		/* "service=wms" */
} RepoType;

/** Data regarding a map repository. */
typedef struct _RepoData RepoData;
struct _RepoData {
	gchar *name;
	gchar *url;
	gchar *cache_dir;
	gchar *format;
	guint dl_zoom_steps;
	guint view_zoom_steps;
	gboolean double_size;
	gboolean nextable;
	RepoType type;
	GtkWidget *menu_item;
};

/** Data used during the asynchronous progress update phase of automatic map
 * downloading. */
typedef struct _ProgressUpdateInfo ProgressUpdateInfo;
struct _ProgressUpdateInfo {
	gchar *src_str;
	gchar *dest_str;
	RepoData *repo;
	guint tilex, tiley;
	gint zoom;	/* for refresh. */
	gint retries;		/* if equal to zero, it means we're DELETING maps. */
	guint priority;
	FILE *file;
};

GList *_repo_list;
RepoData *_curr_repo;

gboolean repo_set_curr(RepoData * rd);
void set_repo_type(RepoData * repo);

#endif
