#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <glib-object.h>
#include <dbus/dbus-glib.h>
#include "marshal.h"

#define SERVICE_NAME      "com.nokia.icd"
#define OBJECT_PATH       "/com/nokia/icd"
#define SERVICE_INTERFACE "com.nokia.icd"

/* TODO: read these values from environment or command line */
#define IAP_NAME    "DUMMY"
#define PAN_CONTROL "/usr/lib/maemo-pan/pan-control"


void daemonize() {

  int devnull;

  if (fork()) exit(0);
  chdir("/");
  setsid();
  umask(0);
  if (fork()) exit(0);

  devnull = open("/dev/null", O_RDWR);
  close(STDIN_FILENO); dup2(STDIN_FILENO, devnull);
  close(STDOUT_FILENO); dup2(STDOUT_FILENO, devnull);
  close(STDERR_FILENO); dup2(STDERR_FILENO, devnull);
  close(devnull);

}


static
void status_changed_cb(DBusGProxy* icd,
                       const char* name,
                       const char* type,
                       const char* status,
                       const char* arg) {

  GError *error = NULL;

  if (g_str_equal(name, IAP_NAME)) {
    if (g_str_equal(status, "CONNECTED")) {
      /* fire up PAN */
      g_spawn_command_line_async(PAN_CONTROL " connect", &error);  
    } else if (g_str_equal(status, "IDLE")) {
      /* shut down PAN */
      g_spawn_command_line_async(PAN_CONTROL " disconnect", &error);
    }

    if (error != NULL) {
      g_printerr("Could not run pan-control: %s\n", error->message);
      g_error_free(error);
    }

  }
  g_print("Status changed! %s: %s\n", name, status);

}


int main(int argc, char** argv) {

  DBusGConnection* bus;
  DBusGProxy* icd = NULL;
  GMainLoop* mainloop;
  GError* error = NULL;
  
  daemonize();

  g_type_init();
  mainloop = g_main_loop_new(NULL, FALSE);
  
  bus = dbus_g_bus_get(DBUS_BUS_SYSTEM, &error);
  if (error != NULL) {
    g_printerr("Could not connect to the Session bus: %s\n", error->message);
    g_error_free(error);
    exit(EXIT_FAILURE);
  }

  icd = dbus_g_proxy_new_for_name(bus,
                                  SERVICE_NAME,
                                  OBJECT_PATH,
                                  SERVICE_INTERFACE);
  if (icd == NULL) {
     g_printerr("Couldn't create proxy object.\n");
     exit(EXIT_FAILURE);
  }

  dbus_g_object_register_marshaller(marshal_VOID__STRING_STRING_STRING_STRING,
                                    G_TYPE_NONE,
                                    G_TYPE_STRING, G_TYPE_STRING,
                                    G_TYPE_STRING, G_TYPE_STRING,
                                    G_TYPE_INVALID);
  dbus_g_proxy_add_signal(icd, "status_changed",
                          G_TYPE_STRING, G_TYPE_STRING,
                          G_TYPE_STRING, G_TYPE_STRING,
                          G_TYPE_INVALID);
  dbus_g_proxy_connect_signal(icd, "status_changed",
                              G_CALLBACK(status_changed_cb),
                              bus, NULL);

  g_main_loop_run(mainloop);
  dbus_g_connection_unref(bus);
  
  return 0;
  
}

