/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of libobd.
 *
 *  libobd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  libobd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libobd.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef __OBD_CONN__H__
#define __OBD_CONN__H__

#include <termios.h>
#include <poll.h>

__BEGIN_DECLS

#define MAX_CON_BLEN 256

typedef enum {
	OBDCON_NOT_CONNECTED,
	OBDCON_CONNECTING,
	OBDCON_CONNECTED,
	OBDCON_ERROR
} obdcon_status;

typedef enum {
	OBDCONERR_ERROR = -1,
	OBDCONERR_TIMEOUT = -2,
	OBDCONERR_INVALID_DEVNAME = -3,
	OBDCONERR_INVALID_ARGS = -4,
	OBDCONERR_ALREADY_CONNECTED = -5,
	OBDCONERR_NOT_CONNECTED = -6
} obdcon_err;

struct obdcon {
	char* devname;
	long baudrate;
	int handle;
	struct termios oldtio;
	struct termios newtio;
	obdcon_status status;
	int closepipe[2];
	struct pollfd poll[2];
};

int obdcon_init(struct obdcon* con);
int obdcon_opendev(struct obdcon* con, const char* devname);
int obdcon_closedev(struct obdcon* con);
int obdcon_read(struct obdcon* con, char* buffer, unsigned int size, unsigned int timeout);
int obdcon_write(struct obdcon* con, const char* buffer, unsigned int size);

__END_DECLS

#endif /*__OBD_CONN__H__*/
