/*
 *
 *  Copyright (c) 2008 INdT - Instituto Nokia de Tecnologia
 *
 *  This file is part of libobd.
 *
 *  libobd is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  libobd is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with libobd.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdarg.h>
#include <string.h>

#include "obd-log.h"

#define BUF_SIZE 256

FILE* obdlog_file = 0;
obdloglevel obdlog_level  = OBDLOG_ERROR;


void obdlog_write_noescape(obdloglevel level, char* str, char* buffer, unsigned int size)
{
	char tmp[BUF_SIZE];
	int i = 0;

	if(size > BUF_SIZE - 1)
		size = BUF_SIZE - 1;

	memcpy(tmp, buffer, size);

	tmp[size] = '\0';

	for(i = 0; i < size; i++) {
		switch (tmp[i]) {
			case '\r':
				tmp[i] = '|';
				break;
			case '\n':
				tmp[i] = ';';
				break;
			case '\b':
				tmp[i] = ',';
				break;
		}
	}
	fprintf(obdlog_file, "libobd[RAW_DATA]: %s \'%s\'\n", str, tmp);
	fflush(obdlog_file);
}

void obdlog_write_binary(obdloglevel level, char* str, unsigned char* buffer, unsigned int size)
{
	int i;

	fprintf(obdlog_file, "libobd[RAW_DATA]: %s \'", str);

	if(size < 1)
		return;

	for(i = 0; i < size - 1; i++)
		fprintf(obdlog_file, "%02X ", (unsigned char) buffer[i]);

	fprintf(obdlog_file, "%02X", (unsigned char) buffer[size -1]);
	fprintf(obdlog_file, "\'\n");
	fflush(obdlog_file);
}

void obdlog_setup(FILE* file, obdloglevel level)
{
	obdlog_file = file;
	obdlog_level = level;
}
