
/*****************************************************************
*
* ruby_hildon_sort_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_SORT_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self, parent )
    VALUE self, parent;
{
    RBGTK_INITIALIZE(self, hildon_sort_dialog_new (GTK_WINDOW ( RVAL2GOBJ ( parent ) ) )  );  
    return Qnil;
}


/* methods */


static VALUE
get_sort_key(dialog)
    VALUE dialog;
{
    gint ret =    hildon_sort_dialog_get_sort_key (_SELF ( dialog ) );
    return INT2NUM( ret );
}

static VALUE
get_sort_order(dialog)
    VALUE dialog;
{
    GtkSortType ret =    hildon_sort_dialog_get_sort_order (_SELF ( dialog ) );
    return INT2NUM ( ret ) ;
}

static VALUE
set_sort_key(dialog, key)
    VALUE dialog, key;
{
       hildon_sort_dialog_set_sort_key (_SELF ( dialog ), NUM2INT ( key ) ) ;
    return dialog;
}

static VALUE
set_sort_order(dialog, order)
    VALUE dialog, order;
{
       hildon_sort_dialog_set_sort_order (_SELF ( dialog ), GTK_SORT_TYPE ( RVAL2GOBJ ( order ) ) );
    return dialog;
}

static VALUE
add_sort_key(dialog, sort_key)
    VALUE dialog, sort_key;
{
    gint ret =    hildon_sort_dialog_add_sort_key (_SELF ( dialog ), RVAL2CSTR( sort_key ) );
    return INT2NUM( ret );
}

static VALUE
add_sort_key_reversed(dialog, sort_key)
    VALUE dialog, sort_key;
{
    gint ret =    hildon_sort_dialog_add_sort_key_reversed (_SELF ( dialog ), RVAL2CSTR( sort_key ) );
    return INT2NUM( ret );
}


/* Class Initialisation */


void 
Init_hildon_sort_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_SORT_DIALOG, "SortDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 1);

     rb_define_method(win, "get_sort_key", get_sort_key, 0);

     rb_define_method(win, "get_sort_order", get_sort_order, 0);

     rb_define_method(win, "set_sort_key", set_sort_key, 1);

     rb_define_method(win, "set_sort_order", set_sort_order, 1);

     rb_define_method(win, "add_sort_key", add_sort_key, 1);

     rb_define_method(win, "add_sort_key_reversed", add_sort_key_reversed, 1);
}


