
/*****************************************************************
*
* ruby_hildon_controlbar.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_CONTROLBAR(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_controlbar_new () );
    return Qnil;
}


/* methods */


static VALUE
set_value(self, value)
    VALUE self, value;
{
       hildon_controlbar_set_value (_SELF ( self ), NUM2INT( value ) );
    return self;
}

static VALUE
get_value(self)
    VALUE self;
{
    gint ret =    hildon_controlbar_get_value (_SELF ( self ) );
    return INT2NUM( ret );
}

static VALUE
get_max(self)
    VALUE self;
{
    gint ret =    hildon_controlbar_get_max (_SELF ( self ) );
    return INT2NUM( ret );
}

static VALUE
get_min(self)
    VALUE self;
{
    gint ret =    hildon_controlbar_get_min (_SELF ( self ) );
    return INT2NUM( ret );
}

static VALUE
set_max(self, max)
    VALUE self, max;
{
       hildon_controlbar_set_max (_SELF ( self ), NUM2INT( max ) );
    return self;
}

static VALUE
set_min(self, min)
    VALUE self, min;
{
       hildon_controlbar_set_min (_SELF ( self ), NUM2INT( min ) );
    return self;
}

static VALUE
set_range(self, min, max)
    VALUE self, min, max;
{
       hildon_controlbar_set_range (_SELF ( self ), NUM2INT( min ), NUM2INT( max ) );
    return self;
}


/* Class Initialisation */


void 
Init_hildon_controlbar()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_CONTROLBAR, "Controlbar", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "set_value", set_value, 1);

     rb_define_method(win, "get_value", get_value, 0);

     rb_define_method(win, "get_max", get_max, 0);

     rb_define_method(win, "get_min", get_min, 0);

     rb_define_method(win, "set_max", set_max, 1);

     rb_define_method(win, "set_min", set_min, 1);

     rb_define_method(win, "set_range", set_range, 2);
}


