
/*****************************************************************
*
* ruby_hildon_code_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_CODE_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_code_dialog_new () );
    return Qnil;
}


/* methods */


static VALUE
clear_code(dialog)
    VALUE dialog;
{
       hildon_code_dialog_clear_code (_SELF ( dialog ) );
    return dialog;
}

static VALUE
set_help_text(dialog, text)
    VALUE dialog, text;
{
       hildon_code_dialog_set_help_text (_SELF ( dialog ), RVAL2CSTR( text ) );
    return dialog;
}

static VALUE
set_input_sensitive(dialog, sensitive)
    VALUE dialog, sensitive;
{
       hildon_code_dialog_set_input_sensitive (_SELF ( dialog ), RVAL2CBOOL ( sensitive ) );
    return dialog;
}


/* Class Initialisation */


void 
Init_hildon_code_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_CODE_DIALOG, "CodeDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "clear_code", clear_code, 0);

     rb_define_method(win, "set_help_text", set_help_text, 1);

     rb_define_method(win, "set_input_sensitive", set_input_sensitive, 1);
}


