
/*****************************************************************
*
* ruby_hildon_login_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_LOGIN_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize (argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{

   if (argc == 1)
        RBGTK_INITIALIZE(self, hildon_login_dialog_new (GTK_WINDOW ( RVAL2GOBJ ( argv[0] ) ) ) );	
   else if ( argc == 3 )
	 RBGTK_INITIALIZE(self, hildon_login_dialog_new_with_default (GTK_WINDOW ( RVAL2GOBJ (  argv[0]  ) ), RVAL2CSTR( argv[1]  ), RVAL2CSTR(  argv[2]  ) ) );
 
    return Qnil;
}


/* methods */




static VALUE
set_message(dialog, msg)
    VALUE dialog, msg;
{
       hildon_login_dialog_set_message (_SELF ( dialog ), RVAL2CSTR( msg ) );
    return dialog;
}

static VALUE
get_username(dialog)
    VALUE dialog;
{
       return  CSTR2RVAL(hildon_login_dialog_get_username (_SELF ( dialog ) ) );
}

static VALUE
get_password(dialog)
    VALUE dialog;
{
       return CSTR2RVAL( hildon_login_dialog_get_password (_SELF ( dialog ) )  );
}


/* Class Initialisation */


void 
Init_hildon_login_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_LOGIN_DIALOG, "LoginDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, -1);

     rb_define_method(win, "set_message", set_message, 1);
	
	rb_define_method(win, "get_username",get_username,0);
	
	rb_define_method(win, "get_password",get_password,0);
}


