
/*****************************************************************
*
* ruby_hildon_color_chooser_dialog.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_COLOR_CHOOSER_DIALOG(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_color_chooser_dialog_new () );
    return Qnil;
}


/* methods */


static VALUE
set_color(dialog, color)
    VALUE dialog, color;
{
       hildon_color_chooser_dialog_set_color (_SELF ( dialog ), RVAL2GDKCOLOR(color) );
    return dialog;
}

static VALUE
get_color(dialog)
    VALUE dialog;
{
       GdkColor* color;
	hildon_color_chooser_dialog_get_color (_SELF ( dialog ), color );
    return GDKCOLOR2RVAL(color);
}


/* Class Initialisation */


void 
Init_hildon_color_chooser_dialog()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_COLOR_CHOOSER_DIALOG, "ColorChooserDialog", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "set_color", set_color, 1);

     rb_define_method(win, "get_color", get_color, 0);
}


