
/*****************************************************************
*
* ruby_hildon_banner.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_BANNER(RVAL2GOBJ(self)))

#define MODE_INFORMATION 1
#define MODE_INFORMATIONF 2
#define MODE_MARKUP 3
#define MODE_ANIMATION 4
#define MODE_PROGRESS 5


static ID id_to_a;

/* Initialisation */


static VALUE
initialize (argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
   
	VALUE mode = argv[0];
	VALUE parent = argv[1];
	VALUE name = argv[2];
	VALUE text   = argv[3];
	
	 int imode = NUM2INT( mode );
         GtkWidget* widget = NULL;
	
	switch ( imode )
	{
		case MODE_INFORMATION :
			widget =  hildon_banner_show_information (GTK_WIDGET ( RVAL2GOBJ( parent )), rb_id2name(SYM2ID(name)), RVAL2CSTR( text ) );
		break;
		case MODE_INFORMATIONF:
			widget =   hildon_banner_show_informationf (GTK_WIDGET ( RVAL2GOBJ( parent )), RVAL2CSTR(name ), RVAL2CSTR(text ) );
		break;
		case MODE_MARKUP:
			widget =  hildon_banner_show_information_with_markup (GTK_WIDGET ( RVAL2GOBJ( parent )), rb_id2name(SYM2ID(name)), RVAL2CSTR( text ) );
		break;
		case MODE_ANIMATION:
			widget =   hildon_banner_show_animation (GTK_WIDGET ( RVAL2GOBJ( parent )), RVAL2CSTR( name ), RVAL2CSTR( text ) );
		break;
		case MODE_PROGRESS:
			widget =  hildon_banner_show_progress (GTK_WIDGET ( RVAL2GOBJ( parent )), GTK_PROGRESS_BAR ( RVAL2GOBJ ( name ) ), RVAL2CSTR( text ) );
		break;
		
	}
    RBGTK_INITIALIZE(self, widget );
    return Qnil;
}


/* methods */


static VALUE
show_information(self,parent, icon_name, text)
    VALUE self,parent, icon_name, text;
{
   /* GtkWidget* ret =    hildon_banner_show_information (_SELF ( widget ), RVAL2CSTR( icon_name ), RVAL2CSTR( text ) ); */
    return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_INFORMATION ), parent, icon_name, text ) ;
}


static VALUE
show_informationf(self,parent, icon_name, format)
    VALUE self,parent, icon_name, format;
{
    /* GtkWidget* ret =    hildon_banner_show_informationf (_SELF ( widget ), RVAL2CSTR( icon_name ), RVAL2CSTR( format ) ); */
    return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_INFORMATIONF ), parent, icon_name, format) ;
}



static VALUE
show_information_with_markup(self,parent, icon_name, markup)
    VALUE self,parent, icon_name, markup;
{
    /* GtkWidget* ret =    hildon_banner_show_information_with_markup (_SELF ( widget ), RVAL2CSTR( icon_name ), RVAL2CSTR( markup ) ); */
    return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_MARKUP ), parent, icon_name, markup ) ;
}

static VALUE
show_animation(self,parent, animation_name, text)
    VALUE self,parent, animation_name, text;
{
   /*  GtkWidget* ret =    hildon_banner_show_animation (_SELF ( widget ), RVAL2CSTR( animation_name ), RVAL2CSTR( text ) ); */
    return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_ANIMATION ), parent, animation_name, text ) ;
}

static VALUE
show_progress(self,parent, bar, text)
    VALUE self,parent, bar, text;
{
    /* GtkWidget* ret =    hildon_banner_show_progress (_SELF ( widget ), GTK_PROGRESS_BAR ( RVAL2GOBJ ( bar ) ), RVAL2CSTR( text ) ); */
    return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_PROGRESS ), parent, bar, text ) ;
}

static VALUE
set_text(self, text)
    VALUE self, text;
{
       hildon_banner_set_text (_SELF ( self ), RVAL2CSTR( text ) );
    return self;
}

static VALUE
set_markup(self, markup)
    VALUE self, markup;
{
       hildon_banner_set_markup (_SELF ( self ), RVAL2CSTR( markup ) );
    return self;
}

static VALUE
set_fraction(self, fraction)
    VALUE self, fraction;
{
       hildon_banner_set_fraction (_SELF ( self ), NUM2INT( fraction ) );
    return self;
}

static VALUE
set_icon(self, icon_name)
    VALUE self, icon_name;
{
       hildon_banner_set_icon (_SELF ( self ), RVAL2CSTR( icon_name ) );
    return self;
}

static VALUE
set_icon_from_file(self, icon_file)
    VALUE self, icon_file;
{
       hildon_banner_set_icon_from_file (_SELF ( self ), RVAL2CSTR( icon_file ) );
    return self;
}

static VALUE
set_timeout(self, timeout)
    VALUE self, timeout;
{
       hildon_banner_set_timeout (_SELF ( self ), NUM2UINT( timeout ) );
    return self;
}


/* Class Initialisation */


void 
Init_hildon_banner()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_BANNER, "Banner", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, -1);

     rb_define_singleton_method(win, "show_information", show_information, 3);

   /*  rb_define_singleton_method(win, "show_informationf", show_informationf, 2); */

     rb_define_singleton_method(win, "show_information_with_markup", show_information_with_markup,3);

     rb_define_singleton_method(win, "show_animation", show_animation, 3);

     rb_define_singleton_method(win, "show_progress", show_progress,3);

     rb_define_method(win, "set_text", set_text, 1);

     rb_define_method(win, "set_markup", set_markup, 1);

     rb_define_method(win, "set_fraction", set_fraction, 1);

     rb_define_method(win, "set_icon", set_icon, 1);

     rb_define_method(win, "set_icon_from_file", set_icon_from_file, 1);

     rb_define_method(win, "set_timeout", set_timeout, 1);
}


