
/*****************************************************************
*
* ruby_hildon_window.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_WINDOW(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_window_new () );
    return Qnil;
}


/* methods */


static VALUE
add_with_scrollbar(self, child)
    VALUE self, child;
{
       hildon_window_add_with_scrollbar (_SELF ( self ), GTK_WIDGET ( RVAL2GOBJ ( child ) ) );
    return self;
}

static VALUE
get_menu(self)
    VALUE self;
{
    GtkMenu* ret =    hildon_window_get_menu (_SELF ( self ) );
    return GOBJ2RVAL ( ret ) ;
}

static VALUE
set_main_menu(self, menu)
    VALUE self, menu;
{
       hildon_window_set_main_menu (_SELF ( self ), GTK_MENU ( RVAL2GOBJ ( menu ) ) );
    return self;
}

static VALUE
set_menu(self, menu)
    VALUE self, menu;
{
       hildon_window_set_menu (_SELF ( self ), GTK_MENU ( RVAL2GOBJ ( menu ) ) );
    return self;
}

static VALUE
add_toolbar(self, toolbar)
    VALUE self, toolbar;
{
       hildon_window_add_toolbar (_SELF ( self ), GTK_TOOLBAR ( RVAL2GOBJ ( toolbar ) ) );
    return self;
}

static VALUE
remove_toolbar(self, toolbar)
    VALUE self, toolbar;
{
       hildon_window_remove_toolbar (_SELF ( self ), GTK_TOOLBAR ( RVAL2GOBJ ( toolbar ) ) );
    return self;
}

static VALUE
get_is_topmost(self)
    VALUE self;
{
    gboolean ret =    hildon_window_get_is_topmost (_SELF ( self ) );
    return CBOOL2RVAL( ret );
}


/* Class Initialisation */


void 
Init_hildon_window()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_WINDOW, "Window", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "add_with_scrollbar", add_with_scrollbar, 1);

     rb_define_method(win, "get_menu", get_menu, 0);

     rb_define_method(win, "set_main_menu", set_main_menu, 1);

     rb_define_method(win, "set_menu", set_menu, 1);

     rb_define_method(win, "add_toolbar", add_toolbar, 1);

     rb_define_method(win, "remove_toolbar", remove_toolbar, 1);

     rb_define_method(win, "get_is_topmost", get_is_topmost, 0);
	
    G_DEF_CLASS(HILDON_TYPE_WINDOW_CLIPBOARD_OPERATION,"ClipboardOperation",win);
    G_DEF_CONSTANTS(win,HILDON_TYPE_WINDOW_CLIPBOARD_OPERATION,"HILDON_WINDOW_"); 

}


