
/*****************************************************************
*
* ruby_hildon_note.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_NOTE(RVAL2GOBJ(self)))

#define MODE_CONFIRMATION 1
#define MODE_BUTTONS 2
#define MODE_ICON 3
#define MODE_PROGRESS 4
#define MODE_INFORMATION 5
#define MODE_INFORMATION_ICON 6

static ID id_to_a;

/* Initialisation */


static VALUE
initialize (argc, argv, self)
    int argc;
    VALUE *argv;
    VALUE self;
{
   
	VALUE mode = argv[0];
	VALUE parent = argv[1];
	VALUE description = argv[2];
	VALUE extra;
	
	 int imode = NUM2INT( mode );
         GtkWidget* widget = NULL;
	
	switch ( imode )
	{
		case MODE_CONFIRMATION :
			widget =  hildon_note_new_confirmation (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ) ) ;
		break;
		case MODE_BUTTONS:
			widget =   hildon_note_new_confirmation_add_buttons (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ) ) ;
		break;
		case MODE_ICON:
			extra = argv[3];
			widget =  hildon_note_new_confirmation_with_icon_name (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ), rb_id2name(SYM2ID(extra)) ) ; 
		break;
		case MODE_PROGRESS:
			extra = argv[3];
			widget =   hildon_note_new_cancel_with_progress_bar (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ), GTK_PROGRESS_BAR ( RVAL2GOBJ ( extra ) ) ) ;
		break;
		case MODE_INFORMATION:
			widget =  hildon_note_new_information (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ) ) ;
		break;
		case MODE_INFORMATION_ICON:
			extra = argv[3];
			widget =  hildon_note_new_information_with_icon_name (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ), rb_id2name(SYM2ID(extra))  ) ;
		break;
	}
    RBGTK_INITIALIZE(self, widget );
    return Qnil;
}


/* methods */


static VALUE
new_confirmation( self, parent, description)
    VALUE self, parent, description;
{
    /* RBGTK_INITIALIZE(self, hildon_note_new_confirmation (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ) ) ); */
    return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_CONFIRMATION ), parent, description, Qnil ) ;
}

static VALUE
new_confirmation_add_buttons(self,parent, description)
    VALUE self, parent, description;
{
    /*RBGTK_INITIALIZE(self, hildon_note_new_confirmation_add_buttons (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ) ) );*/
     return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_BUTTONS ), parent, description, Qnil ) ;
}

static VALUE
new_confirmation_with_icon_name(self,parent, description, icon_name)
    VALUE self, parent, description, icon_name;
{
    /*RBGTK_INITIALIZE(self, hildon_note_new_confirmation_with_icon_name (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ), RVAL2CSTR( icon_name ) ) );*/
     return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_ICON ), parent, description, icon_name ) ;
}

static VALUE
new_cancel_with_progress_bar(self, parent, description, progressbar)
    VALUE self, parent, description, progressbar;
{
    /*RBGTK_INITIALIZE(self, hildon_note_new_cancel_with_progress_bar (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ), GTK_PROGRESS_BAR ( RVAL2GOBJ ( progressbar ) ) ) );*/
     return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_PROGRESS ), parent, description, progressbar ) ;
}

static VALUE
new_information(self, parent, description)
    VALUE self, parent, description;
{
    /*RBGTK_INITIALIZE(self, hildon_note_new_information (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ) ) );*/
     return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_INFORMATION ), parent, description, Qnil ) ;
}

static VALUE
new_information_with_icon_name(self, parent, description, icon_name)
    VALUE self, parent, description, icon_name;
{
    /*RBGTK_INITIALIZE(self, hildon_note_new_information_with_icon_name (GTK_WINDOW ( RVAL2GOBJ ( parent ) ), RVAL2CSTR( description ), RVAL2CSTR( icon_name ) ) );*/
     return rb_funcall ( self, rb_intern ( "new" ), 4 , INT2NUM( MODE_INFORMATION_ICON ), parent, description, icon_name ) ;
}

static VALUE
set_button_text(note, text)
    VALUE note, text;
{
       hildon_note_set_button_text (_SELF ( note ), RVAL2CSTR( text ) );
    return note;
}

static VALUE
set_button_texts(note, text_ok, text_cancel)
    VALUE note, text_ok, text_cancel;
{
       hildon_note_set_button_texts (_SELF ( note ), RVAL2CSTR( text_ok ), RVAL2CSTR( text_cancel ) );
    return note;
}


/* Class Initialisation */


void 
Init_hildon_note()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_NOTE, "Note", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize,-1);

    rb_define_singleton_method(win, "new_confirmation", new_confirmation, 2);

  /*   rb_define_singleton_method(win, "new_confirmation_add_buttons", new_confirmation_add_buttons, -1); */

     rb_define_singleton_method(win, "new_confirmation_with_icon_name", new_confirmation_with_icon_name, 3);

     rb_define_singleton_method(win, "new_cancel_with_progress_bar", new_cancel_with_progress_bar, 3);

     rb_define_singleton_method(win, "new_information", new_information, 2);
	
     rb_define_singleton_method(win, "new_information_with_icon_name", new_information_with_icon_name, 3);

     rb_define_method(win, "set_button_text", set_button_text, 1);

     rb_define_method(win, "set_button_texts", set_button_texts, 2);
}


