
/*****************************************************************
*
* ruby_hildon_color_chooser.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_COLOR_CHOOSER(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_color_chooser_new () );
    return Qnil;
}


/* methods */


static VALUE
set_color(chooser, color)
    VALUE chooser, color;
{
       hildon_color_chooser_set_color  (_SELF ( chooser ), RVAL2GDKCOLOR(color) );
    return chooser;
}

static VALUE
get_color(chooser)
    VALUE chooser;
{
	GdkColor color;
       hildon_color_chooser_get_color(_SELF ( chooser ), &color );
     return GDKCOLOR2RVAL(&color);
}


/* Class Initialisation */


void 
Init_hildon_color_chooser()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_COLOR_CHOOSER, "ColorChooser", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "set_color", set_color, 1);

     rb_define_method(win, "get_color", get_color, 0);
}


