
/*****************************************************************
*
* ruby_hildon_bread_crumb_trail.c 
*
* Author: Clive Andrews, Reality Bites
*
* Date : 04/08/2008
*
* Copyright (c) C.Andrews 2008
*
* Licenced under the GNU licence
*
*
******************************************************************/
 
#include <ruby.h>
#include <hildon/hildon.h>
#include "rbhildon.h"

#define _SELF(self) (HILDON_BREAD_CRUMB_TRAIL(RVAL2GOBJ(self)))

static ID id_to_a;

/* Initialisation */


static VALUE
initialize ( self )
    VALUE self;
{
    RBGTK_INITIALIZE(self,hildon_bread_crumb_trail_get_type () );
    return Qnil;
}


/* methods */


static VALUE
push(bct, item, id, notify)
    VALUE bct, item, id, notify;
{
       hildon_bread_crumb_trail_push (_SELF ( bct ), HILDON_BREAD_CRUMB ( RVAL2GOBJ ( item ) ), HILDON_BREAD_CRUMB ( RVAL2GOBJ ( item ) ), HILDON_BREAD_CRUMB ( RVAL2GOBJ ( item ) ) );
    return bct;
}

static VALUE
push_text(bct, text, id, notify)
    VALUE bct, text, id, notify;
{
       hildon_bread_crumb_trail_push_text (_SELF ( bct ), RVAL2CSTR( text ), RVAL2CSTR( text ), RVAL2CSTR( text ) );
    return bct;
}

static VALUE
push_icon(bct, text, icon, id, destroy)
    VALUE bct, text, icon, id, destroy;
{
       hildon_bread_crumb_trail_push_icon (_SELF ( bct ), RVAL2CSTR( text ), GTK_WIDGET ( RVAL2GOBJ ( icon ) ), GTK_WIDGET ( RVAL2GOBJ ( icon ) ), GTK_WIDGET ( RVAL2GOBJ ( icon ) ) );
    return bct;
}

static VALUE
pop(bct)
    VALUE bct;
{
       hildon_bread_crumb_trail_pop (_SELF ( bct ) );
    return bct;
}

static VALUE
clear(bct)
    VALUE bct;
{
       hildon_bread_crumb_trail_clear (_SELF ( bct ) );
    return bct;
}


/* Class Initialisation */


void 
Init_hildon_bread_crumb_trail()
{
   
    VALUE win = G_DEF_CLASS(HILDON_TYPE_BREAD_CRUMB_TRAIL, "BreadCrumbTrail", mHildon);

    id_to_a = rb_intern("to_a"); 
    
    rb_define_method(win, "initialize", initialize, 0);

     rb_define_method(win, "push", push, 3);

     rb_define_method(win, "push_text", push_text, 3);

     rb_define_method(win, "push_icon", push_icon, 4);

     rb_define_method(win, "pop", pop, 0);

     rb_define_method(win, "clear", clear, 0);
}


